/*
 * Decompiled with CFR 0.152.
 */
package com.pnuema.java.barcode.symbologies;

import com.pnuema.java.barcode.Barcode;
import com.pnuema.java.barcode.BarcodeCommon;
import com.pnuema.java.barcode.IBarcode;
import com.pnuema.java.barcode.utils.Utils2of5;

public class Interleaved2of5
extends BarcodeCommon
implements IBarcode {
    private final String[] I25_Code = new String[]{"NNWWN", "WNNNW", "NWNNW", "WWNNN", "NNWNW", "WNWNN", "NWWNN", "NNNWW", "WNNWN", "NWNWN"};
    private final Barcode.TYPE type;

    public Interleaved2of5(String input, Barcode.TYPE encodingType) {
        this.setRawData(input);
        this.type = encodingType;
    }

    private String encodeInterleaved2Of5() {
        if (this.getRawData().length() % 2 != (this.type == Barcode.TYPE.Interleaved2of5_Mod10 ? 1 : 0)) {
            this.error("EI25-1: Data length invalid.");
        }
        if (!Interleaved2of5.checkNumericOnly(this.getRawData())) {
            this.error("EI25-2: Numeric Data Only");
        }
        StringBuilder result = new StringBuilder("1010");
        String data = String.valueOf(this.getRawData()) + (this.type == Barcode.TYPE.Interleaved2of5_Mod10 ? Integer.valueOf(Utils2of5.CalculateMod10CheckDigit(this.getRawData())) : "");
        int i = 0;
        while (i < data.length()) {
            boolean bars = true;
            String patternbars = this.I25_Code[Integer.parseInt(String.valueOf(data.charAt(i)))];
            String patternspaces = this.I25_Code[Integer.parseInt(String.valueOf(data.charAt(i + 1)))];
            StringBuilder patternmixed = new StringBuilder();
            while (patternbars.trim().length() != 0) {
                patternmixed.append(patternbars.charAt(0)).append(patternspaces.toCharArray()[0]);
                patternbars = patternbars.substring(1);
                patternspaces = patternspaces.substring(1);
            }
            char[] cArray = patternmixed.toString().toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c1 = cArray[n2];
                if (bars) {
                    result.append(c1 == 'N' ? "1" : "11");
                } else {
                    result.append(c1 == 'N' ? "0" : "00");
                }
                bars = !bars;
                ++n2;
            }
            i += 2;
        }
        result.append("1101");
        return result.toString();
    }

    public String getEncodedValue() {
        return this.encodeInterleaved2Of5();
    }
}

