/*
 * Decompiled with CFR 0.152.
 */
package com.androdome.label;

import com.androdome.label.PrintUtils;
import com.pnuema.java.barcode.Barcode;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.ImageCapabilities;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class MainInterface
extends JFrame
implements ActionListener,
ItemListener {
    private static final long serialVersionUID = 1L;
    private JPanel contentPane;
    private JTextField txtLine1;
    private JTextField txtCode;
    JLabel lblPreview = new JLabel("Preview will go here");
    JButton btnGeneratePreview = new JButton("Generate Preview");
    JButton btnPrint = new JButton("Print");
    JButton btnRefresh = new JButton("Refresh");
    JButton btnExit = new JButton("Exit");
    private JTextField txtLine2;
    private JTextField txtLine3;
    JComboBox comboBox = new JComboBox<Barcode.TYPE>(Barcode.TYPE.values());
    JComboBox cmbPrintServices = new JComboBox();
    JSpinner spnScale = new JSpinner();
    JSpinner spnText = new JSpinner();

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                try {
                    MainInterface frame = new MainInterface();
                    frame.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public MainInterface() {
        super("Flare LabelPrint Alpha 0.0.1");
        this.setDefaultCloseOperation(3);
        this.comboBox.setSelectedItem((Object)Barcode.TYPE.CODE128A);
        this.setBounds(100, 100, 643, 444);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.contentPane.setLayout(new BorderLayout(0, 0));
        this.setContentPane(this.contentPane);
        JSplitPane splitPane = new JSplitPane();
        splitPane.setResizeWeight(1.0);
        this.contentPane.add((Component)splitPane, "Center");
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder(null, "Preview", 4, 2, null, null));
        splitPane.setLeftComponent(panel);
        GridBagLayout gbl_panel = new GridBagLayout();
        panel.setLayout(gbl_panel);
        panel.add(this.lblPreview);
        JPanel panel_1 = new JPanel();
        splitPane.setRightComponent(panel_1);
        panel_1.setLayout(new BorderLayout(0, 0));
        JPanel panel_2 = new JPanel();
        panel_2.setBorder(new TitledBorder(null, "Label Information", 4, 2, null, null));
        panel_1.add((Component)panel_2, "North");
        panel_2.setLayout(new GridLayout(0, 1, 0, 2));
        JPanel panel_3 = new JPanel();
        panel_2.add(panel_3);
        panel_3.setLayout(new BorderLayout(10, 0));
        JLabel lblNewLabel_1 = new JLabel("Line1");
        panel_3.add((Component)lblNewLabel_1, "West");
        this.txtLine1 = new JTextField();
        panel_3.add((Component)this.txtLine1, "Center");
        this.txtLine1.setColumns(10);
        JPanel panel_8 = new JPanel();
        panel_2.add(panel_8);
        panel_8.setLayout(new BorderLayout(10, 0));
        JLabel lblLine = new JLabel("Line2");
        panel_8.add((Component)lblLine, "West");
        this.txtLine2 = new JTextField();
        this.txtLine2.setColumns(10);
        panel_8.add((Component)this.txtLine2, "Center");
        JPanel panel_9 = new JPanel();
        panel_2.add(panel_9);
        panel_9.setLayout(new BorderLayout(10, 0));
        JLabel lblLine_1 = new JLabel("Line3");
        panel_9.add((Component)lblLine_1, "West");
        this.txtLine3 = new JTextField();
        this.txtLine3.setColumns(10);
        panel_9.add((Component)this.txtLine3, "Center");
        JPanel panel_4 = new JPanel();
        panel_2.add(panel_4);
        panel_4.setLayout(new BorderLayout(10, 0));
        JLabel lblBarcode = new JLabel("Code");
        panel_4.add((Component)lblBarcode, "West");
        this.txtCode = new JTextField();
        this.txtCode.setColumns(10);
        panel_4.add((Component)this.txtCode, "Center");
        JPanel panel_10 = new JPanel();
        panel_2.add(panel_10);
        panel_10.setLayout(new BorderLayout(10, 0));
        JLabel lblType = new JLabel("Type");
        panel_10.add((Component)lblType, "West");
        panel_10.add((Component)this.comboBox, "Center");
        JPanel panel_11 = new JPanel();
        panel_2.add(panel_11);
        panel_11.setLayout(new BorderLayout(10, 0));
        JLabel lblScale = new JLabel("Scale");
        panel_11.add((Component)lblScale, "West");
        this.spnScale.setModel(new SpinnerNumberModel(new Float(6.0f), null, null, new Float(0.125f)));
        panel_11.add((Component)this.spnScale, "Center");
        JPanel panel_12 = new JPanel();
        panel_2.add(panel_12);
        panel_12.setLayout(new BorderLayout(10, 0));
        JLabel lblText = new JLabel(" Text");
        panel_12.add((Component)lblText, "West");
        this.spnText.setModel(new SpinnerNumberModel(new Float(6.0f), null, null, new Float(0.125)));
        panel_12.add((Component)this.spnText, "Center");
        JPanel panel_5 = new JPanel();
        panel_5.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Printing", 4, 2, null, new Color(0, 0, 0)));
        panel_1.add((Component)panel_5, "South");
        panel_5.setLayout(new GridLayout(0, 1, 0, 2));
        JPanel panel_6 = new JPanel();
        panel_5.add(panel_6);
        panel_6.setLayout(new BorderLayout(10, 0));
        JLabel lblNewLabel_2 = new JLabel("Print");
        panel_6.add((Component)lblNewLabel_2, "West");
        panel_6.add((Component)this.btnPrint, "East");
        JPanel panel_7 = new JPanel();
        panel_7.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Label Settings", 4, 2, null, new Color(0, 0, 0)));
        panel_1.add((Component)panel_7, "Center");
        panel_7.setLayout(new GridLayout(0, 1, 0, 2));
        panel_7.add(this.btnGeneratePreview);
        splitPane.setDividerLocation(this.getWidth() - 250);
        JToolBar toolBar = new JToolBar();
        this.contentPane.add((Component)toolBar, "North");
        JPanel panel_13 = new JPanel();
        FlowLayout flowLayout = (FlowLayout)panel_13.getLayout();
        flowLayout.setVgap(0);
        flowLayout.setAlignment(0);
        toolBar.add(panel_13);
        JLabel lblPrintService = new JLabel("Print Service:");
        panel_13.add(lblPrintService);
        panel_13.add(this.cmbPrintServices);
        panel_13.add(this.btnRefresh);
        panel_13.add(this.btnExit);
        this.btnGeneratePreview.addActionListener(this);
        this.btnPrint.addActionListener(this);
        this.comboBox.addItemListener(this);
        this.btnRefresh.addActionListener(this);
        this.btnExit.addActionListener(this);
        this.refreshPrinters();
    }

    public BufferedImage getBarcode(String titleLine1, String titleLine2, String titleLine3, String code, float multi, float txtScale) {
        Image textImage;
        float txtScaleX = txtScale;
        int txtScaleY = 4;
        Barcode barcodeData = new Barcode(code, (Barcode.TYPE)((Object)this.comboBox.getSelectedItem()));
        Image barcode = barcodeData.encode(barcodeData.getEncodedType(), code, -1, 200);
        BufferedImage image = new BufferedImage(2100, 675, 1);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setColor(Color.WHITE);
        try {
            textImage = this.createVolatileImage((int)(2100.0f / txtScaleX), 675 / txtScaleY, new ImageCapabilities(false));
        }
        catch (AWTException e) {
            textImage = new BufferedImage((int)(2100.0f / txtScaleX), 675 / txtScaleY, 1);
            e.printStackTrace();
        }
        Graphics2D volatileGraphics = (Graphics2D)textImage.getGraphics();
        volatileGraphics.setColor(Color.WHITE);
        volatileGraphics.fillRect(0, 0, textImage.getWidth(null), textImage.getHeight(null));
        volatileGraphics.setFont(new Font(null, 0, 20));
        volatileGraphics.setColor(Color.BLACK);
        volatileGraphics.drawString(code, textImage.getWidth(null) / 2 - volatileGraphics.getFontMetrics().stringWidth(code) / 2, textImage.getHeight(null) - 15);
        graphics.drawImage(textImage, 0, 0, image.getWidth(null), image.getHeight(null), null);
        graphics.setColor(Color.BLACK);
        graphics.setFont(new Font("Consolas", 0, 90));
        graphics.drawImage(barcode, (int)((float)(image.getWidth() / 2) - (float)barcode.getWidth(null) * (multi / 2.0f)), 320, (int)((float)barcode.getWidth(null) * multi), barcode.getHeight(null), null);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.drawString(titleLine1, 100, 100);
        graphics.drawString(titleLine2, 100, 190);
        graphics.drawString(titleLine3, 100, 280);
        return image;
    }

    public void refreshPrinters() {
        this.cmbPrintServices.setModel(new JComboBox<PrintService>(PrintUtils.getPrintServices()).getModel());
        int i = 0;
        while (i < this.cmbPrintServices.getModel().getSize()) {
            if (this.cmbPrintServices.getItemAt(i).toString().toLowerCase().contains("label")) {
                this.cmbPrintServices.setSelectedIndex(i);
                break;
            }
            ++i;
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnGeneratePreview) {
            this.lblPreview.setText("");
            this.lblPreview.setIcon(new ImageIcon(this.getBarcode(this.txtLine1.getText(), this.txtLine2.getText(), this.txtLine3.getText(), this.txtCode.getText(), ((Float)this.spnScale.getValue()).floatValue(), ((Float)this.spnText.getValue()).floatValue()).getScaledInstance(712, 192, 2)));
        } else if (e.getSource() == this.btnRefresh) {
            this.refreshPrinters();
        } else if (e.getSource() == this.btnExit) {
            this.dispose();
        } else if (e.getSource() == this.btnPrint) {
            BufferedImage barcode = this.getBarcode(this.txtLine1.getText(), this.txtLine2.getText(), this.txtLine3.getText(), this.txtCode.getText(), ((Float)this.spnScale.getValue()).floatValue(), ((Float)this.spnText.getValue()).floatValue());
            try {
                PrintUtils.print((PrintService)this.cmbPrintServices.getSelectedItem(), (RenderedImage)barcode);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            catch (PrintException e1) {
                e1.printStackTrace();
            }
        }
    }

    public void itemStateChanged(ItemEvent e) {
        e.getSource();
    }
}

