/*
 * Decompiled with CFR 0.152.
 */
package com.androdome.label;

import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PrintQuality;

public class PrintUtils {
    public static PrintService[] getPrintServices() {
        return PrintServiceLookup.lookupPrintServices(null, null);
    }

    @Deprecated
    public static void print(String inPrinterName, RenderedImage image) throws IOException, PrintException {
        PrintService[] printServices = PrintServiceLookup.lookupPrintServices(null, null);
        System.out.println("Number of print services: " + printServices.length);
        PrintService chosen = null;
        PrintService[] printServiceArray = printServices;
        int n = printServices.length;
        int n2 = 0;
        while (n2 < n) {
            PrintService printer = printServiceArray[n2];
            if (printer.getName().toLowerCase().contains(inPrinterName.toLowerCase())) {
                chosen = printer;
                break;
            }
            ++n2;
        }
        if (chosen != null) {
            PrintUtils.print(chosen, image);
        }
    }

    public static void print(PrintService service, RenderedImage image) throws IOException, PrintException {
        HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
        aset.add(OrientationRequested.LANDSCAPE);
        aset.add(new MediaPrintableArea(0.0f, 0.0f, 1.125f, 3.5f, 25400));
        aset.add(PrintQuality.HIGH);
        ByteArrayOutputStream img = new ByteArrayOutputStream();
        ImageIO.write(image, "png", img);
        img.close();
        DocPrintJob printJob = service.createPrintJob();
        SimpleDoc doc = new SimpleDoc(new ByteArrayInputStream(img.toByteArray()), DocFlavor.INPUT_STREAM.PNG, null);
        printJob.print(doc, aset);
    }
}

