/*
 * Decompiled with CFR 0.152.
 */
package com.pnuema.java.barcode.symbologies;

import com.pnuema.java.barcode.BarcodeCommon;
import com.pnuema.java.barcode.IBarcode;
import java.util.HashMap;

public class Codabar
extends BarcodeCommon
implements IBarcode {
    private final HashMap<Character, String> codabarCode = new HashMap();

    public Codabar(String input) {
        this.setRawData(input);
    }

    private String encodeCodabar() {
        if (this.getRawData().length() < 2) {
            this.error("ECODABAR-1: Data format invalid. (Invalid length)");
        }
        switch (this.getRawData().toUpperCase().charAt(0)) {
            case 'A': {
                break;
            }
            case 'B': {
                break;
            }
            case 'C': {
                break;
            }
            case 'D': {
                break;
            }
            default: {
                this.error("ECODABAR-2: Data format invalid. (Invalid START character)");
            }
        }
        switch (this.getRawData().charAt(this.getRawData().toUpperCase().trim().length() - 1)) {
            case 'A': {
                break;
            }
            case 'B': {
                break;
            }
            case 'C': {
                break;
            }
            case 'D': {
                break;
            }
            default: {
                this.error("ECODABAR-3: Data format invalid. (Invalid STOP character)");
            }
        }
        this.initCodabar();
        String temp = this.getRawData();
        for (char c : this.codabarCode.keySet()) {
            if (Codabar.checkNumericOnly(String.valueOf(c))) continue;
            temp = temp.replace(c, '1');
        }
        if (!Codabar.checkNumericOnly(temp)) {
            this.error("ECODABAR-4: Data contains invalid  characters.");
        }
        StringBuilder result = new StringBuilder();
        char[] cArray = this.getRawData().toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            result.append(this.codabarCode.get(Character.valueOf(c)));
            result.append("0");
            ++n2;
        }
        result.deleteCharAt(result.length() - 1);
        this.codabarCode.clear();
        this.setRawData(this.getRawData().trim().substring(1, this.getRawData().trim().length() - 2));
        return result.toString();
    }

    private void initCodabar() {
        this.codabarCode.clear();
        this.codabarCode.put(Character.valueOf('0'), "101010011");
        this.codabarCode.put(Character.valueOf('1'), "101011001");
        this.codabarCode.put(Character.valueOf('2'), "101001011");
        this.codabarCode.put(Character.valueOf('3'), "110010101");
        this.codabarCode.put(Character.valueOf('4'), "101101001");
        this.codabarCode.put(Character.valueOf('5'), "110101001");
        this.codabarCode.put(Character.valueOf('6'), "100101011");
        this.codabarCode.put(Character.valueOf('7'), "100101101");
        this.codabarCode.put(Character.valueOf('8'), "100110101");
        this.codabarCode.put(Character.valueOf('9'), "110100101");
        this.codabarCode.put(Character.valueOf('-'), "101001101");
        this.codabarCode.put(Character.valueOf('$'), "101100101");
        this.codabarCode.put(Character.valueOf(':'), "1101011011");
        this.codabarCode.put(Character.valueOf('/'), "1101101011");
        this.codabarCode.put(Character.valueOf('.'), "1101101101");
        this.codabarCode.put(Character.valueOf('+'), "101100110011");
        this.codabarCode.put(Character.valueOf('A'), "1011001001");
        this.codabarCode.put(Character.valueOf('B'), "1010010011");
        this.codabarCode.put(Character.valueOf('C'), "1001001011");
        this.codabarCode.put(Character.valueOf('D'), "1010011001");
        this.codabarCode.put(Character.valueOf('a'), "1011001001");
        this.codabarCode.put(Character.valueOf('b'), "1010010011");
        this.codabarCode.put(Character.valueOf('c'), "1001001011");
        this.codabarCode.put(Character.valueOf('d'), "1010011001");
    }

    public String getEncodedValue() {
        return this.encodeCodabar();
    }
}

