/*
 * Decompiled with CFR 0.152.
 */
package com.pnuema.java.barcode.symbologies;

import com.pnuema.java.barcode.BarcodeCommon;
import com.pnuema.java.barcode.IBarcode;

public class FIM
extends BarcodeCommon
implements IBarcode {
    public FIM(String input) {
        input = input.trim();
        String[] FIM_Codes = new String[]{"110010011", "101101101", "110101011", "111010111", "101000101"};
        switch (input.toUpperCase().charAt(0)) {
            case 'A': {
                this.setRawData(FIM_Codes[FIMTypes.FIM_A.ordinal()]);
                break;
            }
            case 'B': {
                this.setRawData(FIM_Codes[FIMTypes.FIM_B.ordinal()]);
                break;
            }
            case 'C': {
                this.setRawData(FIM_Codes[FIMTypes.FIM_C.ordinal()]);
                break;
            }
            case 'D': {
                this.setRawData(FIM_Codes[FIMTypes.FIM_D.ordinal()]);
                break;
            }
            case 'E': {
                this.setRawData(FIM_Codes[FIMTypes.FIM_E.ordinal()]);
                break;
            }
            default: {
                this.error("EFIM-1: Could not determine encoding type. (Only pass in A, B, C, D, or E)");
            }
        }
    }

    private String encodeFIM() {
        StringBuilder encoded = new StringBuilder();
        char[] cArray = this.getRawData().toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            encoded.append(c).append("0");
            ++n2;
        }
        encoded = new StringBuilder(encoded.substring(0, encoded.length() - 1));
        return encoded.toString();
    }

    public String getEncodedValue() {
        return this.encodeFIM();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FIMTypes {
        FIM_A,
        FIM_B,
        FIM_C,
        FIM_D,
        FIM_E;

    }
}

