/*
 * Decompiled with CFR 0.152.
 */
package com.pnuema.java.barcode.symbologies;

import com.pnuema.java.barcode.BarcodeCommon;

public class UPCE
extends BarcodeCommon {
    private final String[] EAN_CodeA = new String[]{"0001101", "0011001", "0010011", "0111101", "0100011", "0110001", "0101111", "0111011", "0110111", "0001011"};
    private final String[] EAN_CodeB = new String[]{"0100111", "0110011", "0011011", "0100001", "0011101", "0111001", "0000101", "0010001", "0001001", "0010111"};
    private final String[] UPCE_Code_0 = new String[]{"bbbaaa", "bbabaa", "bbaaba", "bbaaab", "babbaa", "baabba", "baaabb", "bababa", "babaab", "baabab"};
    private final String[] UPCE_Code_1 = new String[]{"aaabbb", "aababb", "aabbab", "aabbba", "abaabb", "abbaab", "abbbaa", "ababab", "ababba", "abbaba"};

    public UPCE(String input) {
        this.setRawData(input);
    }

    private String encodeUPCE() {
        if (this.getRawData().length() != 6 && this.getRawData().length() != 8 && this.getRawData().length() != 12) {
            this.error("EUPCE-1: Invalid data length. (6, 8 or 12 numbers only)");
        }
        int numberSystem = 0;
        if (!UPCE.checkNumericOnly(this.getRawData())) {
            this.error("EUPCE-2: Numeric Data Only");
        }
        if (this.getRawData().length() == 8) {
            this.setRawData(this.getRawData().substring(1, 7));
        }
        if (this.getRawData().length() == 12) {
            numberSystem = Integer.parseInt(String.valueOf(this.getRawData().charAt(0)));
            this.setRawData(this.convertUPCAToUPCE());
        }
        int checkDigit = Integer.parseInt(this.calculateCheckDigit(this.convertUPCEToUPCA(this.getRawData())));
        String pattern = this.getPattern(checkDigit, numberSystem);
        StringBuilder result = new StringBuilder("101");
        int pos = 0;
        char[] cArray = pattern.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            int i = Integer.parseInt(String.valueOf(this.getRawData().toCharArray()[pos++]));
            if (c == 'a') {
                result.append(this.EAN_CodeA[i]);
            } else if (c == 'b') {
                result.append(this.EAN_CodeB[i]);
            }
            ++n2;
        }
        result.append("010101");
        return result.toString();
    }

    private String getPattern(int checkDigit, int numberSystem) {
        if (numberSystem != 0 && numberSystem != 1) {
            this.error("EUPCE-3: Invalid Number System (only 0 & 1 are valid)");
        }
        String pattern = numberSystem == 0 ? this.UPCE_Code_0[checkDigit] : this.UPCE_Code_1[checkDigit];
        return pattern;
    }

    private String convertUPCAToUPCE() {
        String UPCECode = "";
        String manufacturer = this.getRawData().substring(1, 6);
        String productCode = this.getRawData().substring(6, 11);
        int numericProductCode = Integer.parseInt(productCode);
        if ((manufacturer.endsWith("000") || manufacturer.endsWith("100") || manufacturer.endsWith("200")) && numericProductCode <= 999) {
            UPCECode = String.valueOf(UPCECode) + manufacturer.substring(0, 2);
            UPCECode = String.valueOf(UPCECode) + productCode.substring(2, 5);
            UPCECode = String.valueOf(UPCECode) + String.valueOf(manufacturer.toCharArray()[2]);
        } else if (manufacturer.endsWith("00") && numericProductCode <= 99) {
            UPCECode = String.valueOf(UPCECode) + manufacturer.substring(0, 3);
            UPCECode = String.valueOf(UPCECode) + productCode.substring(3, 5);
            UPCECode = String.valueOf(UPCECode) + "3";
        } else if (manufacturer.endsWith("0") && numericProductCode <= 9) {
            UPCECode = String.valueOf(UPCECode) + manufacturer.substring(0, 4);
            UPCECode = String.valueOf(UPCECode) + productCode.toCharArray()[4];
            UPCECode = String.valueOf(UPCECode) + "4";
        } else if (!manufacturer.endsWith("0") && numericProductCode <= 9 && numericProductCode >= 5) {
            UPCECode = String.valueOf(UPCECode) + manufacturer;
            UPCECode = String.valueOf(UPCECode) + productCode.toCharArray()[4];
        } else {
            this.error("EUPCE-4: Illegal UPC-A entered for conversion.  Unable to convert.");
        }
        return UPCECode;
    }

    private String convertUPCEToUPCA(String UPCECode) {
        String UPCACode = "0";
        if (UPCECode.endsWith("0") || UPCECode.endsWith("1") || UPCECode.endsWith("2")) {
            UPCACode = String.valueOf(UPCACode) + UPCECode.substring(0, 2) + UPCECode.charAt(5) + "00";
            UPCACode = String.valueOf(UPCACode) + "00" + UPCECode.substring(2, 5);
        } else if (UPCECode.endsWith("3")) {
            UPCACode = String.valueOf(UPCACode) + UPCECode.substring(0, 3) + "00";
            UPCACode = String.valueOf(UPCACode) + "000" + UPCECode.substring(3, 5);
        } else if (UPCECode.endsWith("4")) {
            UPCACode = String.valueOf(UPCACode) + UPCECode.substring(0, 4) + "0";
            UPCACode = String.valueOf(UPCACode) + "0000" + UPCECode.charAt(4);
        } else {
            UPCACode = String.valueOf(UPCACode) + UPCECode.substring(0, 5);
            UPCACode = String.valueOf(UPCACode) + "0000" + UPCECode.charAt(5);
        }
        return UPCACode;
    }

    private String calculateCheckDigit(String upcA) {
        int cs = 0;
        try {
            int sum = 0;
            int i = 0;
            while (i < upcA.length()) {
                int parseInt = Integer.parseInt(upcA.substring(i, i + 1));
                sum = i % 2 == 0 ? (sum += parseInt * 3) : (sum += parseInt);
                ++i;
            }
            cs = (10 - sum % 10) % 10;
        }
        catch (Exception ex) {
            this.error("EUPCE-5: Error calculating check digit.");
        }
        return String.valueOf(cs);
    }

    public String getEncodedValue() {
        return this.encodeUPCE();
    }
}

