/*
 * Decompiled with CFR 0.152.
 */
package com.androdome.label;

import com.androdome.label.MediaInfo;
import java.awt.Component;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.CopiesSupported;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PrintQuality;
import javax.swing.JOptionPane;

public class PrintUtils {
    public static PrintService[] getPrintServices() {
        return PrintServiceLookup.lookupPrintServices(null, null);
    }

    public static MediaInfo[] getMediaInfo(PrintService service) {
        Object mediaAttr = service.getSupportedAttributeValues(Media.class, null, null);
        ArrayList<MediaInfo> info = new ArrayList<MediaInfo>();
        if (mediaAttr instanceof Media[]) {
            Media[] mediaArray;
            Media[] mediaArray2 = mediaArray = (Media[])mediaAttr;
            int n = mediaArray.length;
            int n2 = 0;
            while (n2 < n) {
                Media media = mediaArray2[n2];
                MediaSize mediaSize = MediaSize.getMediaSizeForName((MediaSizeName)media);
                if (mediaSize != null) {
                    info.add(new MediaInfo(media, mediaSize));
                }
                ++n2;
            }
        }
        return info.toArray(new MediaInfo[0]);
    }

    @Deprecated
    public static void print(String inPrinterName, RenderedImage image) throws IOException, PrintException {
        PrintService[] printServices = PrintServiceLookup.lookupPrintServices(null, null);
        System.out.println("Number of print services: " + printServices.length);
        PrintService chosen = null;
        PrintService[] printServiceArray = printServices;
        int n = printServices.length;
        int n2 = 0;
        while (n2 < n) {
            PrintService printer = printServiceArray[n2];
            if (printer.getName().toLowerCase().contains(inPrinterName.toLowerCase())) {
                chosen = printer;
                break;
            }
            ++n2;
        }
        if (chosen != null) {
            PrintUtils.print(chosen, image, 1, null);
        }
    }

    public static void print(PrintService service, RenderedImage image, int copies, Component dialogRef) throws IOException, PrintException {
        if (copies < 1) {
            return;
        }
        if (copies > 1) {
            Object attr = service.getSupportedAttributeValues(CopiesSupported.class, DocFlavor.INPUT_STREAM.PNG, null);
            if (attr == null || !(attr instanceof CopiesSupported)) {
                JOptionPane.showMessageDialog(null, "This printer does not support multiple copies\r\n\r\nIf this is a dymo device, please ensure *cupsManualCopies is set to true in the PPD file.");
                return;
            }
            CopiesSupported copiesSupported = (CopiesSupported)attr;
            int[][] members = copiesSupported.getMembers();
            if (members == null || members.length < 1) {
                JOptionPane.showMessageDialog(dialogRef, "This printer does not support multiple copies\r\n\r\nIf this is a dymo device, please ensure *cupsManualCopies is set to true in the PPD file.");
                return;
            }
            if (members[0][0] > copies) {
                JOptionPane.showMessageDialog(dialogRef, "This printer requires a minimum of " + members[0][0] + "copies...\r\nTHIS SHOULD NOT HAPPEN");
                return;
            }
            if (members[0][1] == 1) {
                JOptionPane.showMessageDialog(dialogRef, "This printer does not support multiple copies\r\n\r\nIf this is a dymo device, please ensure *cupsManualCopies is set to true in the PPD file.");
                return;
            }
            if (members[0][1] < copies) {
                JOptionPane.showMessageDialog(dialogRef, "This printer only supports up to " + members[0][1] + " copies.\r\n\r\nIf this is a dymo device, please ensure *cupsManualCopies is set to true in the PPD file.");
                return;
            }
        }
        HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
        aset.add(OrientationRequested.LANDSCAPE);
        aset.add(new Copies(copies));
        aset.add(new MediaPrintableArea(0.0f, 0.0f, 1.125f, 3.5f, 25400));
        aset.add(PrintQuality.HIGH);
        ByteArrayOutputStream img = new ByteArrayOutputStream();
        ImageIO.write(image, "png", img);
        img.close();
        DocPrintJob printJob = service.createPrintJob();
        byte[] imgBytes = img.toByteArray();
        SimpleDoc doc = new SimpleDoc(imgBytes, DocFlavor.INPUT_STREAM.PNG, null);
        printJob.print(doc, aset);
    }
}

