/*
 * Decompiled with CFR 0.152.
 */
package com.pnuema.java.barcode.symbologies;

import com.pnuema.java.barcode.BarcodeCommon;
import com.pnuema.java.barcode.utils.Utils2of5;

public class IATA2of5
extends BarcodeCommon {
    private final String[] IATA2of5_Code = new String[]{"10101110111010", "11101010101110", "10111010101110", "11101110101010", "10101110101110", "11101011101010", "10111011101010", "10101011101110", "11101010111010", "10111010111010"};

    public IATA2of5(String input) {
        this.setRawData(input);
    }

    private String encodeIATA2Of5() {
        if (this.getRawData().length() > 17 || this.getRawData().length() < 16) {
            this.error("EIATA25-1: Data length invalid. (Length must be 16 or 17)");
        }
        if (!IATA2of5.checkNumericOnly(this.getRawData())) {
            this.error("EIATA25-2: Numeric Data Only");
        }
        StringBuilder result = new StringBuilder("1010");
        String data = this.getRawData();
        if (this.getRawData().length() == 17) {
            data = this.getRawData().substring(0, 16);
        }
        data = String.valueOf(data) + Utils2of5.CalculateMod10CheckDigit(data);
        char[] cArray = data.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            result.append(this.IATA2of5_Code[Integer.parseInt(String.valueOf(c))]);
            ++n2;
        }
        result.append("111010");
        return result.toString();
    }

    public String getEncodedValue() {
        return this.encodeIATA2Of5();
    }
}

