/*
 * Decompiled with CFR 0.152.
 */
package com.pnuema.java.barcode.symbologies;

import com.pnuema.java.barcode.BarcodeCommon;

public class EAN8
extends BarcodeCommon {
    private final String[] EAN_CodeA = new String[]{"0001101", "0011001", "0010011", "0111101", "0100011", "0110001", "0101111", "0111011", "0110111", "0001011"};
    private final String[] EAN_CodeC = new String[]{"1110010", "1100110", "1101100", "1000010", "1011100", "1001110", "1010000", "1000100", "1001000", "1110100"};

    public EAN8(String input) {
        this.setRawData(input);
        this.calculateCheckDigit();
    }

    private String encodeEAN8() {
        if (this.getRawData().length() != 8 && this.getRawData().length() != 7) {
            this.error("EEAN8-1: Invalid data length. (7 or 8 numbers only)");
        }
        if (!EAN8.checkNumericOnly(this.getRawData())) {
            this.error("EEAN8-2: Numeric Data Only");
        }
        StringBuilder result = new StringBuilder("101");
        int i = 0;
        while (i < this.getRawData().length() / 2) {
            result.append(this.EAN_CodeA[Integer.parseInt(String.valueOf(this.getRawData().toCharArray()[i]))]);
            ++i;
        }
        result.append("01010");
        i = this.getRawData().length() / 2;
        while (i < this.getRawData().length()) {
            result.append(this.EAN_CodeC[Integer.parseInt(String.valueOf(this.getRawData().toCharArray()[i]))]);
            ++i;
        }
        result.append("101");
        return result.toString();
    }

    private void calculateCheckDigit() {
        if (this.getRawData().length() == 7) {
            int even = 0;
            int odd = 0;
            int i = 0;
            while (i <= 6) {
                odd += Integer.parseInt(this.getRawData().substring(i, i + 1)) * 3;
                i += 2;
            }
            i = 1;
            while (i <= 5) {
                even += Integer.parseInt(this.getRawData().substring(i, i + 1));
                i += 2;
            }
            int total = even + odd;
            int checksum = total % 10;
            if ((checksum = 10 - checksum) == 10) {
                checksum = 0;
            }
            this.setRawData(String.valueOf(this.getRawData()) + checksum);
        }
    }

    public String getEncodedValue() {
        return this.encodeEAN8();
    }
}

