/*
 * Decompiled with CFR 0.152.
 */
package com.pnuema.java.barcode.symbologies;

import com.pnuema.java.barcode.BarcodeCommon;
import java.util.HashMap;

public class Telepen
extends BarcodeCommon {
    private static final HashMap<Character, String> Telepen_Code = new HashMap();
    private StartStopCode startCode = StartStopCode.START1;
    private StartStopCode stopCode = StartStopCode.STOP1;
    private int switchModeIndex = 0;
    private int iCheckSum = 0;

    public Telepen(String input) {
        this.setRawData(input);
    }

    private String encodeTelepen() {
        if (Telepen_Code.isEmpty()) {
            this.initTelepen();
        }
        this.iCheckSum = 0;
        this.setEncodingSequence();
        String result = Telepen_Code.get(Character.valueOf(this.startCode.asChar()));
        switch (this.startCode) {
            case START2: {
                this.encodeNumeric(this.getRawData().substring(0, this.switchModeIndex), result);
                if (this.switchModeIndex >= this.getRawData().length()) break;
                this.encodeSwitchMode(result);
                this.encodeASCII(this.getRawData().substring(this.switchModeIndex), result);
                break;
            }
            case START3: {
                this.encodeASCII(this.getRawData().substring(0, this.switchModeIndex), result);
                this.encodeSwitchMode(result);
                this.encodeNumeric(this.getRawData().substring(this.switchModeIndex), result);
                break;
            }
            default: {
                this.encodeASCII(this.getRawData(), result);
            }
        }
        result = String.valueOf(result) + Telepen_Code.get(Character.valueOf(this.Calculate_Checksum(this.iCheckSum)));
        result = String.valueOf(result) + Telepen_Code.get(Character.valueOf(this.stopCode.asChar()));
        return result;
    }

    private void encodeASCII(String input, String output) {
        try {
            char[] cArray = input.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                output = String.valueOf(output) + Telepen_Code.get(Character.valueOf(c));
                this.iCheckSum += c;
                ++n2;
            }
        }
        catch (Exception ex) {
            this.error("ETELEPEN-1: Invalid data when encoding ASCII");
        }
    }

    private void encodeNumeric(String input, String output) {
        try {
            if (input.length() % 2 > 0) {
                this.error("ETELEPEN-3: Numeric encoding attempted on odd number of characters");
            }
            int i = 0;
            while (i < input.length()) {
                output = String.valueOf(output) + Telepen_Code.get(Character.valueOf(Character.forDigit(Integer.parseInt(input.substring(i, i + 2)) + 27, 10)));
                this.iCheckSum += Integer.parseInt(input.substring(i, i + 2)) + 27;
                i += 2;
            }
        }
        catch (Exception ex) {
            this.error("ETELEPEN-2: Numeric encoding failed");
        }
    }

    private void encodeSwitchMode(String output) {
        this.iCheckSum += 16;
        output = String.valueOf(output) + Telepen_Code.get(Character.valueOf(Character.forDigit(16, 10)));
    }

    private char Calculate_Checksum(int iCheckSum) {
        return Character.forDigit(127 - iCheckSum % 127, 10);
    }

    private void setEncodingSequence() {
        this.startCode = StartStopCode.START1;
        this.stopCode = StartStopCode.STOP1;
        this.switchModeIndex = this.getRawData().length();
        int StartNumerics = 0;
        char[] cArray = this.getRawData().toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!Character.isDigit(c)) break;
            ++StartNumerics;
            ++n2;
        }
        if (StartNumerics == this.getRawData().length()) {
            this.startCode = StartStopCode.START2;
            this.stopCode = StartStopCode.STOP2;
            if (this.getRawData().length() % 2 > 0) {
                this.switchModeIndex = this.getRawData().length() - 1;
            }
        } else {
            int EndNumerics = 0;
            int i = this.getRawData().length() - 1;
            while (i >= 0) {
                if (!Character.isDigit(this.getRawData().toCharArray()[i])) break;
                ++EndNumerics;
                --i;
            }
            if (StartNumerics >= 4 || EndNumerics >= 4) {
                if (StartNumerics > EndNumerics) {
                    this.startCode = StartStopCode.START2;
                    this.stopCode = StartStopCode.STOP2;
                    this.switchModeIndex = StartNumerics % 2 == 1 ? StartNumerics - 1 : StartNumerics;
                } else {
                    this.startCode = StartStopCode.START3;
                    this.stopCode = StartStopCode.STOP3;
                    this.switchModeIndex = EndNumerics % 2 == 1 ? this.getRawData().length() - EndNumerics + 1 : this.getRawData().length() - EndNumerics;
                }
            }
        }
    }

    private void initTelepen() {
        Telepen_Code.put(Character.valueOf(Character.forDigit(0, 10)), "1110111011101110");
        Telepen_Code.put(Character.valueOf(Character.forDigit(1, 10)), "1011101110111010");
        Telepen_Code.put(Character.valueOf(Character.forDigit(2, 10)), "1110001110111010");
        Telepen_Code.put(Character.valueOf(Character.forDigit(3, 10)), "1010111011101110");
        Telepen_Code.put(Character.valueOf(Character.forDigit(4, 10)), "1110101110111010");
        Telepen_Code.put(Character.valueOf(Character.forDigit(5, 10)), "1011100011101110");
        Telepen_Code.put(Character.valueOf(Character.forDigit(6, 10)), "1000100011101110");
        Telepen_Code.put(Character.valueOf(Character.forDigit(7, 10)), "1010101110111010");
        Telepen_Code.put(Character.valueOf(Character.forDigit(8, 10)), "1110111000111010");
        Telepen_Code.put(Character.valueOf(Character.forDigit(9, 10)), "1011101011101110");
        Telepen_Code.put(Character.valueOf(Character.forDigit(10, 10)), "1110001011101110");
        Telepen_Code.put(Character.valueOf(Character.forDigit(11, 10)), "1010111000111010");
        Telepen_Code.put(Character.valueOf(Character.forDigit(12, 10)), "1110101011101110");
        Telepen_Code.put(Character.valueOf(Character.forDigit(13, 10)), "1010001000111010");
        Telepen_Code.put(Character.valueOf(Character.forDigit(14, 10)), "1000101000111010");
        Telepen_Code.put(Character.valueOf(Character.forDigit(15, 10)), "1010101011101110");
        Telepen_Code.put(Character.valueOf(Character.forDigit(16, 10)), "1110111010111010");
        Telepen_Code.put(Character.valueOf(Character.forDigit(17, 10)), "1011101110001110");
        Telepen_Code.put(Character.valueOf(Character.forDigit(18, 10)), "1110001110001110");
        Telepen_Code.put(Character.valueOf(Character.forDigit(19, 10)), "1010111010111010");
        Telepen_Code.put(Character.valueOf(Character.forDigit(20, 10)), "1110101110001110");
        Telepen_Code.put(Character.valueOf(Character.forDigit(21, 10)), "1011100010111010");
        Telepen_Code.put(Character.valueOf(Character.forDigit(22, 10)), "1000100010111010");
        Telepen_Code.put(Character.valueOf(Character.forDigit(23, 10)), "1010101110001110");
        Telepen_Code.put(Character.valueOf(Character.forDigit(24, 10)), "1110100010001110");
        Telepen_Code.put(Character.valueOf(Character.forDigit(25, 10)), "1011101010111010");
        Telepen_Code.put(Character.valueOf(Character.forDigit(26, 10)), "1110001010111010");
        Telepen_Code.put(Character.valueOf(Character.forDigit(27, 10)), "1010100010001110");
        Telepen_Code.put(Character.valueOf(Character.forDigit(28, 10)), "1110101010111010");
        Telepen_Code.put(Character.valueOf(Character.forDigit(29, 10)), "1010001010001110");
        Telepen_Code.put(Character.valueOf(Character.forDigit(30, 10)), "1000101010001110");
        Telepen_Code.put(Character.valueOf(Character.forDigit(31, 10)), "1010101010111010");
        Telepen_Code.put(Character.valueOf(' '), "1110111011100010");
        Telepen_Code.put(Character.valueOf('!'), "1011101110101110");
        Telepen_Code.put(Character.valueOf('\"'), "1110001110101110");
        Telepen_Code.put(Character.valueOf('#'), "1010111011100010");
        Telepen_Code.put(Character.valueOf('$'), "1110101110101110");
        Telepen_Code.put(Character.valueOf('%'), "1011100011100010");
        Telepen_Code.put(Character.valueOf('&'), "1000100011100010");
        Telepen_Code.put(Character.valueOf('\''), "1010101110101110");
        Telepen_Code.put(Character.valueOf('('), "1110111000101110");
        Telepen_Code.put(Character.valueOf(')'), "1011101011100010");
        Telepen_Code.put(Character.valueOf('*'), "1110001011100010");
        Telepen_Code.put(Character.valueOf('+'), "1010111000101110");
        Telepen_Code.put(Character.valueOf(','), "1110101011100010");
        Telepen_Code.put(Character.valueOf('-'), "1010001000101110");
        Telepen_Code.put(Character.valueOf('.'), "1000101000101110");
        Telepen_Code.put(Character.valueOf('/'), "1010101011100010");
        Telepen_Code.put(Character.valueOf('0'), "1110111010101110");
        Telepen_Code.put(Character.valueOf('1'), "1011101000100010");
        Telepen_Code.put(Character.valueOf('2'), "1110001000100010");
        Telepen_Code.put(Character.valueOf('3'), "1010111010101110");
        Telepen_Code.put(Character.valueOf('4'), "1110101000100010");
        Telepen_Code.put(Character.valueOf('5'), "1011100010101110");
        Telepen_Code.put(Character.valueOf('6'), "1000100010101110");
        Telepen_Code.put(Character.valueOf('7'), "1010101000100010");
        Telepen_Code.put(Character.valueOf('8'), "1110100010100010");
        Telepen_Code.put(Character.valueOf('9'), "1011101010101110");
        Telepen_Code.put(Character.valueOf(':'), "1110001010101110");
        Telepen_Code.put(Character.valueOf(';'), "1010100010100010");
        Telepen_Code.put(Character.valueOf('<'), "1110101010101110");
        Telepen_Code.put(Character.valueOf('='), "1010001010100010");
        Telepen_Code.put(Character.valueOf('>'), "1000101010100010");
        Telepen_Code.put(Character.valueOf('?'), "1010101010101110");
        Telepen_Code.put(Character.valueOf('@'), "1110111011101010");
        Telepen_Code.put(Character.valueOf('A'), "1011101110111000");
        Telepen_Code.put(Character.valueOf('B'), "1110001110111000");
        Telepen_Code.put(Character.valueOf('C'), "1010111011101010");
        Telepen_Code.put(Character.valueOf('D'), "1110101110111000");
        Telepen_Code.put(Character.valueOf('E'), "1011100011101010");
        Telepen_Code.put(Character.valueOf('F'), "1000100011101010");
        Telepen_Code.put(Character.valueOf('G'), "1010101110111000");
        Telepen_Code.put(Character.valueOf('H'), "1110111000111000");
        Telepen_Code.put(Character.valueOf('I'), "1011101011101010");
        Telepen_Code.put(Character.valueOf('J'), "1110001011101010");
        Telepen_Code.put(Character.valueOf('K'), "1010111000111000");
        Telepen_Code.put(Character.valueOf('L'), "1110101011101010");
        Telepen_Code.put(Character.valueOf('M'), "1010001000111000");
        Telepen_Code.put(Character.valueOf('N'), "1000101000111000");
        Telepen_Code.put(Character.valueOf('O'), "1010101011101010");
        Telepen_Code.put(Character.valueOf('P'), "1110111010111000");
        Telepen_Code.put(Character.valueOf('Q'), "1011101110001010");
        Telepen_Code.put(Character.valueOf('R'), "1110001110001010");
        Telepen_Code.put(Character.valueOf('S'), "1010111010111000");
        Telepen_Code.put(Character.valueOf('T'), "1110101110001010");
        Telepen_Code.put(Character.valueOf('U'), "1011100010111000");
        Telepen_Code.put(Character.valueOf('V'), "1000100010111000");
        Telepen_Code.put(Character.valueOf('W'), "1010101110001010");
        Telepen_Code.put(Character.valueOf('X'), "1110100010001010");
        Telepen_Code.put(Character.valueOf('Y'), "1011101010111000");
        Telepen_Code.put(Character.valueOf('Z'), "1110001010111000");
        Telepen_Code.put(Character.valueOf('['), "1010100010001010");
        Telepen_Code.put(Character.valueOf('\\'), "1110101010111000");
        Telepen_Code.put(Character.valueOf(']'), "1010001010001010");
        Telepen_Code.put(Character.valueOf('^'), "1000101010001010");
        Telepen_Code.put(Character.valueOf('_'), "1010101010111000");
        Telepen_Code.put(Character.valueOf('`'), "1110111010001000");
        Telepen_Code.put(Character.valueOf('a'), "1011101110101010");
        Telepen_Code.put(Character.valueOf('b'), "1110001110101010");
        Telepen_Code.put(Character.valueOf('c'), "1010111010001000");
        Telepen_Code.put(Character.valueOf('d'), "1110101110101010");
        Telepen_Code.put(Character.valueOf('e'), "1011100010001000");
        Telepen_Code.put(Character.valueOf('f'), "1000100010001000");
        Telepen_Code.put(Character.valueOf('g'), "1010101110101010");
        Telepen_Code.put(Character.valueOf('h'), "1110111000101010");
        Telepen_Code.put(Character.valueOf('i'), "1011101010001000");
        Telepen_Code.put(Character.valueOf('j'), "1110001010001000");
        Telepen_Code.put(Character.valueOf('k'), "1010111000101010");
        Telepen_Code.put(Character.valueOf('l'), "1110101010001000");
        Telepen_Code.put(Character.valueOf('m'), "1010001000101010");
        Telepen_Code.put(Character.valueOf('n'), "1000101000101010");
        Telepen_Code.put(Character.valueOf('o'), "1010101010001000");
        Telepen_Code.put(Character.valueOf('p'), "1110111010101010");
        Telepen_Code.put(Character.valueOf('q'), "1011101000101000");
        Telepen_Code.put(Character.valueOf('r'), "1110001000101000");
        Telepen_Code.put(Character.valueOf('s'), "1010111010101010");
        Telepen_Code.put(Character.valueOf('t'), "1110101000101000");
        Telepen_Code.put(Character.valueOf('u'), "1011100010101010");
        Telepen_Code.put(Character.valueOf('v'), "1000100010101010");
        Telepen_Code.put(Character.valueOf('w'), "1010101000101000");
        Telepen_Code.put(Character.valueOf('x'), "1110100010101000");
        Telepen_Code.put(Character.valueOf('y'), "1011101010101010");
        Telepen_Code.put(Character.valueOf('z'), "1110001010101010");
        Telepen_Code.put(Character.valueOf('{'), "1010100010101000");
        Telepen_Code.put(Character.valueOf('|'), "1110101010101010");
        Telepen_Code.put(Character.valueOf('}'), "1010001010101000");
        Telepen_Code.put(Character.valueOf('~'), "1000101010101000");
        Telepen_Code.put(Character.valueOf(Character.forDigit(127, 10)), "1010101010101010");
        Telepen_Code.put(Character.valueOf(StartStopCode.START1.asChar()), "1010101010111000");
        Telepen_Code.put(Character.valueOf(StartStopCode.STOP1.asChar()), "1110001010101010");
        Telepen_Code.put(Character.valueOf(StartStopCode.START2.asChar()), "1010101011101000");
        Telepen_Code.put(Character.valueOf(StartStopCode.STOP2.asChar()), "1110100010101010");
        Telepen_Code.put(Character.valueOf(StartStopCode.START3.asChar()), "1010101110101000");
        Telepen_Code.put(Character.valueOf(StartStopCode.STOP3.asChar()), "1110101000101010");
    }

    public String getEncodedValue() {
        return this.encodeTelepen();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StartStopCode {
        START1(Character.forDigit(0, 10)),
        STOP1(Character.forDigit(1, 10)),
        START2(Character.forDigit(2, 10)),
        STOP2(Character.forDigit(3, 10)),
        START3(Character.forDigit(4, 10)),
        STOP3(Character.forDigit(5, 10));

        private final char asChar;

        private char asChar() {
            return this.asChar;
        }

        private StartStopCode(char asChar) {
            this.asChar = asChar;
        }
    }
}

