/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.opengl.shaders;

import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.test.opengl.shaders.Shader;
import org.lwjgl.test.opengl.shaders.ShadersTest;

final class ShaderVSH
extends Shader {
    final String file;
    final String source;
    final int shaderID;
    final int programID;
    final int uniformLocation;

    ShaderVSH(String shaderFile) {
        this.file = shaderFile;
        this.source = ShaderVSH.getShaderText(shaderFile);
        this.shaderID = ARBShaderObjects.glCreateShaderObjectARB((int)35633);
        ARBShaderObjects.glShaderSourceARB((int)this.shaderID, (CharSequence)this.source);
        ARBShaderObjects.glCompileShaderARB((int)this.shaderID);
        ShaderVSH.printShaderObjectInfoLog(this.file, this.shaderID);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)this.shaderID, (int)35713) == 0) {
            ShadersTest.kill("A compilation error occured in a vertex shader.");
        }
        this.programID = ARBShaderObjects.glCreateProgramObjectARB();
        ARBShaderObjects.glAttachObjectARB((int)this.programID, (int)this.shaderID);
        ARBShaderObjects.glLinkProgramARB((int)this.programID);
        ShaderVSH.printShaderProgramInfoLog(this.programID);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)this.programID, (int)35714) == 0) {
            ShadersTest.kill("A linking error occured in a shader program.");
        }
        this.uniformLocation = ShaderVSH.getUniformLocation(this.programID, "UNIFORMS");
    }

    void render() {
        ARBShaderObjects.glUseProgramObjectARB((int)this.programID);
        ARBShaderObjects.glUniform2fARB((int)this.uniformLocation, (float)ShadersTest.getSin(), (float)((float)ShadersTest.getSpecularity() * 8.0f));
        ShadersTest.renderObject();
        ARBShaderObjects.glUseProgramObjectARB((int)0);
    }

    void cleanup() {
        ARBShaderObjects.glDetachObjectARB((int)this.programID, (int)this.shaderID);
        ARBShaderObjects.glDeleteObjectARB((int)this.shaderID);
        ARBShaderObjects.glDeleteObjectARB((int)this.programID);
    }
}

