/*
 * Decompiled with CFR 0.152.
 */
package SevenZip.Compression.LZ;

import SevenZip.Compression.LZ.InWindow;
import java.io.IOException;
import java.io.InputStream;

public class BinTree
extends InWindow {
    int _cyclicBufferPos;
    int _cyclicBufferSize;
    int _historySize;
    int _matchMaxLen;
    int[] _son;
    int[] _hash;
    int[] _hash2;
    int[] _hash3;
    int _cutValue = 255;
    boolean HASH_ARRAY = true;
    static final int kHash3Size = 262144;
    static final int kBT2HashSize = 65536;
    static final int kBT4Hash2Size = 1024;
    static final int kBT4Hash4Size = 0x100000;
    static final int kBT4bHash4Size = 0x800000;
    static final int kBT2NumHashDirectBytes = 2;
    static final int kBT4NumHashDirectBytes = 0;
    int kHash2Size = 1024;
    int kNumHashDirectBytes = 0;
    int kNumHashBytes = 4;
    int kHashSize = 0x100000;
    public static int[] _CRCTable = new int[256];
    static final int kEmptyHashValue = 0;
    static final int kMaxValForNormalize = Integer.MAX_VALUE;

    public void SetType(int n, boolean bl) {
        boolean bl2 = this.HASH_ARRAY = n > 2;
        if (this.HASH_ARRAY) {
            this.kHash2Size = 1024;
            this.kNumHashDirectBytes = 0;
            this.kNumHashBytes = 4;
            this.kHashSize = bl ? 0x800000 : 0x100000;
        } else {
            this.kNumHashDirectBytes = 2;
            this.kNumHashBytes = 2;
            this.kHashSize = 65536;
        }
    }

    public void Init(InputStream inputStream) throws IOException {
        int n;
        super.Init(inputStream);
        for (n = 0; n < this.kHashSize; ++n) {
            this._hash[n] = 0;
        }
        if (this.HASH_ARRAY) {
            for (n = 0; n < this.kHash2Size; ++n) {
                this._hash2[n] = 0;
            }
            for (n = 0; n < 262144; ++n) {
                this._hash3[n] = 0;
            }
        }
        this._cyclicBufferPos = 0;
        this.ReduceOffsets(-1);
    }

    public void ReleaseStream() {
        super.ReleaseStream();
    }

    public void MovePos() throws IOException {
        ++this._cyclicBufferPos;
        if (this._cyclicBufferPos >= this._cyclicBufferSize) {
            this._cyclicBufferPos = 0;
        }
        super.MovePos();
        if (this._pos == Integer.MAX_VALUE) {
            this.Normalize();
        }
    }

    public int GetIndexByte(int n) {
        return super.GetIndexByte(n);
    }

    public int GetMatchLen(int n, int n2, int n3) {
        return super.GetMatchLen(n, n2, n3);
    }

    public int GetNumAvailableBytes() {
        return super.GetNumAvailableBytes();
    }

    public void Create(int n, int n2, int n3, int n4) {
        int n5 = (n + n2 + n3 + n4) / 2 + 256;
        this._son = null;
        this._hash = null;
        this._hash2 = null;
        this._hash3 = null;
        super.Create(n + n2, n3 + n4, n5);
        this._historySize = n;
        this._matchMaxLen = n3;
        this._cyclicBufferSize = n + 1;
        this._son = new int[this._cyclicBufferSize * 2];
        this._hash = new int[this.kHashSize];
        if (this.HASH_ARRAY) {
            this._hash2 = new int[this.kHash2Size];
            this._hash3 = new int[262144];
        }
    }

    public int GetLongestMatch(int[] nArray) {
        int n;
        int n2;
        int n3;
        int n4;
        if (this._pos + this._matchMaxLen <= this._streamPos) {
            n4 = this._matchMaxLen;
        } else {
            n4 = this._streamPos - this._pos;
            if (n4 < this.kNumHashBytes) {
                return 0;
            }
        }
        int n5 = this._pos > this._historySize ? this._pos - this._historySize : 1;
        int n6 = this._bufferOffset + this._pos;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        if (this.HASH_ARRAY) {
            n3 = _CRCTable[this._bufferBase[n6] & 0xFF] ^ this._bufferBase[n6 + 1];
            n8 = n3 & this.kHash2Size - 1;
            n9 = (n3 ^= this._bufferBase[n6 + 2] << 8) & 0x3FFFF;
            n2 = (n3 ^ _CRCTable[this._bufferBase[n6 + 3] & 0xFF] << 5) & this.kHashSize - 1;
        } else {
            n2 = (this._bufferBase[n6] ^ this._bufferBase[n6 + 1] << 8) & this.kHashSize - 1;
        }
        n3 = this._hash[n2];
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        boolean bl = false;
        boolean bl2 = false;
        if (this.HASH_ARRAY) {
            n10 = this._hash2[n8];
            n11 = this._hash3[n9];
            this._hash2[n8] = this._pos;
            if (n10 >= n5 && this._bufferBase[this._bufferOffset + n10] == this._bufferBase[n6]) {
                n12 = this._pos - n10 - 1;
                n7 = 2;
                bl = true;
            }
            this._hash3[n9] = this._pos;
            if (n11 >= n5 && this._bufferBase[this._bufferOffset + n11] == this._bufferBase[n6]) {
                n13 = this._pos - n11 - 1;
                n7 = 3;
                bl2 = true;
                if (bl) {
                    if (n13 < n12) {
                        n12 = n13;
                    }
                } else {
                    n12 = n13;
                    bl = true;
                }
            }
        }
        this._hash[n2] = this._pos;
        if (n3 < n5) {
            this._son[this._cyclicBufferPos << 1] = 0;
            this._son[(this._cyclicBufferPos << 1) + 1] = 0;
            if (this.HASH_ARRAY) {
                nArray[2] = n12;
                nArray[3] = n13;
            }
            return n7;
        }
        int n14 = (this._cyclicBufferPos << 1) + 1;
        int n15 = this._cyclicBufferPos << 1;
        int n16 = n = this.kNumHashDirectBytes;
        int n17 = n;
        nArray[n17] = this._pos - n3 - 1;
        for (int i = this._cutValue; i > 0; --i) {
            int n18;
            int n19 = this._bufferOffset + n3;
            for (n18 = Math.min(n16, n); n18 < n4 && this._bufferBase[n19 + n18] == this._bufferBase[n6 + n18]; ++n18) {
            }
            int n20 = this._pos - n3;
            while (n18 > n17) {
                nArray[++n17] = n20 - 1;
            }
            int n21 = (n20 <= this._cyclicBufferPos ? this._cyclicBufferPos - n20 : this._cyclicBufferPos - n20 + this._cyclicBufferSize) << 1;
            if (n18 != n4) {
                if (this._bufferBase[n19 + n18] < this._bufferBase[n6 + n18]) {
                    this._son[n15] = n3;
                    n15 = n21 + 1;
                    n3 = this._son[n15];
                    if (n18 > n16) {
                        n16 = n18;
                    }
                } else {
                    this._son[n14] = n3;
                    n14 = n21;
                    n3 = this._son[n14];
                    if (n18 > n) {
                        n = n18;
                    }
                }
            } else if (n18 < this._matchMaxLen) {
                this._son[n14] = n3;
                n14 = n21;
                n3 = this._son[n14];
                if (n18 > n) {
                    n = n18;
                }
            } else {
                this._son[n14] = this._son[n21 + 1];
                this._son[n15] = this._son[n21];
                if (this.HASH_ARRAY) {
                    if (bl && n12 < nArray[2]) {
                        nArray[2] = n12;
                    }
                    if (bl2 && n13 < nArray[3]) {
                        nArray[3] = n13;
                    }
                }
                return n17;
            }
            if (n3 < n5) break;
        }
        this._son[n14] = 0;
        this._son[n15] = 0;
        if (this.HASH_ARRAY) {
            if (bl) {
                if (n17 < 2) {
                    nArray[2] = n12;
                    n17 = 2;
                } else if (n12 < nArray[2]) {
                    nArray[2] = n12;
                }
            }
            if (bl2) {
                if (n17 < 3) {
                    nArray[3] = n13;
                    n17 = 3;
                } else if (n13 < nArray[3]) {
                    nArray[3] = n13;
                }
            }
        }
        return n17;
    }

    public void DummyLongestMatch() {
        int n;
        int n2;
        int n3;
        int n4;
        if (this._pos + this._matchMaxLen <= this._streamPos) {
            n4 = this._matchMaxLen;
        } else {
            n4 = this._streamPos - this._pos;
            if (n4 < this.kNumHashBytes) {
                return;
            }
        }
        int n5 = this._pos > this._historySize ? this._pos - this._historySize : 1;
        int n6 = this._bufferOffset + this._pos;
        int n7 = 0;
        int n8 = 0;
        if (this.HASH_ARRAY) {
            n3 = _CRCTable[this._bufferBase[n6] & 0xFF] ^ this._bufferBase[n6 + 1];
            n7 = n3 & this.kHash2Size - 1;
            n8 = (n3 ^= this._bufferBase[n6 + 2] << 8) & 0x3FFFF;
            n2 = (n3 ^ _CRCTable[this._bufferBase[n6 + 3] & 0xFF] << 5) & this.kHashSize - 1;
        } else {
            n2 = (this._bufferBase[n6] ^ this._bufferBase[n6 + 1] << 8) & this.kHashSize - 1;
        }
        n3 = this._hash[n2];
        int n9 = 0;
        int n10 = 0;
        if (this.HASH_ARRAY) {
            n9 = this._hash2[n7];
            n10 = this._hash3[n8];
            this._hash2[n7] = this._pos;
            this._hash3[n8] = this._pos;
        }
        this._hash[n2] = this._pos;
        if (n3 < n5) {
            this._son[this._cyclicBufferPos << 1] = 0;
            this._son[(this._cyclicBufferPos << 1) + 1] = 0;
            return;
        }
        int n11 = (this._cyclicBufferPos << 1) + 1;
        int n12 = this._cyclicBufferPos << 1;
        int n13 = n = this.kNumHashDirectBytes;
        for (int i = this._cutValue; i > 0; --i) {
            int n14;
            int n15 = this._bufferOffset + n3;
            for (n14 = Math.min(n13, n); n14 < n4 && this._bufferBase[n15 + n14] == this._bufferBase[n6 + n14]; ++n14) {
            }
            int n16 = this._pos - n3;
            int n17 = (n16 <= this._cyclicBufferPos ? this._cyclicBufferPos - n16 : this._cyclicBufferPos - n16 + this._cyclicBufferSize) << 1;
            if (n14 != n4) {
                if (this._bufferBase[n15 + n14] < this._bufferBase[n6 + n14]) {
                    this._son[n12] = n3;
                    n12 = n17 + 1;
                    n3 = this._son[n12];
                    if (n14 > n13) {
                        n13 = n14;
                    }
                } else {
                    this._son[n11] = n3;
                    n11 = n17;
                    n3 = this._son[n11];
                    if (n14 > n) {
                        n = n14;
                    }
                }
            } else if (n14 < this._matchMaxLen) {
                this._son[n11] = n3;
                n11 = n17;
                n3 = this._son[n11];
                if (n14 > n) {
                    n = n14;
                }
            } else {
                this._son[n11] = this._son[n17 + 1];
                this._son[n12] = this._son[n17];
                return;
            }
            if (n3 < n5) break;
        }
        this._son[n11] = 0;
        this._son[n12] = 0;
    }

    void NormalizeLinks(int[] nArray, int n, int n2) {
        for (int i = 0; i < n; ++i) {
            int n3 = nArray[i];
            n3 = n3 <= n2 ? 0 : (n3 -= n2);
            nArray[i] = n3;
        }
    }

    void Normalize() {
        int n = this._pos - this._historySize;
        int n2 = n - 1;
        this.NormalizeLinks(this._son, this._cyclicBufferSize * 2, n2);
        this.NormalizeLinks(this._hash, this.kHashSize, n2);
        if (this.HASH_ARRAY) {
            this.NormalizeLinks(this._hash2, this.kHash2Size, n2);
            this.NormalizeLinks(this._hash3, 262144, n2);
        }
        this.ReduceOffsets(n2);
    }

    static {
        for (int i = 0; i < 256; ++i) {
            int n = i;
            for (int j = 0; j < 8; ++j) {
                if ((n & 1) != 0) {
                    n = n >>> 1 ^ 0xEDB88320;
                    continue;
                }
                n >>>= 1;
            }
            BinTree._CRCTable[i] = n;
        }
    }
}

