/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mirror.apt;

import com.sun.mirror.apt.AnnotationProcessor;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class AnnotationProcessors {
    public static final AnnotationProcessor NO_OP = new NoOpAP();

    public static AnnotationProcessor getCompositeAnnotationProcessor(AnnotationProcessor ... annotationProcessorArray) {
        return new CompositeAnnotationProcessor(annotationProcessorArray);
    }

    public static AnnotationProcessor getCompositeAnnotationProcessor(Collection<AnnotationProcessor> collection) {
        return new CompositeAnnotationProcessor(collection);
    }

    static class CompositeAnnotationProcessor
    implements AnnotationProcessor {
        private List<AnnotationProcessor> aps = new LinkedList<AnnotationProcessor>();

        public CompositeAnnotationProcessor(Collection<AnnotationProcessor> collection) {
            this.aps.addAll(collection);
        }

        public CompositeAnnotationProcessor(AnnotationProcessor ... annotationProcessorArray) {
            for (AnnotationProcessor annotationProcessor : annotationProcessorArray) {
                this.aps.add(annotationProcessor);
            }
        }

        @Override
        public void process() {
            for (AnnotationProcessor annotationProcessor : this.aps) {
                annotationProcessor.process();
            }
        }
    }

    static class NoOpAP
    implements AnnotationProcessor {
        NoOpAP() {
        }

        @Override
        public void process() {
        }
    }
}

