/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CLBuildProgramCallback;
import org.lwjgl.opencl.CLCommandQueue;
import org.lwjgl.opencl.CLContext;
import org.lwjgl.opencl.CLContextCallback;
import org.lwjgl.opencl.CLDevice;
import org.lwjgl.opencl.CLEvent;
import org.lwjgl.opencl.CLFunctionAddress;
import org.lwjgl.opencl.CLKernel;
import org.lwjgl.opencl.CLMem;
import org.lwjgl.opencl.CLNativeKernel;
import org.lwjgl.opencl.CLObject;
import org.lwjgl.opencl.CLPlatform;
import org.lwjgl.opencl.CLProgram;
import org.lwjgl.opencl.CLSampler;
import org.lwjgl.util.generator.Alternate;
import org.lwjgl.util.generator.AutoSize;
import org.lwjgl.util.generator.Check;
import org.lwjgl.util.generator.Code;
import org.lwjgl.util.generator.Const;
import org.lwjgl.util.generator.Constant;
import org.lwjgl.util.generator.GenerateAutos;
import org.lwjgl.util.generator.Helper;
import org.lwjgl.util.generator.Indirect;
import org.lwjgl.util.generator.NativeType;
import org.lwjgl.util.generator.NullTerminated;
import org.lwjgl.util.generator.OutParameter;
import org.lwjgl.util.generator.PointerArray;
import org.lwjgl.util.generator.PointerWrapper;
import org.lwjgl.util.generator.Private;
import org.lwjgl.util.generator.opencl.cl_bool;
import org.lwjgl.util.generator.opencl.cl_byte;
import org.lwjgl.util.generator.opencl.cl_char;
import org.lwjgl.util.generator.opencl.cl_double;
import org.lwjgl.util.generator.opencl.cl_float;
import org.lwjgl.util.generator.opencl.cl_int;
import org.lwjgl.util.generator.opencl.cl_long;
import org.lwjgl.util.generator.opencl.cl_short;
import org.lwjgl.util.generator.opencl.cl_uchar;
import org.lwjgl.util.generator.opencl.cl_uint;
import org.lwjgl.util.generator.opencl.cl_void;
import org.lwjgl.util.generator.opencl.size_t;

public interface CL10 {
    public static final int CL_SUCCESS = 0;
    public static final int CL_DEVICE_NOT_FOUND = -1;
    public static final int CL_DEVICE_NOT_AVAILABLE = -2;
    public static final int CL_COMPILER_NOT_AVAILABLE = -3;
    public static final int CL_MEM_OBJECT_ALLOCATION_FAILURE = -4;
    public static final int CL_OUT_OF_RESOURCES = -5;
    public static final int CL_OUT_OF_HOST_MEMORY = -6;
    public static final int CL_PROFILING_INFO_NOT_AVAILABLE = -7;
    public static final int CL_MEM_COPY_OVERLAP = -8;
    public static final int CL_IMAGE_FORMAT_MISMATCH = -9;
    public static final int CL_IMAGE_FORMAT_NOT_SUPPORTED = -10;
    public static final int CL_BUILD_PROGRAM_FAILURE = -11;
    public static final int CL_MAP_FAILURE = -12;
    public static final int CL_INVALID_VALUE = -30;
    public static final int CL_INVALID_DEVICE_TYPE = -31;
    public static final int CL_INVALID_PLATFORM = -32;
    public static final int CL_INVALID_DEVICE = -33;
    public static final int CL_INVALID_CONTEXT = -34;
    public static final int CL_INVALID_QUEUE_PROPERTIES = -35;
    public static final int CL_INVALID_COMMAND_QUEUE = -36;
    public static final int CL_INVALID_HOST_PTR = -37;
    public static final int CL_INVALID_MEM_OBJECT = -38;
    public static final int CL_INVALID_IMAGE_FORMAT_DESCRIPTOR = -39;
    public static final int CL_INVALID_IMAGE_SIZE = -40;
    public static final int CL_INVALID_SAMPLER = -41;
    public static final int CL_INVALID_BINARY = -42;
    public static final int CL_INVALID_BUILD_OPTIONS = -43;
    public static final int CL_INVALID_PROGRAM = -44;
    public static final int CL_INVALID_PROGRAM_EXECUTABLE = -45;
    public static final int CL_INVALID_KERNEL_NAME = -46;
    public static final int CL_INVALID_KERNEL_DEFINITION = -47;
    public static final int CL_INVALID_KERNEL = -48;
    public static final int CL_INVALID_ARG_INDEX = -49;
    public static final int CL_INVALID_ARG_VALUE = -50;
    public static final int CL_INVALID_ARG_SIZE = -51;
    public static final int CL_INVALID_KERNEL_ARGS = -52;
    public static final int CL_INVALID_WORK_DIMENSION = -53;
    public static final int CL_INVALID_WORK_GROUP_SIZE = -54;
    public static final int CL_INVALID_WORK_ITEM_SIZE = -55;
    public static final int CL_INVALID_GLOBAL_OFFSET = -56;
    public static final int CL_INVALID_EVENT_WAIT_LIST = -57;
    public static final int CL_INVALID_EVENT = -58;
    public static final int CL_INVALID_OPERATION = -59;
    public static final int CL_INVALID_GL_OBJECT = -60;
    public static final int CL_INVALID_BUFFER_SIZE = -61;
    public static final int CL_INVALID_MIP_LEVEL = -62;
    public static final int CL_INVALID_GLOBAL_WORK_SIZE = -63;
    public static final int CL_VERSION_1_0 = 1;
    public static final int CL_FALSE = 0;
    public static final int CL_TRUE = 1;
    public static final int CL_PLATFORM_PROFILE = 2304;
    public static final int CL_PLATFORM_VERSION = 2305;
    public static final int CL_PLATFORM_NAME = 2306;
    public static final int CL_PLATFORM_VENDOR = 2307;
    public static final int CL_PLATFORM_EXTENSIONS = 2308;
    public static final int CL_DEVICE_TYPE_DEFAULT = 1;
    public static final int CL_DEVICE_TYPE_CPU = 2;
    public static final int CL_DEVICE_TYPE_GPU = 4;
    public static final int CL_DEVICE_TYPE_ACCELERATOR = 8;
    public static final int CL_DEVICE_TYPE_ALL = -1;
    public static final int CL_DEVICE_TYPE = 4096;
    public static final int CL_DEVICE_VENDOR_ID = 4097;
    public static final int CL_DEVICE_MAX_COMPUTE_UNITS = 4098;
    public static final int CL_DEVICE_MAX_WORK_ITEM_DIMENSIONS = 4099;
    public static final int CL_DEVICE_MAX_WORK_GROUP_SIZE = 4100;
    public static final int CL_DEVICE_MAX_WORK_ITEM_SIZES = 4101;
    public static final int CL_DEVICE_PREFERRED_VECTOR_WIDTH_CHAR = 4102;
    public static final int CL_DEVICE_PREFERRED_VECTOR_WIDTH_SHORT = 4103;
    public static final int CL_DEVICE_PREFERRED_VECTOR_WIDTH_ = 4104;
    public static final int CL_DEVICE_PREFERRED_VECTOR_WIDTH_LONG = 4105;
    public static final int CL_DEVICE_PREFERRED_VECTOR_WIDTH_FLOAT = 4106;
    public static final int CL_DEVICE_PREFERRED_VECTOR_WIDTH_DOUBLE = 4107;
    public static final int CL_DEVICE_MAX_CLOCK_FREQUENCY = 4108;
    public static final int CL_DEVICE_ADDRESS_BITS = 4109;
    public static final int CL_DEVICE_MAX_READ_IMAGE_ARGS = 4110;
    public static final int CL_DEVICE_MAX_WRITE_IMAGE_ARGS = 4111;
    public static final int CL_DEVICE_MAX_MEM_ALLOC_SIZE = 4112;
    public static final int CL_DEVICE_IMAGE2D_MAX_WIDTH = 4113;
    public static final int CL_DEVICE_IMAGE2D_MAX_HEIGHT = 4114;
    public static final int CL_DEVICE_IMAGE3D_MAX_WIDTH = 4115;
    public static final int CL_DEVICE_IMAGE3D_MAX_HEIGHT = 4116;
    public static final int CL_DEVICE_IMAGE3D_MAX_DEPTH = 4117;
    public static final int CL_DEVICE_IMAGE_SUPPORT = 4118;
    public static final int CL_DEVICE_MAX_PARAMETER_SIZE = 4119;
    public static final int CL_DEVICE_MAX_SAMPLERS = 4120;
    public static final int CL_DEVICE_MEM_BASE_ADDR_ALIGN = 4121;
    public static final int CL_DEVICE_MIN_DATA_TYPE_ALIGN_SIZE = 4122;
    public static final int CL_DEVICE_SINGLE_FP_CONFIG = 4123;
    public static final int CL_DEVICE_GLOBAL_MEM_CACHE_TYPE = 4124;
    public static final int CL_DEVICE_GLOBAL_MEM_CACHELINE_SIZE = 4125;
    public static final int CL_DEVICE_GLOBAL_MEM_CACHE_SIZE = 4126;
    public static final int CL_DEVICE_GLOBAL_MEM_SIZE = 4127;
    public static final int CL_DEVICE_MAX_CONSTANT_BUFFER_SIZE = 4128;
    public static final int CL_DEVICE_MAX_CONSTANT_ARGS = 4129;
    public static final int CL_DEVICE_LOCAL_MEM_TYPE = 4130;
    public static final int CL_DEVICE_LOCAL_MEM_SIZE = 4131;
    public static final int CL_DEVICE_ERROR_CORRECTION_SUPPORT = 4132;
    public static final int CL_DEVICE_PROFILING_TIMER_RESOLUTION = 4133;
    public static final int CL_DEVICE_ENDIAN_LITTLE = 4134;
    public static final int CL_DEVICE_AVAILABLE = 4135;
    public static final int CL_DEVICE_COMPILER_AVAILABLE = 4136;
    public static final int CL_DEVICE_EXECUTION_CAPABILITIES = 4137;
    public static final int CL_DEVICE_QUEUE_PROPERTIES = 4138;
    public static final int CL_DEVICE_NAME = 4139;
    public static final int CL_DEVICE_VENDOR = 4140;
    public static final int CL_DRIVER_VERSION = 4141;
    public static final int CL_DEVICE_PROFILE = 4142;
    public static final int CL_DEVICE_VERSION = 4143;
    public static final int CL_DEVICE_EXTENSIONS = 4144;
    public static final int CL_DEVICE_PLATFORM = 4145;
    public static final int CL_FP_DENORM = 1;
    public static final int CL_FP_INF_NAN = 2;
    public static final int CL_FP_ROUND_TO_NEAREST = 4;
    public static final int CL_FP_ROUND_TO_ZERO = 8;
    public static final int CL_FP_ROUND_TO_INF = 16;
    public static final int CL_FP_FMA = 32;
    public static final int CL_NONE = 0;
    public static final int CL_READ_ONLY_CACHE = 1;
    public static final int CL_READ_WRITE_CACHE = 2;
    public static final int CL_LOCAL = 1;
    public static final int CL_GLOBAL = 2;
    public static final int CL_EXEC_KERNEL = 1;
    public static final int CL_EXEC_NATIVE_KERNEL = 2;
    public static final int CL_QUEUE_OUT_OF_ORDER_EXEC_MODE_ENABLE = 1;
    public static final int CL_QUEUE_PROFILING_ENABLE = 2;
    public static final int CL_CONTEXT_REFERENCE_COUNT = 4224;
    public static final int CL_CONTEXT_DEVICES = 4225;
    public static final int CL_CONTEXT_PROPERTIES = 4226;
    public static final int CL_CONTEXT_PLATFORM = 4228;
    public static final int CL_QUEUE_CONTEXT = 4240;
    public static final int CL_QUEUE_DEVICE = 4241;
    public static final int CL_QUEUE_REFERENCE_COUNT = 4242;
    public static final int CL_QUEUE_PROPERTIES = 4243;
    public static final int CL_MEM_READ_WRITE = 1;
    public static final int CL_MEM_WRITE_ONLY = 2;
    public static final int CL_MEM_READ_ONLY = 4;
    public static final int CL_MEM_USE_HOST_PTR = 8;
    public static final int CL_MEM_ALLOC_HOST_PTR = 16;
    public static final int CL_MEM_COPY_HOST_PTR = 32;
    public static final int CL_R = 4272;
    public static final int CL_A = 4273;
    public static final int CL_RG = 4274;
    public static final int CL_RA = 4275;
    public static final int CL_RGB = 4276;
    public static final int CL_RGBA = 4277;
    public static final int CL_BGRA = 4278;
    public static final int CL_ARGB = 4279;
    public static final int CL_INTENSITY = 4280;
    public static final int CL_LUMINANCE = 4281;
    public static final int CL_SNORM_INT8 = 4304;
    public static final int CL_SNORM_INT16 = 4305;
    public static final int CL_UNORM_INT8 = 4306;
    public static final int CL_UNORM_INT16 = 4307;
    public static final int CL_UNORM_SHORT_565 = 4308;
    public static final int CL_UNORM_SHORT_555 = 4309;
    public static final int CL_UNORM_INT_101010 = 4310;
    public static final int CL_SIGNED_INT8 = 4311;
    public static final int CL_SIGNED_INT16 = 4312;
    public static final int CL_SIGNED_INT32 = 4313;
    public static final int CL_UNSIGNED_INT8 = 4314;
    public static final int CL_UNSIGNED_INT16 = 4315;
    public static final int CL_UNSIGNED_INT32 = 4316;
    public static final int CL_HALF_FLOAT = 4317;
    public static final int CL_FLOAT = 4318;
    public static final int CL_MEM_OBJECT_BUFFER = 4336;
    public static final int CL_MEM_OBJECT_IMAGE2D = 4337;
    public static final int CL_MEM_OBJECT_IMAGE3D = 4338;
    public static final int CL_MEM_TYPE = 4352;
    public static final int CL_MEM_FLAGS = 4353;
    public static final int CL_MEM_SIZE = 4354;
    public static final int CL_MEM_HOST_PTR = 4355;
    public static final int CL_MEM_MAP_COUNT = 4356;
    public static final int CL_MEM_REFERENCE_COUNT = 4357;
    public static final int CL_MEM_CONTEXT = 4358;
    public static final int CL_IMAGE_FORMAT = 4368;
    public static final int CL_IMAGE_ELEMENT_SIZE = 4369;
    public static final int CL_IMAGE_ROW_PITCH = 4370;
    public static final int CL_IMAGE_SLICE_PITCH = 4371;
    public static final int CL_IMAGE_WIDTH = 4372;
    public static final int CL_IMAGE_HEIGHT = 4373;
    public static final int CL_IMAGE_DEPTH = 4374;
    public static final int CL_ADDRESS_NONE = 4400;
    public static final int CL_ADDRESS_CLAMP_TO_EDGE = 4401;
    public static final int CL_ADDRESS_CLAMP = 4402;
    public static final int CL_ADDRESS_REPEAT = 4403;
    public static final int CL_FILTER_NEAREST = 4416;
    public static final int CL_FILTER_LINEAR = 4417;
    public static final int CL_SAMPLER_REFERENCE_COUNT = 4432;
    public static final int CL_SAMPLER_CONTEXT = 4433;
    public static final int CL_SAMPLER_NORMALIZED_COORDS = 4434;
    public static final int CL_SAMPLER_ADDRESSING_MODE = 4435;
    public static final int CL_SAMPLER_FILTER_MODE = 4436;
    public static final int CL_MAP_READ = 1;
    public static final int CL_MAP_WRITE = 2;
    public static final int CL_PROGRAM_REFERENCE_COUNT = 4448;
    public static final int CL_PROGRAM_CONTEXT = 4449;
    public static final int CL_PROGRAM_NUM_DEVICES = 4450;
    public static final int CL_PROGRAM_DEVICES = 4451;
    public static final int CL_PROGRAM_SOURCE = 4452;
    public static final int CL_PROGRAM_BINARY_SIZES = 4453;
    public static final int CL_PROGRAM_BINARIES = 4454;
    public static final int CL_PROGRAM_BUILD_STATUS = 4481;
    public static final int CL_PROGRAM_BUILD_OPTIONS = 4482;
    public static final int CL_PROGRAM_BUILD_LOG = 4483;
    public static final int CL_BUILD_SUCCESS = 0;
    public static final int CL_BUILD_NONE = -1;
    public static final int CL_BUILD_ERROR = -2;
    public static final int CL_BUILD_IN_PROGRESS = -3;
    public static final int CL_KERNEL_FUNCTION_NAME = 4496;
    public static final int CL_KERNEL_NUM_ARGS = 4497;
    public static final int CL_KERNEL_REFERENCE_COUNT = 4498;
    public static final int CL_KERNEL_CONTEXT = 4499;
    public static final int CL_KERNEL_PROGRAM = 4500;
    public static final int CL_KERNEL_WORK_GROUP_SIZE = 4528;
    public static final int CL_KERNEL_COMPILE_WORK_GROUP_SIZE = 4529;
    public static final int CL_KERNEL_LOCAL_MEM_SIZE = 4530;
    public static final int CL_EVENT_COMMAND_QUEUE = 4560;
    public static final int CL_EVENT_COMMAND_TYPE = 4561;
    public static final int CL_EVENT_REFERENCE_COUNT = 4562;
    public static final int CL_EVENT_COMMAND_EXECUTION_STATUS = 4563;
    public static final int CL_COMMAND_NDRANGE_KERNEL = 4592;
    public static final int CL_COMMAND_TASK = 4593;
    public static final int CL_COMMAND_NATIVE_KERNEL = 4594;
    public static final int CL_COMMAND_READ_BUFFER = 4595;
    public static final int CL_COMMAND_WRITE_BUFFER = 4596;
    public static final int CL_COMMAND_COPY_BUFFER = 4597;
    public static final int CL_COMMAND_READ_IMAGE = 4598;
    public static final int CL_COMMAND_WRITE_IMAGE = 4599;
    public static final int CL_COMMAND_COPY_IMAGE = 4600;
    public static final int CL_COMMAND_COPY_IMAGE_TO_BUFFER = 4601;
    public static final int CL_COMMAND_COPY_BUFFER_TO_IMAGE = 4602;
    public static final int CL_COMMAND_MAP_BUFFER = 4603;
    public static final int CL_COMMAND_MAP_IMAGE = 4604;
    public static final int CL_COMMAND_UNMAP_MEM_OBJECT = 4605;
    public static final int CL_COMMAND_MARKER = 4606;
    public static final int CL_COMMAND_ACQUIRE_GL_OBJECTS = 4607;
    public static final int CL_COMMAND_RELEASE_GL_OBJECTS = 4608;
    public static final int CL_COMPLETE = 0;
    public static final int CL_RUNNING = 1;
    public static final int CL_SUBMITTED = 2;
    public static final int CL_QUEUED = 3;
    public static final int CL_PROFILING_COMMAND_QUEUED = 4736;
    public static final int CL_PROFILING_COMMAND_SUBMIT = 4737;
    public static final int CL_PROFILING_COMMAND_START = 4738;
    public static final int CL_PROFILING_COMMAND_END = 4739;

    @Code(javaBeforeNative="\t\tif ( num_platforms == null ) num_platforms = APIUtil.getBufferInt();", javaAfterNative="\t\tif ( __result == CL_SUCCESS && platforms != null ) CLPlatform.registerCLPlatforms(platforms, num_platforms);")
    @cl_int
    public int clGetPlatformIDs(@AutoSize(value="platforms", canBeNull=true) @cl_uint int var1, @OutParameter @Check(canBeNull=true) @NativeType(value="cl_platform_id") PointerBuffer var2, @OutParameter @Check(value="1", canBeNull=true) @cl_uint IntBuffer var3);

    @cl_int
    public int clGetPlatformInfo(@PointerWrapper(value="cl_platform_id", canBeNull=true) CLPlatform var1, @NativeType(value="cl_platform_info") int var2, @AutoSize(value="param_value", canBeNull=true) @size_t long var3, @OutParameter @Check(canBeNull=true) @cl_void ByteBuffer var5, @OutParameter @Check(value="1", canBeNull=true) @NativeType(value="size_t") PointerBuffer var6);

    @Code(javaBeforeNative="\t\telse\n\t\t\tnum_devices = APIUtil.getBufferInt();", javaAfterNative="\t\tif ( __result == CL_SUCCESS && devices != null ) platform.registerCLDevices(devices, num_devices);")
    @cl_int
    public int clGetDeviceIDs(@PointerWrapper(value="cl_platform_id") CLPlatform var1, @NativeType(value="cl_device_type") long var2, @AutoSize(value="devices", canBeNull=true) @cl_uint int var4, @OutParameter @Check(canBeNull=true) @NativeType(value="cl_device_id") PointerBuffer var5, @OutParameter @Check(value="1", canBeNull=true) @cl_uint IntBuffer var6);

    @cl_int
    public int clGetDeviceInfo(@PointerWrapper(value="cl_device_id") CLDevice var1, @NativeType(value="cl_device_info") int var2, @AutoSize(value="param_value", canBeNull=true) @size_t long var3, @OutParameter @Check(canBeNull=true) @cl_void ByteBuffer var5, @OutParameter @Check(value="1", canBeNull=true) @NativeType(value="size_t") PointerBuffer var6);

    @Code(tryBlock=true, javaBeforeNative="\t\tlong user_data = pfn_notify == null || pfn_notify.isCustom() ? 0 : CallbackUtil.createGlobalRef(pfn_notify);", javaFinally="\t\t\tif ( __result != null ) __result.setContextCallback(user_data);")
    @Check(value="errcode_ret", canBeNull=true)
    @PointerWrapper(value="cl_context", params="APIUtil.getCLPlatform(properties)")
    public CLContext clCreateContext(@NullTerminated @Check(value="3") @Const @NativeType(value="cl_context_properties") PointerBuffer var1, @AutoSize(value="devices") @cl_uint int var2, @Check(value="1") @Const @NativeType(value="cl_device_id") PointerBuffer var3, @PointerWrapper(value="cl_create_context_callback", canBeNull=true) CLContextCallback var4, @Constant(value="user_data") @PointerWrapper(value="void *") long var5, @OutParameter @Check(value="1", canBeNull=true) @cl_int IntBuffer var7);

    @Alternate(value="clCreateContext")
    @Code(tryBlock=true, javaBeforeNative="\t\tlong user_data = pfn_notify == null || pfn_notify.isCustom() ? 0 : CallbackUtil.createGlobalRef(pfn_notify);", javaFinally="\t\t\tif ( __result != null ) __result.setContextCallback(user_data);")
    @Check(value="errcode_ret", canBeNull=true)
    @PointerWrapper(value="cl_context", params="APIUtil.getCLPlatform(properties)")
    public CLContext clCreateContext(@NullTerminated @Check(value="3") @Const @NativeType(value="cl_context_properties") PointerBuffer var1, @Constant(value="1") @cl_uint int var2, @Constant(value="APIUtil.getPointer(device)", keepParam=true) CLDevice var3, @PointerWrapper(value="cl_create_context_callback", canBeNull=true) CLContextCallback var4, @Constant(value="user_data") @PointerWrapper(value="void *") long var5, @OutParameter @Check(value="1", canBeNull=true) @cl_int IntBuffer var7);

    @Code(tryBlock=true, javaBeforeNative="\t\tlong user_data = pfn_notify == null || pfn_notify.isCustom() ? 0 : CallbackUtil.createGlobalRef(pfn_notify);", javaFinally="\t\t\tif ( __result != null ) __result.setContextCallback(user_data);")
    @Check(value="errcode_ret", canBeNull=true)
    @PointerWrapper(value="cl_context", params="APIUtil.getCLPlatform(properties)")
    public CLContext clCreateContextFromType(@NullTerminated @Check(value="3") @Const @NativeType(value="cl_context_properties") PointerBuffer var1, @NativeType(value="cl_device_type") long var2, @PointerWrapper(value="cl_create_context_callback", canBeNull=true) CLContextCallback var4, @Constant(value="user_data") @PointerWrapper(value="void *") long var5, @OutParameter @Check(value="1", canBeNull=true) @cl_int IntBuffer var7);

    @Code(javaAfterNative="\t\tif ( __result == CL_SUCCESS ) context.retain();")
    @cl_int
    public int clRetainContext(@PointerWrapper(value="cl_context") CLContext var1);

    @Code(javaBeforeNative="\t\tAPIUtil.releaseObjects(context);", javaAfterNative="\t\tif ( __result == CL_SUCCESS ) context.releaseImpl();")
    @cl_int
    public int clReleaseContext(@PointerWrapper(value="cl_context") CLContext var1);

    @Code(javaBeforeNative="\t\tif ( param_value_size_ret == null && APIUtil.isDevicesParam(param_name) ) param_value_size_ret = APIUtil.getBufferPointer();", javaAfterNative="\t\tif ( __result == CL_SUCCESS && param_value != null && APIUtil.isDevicesParam(param_name) ) context.getParent().registerCLDevices(param_value, param_value_size_ret);")
    @cl_int
    public int clGetContextInfo(@PointerWrapper(value="cl_context") CLContext var1, @NativeType(value="cl_context_info") int var2, @AutoSize(value="param_value", canBeNull=true) @size_t long var3, @OutParameter @Check(canBeNull=true) @cl_void ByteBuffer var5, @OutParameter @Check(value="1", canBeNull=true) @NativeType(value="size_t") PointerBuffer var6);

    @Check(value="errcode_ret", canBeNull=true)
    @PointerWrapper(value="cl_command_queue", params="context, device")
    public CLCommandQueue clCreateCommandQueue(@PointerWrapper(value="cl_context") CLContext var1, @PointerWrapper(value="cl_device_id") CLDevice var2, @NativeType(value="cl_command_queue_properties") long var3, @OutParameter @Check(value="1", canBeNull=true) @cl_int IntBuffer var5);

    @Code(javaAfterNative="\t\tif ( __result == CL_SUCCESS ) command_queue.retain();")
    @cl_int
    public int clRetainCommandQueue(@PointerWrapper(value="cl_command_queue") CLCommandQueue var1);

    @Code(javaBeforeNative="\t\tAPIUtil.releaseObjects(command_queue);", javaAfterNative="\t\tif ( __result == CL_SUCCESS ) command_queue.release();")
    @cl_int
    public int clReleaseCommandQueue(@PointerWrapper(value="cl_command_queue") CLCommandQueue var1);

    @cl_int
    public int clGetCommandQueueInfo(@PointerWrapper(value="cl_command_queue") CLCommandQueue var1, @NativeType(value="cl_command_queue_info") int var2, @AutoSize(value="param_value", canBeNull=true) @size_t long var3, @OutParameter @Check(canBeNull=true) @cl_void ByteBuffer var5, @OutParameter @Check(value="1", canBeNull=true) @NativeType(value="size_t") PointerBuffer var6);

    @GenerateAutos
    @Check(value="errcode_ret", canBeNull=true)
    @PointerWrapper(value="cl_mem", params="context")
    public CLMem clCreateBuffer(@PointerWrapper(value="cl_context") CLContext var1, @NativeType(value="cl_mem_flags") long var2, @AutoSize(value="host_ptr") @size_t long var4, @cl_byte @cl_short @cl_int @cl_long @cl_float @cl_double Buffer var6, @OutParameter @Check(value="1", canBeNull=true) @cl_int IntBuffer var7);

    @Code(javaAfterNative="\t\tif ( __result == CL_SUCCESS ) command_queue.registerCLEvent(event);")
    @cl_int
    public int clEnqueueReadBuffer(@PointerWrapper(value="cl_command_queue") CLCommandQueue var1, @PointerWrapper(value="cl_mem") CLMem var2, @cl_bool int var3, @size_t long var4, @AutoSize(value="ptr") @size_t long var6, @OutParameter @cl_byte @cl_short @cl_int @cl_long @cl_float @cl_double Buffer var8, @AutoSize(value="event_wait_list", canBeNull=true) @cl_uint int var9, @Check(canBeNull=true) @Const @NativeType(value="cl_event") PointerBuffer var10, @OutParameter @Check(value="1", canBeNull=true) @NativeType(value="cl_event") PointerBuffer var11);

    @Code(javaAfterNative="\t\tif ( __result == CL_SUCCESS ) command_queue.registerCLEvent(event);")
    @cl_int
    public int clEnqueueWriteBuffer(@PointerWrapper(value="cl_command_queue") CLCommandQueue var1, @PointerWrapper(value="cl_mem") CLMem var2, @cl_bool int var3, @size_t long var4, @AutoSize(value="ptr") @size_t long var6, @Const @cl_byte @cl_short @cl_int @cl_long @cl_float @cl_double Buffer var8, @AutoSize(value="event_wait_list", canBeNull=true) @cl_uint int var9, @Check(canBeNull=true) @Const @NativeType(value="cl_event") PointerBuffer var10, @OutParameter @Check(value="1", canBeNull=true) @NativeType(value="cl_event") PointerBuffer var11);

    @Code(javaAfterNative="\t\tif ( __result == CL_SUCCESS ) command_queue.registerCLEvent(event);")
    @cl_int
    public int clEnqueueCopyBuffer(@PointerWrapper(value="cl_command_queue") CLCommandQueue var1, @PointerWrapper(value="cl_mem") CLMem var2, @PointerWrapper(value="cl_mem") CLMem var3, @size_t long var4, @size_t long var6, @size_t long var8, @AutoSize(value="event_wait_list", canBeNull=true) @cl_uint int var10, @Check(canBeNull=true) @Const @NativeType(value="cl_event") PointerBuffer var11, @OutParameter @Check(value="1", canBeNull=true) @NativeType(value="cl_event") PointerBuffer var12);

    @Code(javaAfterNative="\t\tif ( __result != null ) command_queue.registerCLEvent(event);")
    @Check(value="errcode_ret", canBeNull=true)
    @cl_void
    @AutoSize(value="size")
    public ByteBuffer clEnqueueMapBuffer(@PointerWrapper(value="cl_command_queue") CLCommandQueue var1, @PointerWrapper(value="cl_mem") CLMem var2, @cl_bool int var3, @NativeType(value="cl_map_flags") long var4, @size_t long var6, @size_t long var8, @AutoSize(value="event_wait_list", canBeNull=true) @cl_uint int var10, @Check(canBeNull=true) @Const @NativeType(value="cl_event") PointerBuffer var11, @OutParameter @Check(value="1", canBeNull=true) @NativeType(value="cl_event") PointerBuffer var12, @OutParameter @Check(value="1", canBeNull=true) @cl_int IntBuffer var13);

    @Check(value="errcode_ret", canBeNull=true)
    @PointerWrapper(value="cl_mem", params="context")
    public CLMem clCreateImage2D(@PointerWrapper(value="cl_context") CLContext var1, @NativeType(value="cl_mem_flags") long var2, @Check(value="2 * 4") @Const @NativeType(value="cl_image_format") ByteBuffer var4, @size_t long var5, @size_t long var7, @size_t long var9, @Check(value="CLChecks.calculateImage2DSize(host_ptr, image_format, image_width, image_height, image_row_pitch)", canBeNull=true) @cl_byte @cl_short @cl_int @cl_float Buffer var11, @OutParameter @Check(value="1", canBeNull=true) @cl_int IntBuffer var12);

    @Check(value="errcode_ret", canBeNull=true)
    @PointerWrapper(value="cl_mem", params="context")
    public CLMem clCreateImage3D(@PointerWrapper(value="cl_context") CLContext var1, @NativeType(value="cl_mem_flags") long var2, @Check(value="2 * 4") @Const @NativeType(value="cl_image_format") ByteBuffer var4, @size_t long var5, @size_t long var7, @size_t long var9, @size_t long var11, @size_t long var13, @Check(value="CLChecks.calculateImage3DSize(host_ptr, image_format, image_width, image_height, image_height, image_row_pitch, image_slice_pitch)", canBeNull=true) @cl_byte @cl_short @cl_int @cl_float Buffer var15, @OutParameter @Check(value="1", canBeNull=true) @cl_int IntBuffer var16);

    @cl_int
    public int clGetSupportedImageFormats(@PointerWrapper(value="cl_context") CLContext var1, @NativeType(value="cl_mem_flags") long var2, @NativeType(value="cl_mem_object_type") int var4, @AutoSize(value="image_formats", expression=" / (2 * 4)", canBeNull=true) @cl_uint int var5, @OutParameter @Check(canBeNull=true) @NativeType(value="cl_image_format") ByteBuffer var6, @OutParameter @Check(value="1", canBeNull=true) @cl_uint IntBuffer var7);

    @Code(javaAfterNative="\t\tif ( __result == CL_SUCCESS ) command_queue.registerCLEvent(event);")
    @cl_int
    public int clEnqueueReadImage(@PointerWrapper(value="cl_command_queue") CLCommandQueue var1, @PointerWrapper(value="cl_mem") CLMem var2, @cl_bool int var3, @Check(value="3") @Const @NativeType(value="size_t") PointerBuffer var4, @Check(value="3") @Const @NativeType(value="size_t") PointerBuffer var5, @size_t long var6, @size_t long var8, @OutParameter @Check(value="CLChecks.calculateImageSize(region, row_pitch, slice_pitch)") @cl_byte @cl_short @cl_int @cl_float Buffer var10, @AutoSize(value="event_wait_list", canBeNull=true) @cl_uint int var11, @Check(canBeNull=true) @Const @NativeType(value="cl_event") PointerBuffer var12, @OutParameter @Check(value="1", canBeNull=true) @NativeType(value="cl_event") PointerBuffer var13);

    @Code(javaAfterNative="\t\tif ( __result == CL_SUCCESS ) command_queue.registerCLEvent(event);")
    @cl_int
    public int clEnqueueWriteImage(@PointerWrapper(value="cl_command_queue") CLCommandQueue var1, @PointerWrapper(value="cl_mem") CLMem var2, @cl_bool int var3, @Check(value="3") @Const @NativeType(value="size_t") PointerBuffer var4, @Check(value="3") @Const @NativeType(value="size_t") PointerBuffer var5, @size_t long var6, @size_t long var8, @Check(value="CLChecks.calculateImageSize(region, input_row_pitch, input_slice_pitch)") @Const @cl_byte @cl_short @cl_int @cl_float Buffer var10, @AutoSize(value="event_wait_list", canBeNull=true) @cl_uint int var11, @Check(canBeNull=true) @Const @NativeType(value="cl_event") PointerBuffer var12, @OutParameter @Check(value="1", canBeNull=true) @NativeType(value="cl_event") PointerBuffer var13);

    @Code(javaAfterNative="\t\tif ( __result == CL_SUCCESS ) command_queue.registerCLEvent(event);")
    @cl_int
    public int clEnqueueCopyImage(@PointerWrapper(value="cl_command_queue") CLCommandQueue var1, @PointerWrapper(value="cl_mem") CLMem var2, @PointerWrapper(value="cl_mem") CLMem var3, @Check(value="3") @Const @NativeType(value="size_t") PointerBuffer var4, @Check(value="3") @Const @NativeType(value="size_t") PointerBuffer var5, @Check(value="3") @Const @NativeType(value="size_t") PointerBuffer var6, @AutoSize(value="event_wait_list", canBeNull=true) @cl_uint int var7, @Check(canBeNull=true) @Const @NativeType(value="cl_event") PointerBuffer var8, @OutParameter @Check(value="1", canBeNull=true) @NativeType(value="cl_event") PointerBuffer var9);

    @Code(javaAfterNative="\t\tif ( __result == CL_SUCCESS ) command_queue.registerCLEvent(event);")
    @cl_int
    public int clEnqueueCopyImageToBuffer(@PointerWrapper(value="cl_command_queue") CLCommandQueue var1, @PointerWrapper(value="cl_mem") CLMem var2, @PointerWrapper(value="cl_mem") CLMem var3, @Check(value="3") @Const @NativeType(value="size_t") PointerBuffer var4, @Check(value="3") @Const @NativeType(value="size_t") PointerBuffer var5, @size_t long var6, @AutoSize(value="event_wait_list", canBeNull=true) @cl_uint int var8, @Check(canBeNull=true) @Const @NativeType(value="cl_event") PointerBuffer var9, @OutParameter @Check(value="1", canBeNull=true) @NativeType(value="cl_event") PointerBuffer var10);

    @Code(javaAfterNative="\t\tif ( __result == CL_SUCCESS ) command_queue.registerCLEvent(event);")
    @cl_int
    public int clEnqueueCopyBufferToImage(@PointerWrapper(value="cl_command_queue") CLCommandQueue var1, @PointerWrapper(value="cl_mem") CLMem var2, @PointerWrapper(value="cl_mem") CLMem var3, @size_t long var4, @Check(value="3") @Const @NativeType(value="size_t") PointerBuffer var6, @Check(value="3") @Const @NativeType(value="size_t") PointerBuffer var7, @AutoSize(value="event_wait_list", canBeNull=true) @cl_uint int var8, @Check(canBeNull=true) @Const @NativeType(value="cl_event") PointerBuffer var9, @OutParameter @Check(value="1", canBeNull=true) @NativeType(value="cl_event") PointerBuffer var10);

    @Code(javaAfterNative="\t\tif ( __result != null ) command_queue.registerCLEvent(event);")
    @Check(value="errcode_ret", canBeNull=true)
    @cl_void
    @AutoSize(value="extcl_CalculateImageSize(region_address, *image_row_pitch_address, image_slice_pitch_address == NULL ? 0 : *image_slice_pitch_address)", isNative=true)
    public ByteBuffer clEnqueueMapImage(@PointerWrapper(value="cl_command_queue") CLCommandQueue var1, @PointerWrapper(value="cl_mem") CLMem var2, @cl_bool int var3, @NativeType(value="cl_map_flags") long var4, @Check(value="3") @Const @NativeType(value="size_t") PointerBuffer var6, @Check(value="3") @Const @NativeType(value="size_t") PointerBuffer var7, @OutParameter @Check(value="1") @NativeType(value="size_t") PointerBuffer var8, @OutParameter @Check(value="1", canBeNull=true) @NativeType(value="size_t") PointerBuffer var9, @AutoSize(value="event_wait_list", canBeNull=true) @cl_uint int var10, @Check(canBeNull=true) @Const @NativeType(value="cl_event") PointerBuffer var11, @OutParameter @Check(value="1", canBeNull=true) @NativeType(value="cl_event") PointerBuffer var12, @OutParameter @Check(value="1", canBeNull=true) @cl_int IntBuffer var13);

    @cl_int
    public int clGetImageInfo(@PointerWrapper(value="cl_mem") CLMem var1, @NativeType(value="cl_image_info") int var2, @AutoSize(value="param_value", canBeNull=true) @size_t long var3, @OutParameter @Check(canBeNull=true) @cl_void ByteBuffer var5, @OutParameter @Check(value="1", canBeNull=true) @NativeType(value="size_t") PointerBuffer var6);

    @Code(javaAfterNative="\t\tif ( __result == CL_SUCCESS ) memobj.retain();")
    @cl_int
    public int clRetainMemObject(@PointerWrapper(value="cl_mem") CLMem var1);

    @Code(javaAfterNative="\t\tif ( __result == CL_SUCCESS ) memobj.release();")
    @cl_int
    public int clReleaseMemObject(@PointerWrapper(value="cl_mem") CLMem var1);

    @Code(javaAfterNative="\t\tif ( __result == CL_SUCCESS ) command_queue.registerCLEvent(event);")
    @cl_int
    public int clEnqueueUnmapMemObject(@PointerWrapper(value="cl_command_queue") CLCommandQueue var1, @PointerWrapper(value="cl_mem") CLMem var2, @Check @cl_void ByteBuffer var3, @AutoSize(value="event_wait_list", canBeNull=true) @cl_uint int var4, @Check(canBeNull=true) @Const @NativeType(value="cl_event") PointerBuffer var5, @OutParameter @Check(value="1", canBeNull=true) @NativeType(value="cl_event") PointerBuffer var6);

    @cl_int
    public int clGetMemObjectInfo(@PointerWrapper(value="cl_mem") CLMem var1, @NativeType(value="cl_mem_info") int var2, @AutoSize(value="param_value", canBeNull=true) @size_t long var3, @OutParameter @Check(canBeNull=true) @cl_void ByteBuffer var5, @OutParameter @Check(value="1", canBeNull=true) @NativeType(value="size_t") PointerBuffer var6);

    @Check(value="errcode_ret", canBeNull=true)
    @PointerWrapper(value="cl_sampler", params="context")
    public CLSampler clCreateSampler(@PointerWrapper(value="cl_context") CLContext var1, @cl_bool int var2, @NativeType(value="cl_addressing_mode") int var3, @NativeType(value="cl_filter_mode") int var4, @OutParameter @Check(value="1", canBeNull=true) @cl_int IntBuffer var5);

    @Code(javaAfterNative="\t\tif ( __result == CL_SUCCESS ) sampler.retain();")
    @cl_int
    public int clRetainSampler(@PointerWrapper(value="cl_sampler") CLSampler var1);

    @Code(javaAfterNative="\t\tif ( __result == CL_SUCCESS ) sampler.release();")
    @cl_int
    public int clReleaseSampler(@PointerWrapper(value="cl_sampler") CLSampler var1);

    @cl_int
    public int clGetSamplerInfo(@PointerWrapper(value="cl_sampler") CLSampler var1, @NativeType(value="cl_sampler_info") int var2, @AutoSize(value="param_value", canBeNull=true) @size_t long var3, @OutParameter @Check(canBeNull=true) @cl_void ByteBuffer var5, @OutParameter @Check(value="1", canBeNull=true) @NativeType(value="size_t") PointerBuffer var6);

    @Check(value="errcode_ret", canBeNull=true)
    @PointerWrapper(value="cl_program", params="context")
    public CLProgram clCreateProgramWithSource(@PointerWrapper(value="cl_context") CLContext var1, @Constant(value="1") @cl_uint int var2, @Check @Indirect @Const @cl_char ByteBuffer var3, @AutoSize(value="string") @Indirect @Const @size_t long var4, @OutParameter @Check(value="1", canBeNull=true) @cl_int IntBuffer var6);

    @Alternate(value="clCreateProgramWithSource", nativeAlt=true)
    @Check(value="errcode_ret", canBeNull=true)
    @PointerWrapper(value="cl_program", params="context")
    public CLProgram clCreateProgramWithSource2(@PointerWrapper(value="cl_context") CLContext var1, @AutoSize(value="lengths") @cl_uint int var2, @Check(value="APIUtil.getSize(lengths)") @PointerArray(value="count", lengths="lengths") @Const @NativeType(value="cl_char") ByteBuffer var3, @Check(value="1") @Const @NativeType(value="size_t") PointerBuffer var4, @OutParameter @Check(value="1", canBeNull=true) @cl_int IntBuffer var5);

    @Alternate(value="clCreateProgramWithSource", nativeAlt=true)
    @Check(value="errcode_ret", canBeNull=true)
    @PointerWrapper(value="cl_program", params="context")
    public CLProgram clCreateProgramWithSource3(@PointerWrapper(value="cl_context") CLContext var1, @Constant(value="strings.length") @cl_uint int var2, @Check(value="1") @PointerArray(value="count") @Const @NativeType(value="cl_char") ByteBuffer[] var3, @Constant(value="APIUtil.getLengths(strings)") @Const @NativeType(value="size_t") PointerBuffer var4, @OutParameter @Check(value="1", canBeNull=true) @cl_int IntBuffer var5);

    @Alternate(value="clCreateProgramWithSource")
    @Check(value="errcode_ret", canBeNull=true)
    @PointerWrapper(value="cl_program", params="context")
    public CLProgram clCreateProgramWithSource(@PointerWrapper(value="cl_context") CLContext var1, @Constant(value="1") @cl_uint int var2, CharSequence var3, @Constant(value="string.length()") @Indirect @Const @size_t long var4, @OutParameter @Check(value="1", canBeNull=true) @cl_int IntBuffer var6);

    @Alternate(value="clCreateProgramWithSource", nativeAlt=true)
    @Check(value="errcode_ret", canBeNull=true)
    @PointerWrapper(value="cl_program", params="context")
    public CLProgram clCreateProgramWithSource4(@PointerWrapper(value="cl_context") CLContext var1, @Constant(value="strings.length") @cl_uint int var2, @Const @PointerArray(value="count", lengths="lengths") CharSequence[] var3, @Constant(value="APIUtil.getLengths(strings)") @Const @NativeType(value="size_t") PointerBuffer var4, @OutParameter @Check(value="1", canBeNull=true) @cl_int IntBuffer var5);

    @Check(value="errcode_ret", canBeNull=true)
    @PointerWrapper(value="cl_program", params="context")
    public CLProgram clCreateProgramWithBinary(@PointerWrapper(value="cl_context") CLContext var1, @Constant(value="1") @cl_uint int var2, @Const @Indirect @PointerWrapper(value="cl_device_id") CLDevice var3, @AutoSize(value="binary") @Const @Indirect @size_t long var4, @Const @Indirect @cl_uchar ByteBuffer var6, @OutParameter @Check(value="1") @cl_int IntBuffer var7, @OutParameter @Check(value="1", canBeNull=true) @cl_int IntBuffer var8);

    @Alternate(value="clCreateProgramWithBinary", nativeAlt=true)
    @Check(value="errcode_ret", canBeNull=true)
    @PointerWrapper(value="cl_program", params="context")
    public CLProgram clCreateProgramWithBinary2(@PointerWrapper(value="cl_context") CLContext var1, @AutoSize(value="device_list") @cl_uint int var2, @Check(value="1") @Const @NativeType(value="cl_device_id") PointerBuffer var3, @Check(value="device_list.remaining()") @Const @NativeType(value="size_t") PointerBuffer var4, @Check(value="APIUtil.getSize(lengths)") @PointerArray(value="num_devices", lengths="lengths") @Const @NativeType(value="cl_uchar") ByteBuffer var5, @OutParameter @Check(value="device_list.remaining()") @cl_int IntBuffer var6, @OutParameter @Check(value="1", canBeNull=true) @cl_int IntBuffer var7);

    @Alternate(value="clCreateProgramWithBinary", nativeAlt=true)
    @Check(value="errcode_ret", canBeNull=true)
    @PointerWrapper(value="cl_program", params="context")
    public CLProgram clCreateProgramWithBinary3(@PointerWrapper(value="cl_context") CLContext var1, @Constant(value="binaries.length") @cl_uint int var2, @Check(value="binaries.length") @Const @NativeType(value="cl_device_id") PointerBuffer var3, @Constant(value="APIUtil.getLengths(binaries)") @Const @NativeType(value="size_t") PointerBuffer var4, @Check(value="1") @PointerArray(value="num_devices") @Const @NativeType(value="cl_uchar") ByteBuffer[] var5, @OutParameter @Check(value="binaries.length") @cl_int IntBuffer var6, @OutParameter @Check(value="1", canBeNull=true) @cl_int IntBuffer var7);

    @Code(javaAfterNative="\t\tif ( __result == CL_SUCCESS ) program.retain();")
    @cl_int
    public int clRetainProgram(@PointerWrapper(value="cl_program") CLProgram var1);

    @Code(javaBeforeNative="\t\tAPIUtil.releaseObjects(program);", javaAfterNative="\t\tif ( __result == CL_SUCCESS ) program.release();")
    @cl_int
    public int clReleaseProgram(@PointerWrapper(value="cl_program") CLProgram var1);

    @Code(tryBlock=true, javaBeforeNative="\t\tlong user_data = CallbackUtil.createGlobalRef(pfn_notify);\n\t\tif ( pfn_notify != null ) pfn_notify.setContext(program.getParent());", javaFinally="\t\t\tCallbackUtil.checkCallback(__result, user_data);")
    @cl_int
    public int clBuildProgram(@PointerWrapper(value="cl_program") CLProgram var1, @AutoSize(value="device_list", canBeNull=true) @cl_uint int var2, @Check(canBeNull=true) @Const @NativeType(value="cl_device_id") PointerBuffer var3, @Check @NullTerminated @Const @cl_char ByteBuffer var4, @PointerWrapper(value="cl_program_callback", canBeNull=true) CLBuildProgramCallback var5, @Constant(value="user_data") @PointerWrapper(value="void *") long var6);

    @Alternate(value="clBuildProgram")
    @Code(tryBlock=true, javaBeforeNative="\t\tlong user_data = CallbackUtil.createGlobalRef(pfn_notify);\n\t\tif ( pfn_notify != null ) pfn_notify.setContext(program.getParent());", javaFinally="\t\t\tCallbackUtil.checkCallback(__result, user_data);")
    @cl_int
    public int clBuildProgram(@PointerWrapper(value="cl_program") CLProgram var1, @AutoSize(value="device_list", canBeNull=true) @cl_uint int var2, @Check(canBeNull=true) @Const @NativeType(value="cl_device_id") PointerBuffer var3, @NullTerminated @Const CharSequence var4, @PointerWrapper(value="cl_program_callback", canBeNull=true) CLBuildProgramCallback var5, @Constant(value="user_data") @PointerWrapper(value="void *") long var6);

    @Alternate(value="clBuildProgram")
    @Code(tryBlock=true, javaBeforeNative="\t\tlong user_data = CallbackUtil.createGlobalRef(pfn_notify);\n\t\tif ( pfn_notify != null ) pfn_notify.setContext(program.getParent());", javaFinally="\t\t\tCallbackUtil.checkCallback(__result, user_data);")
    @cl_int
    public int clBuildProgram(@PointerWrapper(value="cl_program") CLProgram var1, @Constant(value="1") @cl_uint int var2, @Constant(value="APIUtil.getPointer(device)", keepParam=true) CLDevice var3, @NullTerminated @Const CharSequence var4, @PointerWrapper(value="cl_program_callback", canBeNull=true) CLBuildProgramCallback var5, @Constant(value="user_data") @PointerWrapper(value="void *") long var6);

    @cl_int
    public int clUnloadCompiler();

    @cl_int
    public int clGetProgramInfo(@PointerWrapper(value="cl_program") CLProgram var1, @NativeType(value="cl_program_info") int var2, @AutoSize(value="param_value", canBeNull=true) @size_t long var3, @OutParameter @Check(canBeNull=true) @cl_void ByteBuffer var5, @OutParameter @Check(value="1", canBeNull=true) @NativeType(value="size_t") PointerBuffer var6);

    @Alternate(value="clGetProgramInfo", nativeAlt=true)
    @cl_int
    public int clGetProgramInfo2(@PointerWrapper(value="cl_program") CLProgram var1, @Constant(value="CL_PROGRAM_BINARIES") @NativeType(value="cl_program_info") int var2, @Constant(value="sizes_len * sizeof(cl_uchar *)", isNative=true) @size_t long var3, @Constant(value="sizes.remaining()") @Helper(passToNative=true) @size_t long var5, @Helper(passToNative=true) @Check(value="1") @Const @NativeType(value="size_t") PointerBuffer var7, @OutParameter @Check(value="APIUtil.getSize(sizes)") @PointerArray(value="sizes_len", lengths="sizes") @NativeType(value="cl_uchar") ByteBuffer var8, @OutParameter @Check(value="1", canBeNull=true) @NativeType(value="size_t") PointerBuffer var9);

    @Alternate(value="clGetProgramInfo", nativeAlt=true)
    @cl_int
    public int clGetProgramInfo3(@PointerWrapper(value="cl_program") CLProgram var1, @Constant(value="CL_PROGRAM_BINARIES") @NativeType(value="cl_program_info") int var2, @Constant(value="param_value_len * sizeof(cl_uchar *)", isNative=true) @size_t long var3, @Constant(value="param_value.length") @Helper(passToNative=true) @size_t long var5, @PointerArray(value="param_value_len") @NativeType(value="cl_uchar") ByteBuffer[] var7, @OutParameter @Check(value="1", canBeNull=true) @NativeType(value="size_t") PointerBuffer var8);

    @cl_int
    public int clGetProgramBuildInfo(@PointerWrapper(value="cl_program") CLProgram var1, @PointerWrapper(value="cl_device_id") CLDevice var2, @NativeType(value="cl_program_build_info") int var3, @AutoSize(value="param_value", canBeNull=true) @size_t long var4, @OutParameter @Check(canBeNull=true) @cl_void ByteBuffer var6, @OutParameter @Check(value="1", canBeNull=true) @NativeType(value="size_t") PointerBuffer var7);

    @Check(value="errcode_ret", canBeNull=true)
    @PointerWrapper(value="cl_kernel", params="program")
    public CLKernel clCreateKernel(@PointerWrapper(value="cl_program") CLProgram var1, @NullTerminated @Const @cl_char ByteBuffer var2, @OutParameter @Check(value="1", canBeNull=true) @cl_int IntBuffer var3);

    @Alternate(value="clCreateKernel")
    @Check(value="errcode_ret", canBeNull=true)
    @PointerWrapper(value="cl_kernel", params="program")
    public CLKernel clCreateKernel(@PointerWrapper(value="cl_program") CLProgram var1, @NullTerminated @Const CharSequence var2, @OutParameter @Check(value="1", canBeNull=true) @cl_int IntBuffer var3);

    @Code(javaAfterNative="\t\tif ( __result == CL_SUCCESS && kernels != null ) program.registerCLKernels(kernels);")
    @cl_int
    public int clCreateKernelsInProgram(@PointerWrapper(value="cl_program") CLProgram var1, @AutoSize(value="kernels", canBeNull=true) @cl_uint int var2, @OutParameter @Check(canBeNull=true) @NativeType(value="cl_kernel") PointerBuffer var3, @OutParameter @Check(value="1", canBeNull=true) @cl_uint IntBuffer var4);

    @Code(javaAfterNative="\t\tif ( __result == CL_SUCCESS ) kernel.retain();")
    @cl_int
    public int clRetainKernel(@PointerWrapper(value="cl_kernel") CLKernel var1);

    @Code(javaAfterNative="\t\tif ( __result == CL_SUCCESS ) kernel.release();")
    @cl_int
    public int clReleaseKernel(@PointerWrapper(value="cl_kernel") CLKernel var1);

    @GenerateAutos
    @cl_int
    public int clSetKernelArg(@PointerWrapper(value="cl_kernel") CLKernel var1, @cl_uint int var2, @AutoSize(value="arg_value") @size_t long var3, @Const @cl_byte @cl_short @cl_int @cl_long @cl_float @cl_double Buffer var5);

    @Alternate(value="clSetKernelArg")
    @cl_int
    public int clSetKernelArg(@PointerWrapper(value="cl_kernel") CLKernel var1, @cl_uint int var2, @Constant(value="PointerBuffer.getPointerSize()") @size_t long var3, @Check(canBeNull=true) @Const @Constant(value="APIUtil.getPointerSafe(arg_value)", keepParam=true) CLObject var5);

    @Alternate(value="clSetKernelArg")
    @Private
    @cl_int
    public int clSetKernelArg3(@PointerWrapper(value="cl_kernel") CLKernel var1, @cl_uint int var2, @size_t long var3, @Constant(value="MemoryUtil.getAddress0(arg_value)", keepParam=true) Buffer var5);

    @cl_int
    public int clGetKernelInfo(@PointerWrapper(value="cl_kernel") CLKernel var1, @NativeType(value="cl_kernel_info") int var2, @AutoSize(value="param_value", canBeNull=true) @size_t long var3, @OutParameter @Check(canBeNull=true) @cl_void ByteBuffer var5, @OutParameter @Check(value="1", canBeNull=true) @NativeType(value="size_t") PointerBuffer var6);

    @cl_int
    public int clGetKernelWorkGroupInfo(@PointerWrapper(value="cl_kernel") CLKernel var1, @PointerWrapper(value="cl_device_id", canBeNull=true) CLDevice var2, @NativeType(value="cl_kernel_work_group_info") int var3, @AutoSize(value="param_value", canBeNull=true) @size_t long var4, @OutParameter @Check(canBeNull=true) @cl_void ByteBuffer var6, @OutParameter @Check(value="1", canBeNull=true) @NativeType(value="size_t") PointerBuffer var7);

    @Code(javaAfterNative="\t\tif ( __result == CL_SUCCESS ) command_queue.registerCLEvent(event);")
    @cl_int
    public int clEnqueueNDRangeKernel(@PointerWrapper(value="cl_command_queue") CLCommandQueue var1, @PointerWrapper(value="cl_kernel") CLKernel var2, @cl_uint int var3, @Check(value="work_dim", canBeNull=true) @Const @NativeType(value="size_t") PointerBuffer var4, @Check(value="work_dim", canBeNull=true) @Const @NativeType(value="size_t") PointerBuffer var5, @Check(value="work_dim", canBeNull=true) @Const @NativeType(value="size_t") PointerBuffer var6, @AutoSize(value="event_wait_list", canBeNull=true) @cl_uint int var7, @Check(canBeNull=true) @Const @NativeType(value="cl_event") PointerBuffer var8, @OutParameter @Check(value="1", canBeNull=true) @NativeType(value="cl_event") PointerBuffer var9);

    @Code(javaAfterNative="\t\tif ( __result == CL_SUCCESS ) command_queue.registerCLEvent(event);")
    @cl_int
    public int clEnqueueTask(@PointerWrapper(value="cl_command_queue") CLCommandQueue var1, @PointerWrapper(value="cl_kernel") CLKernel var2, @AutoSize(value="event_wait_list", canBeNull=true) @cl_uint int var3, @Check(canBeNull=true) @Const @NativeType(value="cl_event") PointerBuffer var4, @OutParameter @Check(value="1", canBeNull=true) @NativeType(value="cl_event") PointerBuffer var5);

    @Code(tryBlock=true, javaBeforeNative="\t\tlong user_func_ref = CallbackUtil.createGlobalRef(user_func);\n\t\tByteBuffer args = APIUtil.getNativeKernelArgs(user_func_ref, mem_list, sizes);", javaAfterNative="\t\tif ( __result == CL_SUCCESS ) command_queue.registerCLEvent(event);", javaFinally="\t\t\tCallbackUtil.checkCallback(__result, user_func_ref);", nativeAfterVars="\tvoid **args_mem_loc = num_mem_objects == 0 ? NULL : (void **)malloc(num_mem_objects * sizeof(void *));", nativeBeforeCall="\t_ptr_i = 0;\n\twhile ( _ptr_i < num_mem_objects ) {\n\t\targs_mem_loc[_ptr_i] = (cl_void *)((char *)args_address + (12 + 4 + _ptr_i * (4 + sizeof(void *))));\n\t\t_ptr_i++;\n\t}", nativeAfterCall="\tfree(args_mem_loc);")
    @cl_int
    public int clEnqueueNativeKernel(@PointerWrapper(value="cl_command_queue") CLCommandQueue var1, @PointerWrapper(value="cl_native_kernel_func") CLNativeKernel var2, @Constant(value="MemoryUtil.getAddress0(args)") @cl_void ByteBuffer var3, @AutoSize(value="args") @size_t long var4, @Constant(value="mem_list == null ? 0 : mem_list.length") @cl_uint int var6, @Check(value="1", canBeNull=true) @PointerArray(value="num_mem_objects") @Const @NativeType(value="cl_mem") CLMem[] var7, @Check(value="mem_list.length", canBeNull=true) @Helper long[] var8, @Constant(value="(const void**)args_mem_loc", isNative=true) @Const @Indirect @cl_void ByteBuffer var9, @AutoSize(value="event_wait_list", canBeNull=true) @cl_uint int var10, @Check(canBeNull=true) @Const @NativeType(value="cl_event") PointerBuffer var11, @OutParameter @Check(value="1", canBeNull=true) @NativeType(value="cl_event") PointerBuffer var12);

    @cl_int
    public int clWaitForEvents(@AutoSize(value="event_list") @cl_uint int var1, @Check(value="1") @Const @NativeType(value="cl_event") PointerBuffer var2);

    @Alternate(value="clWaitForEvents")
    @cl_int
    public int clWaitForEvents(@Constant(value="1") @cl_uint int var1, @Constant(value="APIUtil.getPointer(event)", keepParam=true) CLEvent var2);

    @cl_int
    public int clGetEventInfo(@PointerWrapper(value="cl_event") CLEvent var1, @NativeType(value="cl_event_info") int var2, @AutoSize(value="param_value", canBeNull=true) @size_t long var3, @OutParameter @Check(canBeNull=true) @cl_void ByteBuffer var5, @OutParameter @Check(value="1", canBeNull=true) @NativeType(value="size_t") PointerBuffer var6);

    @Code(javaAfterNative="\t\tif ( __result == CL_SUCCESS ) event.retain();")
    @cl_int
    public int clRetainEvent(@PointerWrapper(value="cl_event") CLEvent var1);

    @Code(javaAfterNative="\t\tif ( __result == CL_SUCCESS ) event.release();")
    @cl_int
    public int clReleaseEvent(@PointerWrapper(value="cl_event") CLEvent var1);

    @Code(javaAfterNative="\t\tif ( __result == CL_SUCCESS ) command_queue.registerCLEvent(event);")
    @cl_int
    public int clEnqueueMarker(@PointerWrapper(value="cl_command_queue") CLCommandQueue var1, @OutParameter @Check(value="1") @NativeType(value="cl_event") PointerBuffer var2);

    @cl_int
    public int clEnqueueBarrier(@PointerWrapper(value="cl_command_queue") CLCommandQueue var1);

    @cl_int
    public int clEnqueueWaitForEvents(@PointerWrapper(value="cl_command_queue") CLCommandQueue var1, @AutoSize(value="event_list") @cl_uint int var2, @Check(value="1") @Const @NativeType(value="cl_event") PointerBuffer var3);

    @Alternate(value="clEnqueueWaitForEvents")
    @cl_int
    public int clEnqueueWaitForEvents(@PointerWrapper(value="cl_command_queue") CLCommandQueue var1, @Constant(value="1") @cl_uint int var2, @Constant(value="APIUtil.getPointer(event)", keepParam=true) CLEvent var3);

    @cl_int
    public int clGetEventProfilingInfo(@PointerWrapper(value="cl_event") CLEvent var1, @NativeType(value="cl_profiling_info") int var2, @AutoSize(value="param_value", canBeNull=true) @size_t long var3, @OutParameter @Check(canBeNull=true) @cl_void ByteBuffer var5, @OutParameter @Check(value="1", canBeNull=true) @NativeType(value="size_t") PointerBuffer var6);

    @cl_int
    public int clFlush(@PointerWrapper(value="cl_command_queue") CLCommandQueue var1);

    @cl_int
    public int clFinish(@PointerWrapper(value="cl_command_queue") CLCommandQueue var1);

    @Private
    @PointerWrapper(value="void *")
    public CLFunctionAddress clGetExtensionFunctionAddress(@NullTerminated @Const @cl_char ByteBuffer var1);

    @Alternate(value="clGetExtensionFunctionAddress")
    @Private
    @PointerWrapper(value="void *")
    public CLFunctionAddress clGetExtensionFunctionAddress(@NullTerminated CharSequence var1);
}

