/*
 * Decompiled with CFR 0.152.
 */
package com.vulpovile.games.paddlenet;

import com.vulpovile.games.listeners.SettingsListener;
import com.vulpovile.games.paddlenet.Sound;
import com.vulpovile.games.paddlenet.netcode.NetworkHandler;
import com.vulpovile.games.paddlenet.netcode.packet.Packet1Paddle1;
import com.vulpovile.games.paddlenet.netcode.packet.Packet2Paddle2;
import com.vulpovile.games.paddlenet.netcode.packet.Packet3Score1;
import com.vulpovile.games.paddlenet.netcode.packet.Packet4Score2;
import com.vulpovile.games.paddlenet.netcode.packet.Packet5BallVelocity;
import com.vulpovile.games.paddlenet.netcode.packet.Packet6BallPosition;
import com.vulpovile.games.paddlenet.netcode.packet.Packet7PaddleHit;
import com.vulpovile.games.paddlenet.netcode.packet.Packet8PaddleMiss;
import com.vulpovile.games.paddlenet.netcode.packet.Packet9BoardConfiguration;
import com.vulpovile.util.MathUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Random;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class PaddlePanel
extends JPanel
implements MouseMotionListener,
MouseWheelListener,
KeyListener {
    private static final long serialVersionUID = 1L;
    public static final int PADDLE = 0;
    public static final int TENNIS = 1;
    public static final int HOCKEY = 2;
    public static final int SQUASH = 3;
    private Random random = new Random();
    private JFrame containerWindow;
    private NetworkHandler networkHandler = null;
    private boolean isWaiting = false;
    private byte gameOverScore = (byte)15;
    private short paddle1 = (short)240;
    private short paddle2 = (short)240;
    private short paddle1HeightHalf = (short)40;
    private short paddle2HeightHalf = (short)40;
    private short ballX = (short)320;
    private short ballY = (short)240;
    private byte ballXVelocity = (byte)5;
    private byte ballYVelocity = 0;
    private byte ballHeightHalf = (byte)8;
    private byte ballWidthHalf = (byte)8;
    private short lastMouseTick = (short)-1;
    private byte resetTicks = (byte)-1;
    private byte score1 = 0;
    private byte score2 = 0;
    private byte gameMode = 0;
    private byte paddleDivider = (byte)2;
    private boolean gameOver = false;
    private boolean colour = false;
    private boolean rightOwner = false;
    private boolean paddle12hit = false;
    private boolean paddle22hit = false;
    private ArrayList settingsListeners = new ArrayList();

    public PaddlePanel(JFrame jFrame) {
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.addKeyListener(this);
        this.setFocusable(true);
        this.requestFocus();
        this.requestFocusInWindow();
        this.containerWindow = jFrame;
        this.reset();
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        super.paintComponent(g);
        g2d.scale((float)this.getWidth() / 640.0f, (float)this.getHeight() / 480.0f);
        g2d.setColor(Color.BLACK);
        g2d.fillRect(0, 0, 640, 480);
        if (this.colour) {
            g2d.setColor(Color.YELLOW);
        } else {
            g2d.setColor(Color.WHITE);
        }
        if (!this.isWaiting && this.gameMode != 3) {
            g2d.fillRect(316, 2, 8, 474);
        }
        int i = 0;
        while (i < 160) {
            g2d.fillRect(i * 10 + 3, 2, 4, 4);
            g2d.fillRect(i * 10 + 3, 472, 4, 4);
            ++i;
        }
        if (this.gameMode == 2) {
            i = 0;
            while (i < 14) {
                g2d.fillRect(3, i * 10 + 2, 4, 4);
                g2d.fillRect(633, i * 10 + 2, 4, 4);
                g2d.fillRect(3, 472 - i * 10, 4, 4);
                g2d.fillRect(633, 472 - i * 10, 4, 4);
                ++i;
            }
        } else if (this.gameMode == 3) {
            i = 0;
            while (i < 60) {
                g2d.fillRect(3, i * 10 + 2, 4, 4);
                ++i;
            }
        }
        g2d.translate(150, 10);
        if (this.score1 >= 10) {
            this.drawDigit(this.score1 / 10, g2d);
        }
        g2d.translate(65, 0);
        this.drawDigit(this.score1 % 10, g2d);
        g2d.translate(155, 0);
        if (this.score2 >= 10) {
            this.drawDigit(this.score2 / 10, g2d);
        }
        g2d.translate(65, 0);
        this.drawDigit(this.score2 % 10, g2d);
        g2d.translate(-435, -10);
        if (this.isWaiting) {
            g2d.translate(198, 190);
            this.drawWait(g2d);
            g2d.translate(-198, -190);
        }
        if (this.colour) {
            g2d.setColor(Color.BLUE);
        }
        g2d.fillRect(this.ballX - this.ballWidthHalf, this.ballY - this.ballHeightHalf, this.ballWidthHalf + this.ballWidthHalf, this.ballHeightHalf + this.ballHeightHalf);
        if (this.gameMode == 3) {
            if (!this.rightOwner && this.colour) {
                g2d.setColor(Color.RED.darker());
            } else if (!this.rightOwner) {
                g2d.setColor(Color.GRAY);
            } else if (this.colour) {
                g2d.setColor(Color.RED);
            }
        } else if (this.colour) {
            g2d.setColor(Color.RED);
        } else {
            g2d.setColor(Color.WHITE);
        }
        if (this.gameMode == 3) {
            g2d.fillRect(594, this.paddle1 - this.paddle1HeightHalf, 8, this.paddle1HeightHalf + this.paddle1HeightHalf);
        } else {
            g2d.fillRect(20, this.paddle1 - this.paddle1HeightHalf, 8, this.paddle1HeightHalf + this.paddle1HeightHalf);
        }
        if (this.gameMode == 1) {
            g2d.fillRect(220, this.paddle1 - this.paddle1HeightHalf, 8, this.paddle1HeightHalf + this.paddle1HeightHalf);
        } else if (this.gameMode == 2) {
            g2d.fillRect(472, this.paddle1 - this.paddle1HeightHalf, 8, this.paddle1HeightHalf + this.paddle1HeightHalf);
        }
        if (this.gameMode == 3) {
            if (this.rightOwner && this.colour) {
                g2d.setColor(Color.CYAN.darker());
            } else if (this.rightOwner) {
                g2d.setColor(Color.GRAY);
            } else if (this.colour) {
                g2d.setColor(Color.CYAN);
            } else {
                g2d.setColor(Color.WHITE);
            }
        } else if (this.colour) {
            g2d.setColor(Color.CYAN);
        } else {
            g2d.setColor(Color.WHITE);
        }
        g2d.fillRect(612, this.paddle2 - this.paddle2HeightHalf, 8, this.paddle2HeightHalf + this.paddle2HeightHalf);
        if (this.gameMode == 1) {
            g2d.fillRect(412, this.paddle2 - this.paddle2HeightHalf, 8, this.paddle2HeightHalf + this.paddle2HeightHalf);
        } else if (this.gameMode == 2) {
            g2d.fillRect(160, this.paddle2 - this.paddle2HeightHalf, 8, this.paddle2HeightHalf + this.paddle2HeightHalf);
        }
    }

    public void drawWait(Graphics2D g2d) {
        g2d.fillRect(0, 0, 15, 100);
        g2d.fillRect(35, 0, 15, 100);
        g2d.fillRect(70, 0, 15, 100);
        g2d.fillRect(0, 85, 75, 15);
        g2d.fillRect(100, 0, 50, 15);
        g2d.fillRect(100, 50, 50, 15);
        g2d.fillRect(100, 0, 15, 100);
        g2d.fillRect(135, 0, 15, 100);
        g2d.fillRect(165, 0, 15, 100);
        g2d.fillRect(195, 0, 49, 15);
        g2d.fillRect(213, 0, 15, 100);
    }

    public void drawDigit(int digit, Graphics2D g2d) {
        switch (digit) {
            case 1: {
                g2d.fillRect(35, 0, 15, 52);
                g2d.fillRect(35, 52, 15, 51);
                break;
            }
            case 2: {
                g2d.fillRect(0, 0, 50, 15);
                g2d.fillRect(0, 42, 50, 15);
                g2d.fillRect(0, 88, 50, 15);
                g2d.fillRect(0, 52, 15, 51);
                g2d.fillRect(35, 0, 15, 52);
                break;
            }
            case 3: {
                g2d.fillRect(0, 0, 50, 15);
                g2d.fillRect(0, 42, 50, 15);
                g2d.fillRect(0, 88, 50, 15);
                g2d.fillRect(35, 0, 15, 52);
                g2d.fillRect(35, 52, 15, 51);
                break;
            }
            case 4: {
                g2d.fillRect(0, 0, 15, 52);
                g2d.fillRect(35, 0, 15, 52);
                g2d.fillRect(35, 52, 15, 51);
                g2d.fillRect(0, 42, 50, 15);
                break;
            }
            case 5: {
                g2d.fillRect(0, 0, 50, 15);
                g2d.fillRect(0, 42, 50, 15);
                g2d.fillRect(0, 88, 50, 15);
                g2d.fillRect(0, 0, 15, 52);
                g2d.fillRect(35, 52, 15, 51);
                break;
            }
            case 6: {
                g2d.fillRect(0, 0, 15, 52);
                g2d.fillRect(0, 0, 50, 15);
                g2d.fillRect(0, 42, 50, 15);
                g2d.fillRect(0, 88, 50, 15);
                g2d.fillRect(35, 52, 15, 51);
                g2d.fillRect(0, 52, 15, 51);
                break;
            }
            case 7: {
                g2d.fillRect(0, 0, 50, 15);
                g2d.fillRect(35, 0, 15, 52);
                g2d.fillRect(35, 52, 15, 51);
                break;
            }
            case 8: {
                g2d.fillRect(0, 0, 15, 52);
                g2d.fillRect(0, 52, 15, 51);
                g2d.fillRect(35, 0, 15, 52);
                g2d.fillRect(35, 52, 15, 51);
                g2d.fillRect(0, 0, 50, 15);
                g2d.fillRect(0, 42, 50, 15);
                g2d.fillRect(0, 88, 50, 15);
                break;
            }
            case 9: {
                g2d.fillRect(0, 0, 15, 52);
                g2d.fillRect(35, 0, 15, 52);
                g2d.fillRect(35, 52, 15, 51);
                g2d.fillRect(0, 0, 50, 15);
                g2d.fillRect(0, 42, 50, 15);
                g2d.fillRect(0, 88, 50, 15);
                break;
            }
            default: {
                g2d.fillRect(0, 0, 15, 52);
                g2d.fillRect(0, 52, 15, 51);
                g2d.fillRect(35, 0, 15, 52);
                g2d.fillRect(35, 52, 15, 51);
                g2d.fillRect(0, 0, 50, 15);
                g2d.fillRect(0, 88, 50, 15);
            }
        }
    }

    public void tick() {
        if (this.networkHandler == null || this.networkHandler.isServer()) {
            short newPaddle2 = (short)(this.lastMouseTick * 480 / this.getHeight());
            if (newPaddle2 != this.paddle2 && this.networkHandler != null) {
                this.networkHandler.enqueuePacket(new Packet2Paddle2(newPaddle2));
            }
            this.paddle2 = newPaddle2;
        } else {
            short newPaddle1 = (short)(this.lastMouseTick * 480 / this.getHeight());
            if (newPaddle1 != this.paddle1 && this.networkHandler != null) {
                this.networkHandler.enqueuePacket(new Packet1Paddle1(newPaddle1));
            }
            this.paddle1 = newPaddle1;
        }
        if (this.resetTicks == -1) {
            if (this.ballY != Short.MIN_VALUE) {
                this.ballY = (short)(this.ballY + this.ballYVelocity);
                int i = 0;
                while (i < Math.abs(this.ballXVelocity)) {
                    this.ballX = (short)(this.ballX + MathUtil.signum(this.ballXVelocity));
                    if (!this.isServer() && this.rightOwner && (this.ballX < -20 || this.gameMode == 3 && this.ballX > 660)) {
                        this.resetTicks = (byte)60;
                        this.ballX = (short)-10;
                        if (!this.gameOver) {
                            this.score2 = (byte)(this.score2 + 1);
                            if (this.networkHandler != null) {
                                this.networkHandler.enqueuePacket(new Packet8PaddleMiss());
                                this.networkHandler.enqueuePacket(new Packet4Score2(this.score2));
                            }
                            if (this.score2 >= this.gameOverScore) {
                                this.gameOver = true;
                                this.sendBoardConfiguration(true);
                            }
                        }
                        Sound.toneAsync(2019, 50, 0.5);
                        break;
                    }
                    if (!this.rightOwner && this.ballX > 660 && (this.networkHandler == null || this.networkHandler.isServer())) {
                        this.resetTicks = (byte)60;
                        this.ballX = (short)-10;
                        if (!this.gameOver) {
                            this.score1 = (byte)(this.score1 + 1);
                            if (this.networkHandler != null) {
                                this.networkHandler.enqueuePacket(new Packet8PaddleMiss());
                                this.networkHandler.enqueuePacket(new Packet3Score1(this.score1));
                            }
                            if (this.score1 >= this.gameOverScore) {
                                this.gameOver = true;
                                this.sendBoardConfiguration(true);
                            }
                        }
                        Sound.toneAsync(2019, 50, 0.5);
                        break;
                    }
                    if (this.networkHandler == null && this.rightOwner) {
                        this.paddle1 = (short)(this.paddle1 - (short)((this.paddle1 - this.ballY) / (20 + this.random.nextInt(40))));
                    }
                    if (this.ballY < this.ballHeightHalf + this.ballHeightHalf && this.ballYVelocity < 0 || this.ballY > 480 && this.ballYVelocity > 0) {
                        this.ballYVelocity = -this.ballYVelocity;
                        Sound.toneAsync(496, 50, 0.5);
                        break;
                    }
                    if (this.gameMode == 3 && this.ballXVelocity < 0 && this.ballX < 4) {
                        this.ballXVelocity = -this.ballXVelocity;
                        Sound.toneAsync(496, 50, 0.5);
                        break;
                    }
                    if (this.gameMode == 2 && (this.ballY < 142 || this.ballY > 338) && (this.ballXVelocity < 0 && this.ballX < 4 || this.ballXVelocity > 0 && this.ballX > 636)) {
                        this.ballXVelocity = -this.ballXVelocity;
                        this.paddle22hit = false;
                        this.paddle12hit = false;
                        this.updateDirection();
                        Sound.toneAsync(496, 50, 0.5);
                        break;
                    }
                    if (!this.gameOver) {
                        if (this.isMain() && !this.rightOwner && this.ballX > 612 && this.ballX < 620 && this.ballY < this.paddle2 + this.paddle2HeightHalf + this.ballHeightHalf && this.ballY > this.paddle2 - this.paddle2HeightHalf - this.ballHeightHalf) {
                            this.paddle22hit = false;
                            this.paddle12hit = false;
                            this.rightOwner = !this.rightOwner;
                            this.ballXVelocity = -this.ballXVelocity;
                            int ballHitOffset = (this.ballY - this.paddle2) / (2 * (this.paddle2HeightHalf / 20)) / this.paddleDivider;
                            this.ballYVelocity = (byte)(ballHitOffset * Math.abs(this.ballXVelocity / 5));
                            Sound.toneAsync(1019, 50, 0.5);
                            if (this.networkHandler != null) {
                                this.networkHandler.enqueuePacket(new Packet7PaddleHit(this.ballX, this.ballY, this.ballXVelocity, this.ballYVelocity));
                            }
                            break;
                        }
                        if (!this.isServer() && this.rightOwner && (this.gameMode == 3 && this.ballXVelocity > 0 && this.ballX > 594 && this.ballX < 602 || this.gameMode != 3 && this.ballX > 20 && this.ballX < 28) && this.ballY < this.paddle1 + this.paddle1HeightHalf + this.ballHeightHalf && this.ballY > this.paddle1 - this.paddle1HeightHalf - this.ballHeightHalf) {
                            this.paddle22hit = false;
                            this.paddle12hit = false;
                            this.rightOwner = !this.rightOwner;
                            this.ballXVelocity = -this.ballXVelocity;
                            int ballHitOffset = (this.ballY - this.paddle1) / (2 * (this.paddle1HeightHalf / 20)) / this.paddleDivider;
                            this.ballYVelocity = (byte)(ballHitOffset * Math.abs(this.ballXVelocity / 5));
                            Sound.toneAsync(1019, 50, 0.5);
                            if (this.networkHandler != null) {
                                this.networkHandler.enqueuePacket(new Packet7PaddleHit(this.ballX, this.ballY, this.ballXVelocity, this.ballYVelocity));
                            }
                            break;
                        }
                        if (this.gameMode == 2) {
                            if (this.isMain() && !this.paddle22hit && this.ballX > 160 && this.ballX < 168 && this.ballY < this.paddle2 + this.paddle2HeightHalf + this.ballHeightHalf && this.ballY > this.paddle2 - this.paddle2HeightHalf - this.ballHeightHalf) {
                                this.paddle22hit = true;
                                if (!this.rightOwner) {
                                    this.paddle12hit = false;
                                    this.rightOwner = !this.rightOwner;
                                    this.ballXVelocity = -this.ballXVelocity;
                                }
                                int ballHitOffset = (this.ballY - this.paddle2) / (2 * (this.paddle2HeightHalf / 20)) / this.paddleDivider;
                                this.ballYVelocity = (byte)(ballHitOffset * Math.abs(this.ballXVelocity / 5));
                                Sound.toneAsync(1019, 50, 0.5);
                                if (this.networkHandler != null) {
                                    this.networkHandler.enqueuePacket(new Packet7PaddleHit(this.ballX, this.ballY, this.ballXVelocity, this.ballYVelocity, this.rightOwner));
                                }
                                break;
                            }
                            if (!this.isServer() && !this.paddle12hit && this.ballX > 472 && this.ballX < 480 && this.ballY < this.paddle1 + this.paddle1HeightHalf + this.ballHeightHalf && this.ballY > this.paddle1 - this.paddle1HeightHalf - this.ballHeightHalf) {
                                this.paddle12hit = true;
                                if (this.rightOwner) {
                                    this.paddle22hit = false;
                                    this.rightOwner = !this.rightOwner;
                                    this.ballXVelocity = -this.ballXVelocity;
                                }
                                int ballHitOffset = (this.ballY - this.paddle1) / (2 * (this.paddle1HeightHalf / 20)) / this.paddleDivider;
                                this.ballYVelocity = (byte)(ballHitOffset * Math.abs(this.ballXVelocity / 5));
                                Sound.toneAsync(1019, 50, 0.5);
                                if (this.networkHandler != null) {
                                    this.networkHandler.enqueuePacket(new Packet7PaddleHit(this.ballX, this.ballY, this.ballXVelocity, this.ballYVelocity, !this.rightOwner));
                                }
                                break;
                            }
                        } else if (this.gameMode == 1) {
                            if (this.isMain() && !this.rightOwner && this.ballX > 412 && this.ballX < 420 && this.ballY < this.paddle2 + this.paddle2HeightHalf + this.ballHeightHalf && this.ballY > this.paddle2 - this.paddle2HeightHalf - this.ballHeightHalf) {
                                this.paddle22hit = false;
                                this.paddle12hit = false;
                                this.rightOwner = !this.rightOwner;
                                this.ballXVelocity = -this.ballXVelocity;
                                int ballHitOffset = (this.ballY - this.paddle2) / (2 * (this.paddle2HeightHalf / 20)) / this.paddleDivider;
                                this.ballYVelocity = (byte)(ballHitOffset * Math.abs(this.ballXVelocity / 5));
                                Sound.toneAsync(1019, 50, 0.5);
                                if (this.networkHandler != null) {
                                    this.networkHandler.enqueuePacket(new Packet7PaddleHit(this.ballX, this.ballY, this.ballXVelocity, this.ballYVelocity));
                                }
                                break;
                            }
                            if (!this.isServer() && this.rightOwner && this.ballX > 220 && this.ballX < 228 && this.ballY < this.paddle1 + this.paddle1HeightHalf + this.ballHeightHalf && this.ballY > this.paddle1 - this.paddle1HeightHalf - this.ballHeightHalf) {
                                this.paddle22hit = false;
                                this.paddle12hit = false;
                                this.rightOwner = !this.rightOwner;
                                this.ballXVelocity = -this.ballXVelocity;
                                int ballHitOffset = (this.ballY - this.paddle1) / (2 * (this.paddle1HeightHalf / 20)) / this.paddleDivider;
                                this.ballYVelocity = (byte)(ballHitOffset * Math.abs(this.ballXVelocity / 5));
                                Sound.toneAsync(1019, 50, 0.5);
                                if (this.networkHandler != null) {
                                    this.networkHandler.enqueuePacket(new Packet7PaddleHit(this.ballX, this.ballY, this.ballXVelocity, this.ballYVelocity));
                                }
                                break;
                            }
                        }
                    }
                    ++i;
                }
            }
        } else if (this.resetTicks == 0 && this.isMain()) {
            this.ballX = this.ballXVelocity > 0 ? (short)(-this.ballWidthHalf) : (short)(640 + this.ballWidthHalf);
            this.updateDirection();
            this.ballY = (short)240;
            if (this.networkHandler != null) {
                this.networkHandler.enqueuePacket(new Packet6BallPosition(this.ballX, this.ballY));
                this.networkHandler.enqueuePacket(new Packet5BallVelocity(this.ballXVelocity, this.ballYVelocity));
            }
            this.resetTicks = (byte)(this.resetTicks - 1);
        } else if (this.isMain()) {
            this.resetTicks = (byte)(this.resetTicks - 1);
        }
        this.repaint();
    }

    public void updateDirection() {
        if (this.gameMode != 3) {
            this.rightOwner = this.ballXVelocity < 0;
        }
    }

    public void reset() {
        if (this.random.nextBoolean()) {
            this.ballXVelocity = -this.ballXVelocity;
        }
        this.paddle22hit = false;
        this.paddle12hit = false;
        boolean bl = this.rightOwner = this.ballXVelocity < 0;
        if (this.gameMode == 3) {
            this.ballXVelocity = (byte)Math.abs(this.ballXVelocity);
        }
        this.ballX = (short)320;
        this.ballY = Short.MIN_VALUE;
        this.ballYVelocity = 0;
        this.score1 = 0;
        this.score2 = 0;
        this.gameOver = false;
        this.resetTicks = (byte)60;
        this.sendBoardConfiguration(true);
        String s = "PaddleNet";
        if (this.networkHandler != null) {
            s = this.networkHandler.isServer() ? String.valueOf(s) + " - Connected as Server (RIGHT)" : String.valueOf(s) + " - Connected as Client (LEFT)";
        }
        this.containerWindow.setTitle(s);
        this.settingsChanged();
    }

    public boolean isServer() {
        return this.networkHandler != null && this.networkHandler.isServer();
    }

    public boolean isMain() {
        return this.networkHandler == null || this.networkHandler.isServer();
    }

    public void sendBoardConfiguration(boolean complete) {
        if (this.isServer()) {
            this.networkHandler.enqueuePacket(new Packet9BoardConfiguration(this.paddle1HeightHalf, this.paddle2HeightHalf, this.gameOverScore, this.ballHeightHalf, this.ballWidthHalf, this.paddleDivider, this.gameMode, this.gameOver, this.colour, this.rightOwner));
            if (complete) {
                this.networkHandler.enqueuePacket(new Packet3Score1(this.score1));
                this.networkHandler.enqueuePacket(new Packet4Score2(this.score2));
                this.networkHandler.enqueuePacket(new Packet5BallVelocity(this.ballXVelocity, this.ballYVelocity));
                this.networkHandler.enqueuePacket(new Packet6BallPosition(this.ballX, this.ballY));
            }
        }
    }

    public void mouseMoved(MouseEvent e) {
        this.lastMouseTick = (short)e.getY();
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        if (this.isMain()) {
            this.ballY = (short)(this.ballY + e.getUnitsToScroll() * 10);
            if (this.networkHandler != null) {
                this.networkHandler.enqueuePacket(new Packet6BallPosition(this.ballX, this.ballY));
            }
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        if (this.networkHandler == null || this.networkHandler.isServer()) {
            switch (e.getKeyCode()) {
                case 82: {
                    this.reset();
                    break;
                }
                case 81: {
                    this.paddle1HeightHalf = this.paddle1HeightHalf == 40 ? (short)20 : (short)40;
                    this.sendBoardConfiguration(true);
                    this.settingsChanged();
                    break;
                }
                case 80: {
                    this.paddle2HeightHalf = this.paddle2HeightHalf == 40 ? (short)20 : (short)40;
                    this.sendBoardConfiguration(true);
                    this.settingsChanged();
                    break;
                }
                case 66: {
                    this.ballXVelocity = Math.abs(this.ballXVelocity) != 5 ? (byte)(MathUtil.signum(this.ballXVelocity) * 5) : (byte)(MathUtil.signum(this.ballXVelocity) * 10);
                    this.sendBoardConfiguration(true);
                    this.settingsChanged();
                    break;
                }
                case 65: {
                    this.paddleDivider = this.paddleDivider != 1 ? (byte)1 : (byte)2;
                    this.sendBoardConfiguration(true);
                    this.settingsChanged();
                    break;
                }
                case 67: {
                    this.colour = !this.colour;
                    this.sendBoardConfiguration(true);
                    this.settingsChanged();
                    break;
                }
                case 123: {
                    this.ballYVelocity = Math.abs(this.ballYVelocity) == 100 ? (byte)0 : (byte)100;
                    this.sendBoardConfiguration(true);
                    break;
                }
                case 49: 
                case 50: 
                case 51: 
                case 52: {
                    this.gameMode = (byte)(e.getKeyCode() - 49);
                    this.updateDirection();
                    this.sendBoardConfiguration(true);
                    this.settingsChanged();
                    break;
                }
            }
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void setPaddle1(short pos) {
        this.paddle1 = pos;
    }

    public void setPaddle2(short pos) {
        this.paddle2 = pos;
    }

    public void setScore1(byte score) {
        this.score1 = score;
    }

    public void setScore2(byte score) {
        this.score2 = score;
    }

    public void setBallVelocity(byte x, byte y) {
        this.ballXVelocity = x;
        this.ballYVelocity = y;
        this.updateDirection();
        this.resetTicks = (byte)-1;
    }

    public void setBallPosition(short x, short y) {
        this.ballX = x;
        this.ballY = y;
        this.resetTicks = (byte)-1;
    }

    public void hit(short x, short y, byte xVelocity, byte yVelocity, boolean resetPaddleFlags) {
        if (resetPaddleFlags) {
            this.paddle12hit = false;
            this.paddle22hit = false;
        }
        this.setBallPosition(x, y);
        this.setBallVelocity(xVelocity, yVelocity);
        if (this.gameMode == 3) {
            this.rightOwner = !this.rightOwner;
        } else {
            this.updateDirection();
        }
        Sound.toneAsync(1019, 50, 0.5);
    }

    public void update(short paddle1HeightHalf, short paddle2HeightHalf, byte gameOverScore, byte ballHeightHalf, byte ballWidthHalf, byte paddleDivider, byte gameMode, boolean gameOver, boolean colour, boolean rightOwner) {
        this.paddle1HeightHalf = paddle1HeightHalf;
        this.paddle2HeightHalf = paddle2HeightHalf;
        this.gameOverScore = gameOverScore;
        this.ballHeightHalf = ballHeightHalf;
        this.ballWidthHalf = ballWidthHalf;
        this.paddleDivider = paddleDivider;
        this.gameOver = gameOver;
        this.colour = colour;
        this.gameMode = gameMode;
        this.rightOwner = rightOwner;
        this.settingsChanged();
    }

    public void setWaiting(boolean waiting) {
        this.isWaiting = waiting;
    }

    public void setNetworkHandler(NetworkHandler handler) {
        this.networkHandler = handler;
    }

    public void miss() {
        this.paddle12hit = false;
        this.paddle22hit = false;
        Sound.toneAsync(2019, 50, 0.5);
        if (this.isServer()) {
            if (this.score1 >= this.gameOverScore || this.score2 >= this.gameOverScore) {
                this.gameOver = true;
                this.sendBoardConfiguration(true);
            }
            this.resetTicks = (byte)60;
        }
    }

    public byte getBallXSpeed() {
        return this.ballXVelocity;
    }

    public byte getPaddleDivider() {
        return this.paddleDivider;
    }

    public boolean getColour() {
        return this.colour;
    }

    public short getPaddle1Size() {
        return this.paddle1HeightHalf;
    }

    public short getPaddle2Size() {
        return this.paddle2HeightHalf;
    }

    public byte getGameMode() {
        return this.gameMode;
    }

    public void removeSettingsListeners() {
        this.settingsListeners.clear();
    }

    public void removeSettingsListener(SettingsListener listener) {
        this.settingsListeners.remove(listener);
    }

    public void addSettingsListener(SettingsListener listener) {
        this.settingsListeners.add(listener);
    }

    public void settingsChanged() {
        int i = 0;
        while (i < this.settingsListeners.size()) {
            ((SettingsListener)this.settingsListeners.get(i)).settingsChanged(this);
            ++i;
        }
    }
}

