import java.awt.Color;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;

import javax.swing.JFrame;

public class Worker implements Runnable {
	ProgressDialog progress;
	JFrame parentFrame;
	Image inputImg;
	File outputFile;
	boolean bLogarhytmic;
	int iMinFreq;
	int iMaxFreq;
	int iSampleFreq;
	int iSeconds;
	
	long ir = 0L;
	
	Worker (JFrame parentFrame, Image input, File output, boolean logarhytmic, int minimumFrequenzy,
			int maximumFrequenzy, int sampleFrequenzy, int seconds) {
		this.parentFrame = parentFrame;
		inputImg = input;
		outputFile = output;
		bLogarhytmic = logarhytmic;
		iMinFreq = minimumFrequenzy;
		iMaxFreq = maximumFrequenzy;
		iSampleFreq = sampleFrequenzy;
		iSeconds = seconds;
	}
	
	public void run() {
		parentFrame.setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
		// Jetzt geht's los, jetzt geht's loooooos
		progress = new ProgressDialog(parentFrame, "Vorbereitung..", "Bereite Generierung vor...", true, 0, 100);
		progress.indeterminate(true);
		new Thread(progress).start();
		byte[][] pixels = convertGrayscaleImageToTwoDimByteArray(inputImg);
		double[][] dbMap = ConvertGreyscaleToDezibel(pixels);
		double[] freqs = calculateFrequencies(pixels[0].length, bLogarhytmic, iMinFreq, iMaxFreq);
		progress.setTitle("Frequenzberechnung");
		progress.setText("Wandle Bildinformationen in Tondatei um...");
		progress.indeterminate(false);
		byte[] audioBytes = convertDbArrayToSoundArray(iSampleFreq, iSeconds, dbMap, freqs);
		progress.indeterminate(true);
		
		progress.setTitle("Speichern");
		progress.setText("Schreibe Datei...");
		FileOutputStream f;
		try {
			f = new FileOutputStream(outputFile);
		} catch (FileNotFoundException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
			return;
		}
	    try {
			f.write(audioBytes);
			f.close();
		} catch (IOException e) {
			e.printStackTrace();
		}
		progress.goAway();
		parentFrame.setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
	}
	
	public static byte[] convertGrayscaleImageToOneDimByteArray(Image img) {
		try {
	        PixelGrabber grabber = new PixelGrabber(img, 0, 0, -1, -1, false);
	        
	        if (grabber.grabPixels()) {
	            if (!(grabber.getPixels() instanceof byte[])) {
	            	throw new IllegalArgumentException("Only Gray-Scale Images");
	            }
	            
	            return (byte[]) grabber.getPixels();
	        }
		} catch (InterruptedException e1) {
	        e1.printStackTrace();
	    } 
		return null;
	}
	
	
	public byte[][] convertGrayscaleImageToTwoDimByteArray(Image img) {

        PixelGrabber grabber = new PixelGrabber(img, 0, 0, -1, -1, false);
        
        try {
	        if (!grabber.grabPixels()) {
	        	return null;
	        }
        } catch (Exception e) { e.printStackTrace();}
        
        int columns = grabber.getWidth();
        int rows = grabber.getHeight();
        
        byte[] pixels = convertGrayscaleImageToOneDimByteArray(img);
        byte[][] returnVal = new byte[rows][columns];
        
        //System.out.println(columns + "x" + rows + "=" + pixels.length);
        int pixelCount = 0;
        for (int i = 0; i < rows; ++i) {
        	for (int j = 0; j < columns; ++j) {
        		returnVal[i][j] = pixels[pixelCount];
        		++pixelCount;
        	}
        }
        return returnVal;
	}
	
	public double[][] ConvertGreyscaleToDezibel(byte[][] imagedata) {
		int iColumns = imagedata.length;
		int iRows = imagedata[0].length;
		
		// imagedata: pixel vom java-encoded-rgb-wert zu grauwerten umwandeln
		int[][] grayscaledata = new int[iColumns][iRows];
    	for (int i = 0; i < iColumns; ++i) {
    		for (int j = 0; j < iRows; ++j) {
    			Color c = new Color(imagedata[i][j]);
    			// the blue value of the grayscale image is the gray value
    			// with 0 = black and 255 = white
    			grayscaledata[i][j] = c.getBlue();
    			
    			// convert: 0 = white, 255 = black
    			grayscaledata[i][j] = (grayscaledata[i][j] - 255) * -1;
    			
    			// erase the lowest gray values to unterdrck noise
    			//if (grayscaledata[i][j] < 100) grayscaledata[i][j] = 0;
    		}
    	}
		
		double sound[][] = new double[iColumns][iRows];
		
		for (int i = 0; i < iColumns; i++) {
			for (int j = 0; j < iRows; j++) {
				if (grayscaledata[i][j] > 0) {
					sound[iColumns-i-1][j] = (double)grayscaledata[i][j]/255;
				} else {
					sound[iColumns-i-1][j]= 0.0;
				}
			}
		}
		return sound;
	}
	
	/**
	 * generiert ein array mit den frequenzwerten
	 * @param iNumberOfFrequencies die anzahl der gesamtfrequenzen (=hhe des bildes in px)
	 * @param bExp exponentielle oder lineare berechnung (true = exponenzielle)
	 * @param lowestFreq mindestfrequenz, z.b. 500, in Hertz
	 * @param highestFreq hchte frequenz, z.b. 5000, in Hertz
	 * @return ein array mit allen frequenzen
	 */
	public double[] calculateFrequencies(int iNumberOfFrequencies, boolean bExp, 
			int lowestFreq, int highestFreq) {
		/* Set lin|exp (0|1) frequency distribution and random initial phase */
		double dTwoPi = Math.PI * 2;
		double[] result = new double[iNumberOfFrequencies];
		
		if (bExp) {
			for (int i = 0; i < iNumberOfFrequencies; i++) {
				result[i] = dTwoPi * lowestFreq * Math.pow(1.0* highestFreq/lowestFreq,1.0 * i/(iNumberOfFrequencies-1));
			}
		} else {
			for (int i = 0; i < iNumberOfFrequencies; i++) {
				result[i] = dTwoPi * lowestFreq + dTwoPi * (highestFreq-lowestFreq) * i/(iNumberOfFrequencies-1);
			}
		}
//		for (int i = 0; i < iNumberOfFrequencies; i++) {
//			phi0[i] = dTwoPi * rnd();
//		}
		return result;
	}
	
	public double rnd() {
		long ia=9301L, ic=49297L, im=233280L;
		ir = (ir*ia+ic) % im;
		return ir / (1.0*im);
	}
	
	/**
	 * bla
	 * @param sampleFreq sample-frequenz
	 * @param seconds lnge des wave-tracks
	 * @param dbArray double-array mit den dezibelwerten
	 * @param frequencies double-array mit den zu benutzenden frequenzen
	 * @return ein wave als byte-array
	 */
	public byte[] convertDbArrayToSoundArray(int sampleFreq, double seconds,
			double[][] dbArray, double[] frequencies) {
		ArrayList<Byte> byteList = new ArrayList<Byte>();
		long ns = 2L*(long)(0.5*sampleFreq*seconds); //sampleFreq = z.b. 44100
		int height = dbArray.length;
		int width = dbArray[0].length;
		System.out.println("starting function with params:");
		System.out.println("Sample Frequenzy: " + sampleFreq);
		System.out.println("Time: " + seconds + " seconds");
		System.out.println("Image: " + width + "x" + height);
		System.out.println("Number of Frequencies: " + frequencies.length);
		// System.out.println(height + "x" + width);
		int ss;
		double q, q2, s, t, a, y, yp, z;
		y = z = 0.0;
		double tau1 = 0.5 / frequencies[width-1]; // ?
		double tau2 = 0.25 * tau1 * tau1;
		double dt = 1.0 / sampleFreq;
		double scale = 0.5 / Math.sqrt(width);
		long k = 0L;
		long m = ns/width;
		long l;
		long sso = 0L;
		long ssm = 32768L;
		int j;
		double[] phi0 = new double[frequencies.length];
		for (int i=0; i < frequencies.length; i++) phi0[i] = (Math.PI * 2) * rnd();
		
		//temp
		
		bla("RIFF", byteList); wl(ns*2+36L, byteList);
	   bla("WAVEfmt ", byteList); wl(16L, byteList); wi(1, byteList); wi(1, byteList); wl(0L+sampleFreq, byteList);
	   wl(0L+sampleFreq*2, byteList); wi(2, byteList); wi(16, byteList); bla("data", byteList); wl(ns*2, byteList);
	   //temp
	   progress.setMax((int)ns);
	   while (k < ns) {
		   progress.setValue((int)k);
		      q = 1.0 * (k % m) / (m-1);
		      q2 = 0.5 * q * q;
		      j = (int)(k / m);
		      if (j > width - 1) j = width - 1; // ja
		      s = 0.0;
		      t = k * dt;
		      
	    	  for (int i = 0; i < height; i++) { // ja
		         /* Quadratic B-spline for smooth C1 time window */
	            if (j == 0) {
	            	a = (1.0 - q2) * dbArray[i][j] + q2 * dbArray[i][j+1];
	            } else if (j == width-1) { // ja
	            	a = (q2 - q + 0.5) * dbArray[i][j-1] + (0.5 + q - q2) * dbArray[i][j];
	            } else {
	            	a = (q2 - q + 0.5) * dbArray[i][j-1] + (0.5 + q - q * q) * dbArray[i][j] + q2 * dbArray[i][j+1];
	            }

	            if (width > height) {
	            	s += a * Math.sin(frequencies[(i * width / height)] * t + phi0[(i * width / height)]);
	            } else if (width == height){
	            	s += a * Math.sin(frequencies[i] * t + phi0[i]);
	            } else {
	            	s += a * Math.sin(frequencies[(int)(i * ((double)width/(double)height))] * t + phi0[(int)(i * ((double)width/(double)height))]);
	            }
	    	  }
		      
		      yp = y;
		      y = tau1/dt + tau2/(dt * dt);
		      y  = (s + y * yp + tau2/dt * z) / (1.0 + y); z = (y - yp) / dt;
		      l  = (long)(sso + 0.5 + scale * ssm * y); /* y = 2nd order filtered s */
		      if (l >= sso-1+ssm) l = sso-1+ssm; if (l < sso-ssm) l = sso-ssm;
		      ss = (int)l;
		      
		      int b0 = ss % 256;
		      int b1= (ss - b0) / 256;
		      byteList.add((byte)b0);
		      byteList.add((byte)b1);
		      k++;
		}
		
		// byteList zu byte[]
		byte[] result = new byte[byteList.size()];
		for (int i = 0; i < byteList.size(); ++i) {
			result[i] = byteList.get(i);
		}
		System.out.println("end");
		return result;
	}
	void bla(String s, ArrayList<Byte> b) {for (int i = 0; i < s.length(); ++i){b.add((byte)(s.charAt(i)));}}
	void wi(int i, ArrayList<Byte> b) { int b1,b0; b0=i%256; b1=(i-b0)/256; b.add((byte)b0); b.add((byte)b1); }
	void wl(long l, ArrayList<Byte> b) { int i1,i0; i0=(int)(l%65536L); i1=(int)((l-i0)/65536L); wi(i0, b); wi(i1, b); }
}
