/*
 * Decompiled with CFR 0.152.
 */
package com.androdome.iadventure;

import com.androdome.iadventure.CancelableThread;
import com.androdome.iadventure.HtmlUtils;
import com.androdome.iadventure.MainFrame;
import com.androdome.iadventure.appletutils.AppletManager;
import com.androdome.iadventure.componentutils.ComponentManager;
import java.awt.Dimension;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import javax.net.ssl.SSLHandshakeException;
import org.fit.cssbox.css.CSSNorm;
import org.fit.cssbox.css.DOMAnalyzer;
import org.fit.cssbox.demo.DOMSource;
import org.w3c.dom.Document;

public class ConnectionHandler {
    CancelableThread ct = null;

    public void navigateError(MainFrame frame, String string, String errHtml) {
        try {
            String read;
            if (this.ct != null) {
                this.ct.cancel();
            }
            frame.clearComp();
            URL url = new URL(string);
            URLConnection con = url.openConnection();
            InputStream is = con.getInputStream();
            String page = "";
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            while ((read = reader.readLine()) != null) {
                page = String.valueOf(page) + read;
            }
            reader.close();
            page = page.replace("$er", errHtml);
            DOMSource parser = new DOMSource(new ByteArrayInputStream(page.getBytes("UTF-8")));
            Document doc = parser.parse();
            DOMAnalyzer da = new DOMAnalyzer(doc, url);
            da.attributesToStyles();
            da.addStyleSheet(null, CSSNorm.stdStyleSheet());
            da.addStyleSheet(null, CSSNorm.userStyleSheet());
            da.getStyleSheets();
            frame.browser.navigate(da.getRoot(), da, new Dimension(frame.scrollPane.getWidth(), frame.scrollPane.getHeight()), url);
            frame.browser.redrawBoxes();
            frame.browser.repaint();
            frame.browser.revalidate();
            frame.validate();
            frame.repaint();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static InputStream getSiteData(MainFrame frame, URL[] url) throws IOException, SSLHandshakeException {
        URLConnection con = url[0].openConnection();
        con.setRequestProperty("User-Agent", "MSIE 4");
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(con.getInputStream());
        }
        catch (IOException ex) {
            if (con instanceof HttpURLConnection) {
                in = new BufferedInputStream(((HttpURLConnection)con).getErrorStream());
            }
            throw ex;
        }
        if (con instanceof HttpURLConnection) {
            url[0] = con.getURL();
        }
        System.out.println(con.getURL());
        frame.progressBar.setMaximum(Math.max(con.getContentLength(), ((InputStream)in).available()));
        ByteArrayOutputStream bytearr = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        frame.progressBar.setValue(0);
        frame.lblProg.setText("Transferring from " + url[0].toString() + "...");
        while (((InputStream)in).read(buffer) > 0) {
            frame.progressBar.setValue(frame.progressBar.getValue() + 1024);
            frame.progressBar.repaint();
            frame.progressBar.revalidate();
            bytearr.write(buffer);
            buffer = new byte[1024];
        }
        ((InputStream)in).close();
        frame.progressBar.setValue(frame.progressBar.getMaximum());
        frame.progressBar.repaint();
        return new ByteArrayInputStream(bytearr.toByteArray());
    }

    public static URL make_url(String a_url) throws MalformedURLException {
        try {
            return new URL(a_url);
        }
        catch (MalformedURLException malformedURLException) {
            return new URL("http://" + a_url);
        }
    }

    public void navigate(final MainFrame frame, final String location) {
        if (this.ct != null) {
            this.ct.cancel();
        }
        this.ct = new CancelableThread(){

            public void run() {
                if (this.cancelled) {
                    return;
                }
                frame.lblProg.setText("Connecting...");
                try {
                    URL url = ConnectionHandler.make_url(location);
                    if (url == null) {
                        throw new MalformedURLException();
                    }
                    frame.navBar.setText(url.toString());
                    frame.clearComp();
                    if (this.cancelled) {
                        frame.lblProg.setText("Cancelled.");
                        return;
                    }
                    URL[] urlar = new URL[]{url};
                    InputStream is = ConnectionHandler.getSiteData(frame, urlar);
                    url = urlar[0];
                    frame.navBar.setText(url.toString());
                    frame.lblProg.setText("Parsing...");
                    DOMSource parser = new DOMSource(is);
                    if (this.cancelled) {
                        is.close();
                        frame.lblProg.setText("Cancelled.");
                        return;
                    }
                    Document doc = parser.parse();
                    DOMAnalyzer da = new DOMAnalyzer(doc, url);
                    da.attributesToStyles();
                    da.addStyleSheet(null, CSSNorm.stdStyleSheet());
                    da.addStyleSheet(null, CSSNorm.userStyleSheet());
                    da.getStyleSheets();
                    frame.lblProg.setText("Drawing...");
                    if (this.cancelled) {
                        frame.lblProg.setText("Cancelled.");
                        return;
                    }
                    frame.browser.navigate(da.getRoot(), da, new Dimension(frame.scrollPane.getWidth(), frame.scrollPane.getHeight()), url);
                    frame.lblProg.setText("Parsing Applets...");
                    if (this.cancelled) {
                        frame.lblProg.setText("Cancelled.");
                        return;
                    }
                    AppletManager.parseApplets(frame.browser, frame);
                    ComponentManager.parseComponents(frame.browser, frame);
                    frame.browser.redrawBoxes();
                    frame.browser.repaint();
                    frame.browser.revalidate();
                    frame.validate();
                    frame.repaint();
                    frame.navBar.setText(url.toString());
                    frame.lblProg.setText("Done.");
                    ConnectionHandler.this.ct = null;
                }
                catch (MalformedURLException e) {
                    ConnectionHandler.this.handleExcec(frame, location, e);
                }
                catch (UnknownHostException e) {
                    frame.lblProg.setText("Unknown Host");
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    e.printStackTrace(pw);
                    String sStackTrace = sw.toString();
                    ConnectionHandler.this.navigateError(frame, "about:eunknownhost", "<br><br>The host <a href='" + HtmlUtils.stringToHTMLString(location) + "'>" + HtmlUtils.stringToHTMLString(location) + "</a><br> could not be connected to." + "<br>It may have been mistyped, or does not exist" + "<br>Please ensure that the host is valid " + "<br>and that everything is spelled correctly.<br />&nbsp;<br />" + "Java stack trace:" + "<br />&nbsp;<br />&nbsp;<br />" + HtmlUtils.stringToHTMLString(sStackTrace));
                }
                catch (SSLHandshakeException e) {
                    frame.lblProg.setText("SSL Error");
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    e.printStackTrace(pw);
                    String sStackTrace = sw.toString();
                    ConnectionHandler.this.navigateError(frame, "about:esecurityexception", "<br><br>The host <a href='" + HtmlUtils.stringToHTMLString(location) + "'>" + HtmlUtils.stringToHTMLString(location) + "</a><br> rejected the SSL Handshake." + "<br>It may be a bad site, or your JVM doesn't have up to date" + "<br>encryption protocols. " + "<br>Connection cannot continue.<br />&nbsp;<br />" + "Java stack trace:" + "<br />&nbsp;<br />&nbsp;<br />" + HtmlUtils.stringToHTMLString(sStackTrace));
                }
                catch (IOException e) {
                    frame.lblProg.setText("Connection Error");
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    e.printStackTrace(pw);
                    String sStackTrace = sw.toString();
                    ConnectionHandler.this.navigateError(frame, "about:econfailed", "<br><br>The host <a href='" + HtmlUtils.stringToHTMLString(location) + "'>" + HtmlUtils.stringToHTMLString(location) + "</a><br> rejected the connection." + "<br>It may be a bad site, or you have tried to access" + "<br>a document you don't have permission to." + "<br>Please ensure that the host is valid " + "<br>and that everything is spelled correctly.<br />&nbsp;<br />" + "Java stack trace:" + "<br />&nbsp;<br />&nbsp;<br />" + HtmlUtils.stringToHTMLString(sStackTrace));
                }
                catch (Exception e) {
                    frame.lblProg.setText("Unknown Error");
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    e.printStackTrace(pw);
                    String sStackTrace = sw.toString();
                    ConnectionHandler.this.navigateError(frame, "about:eunknown", "<br><br>There was an unknown error when trying to connect to <br>the host <a href='" + HtmlUtils.stringToHTMLString(location) + "'>" + HtmlUtils.stringToHTMLString(location) + "</a>" + "<br>Please ensure that the host is valid " + "<br>and that everything is spelled correctly.<br />&nbsp;<br />" + "Java stack trace:" + "<br />&nbsp;<br />&nbsp;<br />" + HtmlUtils.stringToHTMLString(sStackTrace));
                }
            }
        };
        this.ct.start();
    }

    public void navigate(MainFrame frame, URL baseURL, String nodeValue) {
        try {
            URI uri = baseURL.toURI();
            this.navigate(frame, uri.resolve(nodeValue).toString());
        }
        catch (URISyntaxException e) {
            this.handleExcec(frame, nodeValue, e);
        }
    }

    private void handleExcec(MainFrame frame, String location, Exception e) {
        frame.lblProg.setText("Error");
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        String sStackTrace = sw.toString();
        this.navigateError(frame, "about:eurlmalform", "<br><br>The address <a href='" + HtmlUtils.stringToHTMLString(location) + "'>" + HtmlUtils.stringToHTMLString(location) + "</a><br>does not match any supported protocol." + "<br>It may have been mistyped." + "<br>Please ensure that the protocol is supported " + "<br>and that everything is spelled correctly.<br />&nbsp;<br />" + "Java stack trace:" + "<br />&nbsp;<br />&nbsp;<br />" + HtmlUtils.stringToHTMLString(sStackTrace));
    }

    public void onFormGet(String action, String enctype, MainFrame frame, String subParams) {
        try {
            String getURL = String.valueOf(frame.browser.getBaseURL().toURI().resolve(action).toString()) + "?" + subParams;
            this.navigate(frame, getURL);
        }
        catch (URISyntaxException e) {
            this.handleExcec(frame, action, e);
            e.printStackTrace();
        }
    }

    public void onFormPost(String action, String enctype, MainFrame frame, String subParams) {
    }
}

