/*
 * Decompiled with CFR 0.152.
 */
package com.androdome.iadventure;

import java.awt.Rectangle;
import javax.swing.tree.DefaultMutableTreeNode;
import org.fit.cssbox.layout.Box;

public class HtmlUtils {
    public static String stringToHTMLString(String string) {
        StringBuffer sb = new StringBuffer(string.length());
        boolean lastWasBlankChar = false;
        int len = string.length();
        int i = 0;
        while (i < len) {
            char c = string.charAt(i);
            if (c == ' ') {
                if (lastWasBlankChar) {
                    lastWasBlankChar = false;
                    sb.append("&nbsp;");
                } else {
                    lastWasBlankChar = true;
                    sb.append(' ');
                }
            } else {
                lastWasBlankChar = false;
                if (c == '\"') {
                    sb.append("&quot;");
                } else if (c == '&') {
                    sb.append("&amp;");
                } else if (c == '<') {
                    sb.append("&lt;");
                } else if (c == '>') {
                    sb.append("&gt;");
                } else if (c == '\n') {
                    sb.append("<br />");
                } else {
                    int ci = 0xFFFF & c;
                    if (ci < 160) {
                        sb.append(c);
                    } else {
                        sb.append("&#");
                        sb.append(new Integer(ci).toString());
                        sb.append(';');
                    }
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static DefaultMutableTreeNode locateBox(DefaultMutableTreeNode root, int x, int y) {
        DefaultMutableTreeNode found = null;
        Box box = (Box)root.getUserObject();
        Rectangle bounds = box.getAbsoluteBounds();
        if (bounds.contains(x, y)) {
            found = root;
        }
        int i = 0;
        while (i < root.getChildCount()) {
            DefaultMutableTreeNode inside = HtmlUtils.locateBox((DefaultMutableTreeNode)root.getChildAt(i), x, y);
            if (inside != null) {
                if (found == null) {
                    found = inside;
                } else {
                    Box fbox = (Box)found.getUserObject();
                    Box ibox = (Box)inside.getUserObject();
                    if (ibox.getAbsoluteBounds().width * ibox.getAbsoluteBounds().height < fbox.getAbsoluteBounds().width * fbox.getAbsoluteBounds().height) {
                        found = inside;
                    }
                }
            }
            ++i;
        }
        return found;
    }
}

