/*
 * Decompiled with CFR 0.152.
 */
package com.androdome.iadventure.componentutils;

import com.androdome.iadventure.MainFrame;
import com.androdome.iadventure.componentutils.FormItem;
import java.util.ArrayList;
import java.util.Stack;
import javax.swing.JButton;
import javax.swing.JTextField;
import org.fit.cssbox.layout.Box;
import org.fit.cssbox.layout.BrowserCanvas;
import org.fit.cssbox.layout.InlineBox;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ComponentManager {
    public static void parseComponents(BrowserCanvas browser, MainFrame frame) {
        ArrayList<InlineBox> forms = browser.getViewport().getInlineBoxesByName("form", false);
        System.out.println(forms.size());
        for (InlineBox element : forms) {
            String action = ".";
            String method = "GET";
            String enctype = "application/x-www-form-urlencoded";
            if (element.getNode().getAttributes().getNamedItem("action") != null) {
                action = element.getNode().getAttributes().getNamedItem("action").getNodeValue();
            }
            if (element.getNode().getAttributes().getNamedItem("enctype") != null) {
                enctype = element.getNode().getAttributes().getNamedItem("enctype").getNodeValue();
            }
            if (element.getNode().getAttributes().getNamedItem("method") != null) {
                method = element.getNode().getAttributes().getNamedItem("method").getNodeValue();
            }
            FormItem form = new FormItem(action, method, enctype, frame);
            Stack<Node> mustSearch = new Stack<Node>();
            mustSearch.push(element.getNode());
            Stack<Node> foundInput = new Stack<Node>();
            while (!mustSearch.isEmpty()) {
                NodeList l = ((Node)mustSearch.pop()).getChildNodes();
                int i = 0;
                while (i < l.getLength()) {
                    if (l.item(i).getNodeName().equalsIgnoreCase("input")) {
                        foundInput.add(l.item(i));
                    } else {
                        mustSearch.add(l.item(i));
                    }
                    ++i;
                }
            }
            for (Node n : foundInput) {
                Box box = browser.getViewport().getElementBoxByNode(n);
                if (box != null && box.getNode() != null && box.getNode().getAttributes() != null && box.getNode().getAttributes().getNamedItem("type") != null) {
                    JButton textField;
                    String text;
                    String type = box.getNode().getAttributes().getNamedItem("type").getNodeValue();
                    if (type.equalsIgnoreCase("text")) {
                        JTextField textField2 = new JTextField();
                        textField2.setBounds(box.getAbsoluteBounds());
                        browser.add(textField2);
                        frame.addComponentNodeBinding(new JTextField(), box.getNode());
                        form.add(textField2, n);
                        continue;
                    }
                    if (type.equalsIgnoreCase("button")) {
                        text = "Generic Input Button";
                        if (box.getNode().getAttributes().getNamedItem("value") != null) {
                            text = box.getNode().getAttributes().getNamedItem("value").getNodeValue();
                        }
                        textField = new JButton(text);
                        textField.setBounds(box.getAbsoluteBounds());
                        browser.add(textField);
                        frame.addComponentNodeBinding(new JTextField(), box.getNode());
                        form.add(textField, n);
                        continue;
                    }
                    if (type.equalsIgnoreCase("submit")) {
                        text = "Generic Submit Button";
                        if (box.getNode().getAttributes().getNamedItem("value") != null) {
                            text = box.getNode().getAttributes().getNamedItem("value").getNodeValue();
                        }
                        textField = new JButton(text);
                        textField.setBounds(box.getAbsoluteBounds());
                        browser.add(textField);
                        frame.addComponentNodeBinding(new JTextField(), box.getNode());
                        form.add(textField, n);
                        continue;
                    }
                    form.add(null, n);
                    continue;
                }
                if (box == null) continue;
                JTextField textField = new JTextField();
                textField.setBounds(box.getAbsoluteBounds());
                browser.add(textField);
                frame.addComponentNodeBinding(new JTextField(), box.getNode());
                form.add(textField, n);
            }
        }
        browser.repaint();
        browser.revalidate();
    }
}

