/*
 * Decompiled with CFR 0.152.
 */
package com.androdome.iadventure.componentutils;

import com.androdome.iadventure.MainFrame;
import com.androdome.iadventure.utils.ArrayListBinding;
import com.androdome.iadventure.utils.BindingObject;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URLEncoder;
import javax.swing.JButton;
import javax.swing.JTextField;
import org.w3c.dom.Node;

public class FormItem
implements ActionListener {
    ArrayListBinding<Component, Node> componentNodeBinding = new ArrayListBinding();
    String method;
    String enctype;
    String action;
    MainFrame frame;

    public FormItem(String action, String method, String enctype, MainFrame frame) {
        this.action = action;
        this.enctype = enctype;
        this.method = method;
        this.frame = frame;
    }

    public void actionPerformed(ActionEvent arg0) {
        Object c = arg0.getSource();
        if (c instanceof JButton) {
            JButton btn = (JButton)c;
            Node n = this.componentNodeBinding.getFirstValueFromKey(btn);
            if (n == null) {
                return;
            }
            if (n.getAttributes().getNamedItem("type") != null && n.getAttributes().getNamedItem("type").getNodeValue().equalsIgnoreCase("submit")) {
                String subParams = "submit=submit";
                if (n.getAttributes().getNamedItem("name") != null) {
                    try {
                        subParams = URLEncoder.encode(n.getAttributes().getNamedItem("name").getNodeValue(), "UTF-8");
                        if (n.getAttributes().getNamedItem("value") != null) {
                            subParams = String.valueOf(subParams) + "=" + URLEncoder.encode(n.getAttributes().getNamedItem("value").getNodeValue(), "UTF-8");
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                System.out.println("Submit was pressed!");
                int i = 0;
                while (i < this.componentNodeBinding.getValueList().size()) {
                    BindingObject<Component, Node> binding = this.componentNodeBinding.getBindingObject(i);
                    Node node = (Node)binding.value;
                    if (binding.key == null) {
                        if (node.getAttributes().getNamedItem("name") != null) {
                            try {
                                subParams = String.valueOf(subParams) + "&" + URLEncoder.encode(node.getAttributes().getNamedItem("name").getNodeValue(), "UTF-8");
                                if (node.getAttributes().getNamedItem("value") != null) {
                                    subParams = String.valueOf(subParams) + "=" + URLEncoder.encode(node.getAttributes().getNamedItem("value").getNodeValue(), "UTF-8");
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    } else if (binding.key instanceof JTextField && node.getAttributes().getNamedItem("name") != null) {
                        try {
                            subParams = String.valueOf(subParams) + "&" + URLEncoder.encode(node.getAttributes().getNamedItem("name").getNodeValue(), "UTF-8");
                            subParams = String.valueOf(subParams) + "=" + URLEncoder.encode(((JTextField)binding.key).getText(), "UTF-8");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    ++i;
                }
                System.out.println("Params: " + subParams);
                if (this.method.trim().equalsIgnoreCase("POST")) {
                    this.frame.conHandler.onFormPost(this.action, this.enctype, this.frame, subParams);
                } else {
                    this.frame.conHandler.onFormGet(this.action, this.enctype, this.frame, subParams);
                }
            }
        }
    }

    public void add(Component comp, Node n) {
        if (comp instanceof JButton) {
            ((JButton)comp).addActionListener(this);
        }
        this.componentNodeBinding.addBinding(comp, n);
    }
}

