/*
 * Decompiled with CFR 0.152.
 */
package com.androdome.iadventure.plugin;

import com.androdome.iadventure.MainFrame;
import com.androdome.iadventure.plugin.Event;
import com.androdome.iadventure.plugin.EventListener;
import com.androdome.iadventure.plugin.JavaPlugin;
import com.androdome.iadventure.plugin.RegisteredEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginManager {
    private MainFrame browerFrame;
    private File pluginDir = new File("./conf/plugins/");
    private ArrayList<RegisteredEvent> registeredEvents = new ArrayList();
    private HashMap<String, JavaPlugin> plugins = new HashMap();
    private HashMap<JavaPlugin, String> names = new HashMap();
    public static final float API_VERSION = 0.5f;

    public boolean isAlphaNumeric(String s) {
        String pattern = "^[a-zA-Z0-9]*$";
        return s.matches(pattern);
    }

    public boolean unload(JavaPlugin plugin) {
        int i = this.registeredEvents.size() - 1;
        while (i >= 0) {
            if (this.registeredEvents.get(i).getPlugin() == plugin) {
                this.registeredEvents.remove(i);
            }
            --i;
        }
        plugin.destroy();
        this.names.remove(plugin);
        return this.plugins.values().remove(plugin);
    }

    public void reload() {
        this.destroyPlugins();
        this.loadPlugins();
    }

    public RegisteredEvent registerEvent(Event.Type eventType, EventListener listener, JavaPlugin plugin, Event.Priority priority) {
        int i = 0;
        while (i < this.registeredEvents.size()) {
            if (this.registeredEvents.get(i).getPriority().compareTo(priority) > 0) {
                RegisteredEvent event = new RegisteredEvent(eventType, listener, plugin, priority);
                this.registeredEvents.add(i, event);
                return event;
            }
            ++i;
        }
        RegisteredEvent event = new RegisteredEvent(eventType, listener, plugin, priority);
        this.registeredEvents.add(event);
        return event;
    }

    public boolean unregisterEvent(RegisteredEvent event) {
        return this.registeredEvents.remove(event);
    }

    public boolean processEvent(Event event) {
        return true;
    }

    public PluginManager(MainFrame server) {
        this.browerFrame = server;
    }

    public MainFrame getSelectedTab() {
        return this.browerFrame;
    }

    public JavaPlugin getPlugin(String name) {
        return this.plugins.get(name);
    }

    public void destroyPlugins() {
        Collection<JavaPlugin> pluginList = this.plugins.values();
        JavaPlugin[] pluginArr = new JavaPlugin[pluginList.size()];
        pluginList.toArray(pluginArr);
        int i = 0;
        while (i < pluginArr.length) {
            pluginArr[i].destroy();
            ++i;
        }
        this.registeredEvents.clear();
        this.plugins.clear();
        this.names.clear();
    }

    public void loadPlugins() {
        System.out.println("Loading plugins...");
        if (!this.plugins.isEmpty()) {
            throw new RuntimeException("Already initialized plugin manager!");
        }
        if (!this.pluginDir.isDirectory()) {
            this.pluginDir.mkdirs();
        } else {
            File[] jars = this.pluginDir.listFiles();
            ArrayList<URL> urls = new ArrayList<URL>();
            ArrayList<String> mainClass = new ArrayList<String>();
            ArrayList<String> name = new ArrayList<String>();
            if (jars != null) {
                int i = 0;
                while (i < jars.length) {
                    String pluginName = jars[i].getName();
                    try {
                        if (jars[i].getName().endsWith(".jar")) {
                            URLClassLoader classLoader = new URLClassLoader(new URL[]{jars[i].toURI().toURL()});
                            BufferedReader reader = new BufferedReader(new InputStreamReader(classLoader.getResourceAsStream("plugin.info")));
                            pluginName = reader.readLine();
                            String mainClassStr = reader.readLine();
                            reader.close();
                            urls.add(jars[i].toURI().toURL());
                            mainClass.add(mainClassStr);
                            name.add(pluginName);
                        }
                    }
                    catch (Exception e) {
                        System.out.println("Failed to load plugin " + pluginName + " (is it out of date?):");
                        e.printStackTrace();
                    }
                    catch (Error e) {
                        System.out.println("Plugin " + pluginName + " crashed while attempting to load. (is it out of date?):");
                        e.printStackTrace();
                    }
                    ++i;
                }
            }
            URL[] uarr = new URL[urls.size()];
            urls.toArray(uarr);
            URLClassLoader classLoader = new URLClassLoader(uarr);
            int i = 0;
            while (i < urls.size()) {
                try {
                    Class<?> pluginClass = classLoader.loadClass((String)mainClass.get(i));
                    JavaPlugin plugin = (JavaPlugin)pluginClass.newInstance();
                    plugin.pluginManager = this;
                    this.plugins.put((String)name.get(i), plugin);
                    this.names.put(plugin, (String)name.get(i));
                }
                catch (Exception e) {
                    System.out.println("Failed to load plugin " + (String)name.get(i) + " (is it out of date?):");
                    e.printStackTrace();
                }
                catch (Error e) {
                    System.out.println("Plugin " + (String)name.get(i) + " crashed while attempting to load. (is it out of date?):");
                    e.printStackTrace();
                }
                ++i;
            }
            ArrayList<JavaPlugin> plugins = new ArrayList<JavaPlugin>(this.plugins.values());
            int i2 = 0;
            while (i2 < plugins.size()) {
                try {
                    plugins.get(i2).init();
                }
                catch (Exception e) {
                    System.out.println("Failed to load plugin " + (String)name.get(i2) + " (is it out of date?):");
                    e.printStackTrace();
                }
                catch (Error e) {
                    System.out.println("Plugin " + (String)name.get(i2) + " crashed while attempting to load. (is it out of date?):");
                    e.printStackTrace();
                }
                ++i2;
            }
        }
        System.out.println("Done!");
    }

    public ArrayList<String> getPlugins() {
        return new ArrayList<String>(this.names.values());
    }

    public File getPluginDirectory() {
        return this.pluginDir;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        OK,
        CMD_IN_USE,
        CMD_ALNUM_WARN,
        CMD_HANDLE_INVALID;

    }
}

