/*
 * Decompiled with CFR 0.152.
 */
package com.androdome.iadventure.utils;

import com.androdome.iadventure.utils.Binding;
import com.androdome.iadventure.utils.BindingObject;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayListBinding<K, V>
implements Binding<K, V> {
    private ArrayList<K> keys = new ArrayList();
    private ArrayList<V> values = new ArrayList();

    @Override
    public BindingObject<K, V> getBindingObject(int i) {
        if (i < 0 || i > this.keys.size() - 1) {
            return null;
        }
        return new BindingObject<K, V>(this.keys.get(i), this.values.get(i));
    }

    @Override
    public List<K> getKeyList() {
        return this.keys;
    }

    @Override
    public synchronized boolean addBinding(K key, V value) {
        int i = 0;
        while (i < this.keys.size()) {
            if (this.keys.get(i) == key && this.values.get(i) == value) {
                return false;
            }
            ++i;
        }
        this.keys.add(key);
        this.values.add(value);
        return true;
    }

    @Override
    public synchronized boolean removeBinding(K key, V value) {
        int i = 0;
        while (i < this.keys.size()) {
            if (this.keys.get(i) == key && this.values.get(i) == value) {
                this.keys.remove(i);
                this.values.remove(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public List<V> getValueList() {
        return this.values;
    }

    @Override
    public boolean removeBinding(int i) {
        if (i < 0 || i > this.keys.size() - 1) {
            return false;
        }
        this.keys.remove(i);
        this.values.remove(i);
        return true;
    }

    @Override
    public K getFirstKeyFromValue(V value) {
        int idx = this.values.indexOf(value);
        if (idx == -1) {
            return null;
        }
        return this.keys.get(idx);
    }

    @Override
    public V getFirstValueFromKey(K key) {
        int idx = this.keys.indexOf(key);
        if (idx == -1) {
            return null;
        }
        return this.values.get(idx);
    }
}

