/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.web.csskit;

import cz.vutbr.web.css.CombinedSelector;
import cz.vutbr.web.css.Selector;
import cz.vutbr.web.csskit.AbstractRule;
import cz.vutbr.web.csskit.ElementUtil;
import cz.vutbr.web.csskit.OutputUtil;
import java.util.HashMap;
import org.w3c.dom.Element;

public class SelectorImpl
extends AbstractRule<Selector.SelectorPart>
implements Selector {
    protected Selector.Combinator combinator;

    @Override
    public Selector.Combinator getCombinator() {
        return this.combinator;
    }

    @Override
    public Selector setCombinator(Selector.Combinator combinator) {
        this.combinator = combinator;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.combinator != null) {
            sb.append(this.combinator.value());
        }
        sb = OutputUtil.appendList(sb, this.list, "");
        return sb.toString();
    }

    @Override
    public String getClassName() {
        String className = null;
        for (Selector.SelectorPart item : this.list) {
            if (!(item instanceof Selector.ElementClass)) continue;
            className = ((Selector.ElementClass)item).getClassName();
        }
        return className;
    }

    @Override
    public String getIDName() {
        String idName = null;
        for (Selector.SelectorPart item : this.list) {
            if (!(item instanceof Selector.ElementID)) continue;
            idName = ((Selector.ElementID)item).getID();
        }
        return idName;
    }

    @Override
    public String getElementName() {
        String elementName = null;
        for (Selector.SelectorPart item : this.list) {
            if (!(item instanceof Selector.ElementName)) continue;
            elementName = ((Selector.ElementName)item).getName();
        }
        return elementName;
    }

    @Override
    public Selector.PseudoDeclaration getPseudoElement() {
        Selector.PseudoDeclaration ret = null;
        for (Selector.SelectorPart item : this.list) {
            if (!(item instanceof Selector.PseudoPage)) continue;
            ret = ((Selector.PseudoPage)item).getDeclaration();
            if (ret.isPseudoElement()) break;
            ret = null;
        }
        return ret;
    }

    @Override
    public boolean matches(Element e) {
        for (Selector.SelectorPart item : this.list) {
            if (item != null && item.matches(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void computeSpecificity(CombinedSelector.Specificity spec) {
        for (Selector.SelectorPart item : this.list) {
            item.computeSpecificity(spec);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.combinator == null ? 0 : this.combinator.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SelectorImpl)) {
            return false;
        }
        SelectorImpl other = (SelectorImpl)obj;
        return !(this.combinator == null ? other.combinator != null : !this.combinator.equals((Object)other.combinator));
    }

    public static class ElementAttributeImpl
    implements Selector.ElementAttribute {
        private Selector.Operator operator;
        private String attribute;
        private String value;
        private boolean isStringValue;

        protected ElementAttributeImpl(String value, boolean isStringValue, Selector.Operator operator, String attribute) {
            this.isStringValue = isStringValue;
            this.operator = operator;
            this.attribute = attribute;
            this.setValue(value);
        }

        @Override
        public Selector.Operator getOperator() {
            return this.operator;
        }

        @Override
        public void setOperator(Selector.Operator operator) {
            this.operator = operator;
        }

        @Override
        public String getAttribute() {
            return this.attribute;
        }

        @Override
        public Selector.ElementAttribute setAttribute(String name) {
            this.attribute = name;
            return this;
        }

        @Override
        public void computeSpecificity(CombinedSelector.Specificity spec) {
            spec.add(CombinedSelector.Specificity.Level.C);
        }

        @Override
        public boolean matches(Element e) {
            return ElementUtil.matchesAttribute(e, this.attribute, this.value, this.operator);
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public Selector.ElementAttribute setValue(String value) {
            this.value = value;
            return this;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[").append(this.attribute);
            sb.append(this.operator.value());
            if (this.isStringValue && this.value != null) {
                sb.append("'");
            }
            if (this.value != null) {
                sb.append(this.value);
            }
            if (this.isStringValue && this.value != null) {
                sb.append("'");
            }
            sb.append("]");
            return sb.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.attribute == null ? 0 : this.attribute.hashCode());
            result = 31 * result + (this.isStringValue ? 1231 : 1237);
            result = 31 * result + (this.operator == null ? 0 : this.operator.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ElementAttributeImpl)) {
                return false;
            }
            ElementAttributeImpl other = (ElementAttributeImpl)obj;
            if (this.attribute == null ? other.attribute != null : !this.attribute.equals(other.attribute)) {
                return false;
            }
            if (this.isStringValue != other.isStringValue) {
                return false;
            }
            if (this.operator == null ? other.operator != null : !this.operator.equals((Object)other.operator)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }
    }

    public static class ElementClassImpl
    implements Selector.ElementClass {
        private String className;

        protected ElementClassImpl(String className) {
            this.setClassName(className);
        }

        @Override
        public void computeSpecificity(CombinedSelector.Specificity spec) {
            spec.add(CombinedSelector.Specificity.Level.C);
        }

        @Override
        public boolean matches(Element e) {
            return ElementUtil.matchesClass(e, this.className);
        }

        @Override
        public String getClassName() {
            return this.className;
        }

        @Override
        public Selector.ElementClass setClassName(String className) {
            if (className == null) {
                throw new IllegalArgumentException("Invalid element class (null)");
            }
            this.className = className;
            return this;
        }

        public String toString() {
            return "." + this.className;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ElementClassImpl)) {
                return false;
            }
            ElementClassImpl other = (ElementClassImpl)obj;
            return !(this.className == null ? other.className != null : !this.className.equals(other.className));
        }
    }

    public static class ElementDOMImpl
    implements Selector.ElementDOM {
        private Element elem;

        protected ElementDOMImpl(Element e) {
            this.elem = e;
        }

        @Override
        public Element getElement() {
            return this.elem;
        }

        @Override
        public Selector.ElementDOM setElement(Element e) {
            this.elem = e;
            return this;
        }

        @Override
        public void computeSpecificity(CombinedSelector.Specificity spec) {
            spec.add(CombinedSelector.Specificity.Level.A);
        }

        @Override
        public boolean matches(Element e) {
            return this.elem.equals(e);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.elem == null ? 0 : this.elem.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ElementDOMImpl)) {
                return false;
            }
            ElementDOMImpl other = (ElementDOMImpl)obj;
            return !(this.elem == null ? other.elem != null : !this.elem.equals(other.elem));
        }
    }

    public static class ElementIDImpl
    implements Selector.ElementID {
        private String id;

        protected ElementIDImpl(String value) {
            this.setID(value);
        }

        @Override
        public void computeSpecificity(CombinedSelector.Specificity spec) {
            spec.add(CombinedSelector.Specificity.Level.B);
        }

        @Override
        public boolean matches(Element e) {
            return ElementUtil.matchesID(e, this.id);
        }

        @Override
        public Selector.ElementID setID(String id) {
            if (id == null) {
                throw new IllegalArgumentException("Invalid element ID (null)");
            }
            this.id = id;
            return this;
        }

        @Override
        public String getID() {
            return this.id;
        }

        public String toString() {
            return "#" + this.id;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ElementIDImpl)) {
                return false;
            }
            ElementIDImpl other = (ElementIDImpl)obj;
            return !(this.id == null ? other.id != null : !this.id.equals(other.id));
        }
    }

    public static class ElementNameImpl
    implements Selector.ElementName {
        private String name;

        protected ElementNameImpl(String name) {
            this.setName(name);
        }

        @Override
        public void computeSpecificity(CombinedSelector.Specificity spec) {
            if (!"*".equals(this.name)) {
                spec.add(CombinedSelector.Specificity.Level.D);
            }
        }

        @Override
        public boolean matches(Element e) {
            if (this.name != null && "*".equals(this.name)) {
                return true;
            }
            return ElementUtil.matchesName(e, this.name);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Selector.ElementName setName(String name) {
            if (name == null) {
                throw new IllegalArgumentException("Invalid element name (null)");
            }
            this.name = name;
            return this;
        }

        public String toString() {
            return this.name;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ElementNameImpl)) {
                return false;
            }
            ElementNameImpl other = (ElementNameImpl)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }
    }

    public static class PseudoPageImpl
    implements Selector.PseudoPage {
        private static HashMap<String, Selector.PseudoDeclaration> PSEUDO_DECLARATIONS = new HashMap(11);
        private String functionName;
        private String value;
        private Selector.PseudoDeclaration declaration;

        static {
            PSEUDO_DECLARATIONS.put("active", Selector.PseudoDeclaration.ACTIVE);
            PSEUDO_DECLARATIONS.put("focus", Selector.PseudoDeclaration.FOCUS);
            PSEUDO_DECLARATIONS.put("hover", Selector.PseudoDeclaration.HOVER);
            PSEUDO_DECLARATIONS.put("link", Selector.PseudoDeclaration.LINK);
            PSEUDO_DECLARATIONS.put("visited", Selector.PseudoDeclaration.VISITED);
            PSEUDO_DECLARATIONS.put("first-child", Selector.PseudoDeclaration.FIRST_CHILD);
            PSEUDO_DECLARATIONS.put("lang", Selector.PseudoDeclaration.LANG);
            PSEUDO_DECLARATIONS.put("first-letter", Selector.PseudoDeclaration.FIRST_LETTER);
            PSEUDO_DECLARATIONS.put("first-line", Selector.PseudoDeclaration.FIRST_LINE);
            PSEUDO_DECLARATIONS.put("before", Selector.PseudoDeclaration.BEFORE);
            PSEUDO_DECLARATIONS.put("after", Selector.PseudoDeclaration.AFTER);
        }

        protected PseudoPageImpl(String value, String functionName) {
            this.setValue(value);
            this.setFunctionName(functionName);
        }

        @Override
        public Selector.PseudoDeclaration getDeclaration() {
            return this.declaration;
        }

        @Override
        public String getFunctionName() {
            return this.functionName;
        }

        @Override
        public Selector.PseudoPage setFunctionName(String functionName) {
            this.functionName = functionName;
            this.inferDeclaration();
            return this;
        }

        @Override
        public void computeSpecificity(CombinedSelector.Specificity spec) {
            if (this.declaration != null) {
                if (this.declaration.isPseudoElement()) {
                    spec.add(CombinedSelector.Specificity.Level.D);
                } else {
                    spec.add(CombinedSelector.Specificity.Level.C);
                }
            }
        }

        @Override
        public boolean matches(Element e) {
            return this.declaration != null && (this.declaration.isPseudoElement() || e.getTagName().equalsIgnoreCase("a") && this.declaration == Selector.PseudoDeclaration.LINK);
        }

        @Override
        public Selector.PseudoPage setValue(String value) {
            this.value = value;
            this.inferDeclaration();
            return this;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(":");
            if (this.functionName != null) {
                sb.append(this.functionName).append("(");
            }
            if (this.value != null) {
                sb.append(this.value);
            }
            if (this.functionName != null) {
                sb.append(")");
            }
            sb.append("");
            return sb.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.functionName == null ? 0 : this.functionName.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof PseudoPageImpl)) {
                return false;
            }
            PseudoPageImpl other = (PseudoPageImpl)obj;
            if (this.functionName == null ? other.functionName != null : !this.functionName.equals(other.functionName)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        private void inferDeclaration() {
            this.declaration = this.functionName != null ? PSEUDO_DECLARATIONS.get(this.functionName.toLowerCase()) : (this.value != null ? PSEUDO_DECLARATIONS.get(this.value.toLowerCase()) : null);
        }
    }
}

