/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.web.csskit;

import cz.vutbr.web.css.Term;
import cz.vutbr.web.css.TermColor;
import cz.vutbr.web.css.TermFunction;
import cz.vutbr.web.css.TermIdent;
import cz.vutbr.web.css.TermInteger;
import cz.vutbr.web.css.TermPercent;
import cz.vutbr.web.csskit.ColorCard;
import cz.vutbr.web.csskit.TermImpl;
import java.awt.Color;

public class TermColorImpl
extends TermImpl<Color>
implements TermColor {
    protected static final String COLOR_FUNCTION_NAME = "rgb";
    protected static final int COLOR_PARAMS_COUNT = 3;
    protected static final int MAX_VALUE = 255;
    protected static final int MIN_VALUE = 0;
    protected static final int PERCENT_CONVERSION = 100;

    protected TermColorImpl(int r, int g, int b) {
        this.value = new Color(r, g, b);
    }

    @Override
    public String toString() {
        String s;
        StringBuilder sb = new StringBuilder();
        if (this.operator != null) {
            sb.append(this.operator.value());
        }
        if ((s = Integer.toHexString(((Color)this.value).getRGB() & 0xFFFFFF)).length() < 6) {
            s = String.valueOf("000000".substring(0, 6 - s.length())) + s;
        }
        sb.append("#").append(s);
        return sb.toString();
    }

    public static TermColor getColorByIdent(TermIdent ident) {
        return ColorCard.getTermColor((String)ident.getValue());
    }

    public static TermColor getColorByHash(String hash) {
        if (hash == null) {
            throw new IllegalArgumentException("Invalid hash value (null) for color construction");
        }
        if ((hash = hash.toLowerCase().replaceAll("^#", "")).matches("^[0-9a-f]{3}$")) {
            String r = hash.substring(0, 1);
            String g = hash.substring(1, 2);
            String b = hash.substring(2, 3);
            return new TermColorImpl(Integer.parseInt(String.valueOf(r) + r, 16), Integer.parseInt(String.valueOf(g) + g, 16), Integer.parseInt(String.valueOf(b) + b, 16));
        }
        if (hash.matches("^[0-9a-f]{6}$")) {
            String r = hash.substring(0, 2);
            String g = hash.substring(2, 4);
            String b = hash.substring(4, 6);
            return new TermColorImpl(Integer.parseInt(r, 16), Integer.parseInt(g, 16), Integer.parseInt(b, 16));
        }
        return null;
    }

    public static TermColor getColorByFunction(TermFunction func) {
        if (COLOR_FUNCTION_NAME.equals(func.getFunctionName()) && func.size() == 3) {
            int[] rgb = new int[3];
            int i = 0;
            for (Term term : func) {
                if (term instanceof TermInteger) {
                    rgb[i] = ((TermInteger)term).getIntValue();
                } else if (term instanceof TermPercent) {
                    int value = ((Float)((TermPercent)term).getValue()).intValue();
                    rgb[i] = value * 255 / 100;
                } else {
                    return null;
                }
                ++i;
            }
            i = 0;
            while (i < rgb.length) {
                if (rgb[i] < 0) {
                    rgb[i] = 0;
                }
                if (rgb[i] > 255) {
                    rgb[i] = 255;
                }
                ++i;
            }
            return new TermColorImpl(rgb[0], rgb[1], rgb[2]);
        }
        return null;
    }
}

