/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.web.csskit;

import cz.vutbr.web.css.Term;
import cz.vutbr.web.css.TermAngle;
import cz.vutbr.web.css.TermColor;
import cz.vutbr.web.css.TermExpression;
import cz.vutbr.web.css.TermFactory;
import cz.vutbr.web.css.TermFrequency;
import cz.vutbr.web.css.TermFunction;
import cz.vutbr.web.css.TermIdent;
import cz.vutbr.web.css.TermInteger;
import cz.vutbr.web.css.TermLength;
import cz.vutbr.web.css.TermList;
import cz.vutbr.web.css.TermNumber;
import cz.vutbr.web.css.TermNumeric;
import cz.vutbr.web.css.TermPair;
import cz.vutbr.web.css.TermPercent;
import cz.vutbr.web.css.TermString;
import cz.vutbr.web.css.TermTime;
import cz.vutbr.web.css.TermURI;
import cz.vutbr.web.csskit.TermAngleImpl;
import cz.vutbr.web.csskit.TermColorImpl;
import cz.vutbr.web.csskit.TermExpressionImpl;
import cz.vutbr.web.csskit.TermFrequencyImpl;
import cz.vutbr.web.csskit.TermFunctionImpl;
import cz.vutbr.web.csskit.TermIdentImpl;
import cz.vutbr.web.csskit.TermImpl;
import cz.vutbr.web.csskit.TermIntegerImpl;
import cz.vutbr.web.csskit.TermLengthImpl;
import cz.vutbr.web.csskit.TermListImpl;
import cz.vutbr.web.csskit.TermNumberImpl;
import cz.vutbr.web.csskit.TermPairImpl;
import cz.vutbr.web.csskit.TermPercentImpl;
import cz.vutbr.web.csskit.TermStringImpl;
import cz.vutbr.web.csskit.TermTimeImpl;
import cz.vutbr.web.csskit.TermURIImpl;

public class TermFactoryImpl
implements TermFactory {
    private static final TermFactory instance = new TermFactoryImpl();

    public static final TermFactory getInstance() {
        return instance;
    }

    private TermFactoryImpl() {
    }

    @Override
    public TermAngle createAngle(Float value) {
        return (TermAngle)new TermAngleImpl().setValue(value);
    }

    @Override
    public TermAngle createAngle(String value, TermNumeric.Unit unit, int unary) {
        return (TermAngle)new TermAngleImpl().setUnit(unit).setValue(this.convertFloat(value, unit.value(), unary));
    }

    @Override
    public TermColor createColor(TermIdent ident) {
        return TermColorImpl.getColorByIdent(ident);
    }

    @Override
    public TermColor createColor(String hash) {
        return TermColorImpl.getColorByHash(hash);
    }

    @Override
    public TermColor createColor(int r, int g, int b) {
        return new TermColorImpl(r, g, b);
    }

    @Override
    public TermColor createColor(TermFunction function) {
        return TermColorImpl.getColorByFunction(function);
    }

    @Override
    public TermFrequency createFrequency(Float value) {
        return new TermFrequencyImpl().setValue(value);
    }

    @Override
    public TermFrequency createFrequency(String value, TermNumeric.Unit unit, int unary) {
        return (TermFrequency)new TermFrequencyImpl().setUnit(unit).setValue(this.convertFloat(value, unit.value(), unary));
    }

    @Override
    public TermExpression createExpression(String expr) {
        return new TermExpressionImpl().setValue(expr);
    }

    @Override
    public TermFunction createFunction() {
        return new TermFunctionImpl();
    }

    @Override
    public TermIdent createIdent(String value) {
        return (TermIdent)new TermIdentImpl().setValue(value);
    }

    @Override
    public TermIdent createIdent(String value, boolean dash) {
        if (!dash) {
            return (TermIdent)new TermIdentImpl().setValue(value);
        }
        return (TermIdent)new TermIdentImpl().setValue("-" + value);
    }

    @Override
    public TermInteger createInteger(Integer value) {
        return new TermIntegerImpl().setValue(value);
    }

    @Override
    public TermInteger createInteger(String value, int unary) {
        return new TermIntegerImpl().setValue(this.convertInteger(value, null, unary));
    }

    @Override
    public TermLength createLength(Float value) {
        return (TermLength)new TermLengthImpl().setValue(value);
    }

    @Override
    public TermLength createLength(Float value, TermNumeric.Unit unit) {
        return (TermLength)new TermLengthImpl().setUnit(unit).setValue(value);
    }

    @Override
    public TermLength createLength(String value, TermNumeric.Unit unit, int unary) {
        return (TermLength)new TermLengthImpl().setUnit(unit).setValue(this.convertFloat(value, unit.value(), unary));
    }

    @Override
    public TermList createList() {
        return new TermListImpl();
    }

    @Override
    public TermList createList(int initialSize) {
        return new TermListImpl(initialSize);
    }

    @Override
    public TermNumber createNumber(Float value) {
        return (TermNumber)new TermNumberImpl().setValue(value);
    }

    @Override
    public TermNumber createNumber(String value, int unary) {
        return (TermNumber)new TermNumberImpl().setValue(this.convertFloat(value, null, unary));
    }

    @Override
    public TermNumeric<?> createNumeric(String value, int unary) {
        try {
            return this.createInteger(value, unary);
        }
        catch (IllegalArgumentException e) {
            return this.createNumber(value, unary);
        }
    }

    @Override
    public TermNumeric<Float> createDimension(String value, int unary) {
        TermNumeric.Unit[] unitArray = TermNumeric.Unit.values();
        int n = unitArray.length;
        int n2 = 0;
        while (n2 < n) {
            TermNumeric.Unit unit = unitArray[n2];
            if (value.matches("^[0-9]*.?[0-9]+" + unit.value() + "$")) {
                Float f = this.convertFloat(value, unit.value(), unary);
                if (unit.isAngle()) {
                    return (TermNumeric)new TermAngleImpl().setUnit(unit).setValue(f);
                }
                if (unit.isFrequency()) {
                    return (TermNumeric)new TermFrequencyImpl().setUnit(unit).setValue(f);
                }
                if (unit.isLength()) {
                    return (TermNumeric)new TermLengthImpl().setUnit(unit).setValue(f);
                }
                if (unit.isTime()) {
                    return (TermNumeric)new TermTimeImpl().setUnit(unit).setValue(f);
                }
            }
            ++n2;
        }
        return null;
    }

    @Override
    public <K, V> TermPair<K, V> createPair(K key, V value) {
        return (TermPair)new TermPairImpl().setKey(key).setValue(value);
    }

    @Override
    public TermPercent createPercent(Float value) {
        return (TermPercent)new TermPercentImpl().setValue(value);
    }

    @Override
    public TermPercent createPercent(String value, int unary) {
        return (TermPercent)new TermPercentImpl().setValue(this.convertFloat(value, "%", unary));
    }

    @Override
    public TermString createString(String value) {
        return new TermStringImpl().setValue(value);
    }

    @Override
    public <V> Term<V> createTerm(V value) {
        return new TermImpl<V>().setValue(value);
    }

    @Override
    public TermTime createTime(Float value) {
        return new TermTimeImpl().setValue(value);
    }

    @Override
    public TermTime createTime(String value, TermNumeric.Unit unit, int unary) {
        return (TermTime)new TermTimeImpl().setUnit(unit).setValue(this.convertFloat(value, unit.value(), unary));
    }

    @Override
    public TermURI createURI(String value) {
        return new TermURIImpl().setValue(value);
    }

    protected Float convertFloat(String value, String unit, int unary) throws IllegalArgumentException {
        try {
            value = value.trim().toLowerCase();
            if (unit != null) {
                value = value.replaceAll(String.valueOf(unit) + "$", "");
            }
            return Float.valueOf(Float.parseFloat(value) * (float)unary);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid number format " + value, e);
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("Invalid null format");
        }
    }

    protected Integer convertInteger(String value, String unit, int unary) throws IllegalArgumentException {
        try {
            value = value.trim().toLowerCase();
            if (unit != null) {
                value = value.replaceAll(String.valueOf(unit) + "$", "");
            }
            return Integer.valueOf(value) * unary;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid number format " + value, e);
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("Invalid null format");
        }
    }
}

