/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.web.csskit.antlr;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.ANTLRReaderStream;
import org.antlr.runtime.CharStream;

public class CSSInputStream
implements CharStream {
    private CharStream input;
    private String rawData;
    private URL base = null;
    private String encoding;

    public static CSSInputStream stringStream(String source) throws IOException {
        CSSInputStream stream = new CSSInputStream();
        stream.rawData = source;
        stream.encoding = Charset.defaultCharset().name();
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(source.getBytes()), stream.encoding));
        stream.input = new ANTLRReaderStream(br);
        return stream;
    }

    public static CSSInputStream urlStream(URL source) throws IOException {
        CSSInputStream stream = new CSSInputStream();
        stream.base = source;
        stream.encoding = Charset.defaultCharset().name();
        stream.input = new ANTLRInputStream(source.openStream(), stream.encoding);
        return stream;
    }

    private CSSInputStream() {
    }

    @Override
    public int LT(int arg0) {
        return this.input.LT(arg0);
    }

    @Override
    public int getCharPositionInLine() {
        return this.input.getCharPositionInLine();
    }

    @Override
    public int getLine() {
        return this.input.getLine();
    }

    @Override
    public void setCharPositionInLine(int arg0) {
        this.input.setCharPositionInLine(arg0);
    }

    @Override
    public void setLine(int arg0) {
        this.input.setLine(arg0);
    }

    @Override
    public String substring(int arg0, int arg1) {
        return this.input.substring(arg0, arg1);
    }

    @Override
    public int LA(int arg0) {
        return this.input.LA(arg0);
    }

    @Override
    public void consume() {
        this.input.consume();
    }

    @Override
    public int index() {
        return this.input.index();
    }

    @Override
    public int mark() {
        return this.input.mark();
    }

    @Override
    public void release(int arg0) {
        this.input.release(arg0);
    }

    @Override
    public void rewind() {
        this.input.rewind();
    }

    @Override
    public void rewind(int arg0) {
        this.input.rewind(arg0);
    }

    @Override
    public void seek(int arg0) {
        this.input.seek(arg0);
    }

    @Override
    public int size() {
        return this.input.size();
    }

    @Override
    public String getSourceName() {
        return this.base != null ? this.base.toString() : "";
    }

    public URL getBase() {
        return this.base;
    }

    public void setBase(URL base) {
        this.base = base;
    }

    public String getRawData() {
        return this.rawData;
    }
}

