/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.web.csskit.antlr;

import cz.vutbr.web.css.CSSFactory;
import cz.vutbr.web.css.CombinedSelector;
import cz.vutbr.web.css.Declaration;
import cz.vutbr.web.css.RuleBlock;
import cz.vutbr.web.css.RuleFactory;
import cz.vutbr.web.css.RuleMedia;
import cz.vutbr.web.css.RulePage;
import cz.vutbr.web.css.RuleSet;
import cz.vutbr.web.css.Selector;
import cz.vutbr.web.csskit.PriorityStrategy;
import cz.vutbr.web.csskit.antlr.Preparator;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class SimplePreparator
implements Preparator {
    protected static final Logger log = LoggerFactory.getLogger(SimplePreparator.class);
    private static RuleFactory rf = CSSFactory.getRuleFactory();
    private PriorityStrategy ps;
    private Element elem;

    public SimplePreparator(PriorityStrategy ps, Element e) {
        this.ps = ps;
        this.elem = e;
    }

    @Override
    public RuleBlock<?> prepareRuleSet(List<CombinedSelector> cslist, List<Declaration> dlist, boolean wrap, List<String> media) {
        if ((cslist == null || cslist.isEmpty()) && (dlist == null || dlist.isEmpty())) {
            log.debug("Empty RuleSet was ommited");
            return null;
        }
        RuleBlock.Priority prio = this.ps.getAndIncrement();
        RuleSet rs = rf.createSet(prio);
        rs.setSelectors(cslist);
        rs.replaceAll(dlist);
        log.info("Created RuleSet as {}th with:\n{}", prio, (Object)rs);
        if (wrap) {
            prio = rs.getPriority();
            rs.setPriority(this.ps.getAndIncrement());
            RuleMedia rm = rf.createMedia(prio);
            log.debug("Wrapping RuleSet {} into RuleMedia: {}", rs, media);
            rm.unlock();
            rm.add(rs);
            rm.setMedia(media);
            return rm;
        }
        return rs;
    }

    @Override
    public RuleBlock<?> prepareRuleMedia(RuleBlock.Priority mark, List<RuleSet> rules, List<String> media) {
        if (rules == null || rules.isEmpty()) {
            log.debug("Empty RuleMedia was ommited");
            return null;
        }
        RuleMedia rm = rf.createMedia(mark);
        rm.replaceAll(rules);
        if (media != null && !media.isEmpty()) {
            rm.setMedia(media);
        }
        log.info("Create @media as {}th with:\n{}", mark, (Object)rm);
        return rm;
    }

    @Override
    public RuleBlock<?> prepareRulePage(List<Declaration> decl, String pseudo) {
        if (decl == null || decl.isEmpty()) {
            log.debug("Empty RulePage was ommited");
            return null;
        }
        RuleBlock.Priority prio = this.ps.getAndIncrement();
        RulePage rp = rf.createPage(prio);
        rp.replaceAll(decl);
        rp.setPseudo(pseudo);
        log.info("Create @page as {}th with:\n{}", prio, (Object)rp);
        return rp;
    }

    @Override
    public RuleBlock.Priority markPriority() {
        return this.ps.markAndIncrement();
    }

    @Override
    public RuleBlock<?> prepareInlineRuleSet(List<Declaration> dlist, List<Selector.PseudoPage> pseudos) {
        if (dlist == null || dlist.isEmpty()) {
            log.debug("Empty RuleSet (inline) was ommited");
            return null;
        }
        CombinedSelector cs = (CombinedSelector)rf.createCombinedSelector().unlock();
        Selector sel = (Selector)rf.createSelector().unlock();
        sel.add(rf.createElementDOM(this.elem));
        if (pseudos != null) {
            sel.addAll(pseudos);
        }
        cs.add(sel);
        RuleBlock.Priority prio = this.ps.getAndIncrement();
        RuleSet rs = rf.createSet(prio);
        rs.replaceAll(dlist);
        rs.setSelectors(Arrays.asList(cs));
        log.info("Create @media as {}th with:\n{}", prio, (Object)rs);
        return rs;
    }
}

