/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.web.csskit.antlr;

import org.antlr.runtime.tree.CommonTree;

public class TreeUtil {
    private TreeUtil() {
        throw new AssertionError();
    }

    public static String toStringTree(CommonTree tree) {
        StringBuilder sb = new StringBuilder();
        TreeUtil.nest(tree, sb, 0);
        return sb.toString();
    }

    private static void nest(CommonTree tree, StringBuilder sb, int nest) {
        assert (tree != null);
        if (tree.getChildCount() == 0) {
            TreeUtil.addTree(sb, tree, nest);
            return;
        }
        if (!tree.isNil()) {
            TreeUtil.addTree(sb, tree, nest);
        }
        int i = 0;
        while (i < tree.getChildCount()) {
            CommonTree n = (CommonTree)tree.getChild(i);
            TreeUtil.nest(n, sb, nest + 1);
            ++i;
        }
        if (!tree.isNil()) {
            sb.append(")");
        }
    }

    private static StringBuilder addTree(StringBuilder sb, CommonTree tree, int nest) {
        sb.append("\n");
        int i = 0;
        while (i < nest) {
            sb.append("  ");
            ++i;
        }
        if (!tree.isNil()) {
            sb.append("(");
        }
        sb.append(tree.toString()).append(" |").append(tree.getType()).append("| ");
        return sb;
    }
}

