/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.css;

import cz.vutbr.web.css.CSSFactory;
import cz.vutbr.web.css.TermLength;
import cz.vutbr.web.css.TermLengthOrPercent;
import cz.vutbr.web.css.TermNumeric;
import cz.vutbr.web.css.TermPercent;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLNorm {
    public static void attributesToStyles(Node n, String tab_inh) {
        String itab = tab_inh;
        if (n.getNodeType() == 1) {
            String width;
            String align;
            String border;
            Element el = (Element)n;
            String attrs = "";
            if (el.getTagName().equals("table") || el.getTagName().equals("tr") || el.getTagName().equals("th") || el.getTagName().equals("td") || el.getTagName().equals("body")) {
                if (el.getAttributes().getNamedItem("bgcolor") != null) {
                    attrs = String.valueOf(attrs) + "background-color: " + el.getAttribute("bgcolor") + ";";
                }
                if (el.getAttributes().getNamedItem("text") != null) {
                    attrs = String.valueOf(attrs) + "color: " + el.getAttribute("text") + ";";
                }
            }
            if (el.getTagName().equals("table")) {
                border = "0";
                String frame = "void";
                String rules = "none";
                int cpadding = 0;
                int cspacing = 0;
                itab = "";
                if (el.getAttributes().getNamedItem("cellpadding") != null) {
                    try {
                        cpadding = Integer.parseInt(el.getAttribute("cellpadding"));
                        itab = String.valueOf(itab) + "padding: " + cpadding + "px; ";
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (el.getAttributes().getNamedItem("cellspacing") != null) {
                    try {
                        cspacing = Integer.parseInt(el.getAttribute("cellspacing"));
                        attrs = String.valueOf(attrs) + "border-spacing: " + cspacing + "px; ";
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (el.getAttributes().getNamedItem("border") != null && !(border = el.getAttribute("border")).equals("0")) {
                    frame = "border";
                    rules = "all";
                }
                if (el.getAttributes().getNamedItem("frame") != null) {
                    frame = el.getAttribute("frame").toLowerCase();
                }
                if (el.getAttributes().getNamedItem("rules") != null) {
                    frame = el.getAttribute("rules").toLowerCase();
                }
                if (!border.equals("0")) {
                    String fstyle = "border-@-color:auto;border-@-style:solid;border-@-width:" + border + "px;";
                    if (frame.equals("above")) {
                        attrs = String.valueOf(attrs) + HTMLNorm.applyBorders(fstyle, "top");
                    }
                    if (frame.equals("below")) {
                        attrs = String.valueOf(attrs) + HTMLNorm.applyBorders(fstyle, "bottom");
                    }
                    if (frame.equals("hsides")) {
                        attrs = String.valueOf(attrs) + HTMLNorm.applyBorders(fstyle, "left");
                        attrs = String.valueOf(attrs) + HTMLNorm.applyBorders(fstyle, "right");
                    }
                    if (frame.equals("lhs")) {
                        attrs = String.valueOf(attrs) + HTMLNorm.applyBorders(fstyle, "left");
                    }
                    if (frame.equals("rhs")) {
                        attrs = String.valueOf(attrs) + HTMLNorm.applyBorders(fstyle, "right");
                    }
                    if (frame.equals("vsides")) {
                        attrs = String.valueOf(attrs) + HTMLNorm.applyBorders(fstyle, "top");
                        attrs = String.valueOf(attrs) + HTMLNorm.applyBorders(fstyle, "bottom");
                    }
                    if (frame.equals("box")) {
                        attrs = String.valueOf(attrs) + HTMLNorm.applyBorders(fstyle, "left");
                        attrs = String.valueOf(attrs) + HTMLNorm.applyBorders(fstyle, "right");
                        attrs = String.valueOf(attrs) + HTMLNorm.applyBorders(fstyle, "top");
                        attrs = String.valueOf(attrs) + HTMLNorm.applyBorders(fstyle, "bottom");
                    }
                    if (frame.equals("border")) {
                        attrs = String.valueOf(attrs) + HTMLNorm.applyBorders(fstyle, "left");
                        attrs = String.valueOf(attrs) + HTMLNorm.applyBorders(fstyle, "right");
                        attrs = String.valueOf(attrs) + HTMLNorm.applyBorders(fstyle, "top");
                        attrs = String.valueOf(attrs) + HTMLNorm.applyBorders(fstyle, "bottom");
                    }
                    fstyle = "border-@-color:auto;border-@-style:solid;border-@-width:1px;";
                    if (rules.equals("rows")) {
                        itab = String.valueOf(itab) + HTMLNorm.applyBorders(fstyle, "top");
                        itab = String.valueOf(itab) + HTMLNorm.applyBorders(fstyle, "bottom");
                    }
                    if (rules.equals("rows")) {
                        itab = String.valueOf(itab) + HTMLNorm.applyBorders(fstyle, "left");
                        itab = String.valueOf(itab) + HTMLNorm.applyBorders(fstyle, "right");
                    }
                    if (rules.equals("all")) {
                        itab = String.valueOf(itab) + HTMLNorm.applyBorders(fstyle, "top");
                        itab = String.valueOf(itab) + HTMLNorm.applyBorders(fstyle, "bottom");
                        itab = String.valueOf(itab) + HTMLNorm.applyBorders(fstyle, "left");
                        itab = String.valueOf(itab) + HTMLNorm.applyBorders(fstyle, "right");
                    }
                }
            }
            if ((el.getTagName().equals("th") || el.getTagName().equals("td")) && itab.length() > 0) {
                attrs = String.valueOf(itab) + attrs;
            }
            if ((el.getTagName().equals("img") || el.getTagName().equals("object")) && el.getAttributes().getNamedItem("border") != null) {
                border = el.getAttribute("border");
                String fstyle = border.equals("0") ? "border-@-style:none;" : "border-@-color:auto;border-@-style:solid;border-@-width:" + border + "px;";
                attrs = String.valueOf(attrs) + HTMLNorm.applyBorders(fstyle, "top");
                attrs = String.valueOf(attrs) + HTMLNorm.applyBorders(fstyle, "right");
                attrs = String.valueOf(attrs) + HTMLNorm.applyBorders(fstyle, "bottom");
                attrs = String.valueOf(attrs) + HTMLNorm.applyBorders(fstyle, "left");
            }
            if (el.getTagName().equals("img") || el.getTagName().equals("object") || el.getTagName().equals("applet") || el.getTagName().equals("iframe") || el.getTagName().equals("input")) {
                if (el.getAttributes().getNamedItem("align") != null) {
                    align = el.getAttribute("align");
                    if (align.equals("left")) {
                        attrs = String.valueOf(attrs) + "float:left;";
                    } else if (align.equals("right")) {
                        attrs = String.valueOf(attrs) + "float:right;";
                    }
                }
                if (el.getAttributes().getNamedItem("width") != null) {
                    width = el.getAttribute("width");
                    attrs = String.valueOf(attrs) + "width:" + width + "px;";
                }
                if (el.getAttributes().getNamedItem("height") != null) {
                    String height = el.getAttribute("height");
                    attrs = String.valueOf(attrs) + "height:" + height + "px;";
                }
            }
            if (el.getTagName().equals("input") && el.getAttributes().getNamedItem("size") != null) {
                width = el.getAttribute("size");
                attrs = String.valueOf(attrs) + "width:" + width + "px;";
            }
            if (el.getTagName().equals("div") && el.getAttributes().getNamedItem("align") != null && (align = el.getAttribute("align")).equalsIgnoreCase("center")) {
                System.out.println("Found center item");
                attrs = String.valueOf(attrs) + "margin-left:auto; margin-right:auto;text-align:center;";
            }
            if (el.getTagName().equals("col") || el.getTagName().equals("colgroup") || el.getTagName().equals("tbody") || el.getTagName().equals("td") || el.getTagName().equals("tfoot") || el.getTagName().equals("th") || el.getTagName().equals("thead") || el.getTagName().equals("tr")) {
                if (el.getAttributes().getNamedItem("align") != null) {
                    align = el.getAttribute("align");
                    if (align.equals("left")) {
                        attrs = String.valueOf(attrs) + "text-align:left;";
                    } else if (align.equals("right")) {
                        attrs = String.valueOf(attrs) + "text-align:right;";
                    } else if (align.equals("center")) {
                        attrs = String.valueOf(attrs) + "text-align:center;";
                    } else if (align.equals("justify")) {
                        attrs = String.valueOf(attrs) + "text-align:justify;";
                    }
                }
                if (el.getAttributes().getNamedItem("valign") != null) {
                    align = el.getAttribute("valign");
                    if (align.equals("top")) {
                        attrs = String.valueOf(attrs) + "vertical-align:top;";
                    } else if (align.equals("middle")) {
                        attrs = String.valueOf(attrs) + "vertical-align:middle;";
                    } else if (align.equals("bottom")) {
                        attrs = String.valueOf(attrs) + "vertical-align:bottom;";
                    } else if (align.equals("baseline")) {
                        attrs = String.valueOf(attrs) + "vertical-align:baseline;";
                    }
                }
            }
            if (el.getTagName().equals("font")) {
                if (el.getAttributes().getNamedItem("color") != null) {
                    attrs = String.valueOf(attrs) + "color: " + el.getAttribute("color") + ";";
                }
                if (el.getAttributes().getNamedItem("face") != null) {
                    attrs = String.valueOf(attrs) + "font-family: " + el.getAttribute("face") + ";";
                }
                if (el.getAttributes().getNamedItem("size") != null) {
                    String sn;
                    String sz = el.getAttribute("size");
                    String ret = "normal";
                    if (sz.equals("1")) {
                        ret = "xx-small";
                    } else if (sz.equals("2")) {
                        ret = "x-small";
                    } else if (sz.equals("3")) {
                        ret = "small";
                    } else if (sz.equals("4")) {
                        ret = "normal";
                    } else if (sz.equals("5")) {
                        ret = "large";
                    } else if (sz.equals("6")) {
                        ret = "x-large";
                    } else if (sz.equals("7")) {
                        ret = "xx-large";
                    } else if (sz.startsWith("+")) {
                        sn = sz.substring(1);
                        if (sn.equals("1")) {
                            ret = "120%";
                        } else if (sn.equals("2")) {
                            ret = "140%";
                        } else if (sn.equals("3")) {
                            ret = "160%";
                        } else if (sn.equals("4")) {
                            ret = "180%";
                        } else if (sn.equals("5")) {
                            ret = "200%";
                        } else if (sn.equals("6")) {
                            ret = "210%";
                        } else if (sn.equals("7")) {
                            ret = "220%";
                        }
                    } else if (sz.startsWith("-")) {
                        sn = sz.substring(1);
                        if (sn.equals("1")) {
                            ret = "90%";
                        } else if (sn.equals("2")) {
                            ret = "80%";
                        } else if (sn.equals("3")) {
                            ret = "70%";
                        } else if (sn.equals("4")) {
                            ret = "60%";
                        } else if (sn.equals("5")) {
                            ret = "50%";
                        } else if (sn.equals("6")) {
                            ret = "40%";
                        } else if (sn.equals("7")) {
                            ret = "30%";
                        }
                    }
                    attrs = String.valueOf(attrs) + "font-size: " + ret;
                }
            }
            if (attrs.length() > 0) {
                el.setAttribute("style", String.valueOf(el.getAttribute("style")) + ";" + attrs);
            }
        }
        NodeList child = n.getChildNodes();
        int i = 0;
        while (i < child.getLength()) {
            HTMLNorm.attributesToStyles(child.item(i), itab);
            ++i;
        }
    }

    public static int computeAttributeLength(String value, int whole) {
        try {
            if (value.endsWith("%")) {
                double val = Double.parseDouble(value.substring(0, value.length() - 1));
                return (int)Math.round(val * (double)whole / 100.0);
            }
            return (int)Math.rint(Double.parseDouble(value));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static TermLengthOrPercent createLengthOrPercent(String spec) {
        if ((spec = spec.trim()).endsWith("%")) {
            try {
                float val = Float.parseFloat(spec.substring(0, spec.length() - 1));
                TermPercent perc = CSSFactory.getTermFactory().createPercent(Float.valueOf(val));
                return perc;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        try {
            float val = Float.parseFloat(spec);
            TermLength len = CSSFactory.getTermFactory().createLength(Float.valueOf(val), TermNumeric.Unit.px);
            return len;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static String applyBorders(String template, String dir) {
        return template.replaceAll("@", dir);
    }

    public static void normalizeHTMLTree(Document doc) {
        NodeList tables = doc.getElementsByTagName("table");
        int i = 0;
        while (i < tables.getLength()) {
            Vector<Node> nodes = new Vector<Node>();
            HTMLNorm.recursiveFindBadNodesInTable(tables.item(i), null, nodes);
            for (Node n : nodes) {
                HTMLNorm.moveSubtreeBefore(n, tables.item(i));
            }
            ++i;
        }
    }

    private static void recursiveFindBadNodesInTable(Node n, Node cellroot, Vector<Node> nodes) {
        Node cell = cellroot;
        if (n.getNodeType() == 1) {
            String tag = n.getNodeName();
            if (tag.equalsIgnoreCase("table")) {
                if (cell != null) {
                    return;
                }
            } else if (!(tag.equalsIgnoreCase("tbody") || tag.equalsIgnoreCase("thead") || tag.equalsIgnoreCase("tfoot") || tag.equalsIgnoreCase("tr") || tag.equalsIgnoreCase("col") || tag.equalsIgnoreCase("colgroup"))) {
                if (tag.equalsIgnoreCase("td") || tag.equalsIgnoreCase("th") || tag.equalsIgnoreCase("caption")) {
                    cell = n;
                } else if (cell == null) {
                    nodes.add(n);
                    return;
                }
            }
        } else if (n.getNodeType() == 3 && cell == null && n.getNodeValue().trim().length() > 0) {
            nodes.add(n);
            return;
        }
        NodeList child = n.getChildNodes();
        int i = 0;
        while (i < child.getLength()) {
            HTMLNorm.recursiveFindBadNodesInTable(child.item(i), cell, nodes);
            ++i;
        }
    }

    private static void moveSubtreeBefore(Node root, Node ref) {
        ref.getParentNode().insertBefore(root, ref);
    }
}

