/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.css;

import java.io.PrintStream;
import org.fit.cssbox.css.Output;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NormalOutput
extends Output {
    public NormalOutput(Node root) {
        super(root);
    }

    public void dumpTo(PrintStream out) {
        this.recursiveDump(this.root, 0, out);
    }

    private void recursiveDump(Node n, int level, PrintStream p) {
        if (n.getNodeType() == 1) {
            String tag = "";
            Element el = (Element)n;
            if (el.getTagName().equals("style")) {
                return;
            }
            if (el.getTagName().equals("link") && (el.getAttribute("rel").equalsIgnoreCase("stylesheet") || el.getAttribute("type").equalsIgnoreCase("text/css"))) {
                return;
            }
            if (el.getTagName().equals("meta") && el.getAttribute("name").equals("generator")) {
                el.setAttribute("content", "CSS Transformer by Radek Burget, burgetr@fit.vutbr.cz");
            }
            tag = String.valueOf(tag) + "<" + el.getTagName();
            NamedNodeMap attrs = el.getAttributes();
            int i = 0;
            while (i < attrs.getLength()) {
                Node attr = attrs.item(i);
                tag = String.valueOf(tag) + " " + attr.getNodeName() + "=\"" + attr.getNodeValue() + "\"";
                ++i;
            }
            tag = String.valueOf(tag) + ">";
            p.print(tag);
        } else if (n.getNodeType() == 3) {
            p.print(n.getNodeValue());
        }
        NodeList child = n.getChildNodes();
        int i = 0;
        while (i < child.getLength()) {
            this.recursiveDump(child.item(i), level + 1, p);
            ++i;
        }
        if (n.getNodeType() == 1) {
            p.print("</" + n.getNodeName() + ">");
        }
    }

    private void recursiveDumpNice(Node n, int level, PrintStream p) {
        if (n.getNodeType() == 1) {
            String tag = "";
            Element el = (Element)n;
            if (el.getTagName().equals("style")) {
                return;
            }
            tag = String.valueOf(tag) + "<" + el.getTagName();
            NamedNodeMap attrs = el.getAttributes();
            int i = 0;
            while (i < attrs.getLength()) {
                Node attr = attrs.item(i);
                tag = String.valueOf(tag) + " " + attr.getNodeName() + "=\"" + attr.getNodeValue() + "\"";
                ++i;
            }
            tag = String.valueOf(tag) + ">";
            this.indent(level, p);
            p.println(tag);
        } else if (n.getNodeType() == 3) {
            this.indent(level, p);
            p.println(n.getNodeValue());
        }
        NodeList child = n.getChildNodes();
        int i = 0;
        while (i < child.getLength()) {
            this.recursiveDumpNice(child.item(i), level + 1, p);
            ++i;
        }
        if (n.getNodeType() == 1) {
            this.indent(level, p);
            p.println("</" + n.getNodeName() + ">");
        }
    }

    private void indent(int level, PrintStream p) {
        String ind = "";
        int i = 0;
        while (i < level * 4) {
            ind = String.valueOf(ind) + ' ';
            ++i;
        }
        p.print(ind);
    }
}

