/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.layout;

import cz.vutbr.web.css.CSSProperty;
import cz.vutbr.web.css.NodeData;
import cz.vutbr.web.css.TermLengthOrPercent;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Iterator;
import java.util.Vector;
import org.fit.cssbox.layout.BlockLayoutStatus;
import org.fit.cssbox.layout.Box;
import org.fit.cssbox.layout.CSSDecoder;
import org.fit.cssbox.layout.ElementBox;
import org.fit.cssbox.layout.FloatList;
import org.fit.cssbox.layout.Inline;
import org.fit.cssbox.layout.InlineBox;
import org.fit.cssbox.layout.LengthSet;
import org.fit.cssbox.layout.LineBox;
import org.fit.cssbox.layout.VisualContext;
import org.w3c.dom.Element;

public class BlockBox
extends InlineBox {
    public static final CSSProperty.Float FLOAT_NONE = CSSProperty.Float.NONE;
    public static final CSSProperty.Float FLOAT_LEFT = CSSProperty.Float.LEFT;
    public static final CSSProperty.Float FLOAT_RIGHT = CSSProperty.Float.RIGHT;
    public static final CSSProperty.Clear CLEAR_NONE = CSSProperty.Clear.NONE;
    public static final CSSProperty.Clear CLEAR_LEFT = CSSProperty.Clear.LEFT;
    public static final CSSProperty.Clear CLEAR_RIGHT = CSSProperty.Clear.RIGHT;
    public static final CSSProperty.Clear CLEAR_BOTH = CSSProperty.Clear.BOTH;
    public static final CSSProperty.Position POS_STATIC = CSSProperty.Position.STATIC;
    public static final CSSProperty.Position POS_RELATIVE = CSSProperty.Position.RELATIVE;
    public static final CSSProperty.Position POS_ABSOLUTE = CSSProperty.Position.ABSOLUTE;
    public static final CSSProperty.Position POS_FIXED = CSSProperty.Position.FIXED;
    public static final CSSProperty.TextAlign ALIGN_LEFT = CSSProperty.TextAlign.LEFT;
    public static final CSSProperty.TextAlign ALIGN_RIGHT = CSSProperty.TextAlign.RIGHT;
    public static final CSSProperty.TextAlign ALIGN_CENTER = CSSProperty.TextAlign.CENTER;
    public static final CSSProperty.TextAlign ALIGN_JUSTIFY = CSSProperty.TextAlign.JUSTIFY;
    public static final CSSProperty.Overflow OVERFLOW_VISIBLE = CSSProperty.Overflow.VISIBLE;
    public static final CSSProperty.Overflow OVERFLOW_HIDDEN = CSSProperty.Overflow.HIDDEN;
    public static final CSSProperty.Overflow OVERFLOW_SCROLL = CSSProperty.Overflow.SCROLL;
    public static final CSSProperty.Overflow OVERFLOW_AUTO = CSSProperty.Overflow.AUTO;
    protected static final int INFLOW_SPACE_THRESHOLD = 15;
    protected boolean contblock;
    protected boolean anyinflow;
    protected FloatList fleft;
    protected FloatList fright;
    protected FloatList fown;
    protected int floatXl;
    protected int floatXr;
    protected int floatY;
    protected Dimension min_size;
    protected Dimension max_size;
    protected boolean wset;
    protected boolean hset;
    protected boolean wrelative;
    protected int preferredWidth;
    protected int lastPreferredWidth;
    protected boolean widthComputed = false;
    protected LengthSet declMargin;
    protected CSSProperty.Float floating;
    protected CSSProperty.Clear clearing;
    protected CSSProperty.Position position;
    protected CSSProperty.Overflow overflow;
    protected LengthSet coords;
    protected boolean topset;
    protected boolean leftset;
    protected boolean bottomset;
    protected boolean rightset;
    protected boolean leftstatic;
    protected boolean topstatic;
    protected Box absReference;
    protected CSSProperty.TextAlign align;

    public BlockBox(Element n, Graphics2D g, VisualContext ctx) {
        super(n, g, ctx);
        this.isblock = true;
        this.contblock = false;
        this.anyinflow = false;
        this.fleft = null;
        this.fright = null;
        this.fown = null;
        this.floatXl = 0;
        this.floatXr = 0;
        this.floatY = 0;
        this.floating = FLOAT_NONE;
        this.clearing = CLEAR_NONE;
        this.position = POS_STATIC;
        this.overflow = OVERFLOW_VISIBLE;
        this.align = ALIGN_LEFT;
        this.topset = false;
        this.leftset = false;
        this.bottomset = false;
        this.rightset = false;
        this.topstatic = false;
        if (this.style != null) {
            this.loadBlockStyle();
        }
    }

    public BlockBox(InlineBox src) {
        super(src.el, src.g, src.ctx);
        this.setStyle(src.getStyle());
        this.viewport = src.viewport;
        this.cblock = src.cblock;
        this.clipblock = src.clipblock;
        this.isblock = true;
        this.contblock = false;
        this.anyinflow = false;
        this.style = src.style;
        this.fleft = null;
        this.fright = null;
        this.fown = null;
        this.floatXl = 0;
        this.floatXr = 0;
        this.floatY = 0;
        this.floating = FLOAT_NONE;
        this.clearing = CLEAR_NONE;
        this.position = POS_STATIC;
        this.overflow = OVERFLOW_VISIBLE;
        this.align = ALIGN_LEFT;
        this.topset = false;
        this.leftset = false;
        this.bottomset = false;
        this.rightset = false;
        this.topstatic = false;
        this.nested = src.nested;
        this.startChild = src.startChild;
        this.endChild = src.endChild;
        this.loadBlockStyle();
    }

    public void copyValues(BlockBox src) {
        super.copyValues(src);
        this.contblock = src.contblock;
        this.anyinflow = src.anyinflow;
        this.setFloats(src.fleft, src.fright, src.floatXl, src.floatXr, src.floatY);
        this.fown = src.fown;
        this.floating = src.floating;
        this.clearing = src.clearing;
        this.position = src.position;
        this.overflow = src.overflow;
        this.align = src.align;
        this.topset = src.topset;
        this.leftset = src.leftset;
        this.bottomset = src.bottomset;
        this.rightset = src.rightset;
        this.topstatic = src.topstatic;
        if (src.declMargin != null) {
            this.declMargin = new LengthSet(src.declMargin);
        }
    }

    public BlockBox copyBox() {
        BlockBox ret = new BlockBox(this.el, this.g, this.ctx);
        ret.copyValues(this);
        return ret;
    }

    public void initBox() {
        this.setFloats(new FloatList(this), new FloatList(this), 0, 0, 0);
    }

    public void addSubBox(Box box) {
        super.addSubBox(box);
        if (box.isInFlow()) {
            this.anyinflow = true;
            if (box.isBlock()) {
                this.contblock = true;
            }
        }
    }

    public void setStyle(NodeData s) {
        super.setStyle(s);
        this.loadBlockStyle();
    }

    public String toString() {
        return "<" + this.el.getTagName() + " id=\"" + this.el.getAttribute("id") + "\" class=\"" + this.el.getAttribute("class") + "\">";
    }

    public boolean containsBlocks() {
        return this.contblock;
    }

    public void setFloats(FloatList left, FloatList right, int xl, int xr, int y) {
        this.fleft = left;
        this.fright = right;
        this.floatXl = xl;
        this.floatXr = xr;
        this.floatY = y;
    }

    public void setOwnerFloatList(FloatList list) {
        this.fown = list;
    }

    public FloatList getOwnerFloatList() {
        return this.fown;
    }

    public CSSProperty.Float getFloating() {
        return this.floating;
    }

    public String getFloatingString() {
        return this.floating.toString();
    }

    public CSSProperty.Clear getClearing() {
        return this.clearing;
    }

    public String getClearingString() {
        return this.clearing.toString();
    }

    public String getPositionString() {
        return this.position.toString();
    }

    public String getOverflowString() {
        return this.overflow.toString();
    }

    public int getFloatY() {
        return this.floatY;
    }

    public boolean isInFlow() {
        return this.displayed && this.floating == FLOAT_NONE && this.position != POS_ABSOLUTE && this.position != POS_FIXED;
    }

    public boolean isPositioned() {
        return this.displayed && (this.position == POS_ABSOLUTE || this.position == POS_FIXED);
    }

    public boolean isFloating() {
        return this.displayed && this.floating != FLOAT_NONE;
    }

    public boolean containsFlow() {
        return this.anyinflow;
    }

    public boolean isWhitespace() {
        if (this.anyinflow) {
            return super.isWhitespace();
        }
        return true;
    }

    public boolean marginsAdjoin() {
        if (this.padding.top > 0 || this.padding.bottom > 0 || this.border.top > 0 || this.border.bottom > 0) {
            return false;
        }
        if (this.min_size.height > 0) {
            return false;
        }
        if (this.hset) {
            return this.content.height == 0;
        }
        if (!this.anyinflow) {
            return true;
        }
        int i = this.startChild;
        while (i < this.endChild) {
            Box box = this.getSubBox(i);
            if (box instanceof ElementBox ? !((ElementBox)box).marginsAdjoin() : !box.isWhitespace()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean affectsDisplay() {
        boolean ret = this.containsFlow();
        if (this.border.top > 0 || this.border.bottom > 0) {
            ret = true;
        }
        if (this.padding.top > 0 || this.padding.bottom > 0) {
            ret = true;
        }
        return ret;
    }

    public boolean canSplitInside() {
        return false;
    }

    public boolean canSplitBefore() {
        return true;
    }

    public boolean canSplitAfter() {
        return true;
    }

    public boolean startsWithWhitespace() {
        return false;
    }

    public boolean endsWithWhitespace() {
        return false;
    }

    public void setIgnoreInitialWhitespace(boolean b) {
    }

    public boolean canIncreaseWidth() {
        return false;
    }

    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    public Box getAbsReference() {
        return this.absReference;
    }

    public void setContentWidth(int width) {
        int w = width;
        if (this.max_size.width != -1 && w > this.max_size.width) {
            w = this.max_size.width;
        }
        if (this.min_size.width != -1 && w < this.min_size.width) {
            w = this.min_size.width;
        }
        this.content.width = w;
    }

    public void setContentHeight(int height) {
        int h = height;
        if (this.max_size.height != -1 && h > this.max_size.height) {
            h = this.max_size.height;
        }
        if (this.min_size.height != -1 && h < this.min_size.height) {
            h = this.min_size.height;
        }
        this.content.height = h;
    }

    public int totalHeight() {
        if (this.border.top == 0 && this.border.bottom == 0 && this.padding.top == 0 && this.padding.bottom == 0 && this.content.height == 0) {
            return Math.max(this.emargin.top, this.emargin.bottom);
        }
        return this.emargin.top + this.border.top + this.padding.top + this.content.height + this.padding.bottom + this.border.bottom + this.emargin.bottom;
    }

    public void moveDown(int ofs) {
        super.moveDown(ofs);
        if (this.isInFlow()) {
            this.moveFloatsDown(ofs);
        }
    }

    private void moveFloatsDown(int ofs) {
        this.floatY += ofs;
        int i = this.startChild;
        while (i < this.endChild) {
            Box box = this.getSubBox(i);
            if (box instanceof BlockBox) {
                BlockBox block = (BlockBox)box;
                if (block.isInFlow()) {
                    block.moveFloatsDown(ofs);
                } else if (block.getFloating() != FLOAT_NONE) {
                    block.moveDown(ofs);
                }
            }
            ++i;
        }
    }

    private void alignLineHorizontally(LineBox line) {
        int dif = this.content.width - line.getLimits() - line.getWidth();
        if (this.align != ALIGN_LEFT && dif > 0) {
            int i = line.getStart();
            while (i < line.getEnd()) {
                Box subbox = this.getSubBox(i);
                if (!subbox.isBlock()) {
                    if (this.align == ALIGN_RIGHT) {
                        subbox.moveRight(dif);
                    } else if (this.align == ALIGN_CENTER) {
                        subbox.moveRight(dif / 2);
                    }
                }
                ++i;
            }
        }
    }

    private void alignLineVertically(LineBox line) {
        int i = line.getStart();
        while (i < line.getEnd()) {
            Box subbox = this.getSubBox(i);
            if (!subbox.isBlock()) {
                int dif = line.alignBox((Inline)((Object)subbox));
                if (subbox instanceof ElementBox) {
                    dif -= ((ElementBox)subbox).getContentOffsetY();
                }
                if (subbox instanceof InlineBox) {
                    ((InlineBox)subbox).setLineBox(line);
                }
                int y = line.getY() + line.getLead() / 2 + dif;
                subbox.moveDown(y);
            }
            ++i;
        }
    }

    public void computeEfficientMargins() {
        this.emargin.top = this.margin.top;
        this.emargin.bottom = this.margin.bottom;
        if (this.containsBlocks() && this.containsFlow()) {
            BlockBox firstseparated = null;
            int mbottom = 0;
            int i = 0;
            while (i < this.getSubBoxNumber()) {
                BlockBox subbox = (BlockBox)this.getSubBox(i);
                if (subbox.isDisplayed() && subbox.isInFlow()) {
                    subbox.computeEfficientMargins();
                    boolean boxempty = subbox.marginsAdjoin();
                    if (firstseparated == null && !this.separatedFromTop(this) && subbox.emargin.top > this.emargin.top) {
                        this.emargin.top = subbox.emargin.top;
                    }
                    if (boxempty) {
                        if (subbox.emargin.bottom > mbottom) {
                            mbottom = subbox.emargin.bottom;
                        }
                    } else {
                        mbottom = subbox.emargin.bottom;
                    }
                    if (!boxempty && firstseparated == null) {
                        firstseparated = subbox;
                    }
                }
                ++i;
            }
            if (mbottom > this.emargin.bottom && !this.separatedFromBottom(this)) {
                this.emargin.bottom = mbottom;
            }
        }
        if (this.marginsAdjoin()) {
            this.emargin.top = this.emargin.bottom = Math.max(this.emargin.top, this.emargin.bottom);
        }
    }

    public boolean doLayout(int availw, boolean force, boolean linestart) {
        if (!this.displayed) {
            this.content.setSize(0, 0);
            this.bounds.setSize(0, 0);
            return true;
        }
        this.clearSplitted();
        if (!this.hasFixedWidth()) {
            int min = this.getMinimalContentWidthLimit();
            int max = this.getMaximalContentWidth();
            int pref = Math.min(max, availw);
            if (pref < min) {
                pref = min;
            }
            this.setContentWidth(pref);
            this.updateChildSizes();
        }
        this.widthComputed = true;
        this.setAvailableWidth(this.totalWidth());
        if (!this.contblock) {
            this.layoutInline();
        } else {
            this.layoutBlocks();
        }
        return true;
    }

    protected void layoutInline() {
        int x1 = this.fleft.getWidth(this.floatY) - this.floatXl;
        int x2 = this.fright.getWidth(this.floatY) - this.floatXr;
        if (x1 < 0) {
            x1 = 0;
        }
        if (x2 < 0) {
            x2 = 0;
        }
        int wlimit = this.getAvailableContentWidth();
        int minx1 = 0 - this.floatXl;
        int minx2 = 0 - this.floatXr;
        if (minx1 < 0) {
            minx1 = 0;
        }
        if (minx2 < 0) {
            minx2 = 0;
        }
        int x = x1;
        int y = 0;
        int maxw = 0;
        int prefw = 0;
        int lnstr = 0;
        int lastbreak = 0;
        boolean someinflow = false;
        boolean lastwhite = false;
        Vector<LineBox> lines = new Vector<LineBox>();
        LineBox curline = new LineBox(this, 0, 0);
        lines.add(curline);
        int i = 0;
        while (i < this.getSubBoxNumber()) {
            Box subbox = this.getSubBox(i);
            if (subbox.isBlock()) {
                boolean atstart;
                BlockBox sb = (BlockBox)subbox;
                BlockLayoutStatus stat = new BlockLayoutStatus();
                stat.inlineWidth = x - x1;
                stat.y = y;
                stat.maxh = 0;
                boolean bl = atstart = x <= x1;
                if (sb.getClearing() != CLEAR_NONE) {
                    int ny = stat.y;
                    if (sb.getClearing() == CLEAR_LEFT) {
                        ny = this.fleft.getMaxY() - this.floatY;
                    } else if (sb.getClearing() == CLEAR_RIGHT) {
                        ny = this.fright.getMaxY() - this.floatY;
                    } else if (sb.getClearing() == CLEAR_BOTH) {
                        ny = Math.max(this.fleft.getMaxY(), this.fright.getMaxY()) - this.floatY;
                    }
                    if (stat.y < ny) {
                        stat.y = ny;
                    }
                }
                if (sb.getFloating() == FLOAT_LEFT || sb.getFloating() == FLOAT_RIGHT) {
                    this.layoutBlockFloating(sb, wlimit, stat);
                    if (stat.inlineWidth > 0 && curline.getStart() < i) {
                        int j = curline.getStart();
                        while (j < i) {
                            Box child = this.getSubBox(j);
                            if (!child.isBlock()) {
                                child.moveRight(sb.getWidth());
                            }
                            ++j;
                        }
                        x += sb.getWidth();
                    }
                } else {
                    this.layoutBlockPositioned(sb, wlimit, stat);
                }
                if (stat.prefw > prefw) {
                    prefw = stat.prefw;
                }
                x1 = this.fleft.getWidth(y + this.floatY) - this.floatXl;
                x2 = this.fright.getWidth(y + this.floatY) - this.floatXr;
                if (x1 < 0) {
                    x1 = 0;
                }
                if (x2 < 0) {
                    x2 = 0;
                }
                if (atstart && x < x1) {
                    x = x1;
                }
            } else {
                boolean split;
                if (subbox.canSplitBefore()) {
                    lastbreak = i;
                }
                someinflow = true;
                do {
                    boolean f;
                    split = false;
                    int space = wlimit - x1 - x2;
                    boolean narrowed = x1 > minx1 || x2 > minx2;
                    boolean bl = f = (x == x1 || lastbreak == lnstr) && !narrowed;
                    if (lastwhite) {
                        subbox.setIgnoreInitialWhitespace(true);
                    }
                    boolean fit = false;
                    if (space >= 15 || !narrowed) {
                        fit = subbox.doLayout(wlimit - x - x2, f, x == x1);
                    }
                    if (fit) {
                        if (subbox.isInFlow()) {
                            subbox.setPosition(x, 0);
                            x += subbox.getWidth();
                        }
                        curline.considerBox((Inline)((Object)subbox));
                    }
                    if (!fit && narrowed && (x == x1 || lastbreak == lnstr)) {
                        if (x > maxw) {
                            maxw = x;
                        }
                        curline.setY(y += this.getLineHeight());
                        x1 = this.fleft.getWidth(y + this.floatY) - this.floatXl;
                        x2 = this.fright.getWidth(y + this.floatY) - this.floatXr;
                        if (x1 < 0) {
                            x1 = 0;
                        }
                        if (x2 < 0) {
                            x2 = 0;
                        }
                        x = x1;
                        split = true;
                    } else if ((!fit || x > wlimit - x2) && lastbreak > lnstr || fit && subbox.getRest() != null) {
                        curline.setWidth(x - x1);
                        curline.setLimits(x1, x2);
                        if (x > maxw) {
                            maxw = x;
                        }
                        x1 = this.fleft.getWidth((y += curline.getMaxLineHeight()) + this.floatY) - this.floatXl;
                        x2 = this.fright.getWidth(y + this.floatY) - this.floatXr;
                        if (x1 < 0) {
                            x1 = 0;
                        }
                        if (x2 < 0) {
                            x2 = 0;
                        }
                        x = x1;
                        if (!fit || x > wlimit - x2) {
                            lnstr = i;
                            curline.setEnd(lnstr);
                            curline = new LineBox(this, lnstr, y);
                            lines.add(curline);
                            split = true;
                        } else if (subbox.getRest() != null) {
                            this.insertSubBox(i + 1, subbox.getRest());
                            lnstr = i + 1;
                            curline.setEnd(lnstr);
                            curline = new LineBox(this, lnstr, y);
                            lines.add(curline);
                        }
                    }
                    boolean bl2 = lastwhite = subbox.collapsesSpaces() && subbox.endsWithWhitespace();
                } while (split);
                if (subbox.canSplitAfter()) {
                    lastbreak = i + 1;
                }
            }
            ++i;
        }
        if (someinflow) {
            if (x > maxw) {
                maxw = x;
            }
            if (maxw > prefw) {
                prefw = maxw;
            }
        }
        this.lastPreferredWidth = prefw;
        if (!this.hasFixedHeight()) {
            int mfy;
            if ((this.overflow != OVERFLOW_VISIBLE || this.floating != FLOAT_NONE || this.position == POS_ABSOLUTE || this.display == ElementBox.DISPLAY_INLINE_BLOCK) && (mfy = this.getFloatHeight() - this.floatY) > (y += curline.getMaxLineHeight())) {
                y = mfy;
            }
            this.setContentHeight(y);
            this.updateSizes();
            this.updateChildSizes();
        }
        this.setSize(this.totalWidth(), this.totalHeight());
        curline.setWidth(x);
        curline.setLimits(x1, x2);
        curline.setEnd(this.getSubBoxNumber());
        for (LineBox line : lines) {
            this.alignLineHorizontally(line);
            this.alignLineVertically(line);
        }
    }

    protected void layoutBlocks() {
        int wlimit = this.getAvailableContentWidth();
        BlockLayoutStatus stat = new BlockLayoutStatus();
        int mtop = 0;
        int mbottom = 0;
        int i = 0;
        while (i < this.getSubBoxNumber()) {
            int nexty = stat.y;
            BlockBox subbox = (BlockBox)this.getSubBox(i);
            if (subbox.isDisplayed()) {
                boolean clearance = false;
                if (subbox.getClearing() != CLEAR_NONE) {
                    int ny = stat.y;
                    if (subbox.getClearing() == CLEAR_LEFT) {
                        ny = this.fleft.getMaxY() - this.floatY;
                    } else if (subbox.getClearing() == CLEAR_RIGHT) {
                        ny = this.fright.getMaxY() - this.floatY;
                    } else if (subbox.getClearing() == CLEAR_BOTH) {
                        ny = Math.max(this.fleft.getMaxY(), this.fright.getMaxY()) - this.floatY;
                    }
                    if (stat.y < ny) {
                        stat.y = ny;
                        clearance = true;
                    }
                }
                if (subbox.isInFlow()) {
                    boolean boxempty = subbox.marginsAdjoin();
                    int borderY = stat.y;
                    if (stat.lastinflow != null) {
                        borderY -= stat.lastinflow.emargin.bottom;
                    }
                    if (subbox.emargin.top > mtop) {
                        mtop = subbox.emargin.top;
                    }
                    if (stat.firstseparated == null && this.separatedFromTop(this)) {
                        borderY += mtop;
                    }
                    if (stat.firstseparated != null) {
                        borderY = clearance ? (borderY += mtop + mbottom) : (borderY += Math.max(mtop, mbottom));
                    }
                    stat.lastinflow = subbox;
                    if (!boxempty && stat.firstseparated == null) {
                        stat.firstseparated = subbox;
                    }
                    if (!boxempty) {
                        stat.lastseparated = subbox;
                        mtop = 0;
                        mbottom = subbox.emargin.bottom;
                    }
                    if (stat.lastseparated != null && subbox.emargin.bottom > mbottom) {
                        mbottom = subbox.emargin.bottom;
                    }
                    stat.y = borderY - subbox.margin.top;
                    this.layoutBlockInFlow(subbox, wlimit, stat);
                    if (subbox.getRest() != null) {
                        this.insertSubBox(i + 1, subbox.getRest());
                    }
                    nexty = stat.y;
                } else if (subbox.getFloating() == FLOAT_LEFT || subbox.getFloating() == FLOAT_RIGHT) {
                    this.layoutBlockFloating(subbox, wlimit, stat);
                } else {
                    this.layoutBlockPositioned(subbox, wlimit, stat);
                }
                stat.y = nexty;
            }
            ++i;
        }
        if (!this.separatedFromBottom(this)) {
            stat.y -= mbottom;
        }
        if (!this.hasFixedHeight()) {
            int mfy;
            if ((this.overflow != OVERFLOW_VISIBLE || this.floating != FLOAT_NONE || this.position == POS_ABSOLUTE || this.display == ElementBox.DISPLAY_INLINE_BLOCK) && (mfy = this.getFloatHeight() - this.floatY) > stat.y) {
                stat.y = mfy;
            }
            this.setContentHeight(stat.y);
            this.updateSizes();
            this.updateChildSizes();
        }
        this.setSize(this.totalWidth(), this.totalHeight());
    }

    protected void layoutBlockInFlow(BlockBox subbox, int wlimit, BlockLayoutStatus stat) {
        int pref;
        int newfloatXl = this.floatXl + subbox.margin.left + subbox.border.left + subbox.padding.left;
        int newfloatXr = this.floatXr + subbox.margin.right + subbox.border.right + subbox.padding.right;
        int newfloatY = this.floatY + subbox.margin.top + subbox.border.top + subbox.padding.top;
        subbox.setFloats(this.fleft, this.fright, newfloatXl, newfloatXr, stat.y + newfloatY);
        subbox.setPosition(0, stat.y);
        subbox.doLayout(wlimit, true, true);
        stat.y += subbox.getHeight();
        if (subbox.getWidth() > stat.maxw) {
            stat.maxw = subbox.getWidth();
        }
        if ((pref = subbox.getPreferredWidth()) == -1) {
            pref = subbox.getMaximalWidth();
        }
        if (pref > stat.prefw) {
            stat.prefw = pref;
        }
    }

    protected void layoutBlockFloating(BlockBox subbox, int wlimit, BlockLayoutStatus stat) {
        int pref;
        int ofx;
        int fx;
        subbox.setFloats(new FloatList(subbox), new FloatList(subbox), 0, 0, 0);
        subbox.doLayout(wlimit, true, true);
        FloatList f = subbox.getFloating() == FLOAT_LEFT ? this.fleft : this.fright;
        FloatList of = subbox.getFloating() == FLOAT_LEFT ? this.fright : this.fleft;
        int floatX = subbox.getFloating() == FLOAT_LEFT ? this.floatXl : this.floatXr;
        int oFloatX = subbox.getFloating() == FLOAT_LEFT ? this.floatXr : this.floatXl;
        int fy = stat.y + this.floatY;
        if (fy < f.getLastY()) {
            fy = f.getLastY();
        }
        if ((fx = f.getWidth(fy)) < floatX) {
            fx = floatX;
        }
        if (fx == 0 && floatX < 0) {
            fx = floatX;
        }
        if ((ofx = of.getWidth(fy)) < oFloatX) {
            ofx = oFloatX;
        }
        if (ofx == 0 && oFloatX < 0) {
            ofx = oFloatX;
        }
        while ((fx > floatX || ofx > oFloatX || stat.inlineWidth > 0) && stat.inlineWidth + fx - floatX + ofx - oFloatX + subbox.getWidth() > wlimit) {
            int nexty1 = f.getNextY(fy);
            int nexty2 = of.getNextY(fy);
            fy = nexty1 != -1 && nexty2 != -1 ? Math.min(f.getNextY(fy), of.getNextY(fy)) : (nexty2 != -1 ? nexty2 : (nexty1 != -1 ? nexty1 : (fy += Math.max(stat.maxh, this.getLineHeight()))));
            fx = f.getWidth(fy);
            if (fx < floatX) {
                fx = floatX;
            }
            if (fx == 0 && floatX < 0) {
                fx = floatX;
            }
            if ((ofx = of.getWidth(fy)) < oFloatX) {
                ofx = oFloatX;
            }
            if (ofx == 0 && oFloatX < 0) {
                ofx = oFloatX;
            }
            stat.inlineWidth = 0;
        }
        subbox.setPosition(fx, fy);
        f.add(subbox);
        int floatw = this.maxFloatWidth(fy, fy + subbox.getHeight());
        if (floatw > stat.maxw) {
            stat.maxw = floatw;
        }
        if (stat.maxw > wlimit) {
            stat.maxw = wlimit;
        }
        if ((pref = subbox.getPreferredWidth()) == -1) {
            pref = wlimit;
        }
        if (pref > stat.prefw) {
            stat.prefw = pref;
        }
    }

    protected void layoutBlockPositioned(BlockBox subbox, int wlimit, BlockLayoutStatus stat) {
        subbox.setFloats(new FloatList(subbox), new FloatList(subbox), 0, 0, 0);
        subbox.doLayout(wlimit, true, true);
    }

    public void absolutePositions() {
        if (this.displayed) {
            BlockBox listowner;
            int x = this.cblock.getAbsoluteContentX() + this.bounds.x;
            int y = this.cblock.getAbsoluteContentY() + this.bounds.y;
            if (this.floating == FLOAT_NONE) {
                if (this.position == POS_RELATIVE) {
                    x += this.leftset ? this.coords.left : -this.coords.right;
                    y += this.topset ? this.coords.top : -this.coords.bottom;
                } else if (this.position == POS_ABSOLUTE || this.position == POS_FIXED) {
                    if (this.topstatic || this.leftstatic) {
                        this.updateStaticPosition();
                    }
                    x = this.cblock.getAbsoluteBackgroundBounds().x + this.coords.left;
                    y = this.cblock.getAbsoluteBackgroundBounds().y + this.coords.top;
                }
            } else if (this.floating == FLOAT_LEFT) {
                listowner = this.fown.getOwner();
                x = listowner.getAbsoluteContentX() + this.bounds.x;
                y = listowner.getAbsoluteContentY() + this.bounds.y;
            } else if (this.floating == FLOAT_RIGHT) {
                listowner = this.fown.getOwner();
                x = listowner.getAbsoluteContentX() + listowner.getContentWidth() - this.bounds.width - this.bounds.x - 2;
                y = listowner.getAbsoluteContentY() + this.bounds.y;
            }
            this.absbounds.x = x;
            this.absbounds.y = y;
            this.absbounds.width = this.bounds.width;
            this.absbounds.height = this.bounds.height;
            if (this.isDisplayed()) {
                if (this.clipblock == this.viewport) {
                    this.viewport.updateBoundsFor(this.absbounds);
                } else {
                    this.viewport.updateBoundsFor(this.getClippedBounds());
                }
                int i = this.startChild;
                while (i < this.endChild) {
                    this.getSubBox(i).absolutePositions();
                    ++i;
                }
            }
        }
    }

    private void updateStaticPosition() {
        if (this.absReference != null && this.cblock != null) {
            Rectangle ab = new Rectangle(this.absReference.getAbsoluteBounds());
            Rectangle cb = this.cblock.getAbsoluteBounds();
            ab.x -= cb.x;
            ab.y -= cb.y;
            if (this.topstatic) {
                this.coords.top = ab.y + ab.height - 1 - this.cblock.emargin.top - this.cblock.border.top;
            }
            if (this.leftstatic) {
                this.coords.left = ab.x - this.cblock.emargin.left - this.cblock.border.left;
            }
        } else {
            if (this.topstatic) {
                this.coords.top = this.cblock.padding.top;
            }
            if (this.leftstatic) {
                this.coords.left = this.cblock.padding.left;
            }
        }
    }

    public int getAvailableContentWidth() {
        int ret = this.availwidth - this.margin.left - this.border.left - this.padding.left - this.padding.right - this.border.right - this.margin.right;
        if (this.max_size.width != -1 && ret > this.max_size.width) {
            ret = this.max_size.width;
        }
        return ret;
    }

    public int getMinimalWidth() {
        int ret = 0;
        ret = this.wset && !this.wrelative ? this.content.width : this.getMinimalContentWidth();
        return ret += this.declMargin.left + this.padding.left + this.border.left + this.declMargin.right + this.padding.right + this.border.right;
    }

    protected int getMinimalContentWidth() {
        int ret = 0;
        int i = this.startChild;
        while (i < this.endChild) {
            int w;
            Box box = this.getSubBox(i);
            boolean affect = true;
            if (box instanceof BlockBox) {
                BlockBox block = (BlockBox)box;
                if (block.position == POS_ABSOLUTE || block.position == POS_FIXED) {
                    affect = false;
                }
            }
            if (affect && (w = box.getMinimalWidth()) > ret) {
                ret = w;
            }
            ++i;
        }
        return ret;
    }

    public int getMaximalWidth() {
        int ret = this.wset && !this.wrelative ? this.content.width : this.getMaximalContentWidth();
        return ret += this.declMargin.left + this.padding.left + this.border.left + this.declMargin.right + this.padding.right + this.border.right;
    }

    protected int getMaximalContentWidth() {
        int sum = 0;
        int max = 0;
        int i = this.startChild;
        while (i < this.endChild) {
            Box subbox = this.getSubBox(i);
            if (subbox.isBlock()) {
                BlockBox block = (BlockBox)subbox;
                if (block.getFloating() != FLOAT_NONE) {
                    sum += subbox.getMaximalWidth();
                } else if (block.isInFlow()) {
                    int sm = subbox.getMaximalWidth();
                    if (sm > max) {
                        max = sm;
                    }
                    if (sum > max) {
                        max = sum;
                    }
                    sum = 0;
                }
            } else {
                sum += subbox.getMaximalWidth();
            }
            ++i;
        }
        return Math.max(sum, max);
    }

    public int getMinimalContentWidthLimit() {
        int dif = this.declMargin.left + this.padding.left + this.border.left + this.declMargin.right + this.padding.right + this.border.right;
        int ret = this.wset ? this.content.width : (this.min_size.width != -1 ? this.min_size.width : (this.isInFlow() ? this.cblock.getMinimalContentWidthLimit() - dif : 0));
        return ret;
    }

    public boolean isRelative() {
        return this.wrelative;
    }

    public boolean hasFixedWidth() {
        return this.wset || this.isInFlow();
    }

    public boolean hasFixedHeight() {
        return this.hset;
    }

    public LengthSet getCoords() {
        return this.coords;
    }

    public int getFloatHeight() {
        if (this.fleft != null && this.fright != null) {
            int mfy = Math.max(this.fleft.getMaxYForOwner(this), this.fright.getMaxYForOwner(this));
            if (this.containsBlocks()) {
                int i = 0;
                while (i < this.getSubBoxNumber()) {
                    int cmfy;
                    Box subbox = this.getSubBox(i);
                    if (subbox instanceof BlockBox && (cmfy = ((BlockBox)subbox).getFloatHeight()) > mfy) {
                        mfy = cmfy;
                    }
                    ++i;
                }
            }
            return mfy;
        }
        return 0;
    }

    public void draw(Graphics2D g, int turn, int mode) {
        this.ctx.updateGraphics(g);
        if (this.isDisplayed() && this.isDeclaredVisible()) {
            Shape oldclip = g.getClip();
            g.setClip(this.clipblock.getAbsoluteContentBounds());
            int nestTurn = turn;
            switch (turn) {
                case 0: {
                    if (mode == 0 || mode == 2) {
                        this.drawBackground(g);
                    }
                    nestTurn = 0;
                    break;
                }
                case 1: {
                    if (this.floating != FLOAT_NONE) break;
                    if (mode == 0 || mode == 2) {
                        this.drawBackground(g);
                    }
                    nestTurn = 1;
                    break;
                }
                case 2: {
                    if (this.floating == FLOAT_NONE) break;
                    if (mode == 0 || mode == 2) {
                        this.drawBackground(g);
                    }
                    nestTurn = 0;
                }
            }
            if (this.node.getNodeType() == 1) {
                int i = this.startChild;
                while (i < this.endChild) {
                    this.getSubBox(i).draw(g, nestTurn, mode);
                    ++i;
                }
            }
            g.setClip(oldclip);
        }
    }

    protected void loadBlockStyle() {
        this.floating = (CSSProperty.Float)this.style.getProperty("float");
        if (this.floating == null) {
            this.floating = FLOAT_NONE;
        }
        this.clearing = (CSSProperty.Clear)this.style.getProperty("clear");
        if (this.clearing == null) {
            this.clearing = CLEAR_NONE;
        }
        this.position = (CSSProperty.Position)this.style.getProperty("position");
        if (this.position == null) {
            this.position = POS_STATIC;
        }
        this.overflow = (CSSProperty.Overflow)this.style.getProperty("overflow");
        if (this.overflow == null) {
            this.overflow = OVERFLOW_VISIBLE;
        }
        this.align = (CSSProperty.TextAlign)this.style.getProperty("text-align");
        if (this.align == null) {
            this.align = ALIGN_LEFT;
        }
        if (this.display == ElementBox.DISPLAY_NONE) {
            this.position = POS_STATIC;
            this.floating = FLOAT_NONE;
        } else if (this.position == POS_ABSOLUTE || this.position == POS_FIXED) {
            this.floating = FLOAT_NONE;
        }
    }

    protected void loadPosition() {
        CSSDecoder dec = new CSSDecoder(this.ctx);
        int contw = this.cblock.getContentWidth();
        int conth = this.cblock.getContentHeight();
        CSSProperty.Top ptop = (CSSProperty.Top)this.style.getProperty("top");
        CSSProperty.Right pright = (CSSProperty.Right)this.style.getProperty("right");
        CSSProperty.Bottom pbottom = (CSSProperty.Bottom)this.style.getProperty("bottom");
        CSSProperty.Left pleft = (CSSProperty.Left)this.style.getProperty("left");
        this.topset = ptop != null && ptop != CSSProperty.Top.AUTO;
        this.rightset = pright != null && pright != CSSProperty.Right.AUTO;
        this.bottomset = pbottom != null && pbottom != CSSProperty.Bottom.AUTO;
        this.leftset = pleft != null && pleft != CSSProperty.Left.AUTO;
        this.coords = new LengthSet();
        if (this.topset) {
            this.coords.top = dec.getLength(this.getLengthValue("top"), ptop == CSSProperty.Top.AUTO, 0, 0, conth);
        }
        if (this.rightset) {
            this.coords.right = dec.getLength(this.getLengthValue("right"), pright == CSSProperty.Right.AUTO, 0, 0, contw);
        }
        if (this.bottomset) {
            this.coords.bottom = dec.getLength(this.getLengthValue("bottom"), pbottom == CSSProperty.Bottom.AUTO, 0, 0, conth);
        }
        if (this.leftset) {
            this.coords.left = dec.getLength(this.getLengthValue("left"), pleft == CSSProperty.Left.AUTO, 0, 0, contw);
        }
    }

    protected int blockWidth() {
        return this.content.width;
    }

    protected int blockHeight() {
        return this.content.height;
    }

    protected int maxFloatWidth(int y1, int y2) {
        int ret = 0;
        int y = y1;
        while (y <= y2) {
            int w = this.fleft.getWidth(y) + this.fright.getWidth(y);
            if (w > ret) {
                ret = w;
            }
            ++y;
        }
        return ret;
    }

    protected void loadSizes() {
        this.loadSizes(false);
    }

    public void updateSizes() {
        this.loadSizes(true);
    }

    protected void loadSizes(boolean update) {
        CSSDecoder dec = new CSSDecoder(this.ctx);
        if (this.cblock == null) {
            System.err.println(String.valueOf(this.toString()) + " has no cblock");
            return;
        }
        int contw = this.cblock.getContentWidth();
        int conth = this.cblock.getContentHeight();
        if (!update) {
            this.loadBorders(dec, contw);
        }
        this.loadPadding(dec, contw);
        this.loadPosition();
        if (!update) {
            this.content = new Dimension(0, 0);
            this.margin = new LengthSet();
            this.declMargin = new LengthSet();
        }
        this.loadWidthsHeights(dec, contw, conth, update);
        if (!update) {
            this.emargin = new LengthSet(this.margin);
        }
    }

    protected void loadPadding(CSSDecoder dec, int contw) {
        this.padding = new LengthSet();
        this.padding.top = dec.getLength(this.getLengthValue("padding-top"), false, null, null, contw);
        this.padding.right = dec.getLength(this.getLengthValue("padding-right"), false, null, null, contw);
        this.padding.bottom = dec.getLength(this.getLengthValue("padding-bottom"), false, null, null, contw);
        this.padding.left = dec.getLength(this.getLengthValue("padding-left"), false, null, null, contw);
    }

    protected void loadWidthsHeights(CSSDecoder dec, int contw, int conth, boolean update) {
        this.min_size = new Dimension(dec.getLength(this.getLengthValue("min-width"), false, -1, -1, contw), dec.getLength(this.getLengthValue("min-height"), false, -1, -1, conth));
        this.max_size = new Dimension(dec.getLength(this.getLengthValue("max-width"), false, -1, -1, contw), dec.getLength(this.getLengthValue("max-height"), false, -1, -1, conth));
        if (this.max_size.width != -1 && this.max_size.width < this.min_size.width) {
            this.max_size.width = this.min_size.width;
        }
        if (this.max_size.height != -1 && this.max_size.height < this.min_size.height) {
            this.max_size.height = this.min_size.height;
        }
        TermLengthOrPercent width = this.getLengthValue("width");
        this.computeWidths(width, this.style.getProperty("width") == CSSProperty.Width.AUTO, true, this.cblock, update);
        if (this.max_size.width != -1 && this.content.width > this.max_size.width) {
            width = this.getLengthValue("max-width");
            this.computeWidths(width, false, false, this.cblock, update);
        }
        if (this.min_size.width != -1 && this.content.width < this.min_size.width) {
            width = this.getLengthValue("min-width");
            this.computeWidths(width, false, false, this.cblock, update);
        }
        TermLengthOrPercent height = this.getLengthValue("height");
        this.computeHeights(height, this.style.getProperty("height") == CSSProperty.Height.AUTO, true, this.cblock, update);
        if (this.max_size.height != -1 && this.content.height > this.max_size.height) {
            height = this.getLengthValue("max-height");
            this.computeHeights(height, false, false, this.cblock, update);
        }
        if (this.min_size.height != -1 && this.content.height < this.min_size.height) {
            height = this.getLengthValue("min-height");
            this.computeHeights(height, false, false, this.cblock, update);
        }
    }

    protected void computeWidths(TermLengthOrPercent width, boolean auto, boolean exact, BlockBox cblock, boolean update) {
        if (this.position == POS_ABSOLUTE) {
            this.computeWidthsAbsolute(width, auto, exact, cblock.getContentWidth() + cblock.padding.left + cblock.padding.right, update);
        } else {
            this.computeWidthsInFlow(width, auto, exact, cblock.getContentWidth(), update);
        }
    }

    protected void computeWidthsInFlow(TermLengthOrPercent width, boolean auto, boolean exact, int contw, boolean update) {
        CSSDecoder dec = new CSSDecoder(this.ctx);
        if (width == null) {
            auto = true;
        }
        boolean mleftauto = this.style.getProperty("margin-left") == CSSProperty.Margin.AUTO;
        TermLengthOrPercent mleft = this.getLengthValue("margin-left");
        boolean mrightauto = this.style.getProperty("margin-right") == CSSProperty.Margin.AUTO;
        TermLengthOrPercent mright = this.getLengthValue("margin-right");
        this.preferredWidth = -1;
        if (!this.widthComputed) {
            update = false;
        }
        if (auto) {
            if (exact) {
                this.wset = false;
            }
            this.margin.left = dec.getLength(mleft, mleftauto, 0, 0, contw);
            this.margin.right = dec.getLength(mright, mrightauto, 0, 0, contw);
            this.declMargin.left = this.margin.left;
            this.declMargin.right = this.margin.right;
            if (!update || this.isInFlow()) {
                this.content.width = contw - this.margin.left - this.border.left - this.padding.left - this.padding.right - this.border.right - this.margin.right;
                if (this.content.width < 0) {
                    this.content.width = 0;
                }
            }
            this.preferredWidth = -1;
        } else {
            int prefmr;
            if (exact) {
                this.wset = true;
                this.wrelative = width.isPercentage();
            }
            this.content.width = dec.getLength(width, auto, 0, 0, contw);
            this.margin.left = dec.getLength(mleft, mleftauto, 0, 0, contw);
            this.margin.right = dec.getLength(mright, mrightauto, 0, 0, contw);
            this.declMargin.left = this.margin.left;
            this.declMargin.right = this.margin.right;
            boolean prefer = !width.isPercentage();
            int prefml = mleft == null || mleft.isPercentage() || mleftauto ? 0 : this.margin.left;
            int n = prefmr = mright == null || mright.isPercentage() || mrightauto ? 0 : this.margin.right;
            if (prefer) {
                this.preferredWidth = prefml + this.border.left + this.padding.left + this.content.width + this.padding.right + this.border.right + prefmr;
            }
            if (this.isInFlow() && prefer) {
                if (mleftauto && mrightauto) {
                    int rest = contw - this.content.width - this.border.left - this.padding.left - this.padding.right - this.border.right;
                    if (rest < 0) {
                        rest = 0;
                    }
                    this.margin.left = (rest + 1) / 2;
                    this.margin.right = rest / 2;
                } else if (mleftauto) {
                    this.margin.left = contw - this.content.width - this.border.left - this.padding.left - this.padding.right - this.border.right - this.margin.right;
                } else if (mrightauto) {
                    this.margin.right = contw - this.content.width - this.border.left - this.padding.left - this.padding.right - this.border.right - this.margin.left;
                    if (this.margin.right < 0 && this.cblock.canIncreaseWidth()) {
                        this.margin.right = 0;
                    }
                } else {
                    this.margin.right = contw - this.content.width - this.border.left - this.padding.left - this.padding.right - this.border.right - this.margin.left;
                    if (this.margin.right < 0 && this.cblock.canIncreaseWidth()) {
                        this.margin.right = 0;
                    }
                }
            }
        }
    }

    protected void computeWidthsAbsolute(TermLengthOrPercent width, boolean auto, boolean exact, int contw, boolean update) {
        CSSDecoder dec = new CSSDecoder(this.ctx);
        if (width == null) {
            auto = true;
        }
        boolean mleftauto = this.style.getProperty("margin-left") == CSSProperty.Margin.AUTO;
        TermLengthOrPercent mleft = this.getLengthValue("margin-left");
        boolean mrightauto = this.style.getProperty("margin-right") == CSSProperty.Margin.AUTO;
        TermLengthOrPercent mright = this.getLengthValue("margin-right");
        this.preferredWidth = -1;
        if (!this.widthComputed) {
            update = false;
        }
        if (this.cblock != null && this.cblock.wset) {
            boolean bl = this.wset = exact && !auto && width != null;
            if (!update) {
                this.content.width = dec.getLength(width, auto, 0, 0, contw);
            }
        } else {
            boolean bl = this.wset = exact && !auto && width != null && !width.isPercentage();
            if (!update) {
                this.content.width = dec.getLength(width, auto, 0, 0, 0);
            }
        }
        int constr = 0;
        if (this.wset) {
            ++constr;
        }
        if (this.leftset) {
            ++constr;
        }
        if (this.rightset) {
            ++constr;
        }
        if (constr < 3) {
            this.margin.left = mleftauto ? 0 : dec.getLength(mleft, false, 0, 0, contw);
            this.margin.right = mrightauto ? 0 : dec.getLength(mright, false, 0, 0, contw);
        } else if (mleftauto && mrightauto) {
            int rest = contw - this.coords.left - this.coords.right - this.border.left - this.border.right - this.padding.left - this.padding.right - this.content.width;
            this.margin.left = (rest + 1) / 2;
            this.margin.right = rest / 2;
        } else if (mleftauto) {
            this.margin.right = dec.getLength(mright, false, 0, 0, contw);
            this.margin.left = contw - this.coords.right - this.border.left - this.border.right - this.padding.left - this.padding.right - this.content.width - this.margin.right;
        } else if (mrightauto) {
            this.margin.left = dec.getLength(mright, false, 0, 0, contw);
            this.margin.right = contw - this.coords.right - this.border.left - this.border.right - this.padding.left - this.padding.right - this.content.width - this.margin.left;
        } else {
            this.margin.left = dec.getLength(mleft, false, 0, 0, contw);
            this.margin.right = dec.getLength(mright, false, 0, 0, contw);
        }
        this.declMargin.left = this.margin.left;
        this.declMargin.right = this.margin.right;
        if (!this.leftset && !this.rightset) {
            this.leftstatic = true;
            this.coords.right = contw - this.coords.left - this.border.left - this.border.right - this.padding.left - this.padding.right - this.content.width - this.margin.left - this.margin.right;
        } else if (!this.leftset) {
            this.coords.left = contw - this.coords.right - this.border.left - this.border.right - this.padding.left - this.padding.right - this.content.width - this.margin.left - this.margin.right;
        } else if (!this.rightset) {
            this.coords.right = contw - this.coords.left - this.border.left - this.border.right - this.padding.left - this.padding.right - this.content.width - this.margin.left - this.margin.right;
        } else if (auto) {
            this.content.width = contw - this.coords.left - this.coords.right - this.border.left - this.border.right - this.padding.left - this.padding.right - this.margin.left - this.margin.right;
        } else {
            this.coords.right = contw - this.coords.left - this.border.left - this.border.right - this.padding.left - this.padding.right - this.content.width - this.margin.left - this.margin.right;
        }
    }

    protected void computeHeights(TermLengthOrPercent height, boolean auto, boolean exact, BlockBox cblock, boolean update) {
        if (this.position == POS_ABSOLUTE) {
            int contw = cblock.getContentWidth() + cblock.padding.left + cblock.padding.right;
            int conth = cblock.getContentHeight() + cblock.padding.top + cblock.padding.bottom;
            this.computeHeightsAbsolute(height, auto, exact, contw, conth, update);
        } else {
            this.computeHeightsInFlow(height, auto, exact, cblock.getContentWidth(), cblock.getContentHeight(), update);
        }
        this.declMargin.top = this.margin.top;
        this.declMargin.bottom = this.margin.bottom;
    }

    protected void computeHeightsInFlow(TermLengthOrPercent height, boolean auto, boolean exact, int contw, int conth, boolean update) {
        CSSDecoder dec = new CSSDecoder(this.ctx);
        if (height == null) {
            auto = true;
        }
        boolean mtopauto = this.style.getProperty("margin-top") == CSSProperty.Margin.AUTO;
        TermLengthOrPercent mtop = this.getLengthValue("margin-top");
        boolean mbottomauto = this.style.getProperty("margin-bottom") == CSSProperty.Margin.AUTO;
        TermLengthOrPercent mbottom = this.getLengthValue("margin-bottom");
        if (this.cblock != null && this.cblock.hset) {
            boolean bl = this.hset = exact && !auto && height != null;
            if (!update) {
                this.content.height = dec.getLength(height, auto, 0, 0, conth);
            }
        } else {
            boolean bl = this.hset = exact && !auto && height != null && !height.isPercentage();
            if (!update) {
                this.content.height = dec.getLength(height, auto, 0, 0, 0);
            }
        }
        this.margin.top = mtopauto ? 0 : dec.getLength(mtop, false, 0, 0, contw);
        this.margin.bottom = mbottomauto ? 0 : dec.getLength(mbottom, false, 0, 0, contw);
    }

    protected void computeHeightsAbsolute(TermLengthOrPercent height, boolean auto, boolean exact, int contw, int conth, boolean update) {
        CSSDecoder dec = new CSSDecoder(this.ctx);
        if (height == null) {
            auto = true;
        }
        boolean mtopauto = this.style.getProperty("margin-top") == CSSProperty.Margin.AUTO;
        TermLengthOrPercent mtop = this.getLengthValue("margin-top");
        boolean mbottomauto = this.style.getProperty("margin-bottom") == CSSProperty.Margin.AUTO;
        TermLengthOrPercent mbottom = this.getLengthValue("margin-bottom");
        if (this.cblock != null && this.cblock.hset) {
            boolean bl = this.hset = exact && !auto && height != null;
            if (!update) {
                this.content.height = dec.getLength(height, auto, 0, 0, conth);
            }
        } else {
            boolean bl = this.hset = exact && !auto && height != null && !height.isPercentage();
            if (!update) {
                this.content.height = dec.getLength(height, auto, 0, 0, 0);
            }
        }
        int constr = 0;
        if (this.hset) {
            ++constr;
        }
        if (this.topset) {
            ++constr;
        }
        if (this.bottomset) {
            ++constr;
        }
        if (constr < 3) {
            this.margin.top = mtopauto ? 0 : dec.getLength(mtop, false, 0, 0, contw);
            this.margin.bottom = mbottomauto ? 0 : dec.getLength(mbottom, false, 0, 0, contw);
        } else if (mtopauto && mbottomauto) {
            int rest = conth - this.coords.top - this.coords.bottom - this.border.top - this.border.bottom - this.padding.top - this.padding.bottom - this.content.height;
            this.margin.top = (rest + 1) / 2;
            this.margin.bottom = rest / 2;
        } else if (mtopauto) {
            this.margin.bottom = dec.getLength(mbottom, false, 0, 0, contw);
            this.margin.top = conth - this.coords.top - this.coords.bottom - this.border.top - this.border.bottom - this.padding.top - this.padding.bottom - this.content.height - this.margin.bottom;
        } else if (mbottomauto) {
            this.margin.top = dec.getLength(mtop, false, 0, 0, contw);
            this.margin.bottom = conth - this.coords.top - this.coords.bottom - this.border.top - this.border.bottom - this.padding.top - this.padding.bottom - this.content.height - this.margin.top;
        } else {
            this.margin.top = dec.getLength(mtop, false, 0, 0, contw);
            this.margin.bottom = dec.getLength(mbottom, false, 0, 0, contw);
        }
        if (!this.topset && !this.bottomset) {
            this.topstatic = true;
            this.coords.bottom = conth - this.coords.top - this.border.top - this.border.bottom - this.padding.top - this.padding.bottom - this.margin.top - this.margin.bottom - this.content.height;
        } else if (!this.topset) {
            this.coords.top = conth - this.coords.bottom - this.border.top - this.border.bottom - this.padding.top - this.padding.bottom - this.margin.top - this.margin.bottom - this.content.height;
        } else if (!this.bottomset) {
            this.coords.bottom = conth - this.coords.top - this.border.top - this.border.bottom - this.padding.top - this.padding.bottom - this.margin.top - this.margin.bottom - this.content.height;
        } else if (auto) {
            this.content.height = conth - this.coords.top - this.coords.bottom - this.border.top - this.border.bottom - this.padding.top - this.padding.bottom - this.margin.top - this.margin.bottom;
        } else {
            this.coords.bottom = conth - this.coords.top - this.border.top - this.border.bottom - this.padding.top - this.padding.bottom - this.margin.top - this.margin.bottom - this.content.height;
        }
    }

    public void updateChildSizes() {
        int i = 0;
        while (i < this.getSubBoxNumber()) {
            Box child = this.getSubBox(i);
            if (child instanceof BlockBox) {
                BlockBox block = (BlockBox)child;
                int oldw = block.getContentWidth();
                int oldh = block.getContentHeight();
                block.updateSizes();
                block.setSize(block.totalWidth(), block.totalHeight());
                if (block.getContentWidth() != oldw || block.getContentHeight() != oldh) {
                    block.updateChildSizes();
                }
            }
            ++i;
        }
    }

    private boolean separatedFromTop(ElementBox box) {
        return box.border.top > 0 || box.padding.top > 0;
    }

    private boolean separatedFromBottom(ElementBox box) {
        return box.border.bottom > 0 || box.padding.bottom > 0;
    }

    private void clearSplitted() {
        Iterator it = this.nested.iterator();
        while (it.hasNext()) {
            Box box = (Box)it.next();
            if (!box.splitted) continue;
            it.remove();
            --this.endChild;
        }
    }
}

