/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.layout;

import cz.vutbr.web.css.CSSFactory;
import cz.vutbr.web.css.CSSProperty;
import cz.vutbr.web.css.TermLengthOrPercent;
import cz.vutbr.web.css.TermNumeric;
import java.awt.Graphics2D;
import java.util.Iterator;
import org.fit.cssbox.layout.BlockBox;
import org.fit.cssbox.layout.BlockLayoutStatus;
import org.fit.cssbox.layout.Box;
import org.fit.cssbox.layout.CSSDecoder;
import org.fit.cssbox.layout.InlineBox;
import org.fit.cssbox.layout.LengthSet;
import org.fit.cssbox.layout.TableBox;
import org.fit.cssbox.layout.TableCaptionBox;
import org.fit.cssbox.layout.VisualContext;
import org.w3c.dom.Element;

public class BlockTableBox
extends BlockBox {
    private TableBox table;
    private TableCaptionBox caption;
    private boolean captionbottom;

    public BlockTableBox(Element n, Graphics2D g, VisualContext ctx) {
        super(n, g, ctx);
        this.isblock = true;
    }

    public BlockTableBox(InlineBox src) {
        super(src);
        this.isblock = true;
    }

    public TableCaptionBox getCaption() {
        return this.caption;
    }

    public void setCaption(TableCaptionBox caption) {
        this.caption = caption;
    }

    public TableBox getTable() {
        return this.table;
    }

    public void setTable(TableBox table) {
        this.table = table;
    }

    public void initBox() {
        this.organizeContent();
        this.loadCaptionStyle();
    }

    public boolean canIncreaseWidth() {
        return true;
    }

    public boolean doLayout(int availw, boolean force, boolean linestart) {
        this.setAvailableWidth(availw);
        int x1 = this.fleft.getWidth(this.floatY) - this.floatXl;
        int x2 = this.fright.getWidth(this.floatY) - this.floatXr;
        if (x1 < 0) {
            x1 = 0;
        }
        if (x2 < 0) {
            x2 = 0;
        }
        int wlimit = this.getAvailableContentWidth() - x1 - x2;
        int tabwidth = 0;
        int tabheight = 0;
        int capheight = 0;
        int capwidth = 0;
        BlockLayoutStatus stat = new BlockLayoutStatus();
        this.table.setAvailableWidth(wlimit);
        this.table.updateSizes();
        this.layoutBlockInFlow(this.table, wlimit, stat);
        tabwidth = stat.maxw;
        tabheight = stat.y;
        if (this.caption != null) {
            stat.y = 0;
            this.caption.setAvailableWidth(stat.maxw);
            this.caption.updateSizes();
            this.layoutBlockInFlow(this.caption, stat.maxw, stat);
            capwidth = stat.maxw;
            capheight = stat.y;
            if (this.captionbottom) {
                this.table.setPosition(x1, 0);
                this.caption.setPosition(x1, tabheight);
            } else {
                this.caption.setPosition(x1, 0);
                this.table.setPosition(x1, capheight);
            }
        } else {
            this.table.setPosition(x1, 0);
        }
        this.setContentWidth(Math.max(tabwidth, capwidth));
        this.setContentHeight(tabheight + capheight);
        this.widthComputed = true;
        this.updateSizes();
        this.setSize(this.totalWidth(), this.totalHeight());
        return true;
    }

    protected int getMaximalContentWidth() {
        if (this.caption == null) {
            return this.table.getMaximalContentWidth();
        }
        return Math.max(this.table.getMaximalContentWidth(), this.caption.getMaximalContentWidth());
    }

    protected int getMinimalContentWidth() {
        if (this.caption == null) {
            return this.table.getMinimalContentWidth();
        }
        return Math.max(this.table.getMinimalContentWidth(), this.caption.getMinimalContentWidth());
    }

    protected void loadBackground() {
        this.bgcolor = null;
    }

    protected void loadBorders(CSSDecoder dec, int contw) {
        this.border = new LengthSet();
    }

    protected void loadPadding(CSSDecoder dec, int contw) {
        this.padding = new LengthSet();
    }

    protected void computeWidths(TermLengthOrPercent width, boolean auto, boolean exact, BlockBox cblock, boolean update) {
        if (!this.widthComputed) {
            super.computeWidths(null, true, exact, cblock, update);
        } else {
            super.computeWidths(CSSFactory.getTermFactory().createLength(Float.valueOf(this.content.width), TermNumeric.Unit.px), false, exact, cblock, update);
        }
    }

    protected void loadCaptionStyle() {
        CSSProperty.CaptionSide side = (CSSProperty.CaptionSide)this.style.getProperty("caption-side");
        this.captionbottom = side == CSSProperty.CaptionSide.BOTTOM;
    }

    private void organizeContent() {
        this.table = new TableBox(this.el, this.g, this.ctx);
        this.table.setStyle(this.style);
        this.table.adoptParent(this);
        Iterator it = this.nested.iterator();
        while (it.hasNext()) {
            Box box = (Box)it.next();
            if (box instanceof TableCaptionBox) {
                this.caption = (TableCaptionBox)box;
                continue;
            }
            this.table.addSubBox(box);
            box.setContainingBlock(this.table);
            box.setParent(this.table);
            it.remove();
            --this.endChild;
        }
        this.addSubBox(this.table);
    }
}

