/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.layout;

import cz.vutbr.web.css.CSSFactory;
import cz.vutbr.web.css.CSSProperty;
import cz.vutbr.web.css.Declaration;
import cz.vutbr.web.css.NodeData;
import cz.vutbr.web.css.Selector;
import cz.vutbr.web.css.Term;
import cz.vutbr.web.css.TermFunction;
import cz.vutbr.web.css.TermIdent;
import cz.vutbr.web.css.TermList;
import cz.vutbr.web.css.TermString;
import cz.vutbr.web.css.TermURI;
import java.awt.Graphics2D;
import java.net.URL;
import java.util.ListIterator;
import java.util.Vector;
import org.fit.cssbox.css.DOMAnalyzer;
import org.fit.cssbox.layout.BlockBox;
import org.fit.cssbox.layout.BlockReplacedBox;
import org.fit.cssbox.layout.BlockTableBox;
import org.fit.cssbox.layout.Box;
import org.fit.cssbox.layout.BoxTreeCreationStatus;
import org.fit.cssbox.layout.ElementBox;
import org.fit.cssbox.layout.InlineBox;
import org.fit.cssbox.layout.InlineReplacedBox;
import org.fit.cssbox.layout.ListItemBox;
import org.fit.cssbox.layout.ReplacedImage;
import org.fit.cssbox.layout.TableBodyBox;
import org.fit.cssbox.layout.TableCaptionBox;
import org.fit.cssbox.layout.TableCellBox;
import org.fit.cssbox.layout.TableColumn;
import org.fit.cssbox.layout.TableColumnGroup;
import org.fit.cssbox.layout.TableRowBox;
import org.fit.cssbox.layout.TextBox;
import org.fit.cssbox.layout.Viewport;
import org.fit.cssbox.layout.VisualContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class BoxFactory {
    private static BoxFactory instance = null;
    private boolean useHTML = true;
    protected DOMAnalyzer decoder;
    protected URL baseurl;
    protected Viewport viewport;
    protected int next_order;

    public BoxFactory(DOMAnalyzer decoder, URL baseurl) {
        this.decoder = decoder;
        this.baseurl = baseurl;
        this.next_order = 0;
        instance = this;
    }

    public static BoxFactory getInstance() {
        return instance;
    }

    public void setUseHTML(boolean useHTML) {
        this.useHTML = useHTML;
    }

    public boolean getUseHTML() {
        return this.useHTML;
    }

    public void reset() {
        this.next_order = 0;
    }

    public Viewport createViewportTree(Element root, Graphics2D g, VisualContext ctx, int width, int height) {
        Element vp = this.createAnonymousElement(root.getOwnerDocument(), "Xdiv", "block");
        this.viewport = new Viewport(vp, g, ctx, this, root, width, height);
        BoxTreeCreationStatus stat = new BoxTreeCreationStatus(this.viewport);
        this.createSubtree(root, stat);
        System.out.println("Root box is: " + this.viewport.getRootBox());
        return this.viewport;
    }

    public void createBoxTree(BoxTreeCreationStatus stat) {
        boolean generated = false;
        do {
            if (stat.parent.isDisplayed()) {
                Node n;
                Node n2;
                if (stat.parent.preadd != null) {
                    this.addToTree(stat.parent.preadd, stat);
                }
                if (stat.parent.previousTwin == null && (n2 = this.createPseudoElement(stat.parent, Selector.PseudoDeclaration.BEFORE)) != null && (n2.getNodeType() == 1 || n2.getNodeType() == 3)) {
                    stat.curchild = -1;
                    this.createSubtree(n2, stat);
                }
                NodeList children = stat.parent.getElement().getChildNodes();
                int child = stat.parent.firstDOMChild;
                while (child < stat.parent.lastDOMChild) {
                    Node n3 = children.item(child);
                    if (n3.getNodeType() == 1 || n3.getNodeType() == 3) {
                        stat.curchild = child;
                        this.createSubtree(n3, stat);
                    }
                    ++child;
                }
                if (stat.parent.nextTwin == null && (n = this.createPseudoElement(stat.parent, Selector.PseudoDeclaration.AFTER)) != null && (n.getNodeType() == 1 || n.getNodeType() == 3)) {
                    stat.curchild = children.getLength();
                    this.createSubtree(n, stat);
                }
                this.normalizeBox(stat.parent);
            }
            if (stat.parent.nextTwin != null) {
                stat.parent = stat.parent.nextTwin;
                generated = true;
                continue;
            }
            generated = false;
        } while (generated);
    }

    private void createSubtree(Node n, BoxTreeCreationStatus stat) {
        Box newbox;
        stat.parent.curstat = new BoxTreeCreationStatus(stat);
        boolean istext = false;
        if (n.getNodeType() == 3) {
            newbox = this.createTextBox((Text)n, stat);
            istext = true;
        } else {
            System.out.println(n.toString());
            newbox = this.createElementBox((Element)n, stat);
        }
        if (!istext) {
            BoxTreeCreationStatus newstat = new BoxTreeCreationStatus(stat);
            newstat.parent = (ElementBox)newbox;
            if (newbox.isBlock()) {
                BlockBox block = (BlockBox)newbox;
                if (block.position == BlockBox.POS_ABSOLUTE || block.position == BlockBox.POS_RELATIVE || block.position == BlockBox.POS_FIXED) {
                    newstat.absbox = block;
                }
                newstat.contbox = block;
                if (block.overflow == BlockBox.OVERFLOW_HIDDEN) {
                    newstat.clipbox = block;
                }
                newstat.lastinflow = null;
                this.createBoxTree(newstat);
                this.removeTrailingWhitespaces(block);
            } else {
                this.createBoxTree(newstat);
            }
        }
        this.addToTree(newbox, stat);
    }

    private void addToTree(Box newbox, BoxTreeCreationStatus stat) {
        if (newbox.isBlock()) {
            if (!((BlockBox)newbox).isPositioned()) {
                if (stat.parent.isBlock()) {
                    stat.parent.addSubBox(newbox);
                    stat.lastinflow = newbox;
                } else {
                    ElementBox iparent = null;
                    ElementBox grandpa = stat.parent;
                    ElementBox prev = null;
                    do {
                        iparent = grandpa;
                        grandpa = iparent.getParent();
                        int lastchild = iparent.lastDOMChild;
                        iparent.lastDOMChild = iparent.curstat.curchild;
                        if (iparent.curstat.curchild + 1 >= lastchild && prev == null) continue;
                        ElementBox newparent = iparent.copyBox();
                        newparent.removeAllSubBoxes();
                        newparent.firstDOMChild = iparent.curstat.curchild + 1;
                        iparent.nextTwin = newparent;
                        newparent.previousTwin = iparent;
                        if (prev != null) {
                            newparent.preadd = prev;
                        }
                        prev = newparent;
                    } while (grandpa != null && !grandpa.isBlock());
                    if (grandpa != null) {
                        iparent.postadd = new Vector(2);
                        iparent.postadd.add(newbox);
                        if (iparent.nextTwin != null) {
                            iparent.postadd.add(iparent.nextTwin);
                        }
                    } else {
                        System.err.println("BoxFactory: warning: grandpa is missing for " + newbox);
                    }
                }
            } else {
                newbox.getContainingBlock().addSubBox(newbox);
                ((BlockBox)newbox).absReference = stat.lastinflow;
            }
        } else {
            boolean collapse;
            boolean lastwhite = stat.lastinflow == null || stat.lastinflow.isBlock() || stat.lastinflow.endsWithWhitespace() && stat.lastinflow.collapsesSpaces();
            boolean bl = collapse = lastwhite && newbox.isWhitespace() && newbox.collapsesSpaces();
            if (!collapse) {
                stat.parent.addSubBox(newbox);
                stat.lastinflow = newbox;
            }
        }
        if (newbox instanceof ElementBox && ((ElementBox)newbox).postadd != null) {
            for (Box box : ((ElementBox)newbox).postadd) {
                this.addToTree(box, stat);
            }
        }
    }

    private void removeTrailingWhitespaces(ElementBox block) {
        if (block.collapsesSpaces()) {
            ListIterator<Box> it = block.getSubBoxList().listIterator(block.getSubBoxNumber());
            while (it.hasPrevious()) {
                Box subbox = it.previous();
                if (!subbox.isInFlow()) continue;
                if (subbox.isBlock() || !subbox.collapsesSpaces()) break;
                if (subbox.isWhitespace()) {
                    it.remove();
                    continue;
                }
                if (!(subbox instanceof ElementBox)) continue;
                this.removeTrailingWhitespaces((ElementBox)subbox);
            }
            block.setEndChild(block.getSubBoxList().size());
        }
    }

    public ElementBox createElementBox(Element n, BoxTreeCreationStatus stat) {
        ElementBox ret = this.createBox(stat.parent, n, null);
        ret.setClipBlock(stat.clipbox);
        if (ret.isBlock()) {
            BlockBox block = (BlockBox)ret;
            if (block.position == BlockBox.POS_ABSOLUTE || block.position == BlockBox.POS_FIXED) {
                ret.setContainingBlock(stat.absbox);
            } else {
                ret.setContainingBlock(stat.contbox);
            }
        } else {
            ret.setContainingBlock(stat.contbox);
        }
        return ret;
    }

    private TextBox createTextBox(Text n, BoxTreeCreationStatus stat) {
        TextBox text = new TextBox(n, (Graphics2D)stat.parent.getGraphics().create(), stat.parent.getVisualContext().create());
        text.setOrder(this.next_order++);
        text.setContainingBlock(stat.contbox);
        text.setClipBlock(stat.clipbox);
        text.setViewport(this.viewport);
        text.setBase(this.baseurl);
        return text;
    }

    private ElementBox normalizeBox(ElementBox root) {
        if (root.isBlock() && ((BlockBox)root).containsBlocks()) {
            this.createAnonymousBlocks((BlockBox)root);
        } else if (root.containsMixedContent()) {
            this.createAnonymousInline(root);
        }
        this.createAnonymousBoxes(root, ElementBox.DISPLAY_TABLE_CELL, ElementBox.DISPLAY_TABLE_ROW, ElementBox.DISPLAY_ANY, ElementBox.DISPLAY_ANY, "tr", "table-row");
        this.createAnonymousBoxes(root, ElementBox.DISPLAY_TABLE_ROW, ElementBox.DISPLAY_TABLE_ROW_GROUP, ElementBox.DISPLAY_TABLE_HEADER_GROUP, ElementBox.DISPLAY_TABLE_FOOTER_GROUP, "tbody", "table-row-group");
        this.createAnonymousBoxes(root, ElementBox.DISPLAY_TABLE_COLUMN, ElementBox.DISPLAY_TABLE, ElementBox.DISPLAY_TABLE_COLUMN_GROUP, ElementBox.DISPLAY_ANY, "table", "table");
        this.createAnonymousBoxes(root, ElementBox.DISPLAY_TABLE_ROW_GROUP, ElementBox.DISPLAY_TABLE, ElementBox.DISPLAY_ANY, ElementBox.DISPLAY_ANY, "table", "table");
        return root;
    }

    private void createAnonymousInline(ElementBox root) {
        Vector<Box> nest = new Vector<Box>();
        int i = 0;
        while (i < root.getSubBoxNumber()) {
            Box sub = root.getSubBox(i);
            if (sub instanceof ElementBox) {
                nest.add(sub);
            } else {
                ElementBox anbox = this.createAnonymousBox(root, sub, false);
                anbox.addSubBox(sub);
                nest.add(anbox);
            }
            ++i;
        }
        root.nested = nest;
        root.endChild = nest.size();
    }

    private void createAnonymousBlocks(BlockBox root) {
        Vector<Box> nest = new Vector<Box>();
        ElementBox adiv = null;
        int i = 0;
        while (i < root.getSubBoxNumber()) {
            Box sub = root.getSubBox(i);
            if (sub.isblock) {
                if (adiv != null && !adiv.isempty) {
                    this.normalizeBox(adiv);
                }
                adiv = null;
                nest.add(sub);
            } else if (!sub.isWhitespace()) {
                if (adiv == null) {
                    adiv = this.createAnonymousBox(root, sub, true);
                    nest.add(adiv);
                }
                if (sub.isDisplayed() && !sub.isEmpty()) {
                    adiv.isempty = false;
                    adiv.displayed = true;
                }
                adiv.addSubBox(sub);
            }
            ++i;
        }
        if (adiv != null && !adiv.isempty) {
            this.normalizeBox(adiv);
        }
        root.nested = nest;
        root.endChild = nest.size();
    }

    private void createAnonymousBoxes(ElementBox root, CSSProperty.Display type, CSSProperty.Display reqtype1, CSSProperty.Display reqtype2, CSSProperty.Display reqtype3, String name, String display) {
        if (root.getDisplay() != reqtype1 && root.getDisplay() != reqtype2 && root.getDisplay() != reqtype3) {
            Vector<Box> nest = new Vector<Box>();
            ElementBox adiv = null;
            int i = 0;
            while (i < root.getSubBoxNumber()) {
                Box sub = root.getSubBox(i);
                if (sub instanceof ElementBox) {
                    ElementBox subel = (ElementBox)sub;
                    if (subel.getDisplay() != type) {
                        adiv = null;
                        nest.add(sub);
                    } else {
                        if (adiv == null) {
                            Element elem = this.createAnonymousElement(root.getElement().getOwnerDocument(), name, display);
                            adiv = this.createBox(root, elem, display);
                            adiv.isblock = true;
                            adiv.isempty = true;
                            adiv.setContainingBlock(sub.getContainingBlock());
                            adiv.setClipBlock(sub.getClipBlock());
                            nest.add(adiv);
                        }
                        if (sub.isDisplayed() && !sub.isEmpty()) {
                            adiv.isempty = false;
                            adiv.displayed = true;
                        }
                        sub.setParent(adiv);
                        sub.setContainingBlock((BlockBox)adiv);
                        adiv.addSubBox(sub);
                    }
                } else {
                    return;
                }
                ++i;
            }
            root.nested = nest;
            root.endChild = nest.size();
        }
    }

    protected ElementBox createAnonymousBox(ElementBox parent, Box child, boolean block) {
        InlineBox anbox;
        if (block) {
            Element anelem = this.createAnonymousElement(child.getNode().getOwnerDocument(), "Xdiv", "block");
            anbox = new BlockBox(anelem, child.getGraphics(), child.getVisualContext());
            ((ElementBox)anbox).setStyle(this.createAnonymousStyle("block"));
            ((BlockBox)anbox).contblock = false;
            anbox.isblock = true;
        } else {
            Element anelem = this.createAnonymousElement(child.getNode().getOwnerDocument(), "Xspan", "inline");
            anbox = new InlineBox(anelem, child.getGraphics(), child.getVisualContext());
            ((ElementBox)anbox).setStyle(this.createAnonymousStyle("inline"));
            anbox.isblock = false;
        }
        if (parent != null) {
            this.computeInheritedStyle(anbox, parent);
            anbox.setParent(parent);
        }
        anbox.setOrder(this.next_order++);
        anbox.isempty = true;
        anbox.setBase(child.getBase());
        anbox.setViewport(child.getViewport());
        anbox.setContainingBlock(child.getContainingBlock());
        anbox.setClipBlock(child.getClipBlock());
        return anbox;
    }

    public ElementBox createBox(ElementBox parent, Element n, String display) {
        ElementBox root;
        NodeData style = this.decoder.getElementStyleInherited(n);
        if (style == null) {
            style = this.createAnonymousStyle(display);
        }
        if (this.useHTML && n.getNodeName().equals("img")) {
            InlineReplacedBox rbox = new InlineReplacedBox(n, (Graphics2D)parent.getGraphics().create(), parent.getVisualContext().create());
            rbox.setStyle(style);
            rbox.setContentObj(new ReplacedImage(rbox, rbox.getVisualContext(), this.baseurl));
            root = rbox;
            if (root.isBlock()) {
                root = new BlockReplacedBox(rbox);
            }
        } else {
            root = this.createElementInstance(parent, n, style);
        }
        root.setBase(this.baseurl);
        root.setViewport(this.viewport);
        root.setParent(parent);
        root.setOrder(this.next_order++);
        return root;
    }

    private Node createPseudoElement(ElementBox box, Selector.PseudoDeclaration pseudo) {
        Element n = box.getElement();
        NodeData style = this.decoder.getElementStyleInherited(n, pseudo);
        if (style != null) {
            TermList cont = style.getValue(TermList.class, "content");
            if (cont != null && cont.size() > 0) {
                Element pelem = this.createAnonymousElement(n.getOwnerDocument(), "XPspan", "inline");
                for (Term c : cont) {
                    if (c instanceof TermIdent) continue;
                    if (c instanceof TermString) {
                        Text txt = n.getOwnerDocument().createTextNode((String)((TermString)c).getValue());
                        pelem.appendChild(txt);
                        continue;
                    }
                    if (c instanceof TermURI) continue;
                    boolean cfr_ignored_0 = c instanceof TermFunction;
                }
                this.decoder.useStyle(pelem, null, style);
                return pelem;
            }
            return null;
        }
        return null;
    }

    private ElementBox createElementInstance(ElementBox parent, Element n, NodeData style) {
        InlineBox root = new InlineBox(n, (Graphics2D)parent.getGraphics().create(), parent.getVisualContext().create());
        ((ElementBox)root).setStyle(style);
        if (root.getDisplay() == ElementBox.DISPLAY_LIST_ITEM) {
            root = new ListItemBox(root);
        } else if (root.getDisplay() == ElementBox.DISPLAY_TABLE) {
            root = new BlockTableBox(root);
        } else if (root.getDisplay() == ElementBox.DISPLAY_TABLE_CAPTION) {
            root = new TableCaptionBox(root);
        } else if (root.getDisplay() == ElementBox.DISPLAY_TABLE_ROW_GROUP || root.getDisplay() == ElementBox.DISPLAY_TABLE_HEADER_GROUP || root.getDisplay() == ElementBox.DISPLAY_TABLE_FOOTER_GROUP) {
            root = new TableBodyBox(root);
        } else if (root.getDisplay() == ElementBox.DISPLAY_TABLE_ROW) {
            root = new TableRowBox(root);
        } else if (root.getDisplay() == ElementBox.DISPLAY_TABLE_CELL) {
            root = new TableCellBox(root);
        } else if (root.getDisplay() == ElementBox.DISPLAY_TABLE_COLUMN) {
            root = new TableColumn(root);
        } else if (root.getDisplay() == ElementBox.DISPLAY_TABLE_COLUMN_GROUP) {
            root = new TableColumnGroup(root);
        } else if (root.isBlock()) {
            root = new BlockBox(root);
        }
        return root;
    }

    public Element createAnonymousElement(Document doc, String name, String display) {
        Element div = doc.createElement(name);
        div.setAttribute("class", "Xanonymous");
        div.setAttribute("style", "display:" + display);
        return div;
    }

    public NodeData createAnonymousStyle(String display) {
        NodeData ret = CSSFactory.createNodeData();
        Declaration cls = CSSFactory.getRuleFactory().createDeclaration();
        cls.unlock();
        cls.setProperty("class");
        cls.add(CSSFactory.getTermFactory().createString("Xanonymous"));
        ret.push(cls);
        Declaration disp = CSSFactory.getRuleFactory().createDeclaration();
        disp.unlock();
        disp.setProperty("display");
        disp.add(CSSFactory.getTermFactory().createIdent(display));
        ret.push(disp);
        return ret;
    }

    private void computeInheritedStyle(ElementBox dest, ElementBox parent) {
        NodeData newstyle = dest.getStyle().inheritFrom(parent.getStyle());
        dest.setStyle(newstyle);
    }
}

