/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.layout;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.JPanel;
import org.fit.cssbox.css.DOMAnalyzer;
import org.fit.cssbox.layout.BoxFactory;
import org.fit.cssbox.layout.ElementBox;
import org.fit.cssbox.layout.Viewport;
import org.fit.cssbox.layout.VisualContext;
import org.w3c.dom.Element;

public class BrowserCanvas
extends JPanel {
    private static final long serialVersionUID = -8715215920271505397L;
    protected Element root;
    protected DOMAnalyzer decoder;
    protected URL baseurl;
    protected Viewport viewport;
    protected BufferedImage img;
    BoxFactory factory;

    public URL getBaseURL() {
        return this.baseurl;
    }

    public BrowserCanvas(Element root, DOMAnalyzer decoder, Dimension dim, URL baseurl) {
        this.root = root;
        this.decoder = decoder;
        this.baseurl = baseurl;
        this.createLayout(dim);
    }

    public void navigate(Element root, DOMAnalyzer decoder, Dimension dim, URL baseurl) {
        this.root = root;
        this.decoder = decoder;
        this.baseurl = baseurl;
        this.createLayout(dim);
    }

    public ElementBox getRootBox() {
        if (this.viewport == null) {
            return null;
        }
        return this.viewport.getRootBox();
    }

    public Viewport getViewport() {
        return this.viewport;
    }

    public void createLayout(Dimension dim) {
        this.img = new BufferedImage(dim.width, dim.height, 1);
        System.gc();
        Graphics2D ig = this.img.createGraphics();
        VisualContext ctx = new VisualContext(null);
        System.err.println("Creating boxes");
        this.factory = new BoxFactory(this.decoder, this.baseurl);
        this.factory.reset();
        this.viewport = this.factory.createViewportTree(this.root, ig, ctx, dim.width, dim.height);
        System.err.println("We have " + this.factory.next_order + " boxes");
        this.viewport.initSubtree();
        System.err.println("Layout for " + dim.width + "px");
        this.viewport.doLayout(dim.width, true, true);
        System.err.println("Resulting size: " + this.viewport.getWidth() + "x" + this.viewport.getHeight() + " (" + this.viewport + ")");
        System.err.println("Updating viewport size");
        this.viewport.updateBounds();
        System.err.println("Resulting size: " + this.viewport.getWidth() + "x" + this.viewport.getHeight() + " (" + this.viewport + ")");
        if (this.viewport.getWidth() > dim.width || this.viewport.getHeight() > dim.height) {
            this.img = new BufferedImage(Math.max(this.viewport.getWidth(), dim.width), Math.max(this.viewport.getHeight(), dim.height), 1);
            ig = this.img.createGraphics();
        }
        System.err.println("Positioning for " + this.img.getWidth() + "x" + this.img.getHeight() + "px");
        this.viewport.absolutePositions();
        this.clearCanvas();
        this.viewport.draw(ig);
        this.setPreferredSize(new Dimension(this.img.getWidth(), this.img.getHeight()));
        this.revalidate();
    }

    public void updateLayout(Dimension dim) {
        this.img = new BufferedImage(dim.width, dim.height, 1);
        System.gc();
        Graphics2D ig = this.img.createGraphics();
        System.err.println("Layout for " + dim.width + "px");
        this.viewport.setSize(dim.width, dim.height);
        this.viewport.setContentHeight(dim.height);
        this.viewport.initSubtree();
        this.viewport.doLayout(dim.width, true, true);
        System.err.println("Resulting size: " + this.viewport.getWidth() + "x" + this.viewport.getHeight() + " (" + this.viewport + ")");
        System.err.println("Updating viewport size");
        this.viewport.updateBounds();
        System.err.println("Resulting size: " + this.viewport.getWidth() + "x" + this.viewport.getHeight() + " (" + this.viewport + ")");
        if (this.viewport.getWidth() > dim.width || this.viewport.getHeight() > dim.height) {
            this.img = new BufferedImage(Math.max(this.viewport.getWidth(), dim.width), Math.max(this.viewport.getHeight(), dim.height), 1);
            ig = this.img.createGraphics();
        }
        System.err.println("Positioning for " + this.img.getWidth() + "x" + this.img.getHeight() + "px");
        this.viewport.absolutePositions();
        this.clearCanvas();
        this.viewport.draw(ig);
        this.setPreferredSize(new Dimension(this.img.getWidth(), this.img.getHeight()));
        this.revalidate();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.drawImage(this.img, 0, 0, null);
    }

    public void clearCanvas() {
        Graphics2D ig = this.img.createGraphics();
        Color bg = this.viewport.getBgcolor();
        if (bg == null) {
            bg = Color.white;
        }
        ig.setColor(bg);
        ig.fillRect(0, 0, this.img.getWidth(), this.img.getHeight());
        ig.setColor(Color.black);
    }

    public void redrawBoxes() {
        Graphics2D ig = this.img.createGraphics();
        this.clearCanvas();
        this.viewport.draw(ig);
        this.revalidate();
    }

    public Graphics2D getImageGraphics() {
        return this.img.createGraphics();
    }

    public BufferedImage getImage() {
        return this.img;
    }
}

