/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.layout;

import cz.vutbr.web.css.CSSProperty;
import cz.vutbr.web.css.NodeData;
import cz.vutbr.web.css.Selector;
import cz.vutbr.web.css.Term;
import cz.vutbr.web.css.TermColor;
import cz.vutbr.web.css.TermInteger;
import cz.vutbr.web.css.TermLength;
import cz.vutbr.web.css.TermLengthOrPercent;
import cz.vutbr.web.css.TermNumber;
import cz.vutbr.web.css.TermPercent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.fit.cssbox.css.CSSUnits;
import org.fit.cssbox.layout.BlockBox;
import org.fit.cssbox.layout.Box;
import org.fit.cssbox.layout.BoxTreeCreationStatus;
import org.fit.cssbox.layout.CSSDecoder;
import org.fit.cssbox.layout.LengthSet;
import org.fit.cssbox.layout.TextBox;
import org.fit.cssbox.layout.VisualContext;
import org.fit.cssbox.misc.CSSStroke;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ElementBox
extends Box {
    public static final CSSProperty.Display DISPLAY_ANY = null;
    public static final CSSProperty.Display DISPLAY_NONE = CSSProperty.Display.NONE;
    public static final CSSProperty.Display DISPLAY_INLINE = CSSProperty.Display.INLINE;
    public static final CSSProperty.Display DISPLAY_BLOCK = CSSProperty.Display.BLOCK;
    public static final CSSProperty.Display DISPLAY_LIST_ITEM = CSSProperty.Display.LIST_ITEM;
    public static final CSSProperty.Display DISPLAY_RUN_IN = CSSProperty.Display.RUN_IN;
    public static final CSSProperty.Display DISPLAY_INLINE_BLOCK = CSSProperty.Display.INLINE_BLOCK;
    public static final CSSProperty.Display DISPLAY_TABLE = CSSProperty.Display.TABLE;
    public static final CSSProperty.Display DISPLAY_INLINE_TABLE = CSSProperty.Display.INLINE_TABLE;
    public static final CSSProperty.Display DISPLAY_TABLE_ROW_GROUP = CSSProperty.Display.TABLE_ROW_GROUP;
    public static final CSSProperty.Display DISPLAY_TABLE_HEADER_GROUP = CSSProperty.Display.TABLE_HEADER_GROUP;
    public static final CSSProperty.Display DISPLAY_TABLE_FOOTER_GROUP = CSSProperty.Display.TABLE_FOOTER_GROUP;
    public static final CSSProperty.Display DISPLAY_TABLE_ROW = CSSProperty.Display.TABLE_ROW;
    public static final CSSProperty.Display DISPLAY_TABLE_COLUMN_GROUP = CSSProperty.Display.TABLE_COLUMN_GROUP;
    public static final CSSProperty.Display DISPLAY_TABLE_COLUMN = CSSProperty.Display.TABLE_COLUMN;
    public static final CSSProperty.Display DISPLAY_TABLE_CELL = CSSProperty.Display.TABLE_CELL;
    public static final CSSProperty.Display DISPLAY_TABLE_CAPTION = CSSProperty.Display.TABLE_CAPTION;
    public static final CSSProperty.WhiteSpace WHITESPACE_NORMAL = CSSProperty.WhiteSpace.NORMAL;
    public static final CSSProperty.WhiteSpace WHITESPACE_PRE = CSSProperty.WhiteSpace.PRE;
    public static final CSSProperty.WhiteSpace WHITESPACE_NOWRAP = CSSProperty.WhiteSpace.NOWRAP;
    public static final CSSProperty.WhiteSpace WHITESPACE_PRE_WRAP = CSSProperty.WhiteSpace.PRE_WRAP;
    public static final CSSProperty.WhiteSpace WHITESPACE_PRE_LINE = CSSProperty.WhiteSpace.PRE_LINE;
    private static final float DEFAULT_LINE_HEIGHT = 1.12f;
    protected Element el;
    protected int firstDOMChild;
    protected int lastDOMChild;
    protected Box preadd;
    protected Vector<Box> postadd;
    protected BoxTreeCreationStatus curstat;
    protected ElementBox previousTwin;
    protected ElementBox nextTwin;
    protected NodeData style = null;
    protected Map<Selector.PseudoDeclaration, NodeData> pseudoStyle = new HashMap<Selector.PseudoDeclaration, NodeData>();
    protected CSSProperty.Display display;
    protected CSSProperty.WhiteSpace whitespace;
    protected Color bgcolor;
    protected Vector<Box> nested;
    protected boolean textonly;
    protected Map<Selector.PseudoDeclaration, ElementBox> pseudoElements;
    protected LengthSet margin;
    protected LengthSet emargin;
    protected LengthSet border;
    protected LengthSet padding;
    protected Dimension content;
    protected Rectangle minAbsBounds = null;
    protected int lineHeight;
    protected int startChild;
    protected int endChild;

    public ElementBox(Element n, Graphics2D g, VisualContext ctx) {
        super(n, g, ctx);
        if (n != null) {
            this.el = n;
            this.firstDOMChild = 0;
            this.lastDOMChild = n.getChildNodes().getLength();
            this.previousTwin = null;
            this.nextTwin = null;
            this.nested = new Vector();
            this.pseudoElements = new HashMap<Selector.PseudoDeclaration, ElementBox>();
            this.startChild = 0;
            this.endChild = 0;
            this.isblock = false;
            this.textonly = true;
        }
    }

    public void copyValues(ElementBox src) {
        super.copyValues(src);
        this.nested.addAll(src.nested);
        this.textonly = src.textonly;
        this.pseudoElements = new HashMap<Selector.PseudoDeclaration, ElementBox>(src.pseudoElements);
        this.style = src.style;
        this.pseudoStyle = new HashMap<Selector.PseudoDeclaration, NodeData>(src.pseudoStyle);
        this.startChild = src.startChild;
        this.endChild = src.endChild;
        this.isblock = src.isblock;
        this.style = src.style;
        this.display = src.display;
        this.lineHeight = src.lineHeight;
        this.whitespace = src.whitespace;
        this.whitespace = src.whitespace;
        if (src.margin != null) {
            this.margin = new LengthSet(src.margin);
        }
        if (src.emargin != null) {
            this.emargin = new LengthSet(src.emargin);
        }
        if (src.border != null) {
            this.border = new LengthSet(src.border);
        }
        if (src.padding != null) {
            this.padding = new LengthSet(src.padding);
        }
        if (src.content != null) {
            this.content = new Dimension(src.content);
        }
    }

    public abstract ElementBox copyBox();

    @Override
    public void initSubtree() {
        this.initBox();
        this.loadSizes();
        int i = 0;
        while (i < this.getSubBoxNumber()) {
            this.getSubBox(i).initSubtree();
            ++i;
        }
        this.computeEfficientMargins();
    }

    public Element getElement() {
        return this.el;
    }

    public void setStyle(NodeData s) {
        this.style = s;
        this.loadBasicStyle();
    }

    public NodeData getStyle() {
        return this.style;
    }

    public String getStyleString() {
        if (this.style != null) {
            return this.style.toString();
        }
        return "";
    }

    public String getStylePropertyValue(String property) {
        Term t = this.style.getValue(Term.class, property);
        if (t == null) {
            return "";
        }
        return t.toString();
    }

    public TermLengthOrPercent getLengthValue(String name) {
        if (this.style != null) {
            return this.style.getValue(TermLengthOrPercent.class, name);
        }
        return null;
    }

    public int getBorderWidth(CSSDecoder dec, String property) {
        if (this.style != null) {
            CSSProperty.BorderWidth prop = (CSSProperty.BorderWidth)this.style.getProperty(property);
            if (prop == CSSProperty.BorderWidth.length) {
                return dec.getLength(this.style.getValue(TermLengthOrPercent.class, property), false, 3, 0, 0);
            }
            return CSSUnits.convertBorderWidth(prop);
        }
        return 0;
    }

    public CSSProperty.Display getDisplay() {
        return this.display;
    }

    public String getDisplayString() {
        if (this.display != null) {
            return this.display.toString();
        }
        return "";
    }

    public CSSProperty.WhiteSpace getWhiteSpace() {
        return this.whitespace;
    }

    @Override
    public boolean collapsesSpaces() {
        return this.whitespace != WHITESPACE_PRE && this.whitespace != WHITESPACE_PRE_WRAP;
    }

    public Color getBgcolor() {
        return this.bgcolor;
    }

    public void setBgcolor(Color bgcolor) {
        this.bgcolor = bgcolor;
    }

    public int getSubBoxNumber() {
        return this.nested.size();
    }

    public List<Box> getSubBoxList() {
        return this.nested;
    }

    public Box getSubBox(int index) {
        return this.nested.elementAt(index);
    }

    public void addSubBox(Box box) {
        box.setParent(this);
        this.nested.add(box);
        ++this.endChild;
        if (this.isDisplayed() && !box.isEmpty()) {
            this.isempty = false;
        }
        if (!(box instanceof TextBox)) {
            this.textonly = false;
        }
    }

    public void removeSubBox(Box box) {
        if (this.nested.remove(box)) {
            --this.endChild;
        }
    }

    public void removeAllSubBoxes() {
        this.nested.removeAllElements();
        this.endChild = 0;
    }

    public void insertSubBoxBefore(Box where, Box what) {
        int pos = this.nested.indexOf(where);
        this.nested.insertElementAt(what, pos);
        ++this.endChild;
    }

    public void insertSubBoxAfter(Box where, Box what) {
        int pos = this.nested.indexOf(where);
        this.nested.insertElementAt(what, pos + 1);
        ++this.endChild;
    }

    public void insertSubBox(int index, Box what) {
        this.nested.insertElementAt(what, index);
        ++this.endChild;
    }

    public void setPseudoElement(Selector.PseudoDeclaration pseudo, ElementBox box) {
        this.pseudoElements.put(pseudo, box);
    }

    public ElementBox getPseudoElement(Selector.PseudoDeclaration pseudo) {
        return this.pseudoElements.get((Object)pseudo);
    }

    public boolean hasPseudoElement(Selector.PseudoDeclaration pseudo) {
        return this.pseudoElements.containsKey((Object)pseudo);
    }

    @Override
    public int getContentWidth() {
        return this.content.width;
    }

    @Override
    public int getContentHeight() {
        return this.content.height;
    }

    public int getLineHeight() {
        return this.lineHeight;
    }

    public LengthSet getMargin() {
        return this.margin;
    }

    public LengthSet getEMargin() {
        return this.emargin;
    }

    public LengthSet getBorder() {
        return this.border;
    }

    public LengthSet getPadding() {
        return this.padding;
    }

    public Dimension getContent() {
        return this.content;
    }

    public int getStartChild() {
        return this.startChild;
    }

    public void setStartChild(int index) {
        this.startChild = index;
    }

    public int getEndChild() {
        return this.endChild;
    }

    public void setEndChild(int index) {
        this.endChild = index;
    }

    public void adoptChildren() {
        int i = this.startChild;
        while (i < this.endChild) {
            this.nested.elementAt(i).setParent(this);
            ++i;
        }
    }

    public int getContentOffsetX() {
        return this.margin.left + this.border.left + this.padding.left;
    }

    public int getContentOffsetY() {
        return this.margin.top + this.border.top + this.padding.top;
    }

    @Override
    public int getContentX() {
        return this.bounds.x + this.margin.left + this.border.left + this.padding.left;
    }

    @Override
    public int getContentY() {
        return this.bounds.y + this.margin.top + this.border.top + this.padding.top;
    }

    @Override
    public int getAbsoluteContentX() {
        return this.absbounds.x + this.margin.left + this.border.left + this.padding.left;
    }

    @Override
    public int getAbsoluteContentY() {
        return this.absbounds.y + this.margin.top + this.border.top + this.padding.top;
    }

    @Override
    public int totalWidth() {
        return this.margin.left + this.border.left + this.padding.left + this.content.width + this.padding.right + this.border.right + this.margin.right;
    }

    @Override
    public int getAvailableContentWidth() {
        return this.availwidth - this.margin.left - this.border.left - this.padding.left - this.padding.right - this.border.right - this.margin.right;
    }

    @Override
    public Rectangle getMinimalAbsoluteBounds() {
        if (this.minAbsBounds == null) {
            this.minAbsBounds = this.computeMinimalAbsoluteBounds();
        }
        return this.minAbsBounds;
    }

    private Rectangle computeMinimalAbsoluteBounds() {
        int rx1 = 0;
        int ry1 = 0;
        int rx2 = 0;
        int ry2 = 0;
        boolean valid = false;
        int i = this.startChild;
        while (i < this.endChild) {
            Box sub = this.getSubBox(i);
            Rectangle sb = sub.getMinimalAbsoluteBounds();
            if (sub.isDisplayed() && sub.isVisible() && sb.width > 0 && sb.height > 0) {
                if (sb.x < rx1 || !valid) {
                    rx1 = sb.x;
                }
                if (sb.y < ry1 || !valid) {
                    ry1 = sb.y;
                }
                if (sb.x + sb.width > rx2 || !valid) {
                    rx2 = sb.x + sb.width;
                }
                if (sb.y + sb.height > ry2 || !valid) {
                    ry2 = sb.y + sb.height;
                }
                valid = true;
            }
            ++i;
        }
        return new Rectangle(rx1, ry1, rx2 - rx1, ry2 - ry1);
    }

    @Override
    public boolean affectsDisplay() {
        boolean ret;
        boolean bl = ret = !this.isEmpty();
        if (this.border.top > 0 || this.border.bottom > 0) {
            ret = true;
        }
        if (this.padding.top > 0 || this.padding.bottom > 0) {
            ret = true;
        }
        return ret;
    }

    public Rectangle getAbsoluteBackgroundBounds() {
        return new Rectangle(this.absbounds.x + this.margin.left + this.border.left, this.absbounds.y + this.margin.top + this.border.top, this.content.width + this.padding.left + this.padding.right, this.content.height + this.padding.top + this.padding.bottom);
    }

    public Rectangle getAbsoluteBorderBounds() {
        return new Rectangle(this.absbounds.x + this.margin.left, this.absbounds.y + this.margin.top, this.content.width + this.padding.left + this.padding.right + this.border.left + this.border.right, this.content.height + this.padding.top + this.padding.bottom + this.border.top + this.border.bottom);
    }

    @Override
    public String getText() {
        String ret = "";
        int i = this.startChild;
        while (i < this.endChild) {
            ret = String.valueOf(ret) + this.getSubBox(i).getText();
            ++i;
        }
        return ret;
    }

    @Override
    public boolean isWhitespace() {
        int i = this.startChild;
        while (i < this.endChild) {
            if (!this.getSubBox(i).isWhitespace()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean containsTextOnly() {
        for (Box child : this.nested) {
            if (child instanceof TextBox) continue;
            return false;
        }
        return true;
    }

    public boolean containsMixedContent() {
        boolean ctext = false;
        boolean celem = false;
        for (Box child : this.nested) {
            if (child instanceof TextBox) {
                ctext = true;
            } else {
                celem = true;
            }
            if (!ctext || !celem) continue;
            return true;
        }
        return false;
    }

    public void drawBackground(Graphics2D g) {
        Color color = g.getColor();
        int x = this.absbounds.x;
        int y = this.absbounds.y;
        int bx1 = x + this.margin.left;
        int by1 = y + this.margin.top;
        int bw = this.border.left + this.padding.left + this.content.width + this.padding.right + this.border.right;
        int bh = this.border.top + this.padding.top + this.content.height + this.padding.bottom + this.border.bottom;
        int bx2 = bx1 + bw - 1;
        int by2 = by1 + bh - 1;
        if (this.bgcolor != null) {
            g.setColor(this.bgcolor);
            g.fillRect(bx1, by1, bw, bh);
        }
        this.drawBorders(g, bx1, by1, bx2, by2);
        g.setColor(color);
    }

    protected void drawBorders(Graphics2D g, int bx1, int by1, int bx2, int by2) {
        if (this.border.top > 0) {
            this.drawBorder(g, bx1, by1, bx2, by1, this.border.top, 0, 0, "top", false);
        }
        if (this.border.right > 0) {
            this.drawBorder(g, bx2, by1, bx2, by2, this.border.right, -this.border.right + 1, 0, "right", true);
        }
        if (this.border.bottom > 0) {
            this.drawBorder(g, bx1, by2, bx2, by2, this.border.bottom, 0, -this.border.bottom + 1, "bottom", true);
        }
        if (this.border.left > 0) {
            this.drawBorder(g, bx1, by1, bx1, by2, this.border.left, 0, 0, "left", false);
        }
    }

    private void drawBorder(Graphics2D g, int x1, int y1, int x2, int y2, int width, int right, int down, String side, boolean reverse) {
        TermColor tclr = this.style.getValue(TermColor.class, "border-" + side + "-color");
        CSSProperty.BorderStyle bst = (CSSProperty.BorderStyle)this.style.getProperty("border-" + side + "-style");
        if (tclr != null && bst != CSSProperty.BorderStyle.HIDDEN) {
            Color clr = (Color)tclr.getValue();
            if (clr == null) {
                clr = Color.BLACK;
            }
            g.setColor(clr);
            g.setStroke(new CSSStroke(width, bst, reverse));
            g.draw(new Line2D.Double(x1 + right, y1 + down, x2 + right, y2 + down));
        }
    }

    @Override
    public void drawExtent(Graphics2D g) {
        g.setColor(Color.RED);
        g.drawRect(this.absbounds.x, this.absbounds.y, this.bounds.width, this.bounds.height);
        g.setColor(Color.ORANGE);
        g.drawRect(this.getAbsoluteContentX(), this.getAbsoluteContentY(), this.getContentWidth(), this.getContentHeight());
    }

    protected abstract void loadSizes();

    public abstract void updateSizes();

    public abstract void computeEfficientMargins();

    public abstract boolean marginsAdjoin();

    protected boolean borderVisible(String dir) {
        CSSProperty.BorderStyle st = (CSSProperty.BorderStyle)this.style.getProperty("border-" + dir + "-style");
        return st != null && st != CSSProperty.BorderStyle.NONE && st != CSSProperty.BorderStyle.HIDDEN;
    }

    protected void loadBorders(CSSDecoder dec, int contw) {
        this.border = new LengthSet();
        this.border.top = this.borderVisible("top") ? this.getBorderWidth(dec, "border-top-width") : 0;
        this.border.right = this.borderVisible("right") ? this.getBorderWidth(dec, "border-right-width") : 0;
        this.border.bottom = this.borderVisible("bottom") ? this.getBorderWidth(dec, "border-bottom-width") : 0;
        this.border.left = this.borderVisible("left") ? this.getBorderWidth(dec, "border-left-width") : 0;
    }

    protected void loadBasicStyle() {
        CSSProperty.Position position;
        CSSProperty.Float floating;
        this.ctx.updateForGraphics(this.style, this.g);
        this.display = (CSSProperty.Display)this.style.getProperty("display");
        if (this.display == null) {
            this.display = CSSProperty.Display.INLINE;
        }
        if ((floating = (CSSProperty.Float)this.style.getProperty("float")) == null) {
            floating = BlockBox.FLOAT_NONE;
        }
        if ((position = (CSSProperty.Position)this.style.getProperty("position")) == null) {
            position = BlockBox.POS_STATIC;
        }
        if (this.display == DISPLAY_NONE) {
            position = BlockBox.POS_STATIC;
            floating = BlockBox.FLOAT_NONE;
        } else if (position == BlockBox.POS_ABSOLUTE || position == BlockBox.POS_FIXED) {
            floating = BlockBox.FLOAT_NONE;
        }
        if (floating != BlockBox.FLOAT_NONE || position == BlockBox.POS_ABSOLUTE || this.isRootElement()) {
            if (this.display == DISPLAY_INLINE_TABLE) {
                this.display = DISPLAY_TABLE;
            } else if (this.display == DISPLAY_INLINE || this.display == DISPLAY_RUN_IN || this.display == DISPLAY_TABLE_ROW_GROUP || this.display == DISPLAY_TABLE_COLUMN || this.display == DISPLAY_TABLE_COLUMN_GROUP || this.display == DISPLAY_TABLE_HEADER_GROUP || this.display == DISPLAY_TABLE_FOOTER_GROUP || this.display == DISPLAY_TABLE_ROW || this.display == DISPLAY_TABLE_CELL || this.display == DISPLAY_TABLE_CAPTION || this.display == DISPLAY_INLINE_BLOCK) {
                this.display = DISPLAY_BLOCK;
            }
        }
        this.isblock = this.display == DISPLAY_BLOCK;
        this.displayed = this.display != DISPLAY_NONE && this.display != DISPLAY_TABLE_COLUMN;
        this.visible = this.style.getProperty("visibility") != CSSProperty.Visibility.HIDDEN;
        CSSProperty.LineHeight lh = (CSSProperty.LineHeight)this.style.getProperty("line-height");
        if (lh == null || lh == CSSProperty.LineHeight.NORMAL) {
            this.lineHeight = Math.round(1.12f * (float)this.ctx.getFontHeight());
        } else if (lh == CSSProperty.LineHeight.length) {
            TermLength len = this.style.getValue(TermLength.class, "line-height");
            this.lineHeight = (int)this.ctx.pxLength(len);
        } else if (lh == CSSProperty.LineHeight.percentage) {
            TermPercent len = this.style.getValue(TermPercent.class, "line-height");
            this.lineHeight = (int)this.ctx.pxLength(len, this.ctx.getFontHeight());
        } else {
            Term<?> len = this.style.getValue("line-height", true);
            float r = len instanceof TermInteger ? ((Float)((TermInteger)len).getValue()).floatValue() : ((Float)((TermNumber)len).getValue()).floatValue();
            this.lineHeight = Math.round(r * (float)this.ctx.getFontHeight());
        }
        this.whitespace = (CSSProperty.WhiteSpace)this.style.getProperty("white-space");
        if (this.whitespace == null) {
            this.whitespace = WHITESPACE_NORMAL;
        }
        this.loadBackground();
    }

    protected void loadBackground() {
        CSSProperty.BackgroundColor bg = (CSSProperty.BackgroundColor)this.style.getProperty("background-color");
        if (bg == CSSProperty.BackgroundColor.color) {
            TermColor bgc = this.style.getValue(TermColor.class, "background-color");
            this.bgcolor = (Color)bgc.getValue();
        } else {
            this.bgcolor = null;
        }
    }
}

