/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.layout;

import cz.vutbr.web.css.CSSProperty;
import org.fit.cssbox.layout.CSSDecoder;
import org.fit.cssbox.layout.ElementBox;
import org.fit.cssbox.layout.Inline;
import org.fit.cssbox.layout.InlineBox;

public class LineBox {
    private ElementBox parent;
    private int start;
    private int y;
    private int end;
    private int width;
    private int left;
    private int right;
    private int above;
    private int below;
    private int maxlineheight;

    public LineBox(ElementBox parent, int start, int y) {
        this.parent = parent;
        this.start = start;
        this.y = y;
        this.width = 0;
        this.left = 0;
        this.right = 0;
        this.above = 0;
        this.below = 0;
    }

    public String toString() {
        return "LineBox " + this.start + ".." + this.end + " y=" + this.y + " width=" + this.width + " above=" + this.above + " below=" + this.below + " total=" + (this.above + this.below) + " maxlineh=" + this.maxlineheight;
    }

    public ElementBox getParent() {
        return this.parent;
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public int getStart() {
        return this.start;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getY() {
        return this.y;
    }

    public int getAbsoluteY() {
        return this.parent.getAbsoluteContentY() + this.y;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getLeftLimit() {
        return this.left;
    }

    public int getRightLimit() {
        return this.right;
    }

    public int getLimits() {
        return this.left + this.right;
    }

    public void setLimits(int left, int right) {
        this.left = left;
        this.right = right;
    }

    public int getTotalLineHeight() {
        return this.above + this.below;
    }

    public int getMaxLineHeight() {
        return this.maxlineheight;
    }

    public int getBaselineOffset() {
        return this.above;
    }

    public int getBelowBaseline() {
        return this.below;
    }

    public int getLead() {
        return this.maxlineheight - (this.above + this.below);
    }

    public void considerBox(Inline box) {
        int a = box.getBaselineOffset();
        int b = box.getBelowBaseline();
        if (box instanceof InlineBox) {
            CSSProperty.VerticalAlign va = ((InlineBox)box).getVerticalAlign();
            if (va != CSSProperty.VerticalAlign.TOP && va != CSSProperty.VerticalAlign.BOTTOM) {
                int dif = this.computeBaselineDifference((InlineBox)box);
                this.above = Math.max(this.above, a -= dif);
                this.below = Math.max(this.below, b += dif);
            }
        } else {
            this.above = Math.max(this.above, a);
            this.below = Math.max(this.below, b);
        }
        this.maxlineheight = Math.max(this.maxlineheight, box.getMaxLineHeight());
    }

    public int alignBox(Inline box) {
        if (box instanceof InlineBox) {
            CSSProperty.VerticalAlign va = ((InlineBox)box).getVerticalAlign();
            if (va == CSSProperty.VerticalAlign.TOP) {
                return 0;
            }
            if (va == CSSProperty.VerticalAlign.BOTTOM) {
                return this.getTotalLineHeight() - ((InlineBox)box).getContentHeight() + 1;
            }
            return this.above + this.computeBaselineDifference((InlineBox)box) - box.getBaselineOffset() + ((InlineBox)box).getLineboxOffset();
        }
        return this.above - box.getBaselineOffset();
    }

    private int computeBaselineDifference(InlineBox box) {
        int a = box.getBaselineOffset();
        int b = box.getBelowBaseline();
        CSSProperty.VerticalAlign va = box.getVerticalAlign();
        int dif = 0;
        if (va == CSSProperty.VerticalAlign.BASELINE) {
            dif = 0;
        } else if (va == CSSProperty.VerticalAlign.MIDDLE) {
            int midbox = (a + b) / 2;
            int halfex = (int)Math.round(this.parent.getVisualContext().getEx() / 2.0);
            int na = midbox + halfex;
            dif = a - na;
        } else if (va == CSSProperty.VerticalAlign.SUB) {
            dif = (int)Math.round(0.3 * (double)this.parent.getLineHeight());
        } else if (va == CSSProperty.VerticalAlign.SUPER) {
            dif = -((int)Math.round(0.3 * (double)this.parent.getLineHeight()));
        } else if (va == CSSProperty.VerticalAlign.TEXT_TOP) {
            int na = this.parent.getVisualContext().getBaselineOffset();
            dif = a - na;
        } else if (va == CSSProperty.VerticalAlign.TEXT_BOTTOM) {
            int nb = this.parent.getVisualContext().getFontHeight() - this.parent.getVisualContext().getBaselineOffset();
            dif = nb - b;
        } else if (va == CSSProperty.VerticalAlign.length || va == CSSProperty.VerticalAlign.percentage) {
            CSSDecoder dec = new CSSDecoder(box.getVisualContext());
            int len = dec.getLength(box.getLengthValue("vertical-align"), false, 0, 0, box.getLineHeight());
            dif = -len;
        }
        return dif;
    }
}

