/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.layout;

import com.androdome.iadventure.utils.IconManager;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.imageio.ImageIO;
import org.fit.cssbox.layout.ElementBox;
import org.fit.cssbox.layout.ReplacedContent;
import org.fit.cssbox.layout.VisualContext;

public class ReplacedImage
extends ReplacedContent
implements ImageObserver {
    private static boolean LOAD_IMAGES = true;
    private URL base;
    private URL url;
    private VisualContext ctx;
    private BufferedImage img;
    Graphics2D g = null;
    int width = 0;
    int height = 0;
    private boolean error = false;

    public ReplacedImage(ElementBox owner, VisualContext ctx, URL baseurl) {
        super(owner);
        this.ctx = ctx;
        this.base = baseurl;
        new Thread(){

            public void run() {
                block8: {
                    try {
                        String src = ReplacedImage.this.getOwner().getElement().getAttribute("src");
                        System.out.println(ReplacedImage.this.base);
                        ReplacedImage.this.url = new URL(ReplacedImage.this.base, src);
                        if (LOAD_IMAGES) {
                            System.err.println("Loading image: " + ReplacedImage.this.url);
                            ReplacedImage.this.img = ImageIO.read(ReplacedImage.this.url);
                            if (ReplacedImage.this.g != null) {
                                ReplacedImage.this.draw(ReplacedImage.this.g, ReplacedImage.this.width, ReplacedImage.this.height);
                            }
                        }
                    }
                    catch (MalformedURLException e) {
                        System.err.println("ImgBox: URL: " + e.getMessage());
                        ReplacedImage.this.img = null;
                        ReplacedImage.this.url = null;
                        ReplacedImage.this.error = true;
                        if (ReplacedImage.this.g != null) {
                            ReplacedImage.this.draw(ReplacedImage.this.g, ReplacedImage.this.width, ReplacedImage.this.height);
                        }
                    }
                    catch (IOException e) {
                        System.err.println("ImgBox: I/O: " + e.getMessage());
                        ReplacedImage.this.img = null;
                        ReplacedImage.this.error = true;
                        if (ReplacedImage.this.g != null) {
                            ReplacedImage.this.draw(ReplacedImage.this.g, ReplacedImage.this.width, ReplacedImage.this.height);
                        }
                    }
                    catch (IllegalArgumentException e) {
                        System.err.println("ImgBox: Format error: " + e.getMessage());
                        ReplacedImage.this.img = null;
                        ReplacedImage.this.error = true;
                        if (ReplacedImage.this.g == null) break block8;
                        ReplacedImage.this.draw(ReplacedImage.this.g, ReplacedImage.this.width, ReplacedImage.this.height);
                    }
                }
            }
        }.start();
    }

    public static void setLoadImages(boolean b) {
        LOAD_IMAGES = b;
    }

    public static boolean getLoadImages() {
        return LOAD_IMAGES;
    }

    public URL getUrl() {
        return this.url;
    }

    public BufferedImage getImage() {
        return this.img;
    }

    public void draw(Graphics2D g, int width, int height) {
        this.g = g;
        this.width = width;
        this.height = height;
        this.ctx.updateGraphics(g);
        if (this.img != null) {
            g.drawImage(this.img, this.getOwner().getAbsoluteContentX(), this.getOwner().getAbsoluteContentY(), width, height, this);
        } else if (this.error) {
            g.drawImage(IconManager.getImage("/stopscale.png"), this.getOwner().getAbsoluteContentX() + 2, this.getOwner().getAbsoluteContentY() + 2, 32, 32, this);
            g.setStroke(new BasicStroke(1.0f));
            g.drawRect(this.getOwner().getAbsoluteContentX(), this.getOwner().getAbsoluteContentY(), this.getOwner().getContentWidth() - 1, this.getOwner().getContentHeight() - 1);
        }
    }

    public int getIntrinsicHeight() {
        if (this.img != null) {
            return this.img.getHeight();
        }
        return 20;
    }

    public int getIntrinsicWidth() {
        if (this.img != null) {
            return this.img.getWidth();
        }
        return 20;
    }

    public float getIntrinsicRatio() {
        return (float)this.getIntrinsicWidth() / (float)this.getIntrinsicHeight();
    }

    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        return false;
    }
}

