/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.layout;

import cz.vutbr.web.css.CSSProperty;
import cz.vutbr.web.css.TermLengthOrPercent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import org.fit.cssbox.css.HTMLNorm;
import org.fit.cssbox.layout.BlockBox;
import org.fit.cssbox.layout.CSSDecoder;
import org.fit.cssbox.layout.FloatList;
import org.fit.cssbox.layout.InlineBox;
import org.fit.cssbox.layout.LengthSet;
import org.fit.cssbox.layout.TableColumn;
import org.fit.cssbox.layout.TableRowBox;
import org.fit.cssbox.layout.VisualContext;
import org.w3c.dom.Element;

public class TableCellBox
extends BlockBox {
    protected int colspan;
    protected int rowspan;
    protected int row;
    protected int column;
    protected TableRowBox ownerRow;
    protected TableColumn ownerColumn;
    protected int percent;

    public TableCellBox(Element n, Graphics2D g, VisualContext ctx) {
        super(n, g, ctx);
        this.isblock = true;
        this.loadAttributes();
        this.fleft = new FloatList(this);
        this.fright = new FloatList(this);
        this.overflow = OVERFLOW_HIDDEN;
    }

    public TableCellBox(InlineBox src) {
        super(src);
        this.isblock = true;
        this.loadAttributes();
        this.fleft = new FloatList(this);
        this.fright = new FloatList(this);
        this.overflow = OVERFLOW_HIDDEN;
    }

    public int getColspan() {
        return this.colspan;
    }

    public int getRowspan() {
        return this.rowspan;
    }

    public int getRow() {
        return this.row;
    }

    public int getColumn() {
        return this.column;
    }

    public TableRowBox getOwnerRow() {
        return this.ownerRow;
    }

    public void setOwnerRow(TableRowBox ownerRow) {
        this.ownerRow = ownerRow;
    }

    public TableColumn getOwnerColumn() {
        return this.ownerColumn;
    }

    public void setOwnerColumn(TableColumn ownerColumn) {
        this.ownerColumn = ownerColumn;
    }

    public void setCellPosition(int column, int row) {
        this.column = column;
        this.row = row;
    }

    public void setWidth(int width) {
        this.content.width = width - this.border.left - this.padding.left - this.padding.right - this.border.right;
        this.bounds.width = width;
        this.wset = true;
        this.updateChildSizes();
    }

    public void setHeight(int height) {
        this.content.height = height - this.border.top - this.padding.top - this.padding.bottom - this.border.bottom;
        this.bounds.height = height;
        this.hset = true;
    }

    public int getPercent() {
        return this.percent;
    }

    public String toString() {
        return String.valueOf(super.toString()) + "[" + this.column + "," + this.row + "]";
    }

    public int getMinimalWidth() {
        int ret = this.getMinimalContentWidth();
        return ret += this.margin.left + this.padding.left + this.border.left + this.margin.right + this.padding.right + this.border.right;
    }

    public int getMaximalWidth() {
        int ret = this.getMaximalContentWidth();
        return ret += this.margin.left + this.padding.left + this.border.left + this.margin.right + this.padding.right + this.border.right;
    }

    protected void loadSizes(boolean update) {
        boolean hauto;
        CSSDecoder dec = new CSSDecoder(this.ctx);
        if (this.cblock == null) {
            System.err.println(String.valueOf(this.toString()) + " has no cblock");
            return;
        }
        int contw = this.cblock.getContentWidth();
        if (!update) {
            this.loadBorders(dec, contw);
        }
        this.loadPadding(dec, contw);
        if (!update) {
            this.content = new Dimension(0, 0);
            this.margin = new LengthSet();
            this.emargin = new LengthSet();
            this.min_size = new Dimension(-1, -1);
            this.max_size = new Dimension(-1, -1);
            this.coords = new LengthSet();
        }
        CSSProperty.Width wprop = null;
        TermLengthOrPercent width = null;
        String widthattr = this.getElement().getAttribute("width");
        if (!widthattr.equals("")) {
            width = HTMLNorm.createLengthOrPercent(widthattr);
            if (width != null) {
                wprop = width.isPercentage() ? CSSProperty.Width.percentage : CSSProperty.Width.length;
            }
        } else {
            wprop = (CSSProperty.Width)this.style.getProperty("width");
            width = this.getLengthValue("width");
        }
        if (wprop == null || wprop == CSSProperty.Width.AUTO) {
            this.wset = false;
        } else {
            this.wset = true;
            if (!update) {
                this.content.width = dec.getLength(width, false, 0, 0, contw);
            }
            if (width.isPercentage()) {
                this.wrelative = true;
                this.percent = Math.round(((Float)width.getValue()).floatValue());
                if (this.percent == 0) {
                    this.wrelative = false;
                }
            }
        }
        String heightattr = this.getElement().getAttribute("height");
        CSSProperty.Height hprop = null;
        TermLengthOrPercent height = null;
        if (!heightattr.equals("")) {
            height = HTMLNorm.createLengthOrPercent(widthattr);
            if (height != null) {
                hprop = height.isPercentage() ? CSSProperty.Height.percentage : CSSProperty.Height.length;
            }
        } else {
            hprop = (CSSProperty.Height)this.style.getProperty("height");
            height = this.getLengthValue("height");
        }
        boolean bl = hauto = hprop == null || hprop == CSSProperty.Height.AUTO;
        if (this.cblock.hset) {
            boolean bl2 = this.hset = !hauto;
            if (!update) {
                this.content.height = dec.getLength(height, hauto, 0, 0, this.cblock.getContentHeight());
            }
        } else {
            boolean bl3 = this.hset = !hauto && !height.isPercentage();
            if (!update) {
                this.content.height = dec.getLength(height, hauto, 0, 0, 0);
            }
        }
    }

    public boolean hasFixedWidth() {
        return true;
    }

    public boolean hasFixedHeight() {
        return false;
    }

    public boolean canIncreaseWidth() {
        return true;
    }

    public void drawBackground(Graphics2D g) {
        Color color = g.getColor();
        int x = this.absbounds.x;
        int y = this.absbounds.y;
        int bx1 = x + this.margin.left;
        int by1 = y + this.margin.top;
        int bw = this.border.left + this.padding.left + this.content.width + this.padding.right + this.border.right;
        int bh = this.border.top + this.padding.top + this.content.height + this.padding.bottom + this.border.bottom;
        int bx2 = bx1 + bw - 1;
        int by2 = by1 + bh - 1;
        Color bg = this.bgcolor;
        if (bg == null) {
            bg = this.getOwnerRow().getBgcolor();
        }
        if (bg == null) {
            bg = this.getOwnerColumn().getBgcolor();
        }
        if (bg == null) {
            bg = this.getOwnerRow().getOwnerBody().getBgcolor();
        }
        if (bg != null) {
            g.setColor(bg);
            g.fillRect(bx1, by1, bw, bh);
        }
        this.drawBorders(g, bx1, by1, bx2, by2);
        g.setColor(color);
    }

    protected void loadAttributes() {
        try {
            this.colspan = !this.el.getAttribute("colspan").equals("") ? Integer.parseInt(this.el.getAttribute("colspan")) : 1;
            this.rowspan = !this.el.getAttribute("rowspan").equals("") ? Integer.parseInt(this.el.getAttribute("rowspan")) : 1;
        }
        catch (NumberFormatException e) {
            System.err.println("Invalid width value: " + e.getMessage());
        }
    }
}

