/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.layout;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.Vector;
import org.fit.cssbox.layout.BlockBox;
import org.fit.cssbox.layout.Box;
import org.fit.cssbox.layout.BoxFactory;
import org.fit.cssbox.layout.InlineBox;
import org.fit.cssbox.layout.LengthSet;
import org.fit.cssbox.layout.TableBodyBox;
import org.fit.cssbox.layout.TableCellBox;
import org.fit.cssbox.layout.VisualContext;
import org.w3c.dom.Element;

public class TableRowBox
extends BlockBox {
    protected Vector<TableCellBox> cells;
    protected Iterator<TableCellBox> cursor;
    protected TableBodyBox ownerBody;

    public TableRowBox(Element n, Graphics2D g, VisualContext ctx) {
        super(n, g, ctx);
        this.isblock = true;
    }

    public TableRowBox(InlineBox src) {
        super(src);
        this.isblock = true;
    }

    public void addCell(TableCellBox cell) {
        if (this.cells == null) {
            this.organizeContent();
        }
        this.cells.add(cell);
        cell.setOwnerRow(this);
    }

    public int getCellCount() {
        if (this.cells == null) {
            this.organizeContent();
        }
        return this.cells.size();
    }

    public TableCellBox getCell(int index) {
        if (this.cells == null) {
            this.organizeContent();
        }
        return this.cells.elementAt(index);
    }

    public void rewind() {
        this.cursor = this.cells.iterator();
    }

    public TableCellBox next() {
        if (this.cursor == null) {
            this.rewind();
        }
        return this.cursor.next();
    }

    public boolean hasNext() {
        if (this.cursor == null) {
            this.rewind();
        }
        return this.cursor.hasNext();
    }

    public TableBodyBox getOwnerBody() {
        return this.ownerBody;
    }

    public void setOwnerBody(TableBodyBox ownerBody) {
        this.ownerBody = ownerBody;
    }

    public boolean doLayout(int widthlimit, boolean force, boolean linestart) {
        return true;
    }

    public void absolutePositions() {
        int x = this.cblock.getAbsoluteContentX() + this.bounds.x;
        int y = this.cblock.getAbsoluteContentY() + this.bounds.y;
        if (this.position == POS_RELATIVE) {
            x += this.leftset ? this.coords.left : -this.coords.right;
            y += this.topset ? this.coords.top : -this.coords.bottom;
        }
        this.absbounds.x = x;
        this.absbounds.y = y;
        this.absbounds.width = this.bounds.width;
        this.absbounds.height = this.bounds.height;
        if (this.isDisplayed()) {
            for (TableCellBox child : this.cells) {
                x = this.getAbsoluteContentX() + child.getBounds().x;
                y = this.getAbsoluteContentY() + child.getBounds().y;
                if (child.position == POS_RELATIVE) {
                    x += child.leftset ? child.coords.left : -child.coords.right;
                    y += child.topset ? child.coords.top : -child.coords.bottom;
                }
                child.absbounds.x = x;
                child.absbounds.y = y;
                child.absbounds.width = child.bounds.width;
                child.absbounds.height = child.bounds.height;
                int j = child.getStartChild();
                while (j < child.getEndChild()) {
                    child.getSubBox(j).absolutePositions();
                    ++j;
                }
            }
        }
    }

    protected void loadSizes(boolean update) {
        if (!update) {
            this.content = new Dimension(0, 0);
            this.bounds = new Rectangle(0, 0, 0, 0);
            this.emargin = this.margin = new LengthSet();
            this.padding = new LengthSet();
            this.border = new LengthSet();
            this.min_size = new Dimension(-1, -1);
            this.max_size = new Dimension(-1, -1);
            this.coords = new LengthSet();
        }
        this.content.width = this.cblock.getContentWidth();
    }

    public void drawBackground(Graphics2D g) {
    }

    private void organizeContent() {
        this.cells = new Vector();
        BlockBox anoncell = null;
        Iterator it = this.nested.iterator();
        while (it.hasNext()) {
            Box box = (Box)it.next();
            if (box instanceof TableCellBox) {
                this.addCell((TableCellBox)box);
                if (anoncell != null) {
                    ((TableCellBox)anoncell).endChild = ((TableCellBox)anoncell).nested.size();
                    this.addSubBox(anoncell);
                }
                anoncell = null;
                continue;
            }
            if (anoncell == null) {
                Element anonelem = BoxFactory.getInstance().createAnonymousElement(this.getParent().getParent().getParent().getElement().getOwnerDocument(), "td", "table-cell");
                anoncell = new TableCellBox(anonelem, this.g, this.ctx);
                anoncell.setStyle(BoxFactory.getInstance().createAnonymousStyle("table-cell"));
                anoncell.adoptParent(this);
                this.addCell((TableCellBox)anoncell);
            }
            anoncell.addSubBox(box);
            ((TableCellBox)anoncell).isempty = false;
            if (box.isBlock()) {
                ((TableCellBox)anoncell).contblock = true;
            }
            box.setContainingBlock(anoncell);
            box.setParent(anoncell);
            it.remove();
            --this.endChild;
        }
        if (anoncell != null) {
            ((TableCellBox)anoncell).endChild = ((TableCellBox)anoncell).nested.size();
            this.addSubBox(anoncell);
        }
    }
}

