/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.layout;

import cz.vutbr.web.css.CSSProperty;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import org.fit.cssbox.layout.Box;
import org.fit.cssbox.layout.ElementBox;
import org.fit.cssbox.layout.Inline;
import org.fit.cssbox.layout.VisualContext;
import org.w3c.dom.Text;

public class TextBox
extends Box
implements Inline {
    protected Text textNode;
    protected String text;
    protected int textStart;
    protected int textEnd;
    protected int maxwidth;
    protected int minwidth;
    protected boolean ignoreinitialws;
    protected boolean collapsews;

    public TextBox(Text n, Graphics2D g, VisualContext ctx) {
        super(n, g, ctx);
        this.textNode = n;
        this.setWhiteSpace(ElementBox.WHITESPACE_NORMAL);
        ctx.updateForGraphics(null, g);
        this.minwidth = this.computeMinimalWidth();
        this.maxwidth = this.computeMaximalWidth();
        this.ignoreinitialws = false;
        this.collapsews = true;
    }

    public void copyValues(TextBox src) {
        super.copyValues(src);
        this.text = new String(src.text);
        this.ignoreinitialws = false;
        this.collapsews = src.collapsews;
    }

    public TextBox copyTextBox() {
        TextBox ret = new TextBox(this.textNode, this.g, this.ctx);
        ret.copyValues(this);
        return ret;
    }

    public String toString() {
        return "Text: " + this.text + "<" + this.textStart + "," + this.textEnd + ">";
    }

    public void initBox() {
    }

    public void setParent(ElementBox parent) {
        CSSProperty.WhiteSpace ws;
        super.setParent(parent);
        if (this.getParent() != null && (ws = this.getParent().getWhiteSpace()) != ElementBox.WHITESPACE_NORMAL) {
            this.setWhiteSpace(ws);
        }
    }

    public String getText() {
        if (this.text != null) {
            return this.text.substring(this.textStart, this.textEnd);
        }
        return "";
    }

    public boolean isDeclaredVisible() {
        return true;
    }

    public boolean isDisplayed() {
        if (this.getParent() == null) {
            return true;
        }
        return this.parent.isDisplayed();
    }

    public boolean isVisible() {
        if (this.getParent() == null) {
            return true;
        }
        return this.parent.isVisible();
    }

    public void setWhiteSpace(CSSProperty.WhiteSpace value) {
        boolean bl = this.collapsews = value == ElementBox.WHITESPACE_NORMAL || value == ElementBox.WHITESPACE_NOWRAP || value == ElementBox.WHITESPACE_PRE_LINE;
        if (!this.splitted) {
            this.applyWhiteSpace();
        }
    }

    private void applyWhiteSpace() {
        this.text = this.collapsews ? this.collapseWhitespaces(this.node.getNodeValue()) : this.node.getNodeValue();
        this.textStart = 0;
        this.textEnd = this.text.length();
        this.isempty = this.textEnd == 0;
    }

    private String collapseWhitespaces(String src) {
        StringBuffer ret = new StringBuffer();
        boolean inws = false;
        int i = 0;
        while (i < src.length()) {
            char ch = src.charAt(i);
            if (Character.isWhitespace(ch)) {
                if (!inws) {
                    ret.append(' ');
                    inws = true;
                }
            } else {
                inws = false;
                ret.append(ch);
            }
            ++i;
        }
        return new String(ret);
    }

    protected int getTextStart() {
        return this.textStart;
    }

    protected void setTextStart(int index) {
        this.textStart = index;
    }

    protected int getTextEnd() {
        return this.textEnd;
    }

    protected void setTextEnd(int index) {
        this.textEnd = index;
    }

    public boolean affectsDisplay() {
        return !this.isEmpty();
    }

    public boolean isWhitespace() {
        return this.getText().trim().length() == 0;
    }

    public boolean collapsesSpaces() {
        return this.collapsews;
    }

    public int getContentX() {
        return this.bounds.x;
    }

    public int getAbsoluteContentX() {
        return this.absbounds.x;
    }

    public int getContentY() {
        return this.bounds.y;
    }

    public int getAbsoluteContentY() {
        return this.absbounds.y;
    }

    public int getContentWidth() {
        return this.bounds.width;
    }

    public int getContentHeight() {
        return this.bounds.height;
    }

    public int getAvailableContentWidth() {
        return this.availwidth;
    }

    public int getLineHeight() {
        return this.parent.getLineHeight();
    }

    public int getMaxLineHeight() {
        return this.parent.getLineHeight();
    }

    public int getTotalLineHeight() {
        return this.ctx.getFontHeight();
    }

    public int getBaselineOffset() {
        return this.ctx.getBaselineOffset();
    }

    public int getBelowBaseline() {
        return this.ctx.getFontHeight() - this.ctx.getBaselineOffset();
    }

    public int getHalfLead() {
        return 0;
    }

    public int totalHeight() {
        return this.bounds.width;
    }

    public int totalWidth() {
        return this.bounds.height;
    }

    public Rectangle getMinimalAbsoluteBounds() {
        return this.absbounds;
    }

    public boolean isInFlow() {
        return true;
    }

    public boolean containsFlow() {
        return false;
    }

    public boolean canSplitInside() {
        return this.getText().indexOf(32) != -1;
    }

    public boolean canSplitBefore() {
        if (this.textEnd > this.textStart) {
            return this.text.charAt(this.textStart) == ' ' || this.textStart > 0 && this.text.charAt(this.textStart - 1) == ' ';
        }
        return false;
    }

    public boolean canSplitAfter() {
        if (this.textEnd > this.textStart) {
            return this.text.charAt(this.textEnd - 1) == ' ' || this.textEnd < this.text.length() && this.text.charAt(this.textEnd) == ' ';
        }
        return false;
    }

    public boolean startsWithWhitespace() {
        if (this.textEnd > this.textStart) {
            return Character.isWhitespace(this.text.charAt(this.textStart));
        }
        return false;
    }

    public boolean endsWithWhitespace() {
        if (this.textEnd > this.textStart) {
            return Character.isWhitespace(this.text.charAt(this.textEnd - 1));
        }
        return false;
    }

    public void setIgnoreInitialWhitespace(boolean b) {
        this.ignoreinitialws = b;
    }

    public boolean hasFixedWidth() {
        return false;
    }

    public boolean hasFixedHeight() {
        return false;
    }

    public boolean doLayout(int widthlimit, boolean force, boolean linestart) {
        if (!this.displayed) {
            this.bounds.setSize(0, 0);
            return true;
        }
        this.setAvailableWidth(widthlimit);
        boolean split = false;
        int wlimit = this.getAvailableContentWidth();
        boolean empty = this.text.trim().length() == 0;
        int end = this.text.length();
        FontMetrics fm = this.g.getFontMetrics();
        int w = 0;
        int h = 0;
        if (!empty || !linestart) {
            if ((linestart || this.ignoreinitialws) && this.collapsews) {
                while (this.textStart < end && this.text.charAt(this.textStart) == ' ') {
                    ++this.textStart;
                }
            }
            do {
                w = fm.stringWidth(this.text.substring(this.textStart, end));
                h = fm.getHeight();
                if (w <= wlimit) continue;
                if (empty) {
                    w = 0;
                    h = 0;
                    split = false;
                    break;
                }
                int wordend = this.text.substring(0, end).lastIndexOf(32);
                while (wordend > 0 && this.text.charAt(wordend - 1) == ' ') {
                    --wordend;
                }
                if (wordend <= this.textStart) {
                    if (!force) {
                        end = this.textStart;
                        split = false;
                        break;
                    }
                    split = true;
                    break;
                }
                end = wordend;
                split = true;
            } while (end > this.textStart && w > wlimit);
        }
        this.textEnd = end;
        this.bounds.setSize(w, h);
        if (split) {
            int start = this.textEnd;
            while (start < this.text.length() && this.text.charAt(start) == ' ') {
                ++start;
            }
            if (start < this.text.length()) {
                TextBox rtext = this.copyTextBox();
                rtext.splitted = true;
                rtext.setTextStart(start);
                this.rest = rtext;
            } else {
                this.rest = null;
            }
        } else {
            this.rest = null;
        }
        return this.textEnd > this.textStart || empty;
    }

    public void absolutePositions() {
        if (this.displayed) {
            this.absbounds.x = this.getParent().getAbsoluteContentX() + this.bounds.x;
            this.absbounds.y = this.getParent().getAbsoluteContentY() + this.bounds.y;
            this.absbounds.width = this.bounds.width;
            this.absbounds.height = this.bounds.height;
        }
    }

    public int getMinimalWidth() {
        return this.minwidth;
    }

    private int computeMinimalWidth() {
        int ret = 0;
        String t = this.getText();
        if (t.length() > 0) {
            FontMetrics fm = this.g.getFontMetrics();
            int s1 = 0;
            int s2 = t.indexOf(32);
            do {
                int w;
                if (s2 == -1) {
                    s2 = t.length();
                }
                if ((w = fm.stringWidth(t.substring(s1, s2))) > ret) {
                    ret = w;
                }
                s1 = s2 + 1;
                s2 = t.indexOf(32, s1);
            } while (s1 < t.length() && s2 < t.length());
        }
        return ret;
    }

    public int getMaximalWidth() {
        return this.maxwidth;
    }

    private int computeMaximalWidth() {
        FontMetrics fm = this.g.getFontMetrics();
        return fm.stringWidth(this.getText());
    }

    protected void drawContent(Graphics2D g) {
        int x = this.absbounds.x;
        int y = this.absbounds.y;
        if (this.textEnd > this.textStart) {
            String t = this.text.substring(this.textStart, this.textEnd);
            FontMetrics fm = g.getFontMetrics();
            Rectangle2D rect = fm.getStringBounds(t, g);
            Shape oldclip = g.getClip();
            g.setClip(this.clipblock.getAbsoluteContentBounds());
            g.drawString(t, x + (int)rect.getX(), y - (int)rect.getY());
            g.setClip(oldclip);
        }
    }

    public void draw(Graphics2D g, int turn, int mode) {
        if (!(!this.displayed || turn != 0 && turn != 1 || mode != 0 && mode != 1)) {
            this.drawContent(g);
        }
    }

    public void drawExtent(Graphics2D g) {
        g.setColor(Color.ORANGE);
        g.drawRect(this.absbounds.x, this.absbounds.y, this.bounds.width, this.bounds.height);
        int i = 0;
        while (i < this.getText().length()) {
            if (i != 0) {
                System.out.print(" : ");
            }
            char ch = this.getText().charAt(i);
            System.out.print(ch);
            System.out.print((int)ch);
            if (Character.isWhitespace(ch)) {
                System.out.print("!");
            }
            if (Character.isSpaceChar(ch)) {
                System.out.print("*");
            }
            ++i;
        }
        System.out.println();
    }
}

