/*
 * Decompiled with CFR 0.152.
 */
package test;

import cz.vutbr.web.css.CSSException;
import cz.vutbr.web.css.CSSFactory;
import cz.vutbr.web.css.CSSProperty;
import cz.vutbr.web.css.NodeData;
import cz.vutbr.web.css.StyleSheet;
import cz.vutbr.web.css.Term;
import cz.vutbr.web.css.TermColor;
import cz.vutbr.web.css.TermFactory;
import cz.vutbr.web.css.TermList;
import cz.vutbr.web.domassign.Analyzer;
import cz.vutbr.web.domassign.StyleMap;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Date;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import test.DOMSource;
import test.ElementMap;

public class AdvancedCSS {
    private static Logger log = LoggerFactory.getLogger(AdvancedCSS.class);
    private static TermFactory tf = CSSFactory.getTermFactory();
    private static Document doc;
    private static StyleSheet sheet;
    private static Analyzer analyzer;
    private static ElementMap elements;
    private static StyleMap decl;

    @BeforeClass
    public static void init() throws IOException, CSSException, SAXException {
        log.info("\n\n\n == AdvancedTest test at {} == \n\n\n", new Date());
        DOMSource ds = new DOMSource(new FileInputStream("data/advanced/style.html"));
        doc = ds.parse();
        sheet = CSSFactory.parse("data/advanced/style.css", null);
        analyzer = new Analyzer(sheet);
        decl = analyzer.evaluateDOM(doc, "all", true);
        elements = new ElementMap(doc);
    }

    @Test
    public void testBP() {
        Element bp = elements.getElementById("bp");
        Assert.assertNotNull((String)"Element bp exists", (Object)bp);
        NodeData data = (NodeData)decl.get(bp);
        Assert.assertNotNull((String)"Data for #bp exist", (Object)data);
        log.debug("{}", data);
        Assert.assertEquals((String)"Background position is list of two", (long)2L, (long)data.getValue(TermList.class, "background-position").size());
        Assert.assertEquals((Object)tf.createPercent(Float.valueOf(50.0f)), data.getValue(TermList.class, "background-position").get(0));
        Assert.assertEquals((Object)tf.createPercent(Float.valueOf(100.0f)), data.getValue(TermList.class, "background-position").get(1));
        Assert.assertEquals((Object)tf.createColor(255, 255, 255), (Object)data.getValue(TermColor.class, "color"));
    }

    @Test
    public void testFF() {
        NodeData data = (NodeData)decl.get(elements.getElementById("ff"));
        log.debug("{}", data);
        Assert.assertEquals((String)"Font family contains two fonts ", (long)2L, (long)data.getValue(TermList.class, "font-family").size());
        Assert.assertEquals((String)"Which is serif", tf.createTerm(CSSProperty.FontFamily.SERIF), data.getValue(TermList.class, "font-family").get(0));
        Assert.assertEquals((String)"Which is 'Times New Roman'", tf.createString("Times New Roman").setOperator(Term.Operator.COMMA), data.getValue(TermList.class, "font-family").get(1));
    }

    @Test
    public void testBorder() {
        NodeData data = (NodeData)decl.get(elements.getElementById("border"));
        Assert.assertEquals((String)"", (Object)tf.createColor(255, 255, 255), (Object)data.getValue(TermColor.class, "border-bottom-color"));
    }
}

