/*
 * Decompiled with CFR 0.152.
 */
package test;

import cz.vutbr.web.css.CSSException;
import cz.vutbr.web.css.CSSFactory;
import cz.vutbr.web.css.CSSProperty;
import cz.vutbr.web.css.NodeData;
import cz.vutbr.web.css.StyleSheet;
import cz.vutbr.web.css.SupportedCSS;
import cz.vutbr.web.css.Term;
import cz.vutbr.web.css.TermColor;
import cz.vutbr.web.css.TermLength;
import cz.vutbr.web.css.TermNumeric;
import cz.vutbr.web.domassign.Analyzer;
import cz.vutbr.web.domassign.StyleMap;
import cz.vutbr.web.domassign.Traversal;
import java.awt.Color;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Date;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.TreeWalker;
import org.xml.sax.SAXException;
import test.DOMSource;
import test.ElementMap;

public class AnalyzerTest {
    private static Logger log = LoggerFactory.getLogger(AnalyzerTest.class);
    private static final SupportedCSS css = CSSFactory.getSupportedCSS();
    private static Document doc;
    private static StyleSheet sheet;
    private static Analyzer analyzer;
    private static TreeWalker walker;
    private static ElementMap elements;

    @BeforeClass
    public static void init() throws IOException, CSSException, SAXException {
        log.info("\n\n\n == AnalyzerTest test at {} == \n\n\n", new Date());
        DOMSource ds = new DOMSource(new FileInputStream("data/simple/data.html"));
        doc = ds.parse();
        sheet = CSSFactory.parse("data/simple/data.css", null);
        analyzer = new Analyzer(sheet);
        NodeList list = doc.getElementsByTagName("body");
        Assert.assertEquals((String)"There is one <body> element", (long)1L, (long)list.getLength());
        DocumentTraversal traversal = (DocumentTraversal)((Object)doc);
        walker = traversal.createTreeWalker(list.item(0), 1, null, false);
        elements = new ElementMap(doc);
    }

    @Test
    public void evaluateSimple() {
        StyleMap decl = analyzer.evaluateDOM(doc, "all", false);
        Node current = walker.getCurrentNode();
        NodeData data = current instanceof Element ? (NodeData)decl.get((Element)current) : null;
        Assert.assertEquals((String)"<body> nodedata contains color", (Object)CSSProperty.Color.color, data.getProperty("color"));
        Assert.assertEquals((String)"color declaration contains red color", (Object)new Color(255, 0, 0), data.getValue(TermColor.class, "color").getValue());
        Assert.assertEquals((String)"<body> nodedata contains font-weight: 200", (Object)CSSProperty.FontWeight.numeric_200, data.getProperty("font-weight"));
        walker.setCurrentNode(current);
    }

    @Test
    public void testRepeaterOnMargin() {
        StyleMap decl = analyzer.evaluateDOM(doc, "all", false);
        Element marginator = elements.getElementById("marginator");
        Assert.assertNotNull((String)"Element marginator exists", (Object)marginator);
        NodeData data = (NodeData)decl.get(marginator);
        Assert.assertEquals((String)"<div id=\"marginator\"> contains margin with for same values", (Object)CSSProperty.Margin.length, data.getProperty("margin-top"));
        Assert.assertEquals((String)"<div id=\"marginator\"> contains margin with for same values", (Object)CSSProperty.Margin.length, data.getProperty("margin-bottom"));
        Assert.assertEquals((String)"Margin of 100px", (Object)new Float(100.0f), data.getValue(TermLength.class, "margin-top").getValue());
        Assert.assertEquals((String)"Margin of 100px", (Object)((Object)TermNumeric.Unit.px), (Object)((Object)data.getValue(TermLength.class, "margin-top").getUnit()));
        Assert.assertEquals((String)"for all for both values", (Object)data.getValue(TermLength.class, "margin-bottom"), (Object)data.getValue(TermLength.class, "margin-left"));
    }

    @Test
    public void testVariatorOnBorderTop() {
        StyleMap decl = analyzer.evaluateDOM(doc, "all", false);
        Element marginator = elements.getElementById("marginator");
        Assert.assertNotNull((String)"Element marginator exists", (Object)marginator);
        NodeData data = (NodeData)decl.get(marginator);
        Assert.assertEquals((String)"border-top-style: dotted", (Object)CSSProperty.BorderStyle.DOTTED, data.getProperty("border-top-style"));
    }

    @Test
    public void testFontFamily() {
        StyleMap decl = analyzer.evaluateDOM(doc, "all", false);
        Element fontoid = elements.getElementById("fontoid");
        Assert.assertNotNull((String)"Element fontoid exist", (Object)fontoid);
        NodeData data = (NodeData)decl.get(fontoid);
        Assert.assertEquals((String)"font-family: monospace", (Object)CSSProperty.FontFamily.MONOSPACE, data.getProperty("font-family"));
    }

    @Test
    public void inheritanceDiffers() {
        StyleMap declInh = analyzer.evaluateDOM(doc, "all", true);
        StyleMap decl = analyzer.evaluateDOM(doc, "all", false);
        Pair<StyleMap, StyleMap> pair = new Pair<StyleMap, StyleMap>(declInh, decl);
        Traversal<Boolean> traversal = new Traversal<Boolean>(doc, pair, 1){

            @Override
            protected void processNode(Boolean result, Node current, Object source) {
                Pair pair = (Pair)source;
                Element e = (Element)current;
                NodeData ndInh = (NodeData)((StyleMap)pair.getFirst()).get(e);
                NodeData nd = (NodeData)((StyleMap)pair.getSecond()).get(e);
                String id = e.getAttribute("id");
                if (id != null) {
                    Assert.assertNotSame((String)("Inherited differs for #" + id), (Object)ndInh, (Object)nd);
                }
            }
        };
        traversal.levelTraversal(null);
    }

    @Test
    public void inheritanceNoInheritedValues() {
        StyleMap declInh = analyzer.evaluateDOM(doc, "all", true);
        StyleMap decl = analyzer.evaluateDOM(doc, "all", false);
        Pair<StyleMap, StyleMap> pair = new Pair<StyleMap, StyleMap>(declInh, decl);
        Traversal<Boolean> traversal = new Traversal<Boolean>(doc, pair, 1){

            @Override
            protected void processNode(Boolean result, Node current, Object source) {
                Pair pair = (Pair)source;
                Element e = (Element)current;
                NodeData ndInh = (NodeData)((StyleMap)pair.getFirst()).get(e);
                NodeData nd = (NodeData)((StyleMap)pair.getSecond()).get(e);
                for (String property : css.getDefinedPropertyNames()) {
                    Object inh = ndInh.getProperty(property, false);
                    Object noinh = nd.getProperty(property, true);
                    if (inh != null && noinh == null || inh == null && noinh != null) {
                        Assert.fail((String)"No consitency between inheride and not inherited properties");
                    }
                    if (inh == null && noinh == null) continue;
                    log.debug("{}#{} (INH: {} NOINH: {})", new Object[]{e.getNodeName(), e.getAttribute("id"), inh, noinh});
                    Term tinh = ndInh.getValue(Term.class, property, false);
                    Term tnoinh = nd.getValue(Term.class, property, true);
                    if (tinh != null && tnoinh == null || tinh == null && tnoinh != null) {
                        Assert.fail((String)"No consitency between inheride and not inherited values");
                    }
                    if (tinh == null && tnoinh == null) continue;
                    log.debug("{}#{} (INH: {} NOINH: {})", new Object[]{e.getNodeName(), e.getAttribute("id"), tinh, tnoinh});
                }
            }
        };
        traversal.levelTraversal(null);
    }

    static class Pair<T, V> {
        private T first;
        private V second;

        public Pair(T first, V second) {
            this.first = first;
            this.second = second;
        }

        public T getFirst() {
            return this.first;
        }

        public V getSecond() {
            return this.second;
        }
    }
}

