/*
 * Decompiled with CFR 0.152.
 */
package test;

import cz.vutbr.web.css.CSSFactory;
import cz.vutbr.web.css.NodeData;
import cz.vutbr.web.css.TermColor;
import cz.vutbr.web.css.TermFactory;
import cz.vutbr.web.css.TermList;
import cz.vutbr.web.domassign.StyleMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import test.DOMSource;
import test.ElementMap;

public class DOMAssign {
    private static final Logger log = LoggerFactory.getLogger(DOMAssign.class);
    private static Document doc;
    private static ElementMap elements;
    private static TermFactory tf;

    static {
        tf = CSSFactory.getTermFactory();
    }

    @BeforeClass
    public static void init() throws SAXException, IOException {
        log.info("\n\n\n == DOMAssign test at {} == \n\n\n", new Date());
        DOMSource ds = new DOMSource(new FileInputStream("data/advanced/domassign.html"));
        doc = ds.parse();
        elements = new ElementMap(doc);
    }

    @Test
    public void test() throws MalformedURLException {
        StyleMap decl = CSSFactory.assignDOM(doc, DOMAssign.createBaseFromFilename("data/advanced/domassign.html"), "screen", true);
        NodeData data = (NodeData)decl.get(elements.getElementById("bp"));
        Assert.assertNotNull((String)"Data for #bp exist", (Object)data);
        Assert.assertThat((Object)data.getValue(TermList.class, "background-position").size(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)data.getValue(TermColor.class, "color"), (Matcher)Is.is((Object)tf.createColor(255, 255, 255)));
        data = (NodeData)decl.get(elements.getElementById("battlecruiser"));
        Assert.assertThat((Object)tf.createColor(255, 255, 0), (Matcher)Is.is((Object)data.getValue(TermColor.class, "color")));
        data = (NodeData)decl.get(elements.getElementById("border"));
        Assert.assertNotNull((String)"Data for #border exist", (Object)data);
        Assert.assertThat((Object)data.getValue(TermColor.class, "border-bottom-color"), (Matcher)Is.is((Object)tf.createColor(255, 255, 255)));
    }

    private static URL createBaseFromFilename(String filename) {
        try {
            File f = new File(filename);
            return f.toURI().toURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

