/*
 * Decompiled with CFR 0.152.
 */
package test;

import cz.vutbr.web.css.CSSFactory;
import cz.vutbr.web.css.Declaration;
import cz.vutbr.web.css.RuleFactory;
import cz.vutbr.web.css.Term;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DeclarationsUtil {
    private static final RuleFactory rf = CSSFactory.getRuleFactory();

    public static Declaration createDeclaration(String property, boolean important, List<Term<?>> terms) {
        Declaration dec = (Declaration)rf.createDeclaration().replaceAll(terms);
        dec.setProperty(property);
        dec.setImportant(important);
        return dec;
    }

    public static List<Declaration> appendDeclaration(List<Declaration> declarations, String property, boolean important, List<Term<?>> terms) {
        if (declarations == null) {
            declarations = new ArrayList<Declaration>();
        }
        declarations.add(DeclarationsUtil.createDeclaration(property, important, terms));
        return declarations;
    }

    public static List<Term<?>> appendTerm(List<Term<?>> terms, Term.Operator op, Term<?> term) {
        if (terms == null) {
            terms = new ArrayList();
        }
        term.setOperator(op);
        terms.add(term);
        return terms;
    }

    public static Declaration createDeclaration(String property, List<Term<?>> terms) {
        return DeclarationsUtil.createDeclaration(property, false, terms);
    }

    public static Declaration createDeclaration(String property, Term<?> ... terms) {
        return DeclarationsUtil.createDeclaration(property, Arrays.asList(terms));
    }

    public static Declaration createDeclaration(String property, boolean important, Term<?> ... terms) {
        return DeclarationsUtil.createDeclaration(property, important, Arrays.asList(terms));
    }

    public static List<Declaration> appendDeclaration(List<Declaration> declarations, String property, List<Term<?>> terms) {
        return DeclarationsUtil.appendDeclaration(declarations, property, false, terms);
    }

    public static List<Declaration> appendDeclaration(List<Declaration> declarations, String property, boolean important, Term<?> ... terms) {
        return DeclarationsUtil.appendDeclaration(declarations, property, false, Arrays.asList(terms));
    }

    public static List<Declaration> appendDeclaration(List<Declaration> declarations, String property, Term<?> ... terms) {
        return DeclarationsUtil.appendDeclaration(declarations, property, Arrays.asList(terms));
    }

    public static List<Term<?>> appendSpaceTerm(List<Term<?>> terms, Term<?> term) {
        return DeclarationsUtil.appendTerm(terms, Term.Operator.SPACE, term);
    }

    public static List<Term<?>> appendCommaTerm(List<Term<?>> terms, Term<?> term) {
        return DeclarationsUtil.appendTerm(terms, Term.Operator.COMMA, term);
    }

    public static List<Term<?>> appendSlashTerm(List<Term<?>> terms, Term<?> term) {
        return DeclarationsUtil.appendTerm(terms, Term.Operator.SLASH, term);
    }
}

