/*
 * Decompiled with CFR 0.152.
 */
package test;

import cz.vutbr.web.css.CSSException;
import cz.vutbr.web.css.CSSFactory;
import cz.vutbr.web.css.CSSProperty;
import cz.vutbr.web.css.Declaration;
import cz.vutbr.web.css.NodeData;
import cz.vutbr.web.css.StyleSheet;
import cz.vutbr.web.css.SupportedCSS;
import cz.vutbr.web.css.Term;
import cz.vutbr.web.domassign.Analyzer;
import cz.vutbr.web.domassign.QuadrupleMapNodeData;
import cz.vutbr.web.domassign.SingleMapNodeData;
import cz.vutbr.web.domassign.StyleMap;
import cz.vutbr.web.domassign.Traversal;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.BitSet;
import java.util.Date;
import java.util.Map;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import test.DOMSource;

@Ignore
public class NodeDataVariant {
    private static Logger log = LoggerFactory.getLogger(NodeDataVariant.class);
    private static SupportedCSS css = CSSFactory.getSupportedCSS();
    private static Document doc;
    private static Analyzer analyzer;

    @BeforeClass
    public static void init() throws CSSException, IOException, SAXException {
        log.info("\n\n\n == NodeDataVariant test at {} == \n\n\n", new Date());
        DOMSource ds = new DOMSource(new FileInputStream("data/simple/data.html"));
        doc = ds.parse();
        StyleSheet style = CSSFactory.parse("data/simple/data.css", null);
        analyzer = new Analyzer(style);
    }

    @Test
    @Ignore
    public void testMemoryAllocationEmpty() throws Exception {
        long sm = this.memoryUsage(SingleMapNodeData.class);
        long qm = this.memoryUsage(QuadrupleMapNodeData.class);
        long ea = this.memoryUsage(NodeDataEnumArray.class);
        log.debug("===\nMemory test: SingleMap {}B, QuadrupleMap {}B, NodeDataEnumArray {}B", new Object[]{sm, qm, ea});
    }

    @Test
    public void testTimeUsage() throws Exception {
        long sm = this.timeUsage(SingleMapNodeData.class);
        long qm = this.timeUsage(QuadrupleMapNodeData.class);
        long ea = this.timeUsage(NodeDataEnumArray.class);
        log.debug("===\nTime test: SingleMap {}ms, QuadrupleMap {}ms, NodeDataEnumArray {}ms", new Object[]{sm, qm, ea});
    }

    @Test
    public void testInheritance() throws Exception {
        int SAMPLE = 100;
        long sm = 0L;
        long smt = 0L;
        long qm = 0L;
        long qmt = 0L;
        long tmp = 0L;
        int i = 0;
        while (i < 100) {
            tmp = System.currentTimeMillis();
            this.inheritance(SingleMapNodeData.class);
            smt += System.currentTimeMillis() - tmp;
            ++i;
        }
        smt = Math.round((float)smt / 100.0f);
        i = 0;
        while (i < 100) {
            tmp = System.currentTimeMillis();
            this.inheritance(QuadrupleMapNodeData.class);
            qmt += System.currentTimeMillis() - tmp;
            ++i;
        }
        qmt = Math.round((float)qmt / 100.0f);
        log.debug("===\nInheritance tests Quadruple map {}B at {}ms, SingleMap {}B at {}ms", new Object[]{qm, qmt, sm, smt});
    }

    private void inheritance(Class<? extends NodeData> clazz) {
        CSSFactory.registerNodeDataInstance(clazz);
        StyleMap declInh = analyzer.evaluateDOM(doc, "all", true);
        StyleMap decl = analyzer.evaluateDOM(doc, "all", false);
        Pair<StyleMap, StyleMap> pair = new Pair<StyleMap, StyleMap>(declInh, decl);
        Traversal<Boolean> traversal = new Traversal<Boolean>(doc, pair, 1){

            @Override
            protected void processNode(Boolean result, Node current, Object source) {
                Pair pair = (Pair)source;
                Element e = (Element)current;
                NodeData ndInh = (NodeData)((Map)pair.getFirst()).get(e);
                NodeData nd = (NodeData)((Map)pair.getSecond()).get(e);
                String id = e.getAttribute("id");
                if (id != null) {
                    Assert.assertNotSame((String)("Inherited differs for #" + id), (Object)ndInh, (Object)nd);
                }
            }
        };
        traversal.levelTraversal(null);
    }

    private long timeUsage(Class<? extends NodeData> clazz) throws Exception {
        int SAMPLE = 100000;
        CSSFactory.registerNodeDataInstance(clazz);
        long timeBefore = System.currentTimeMillis();
        int i = 0;
        while (i < 100000) {
            CSSFactory.createNodeData();
            ++i;
        }
        long timeAfter = System.currentTimeMillis();
        return timeAfter - timeBefore;
    }

    private long memoryUsage(Class<? extends NodeData> clazz) throws Exception {
        int SAMPLE = 100;
        CSSFactory.registerNodeDataInstance(clazz);
        Object[] holder = new Object[100];
        NodeData throwAway = clazz.newInstance();
        int i = 0;
        long memoryUsageBefore = this.memoryUsage();
        i = 0;
        while (i < 100) {
            holder[i] = CSSFactory.createNodeData();
            ++i;
        }
        long memoryUsageAfter = this.memoryUsage();
        return Math.round((float)(memoryUsageAfter - memoryUsageBefore) / 100.0f);
    }

    private long memoryUsage() throws Exception {
        int SLEEP_TIME = 100;
        System.gc();
        Thread.sleep(100L);
        System.runFinalization();
        Thread.sleep(100L);
        System.gc();
        Thread.sleep(100L);
        System.runFinalization();
        Thread.sleep(100L);
        long memUsage = Runtime.getRuntime().totalMemory();
        System.gc();
        Thread.sleep(100L);
        System.runFinalization();
        Thread.sleep(100L);
        System.gc();
        Thread.sleep(100L);
        System.runFinalization();
        Thread.sleep(100L);
        return memUsage - Runtime.getRuntime().freeMemory();
    }

    static /* synthetic */ SupportedCSS access$0() {
        return css;
    }

    public static class NodeDataEnumArray
    implements NodeData {
        private NodeData[] properties = new NodeData[NodeDataVariant.access$0().getTotalProperties()];
        private Term<?>[] values = new Term[NodeDataVariant.access$0().getTotalProperties()];
        private BitSet inherited = new BitSet(NodeDataVariant.access$0().getTotalProperties());

        @Override
        public <T extends CSSProperty> T getProperty(String name) {
            return null;
        }

        @Override
        public <T extends CSSProperty> T getProperty(String name, boolean includeInherited) {
            return null;
        }

        @Override
        public Term<?> getValue(String name, boolean includeInherited) {
            return null;
        }

        @Override
        public <T extends Term<?>> T getValue(Class<T> clazz, String name) {
            return null;
        }

        @Override
        public <T extends Term<?>> T getValue(Class<T> clazz, String name, boolean includeInherited) {
            return null;
        }

        @Override
        public NodeData push(Declaration d) {
            return this;
        }

        @Override
        public NodeData inheritFrom(NodeData parent) {
            return this;
        }

        @Override
        public NodeData concretize() {
            return this;
        }
    }

    static class Pair<T, V> {
        private T first;
        private V second;

        public Pair(T first, V second) {
            this.first = first;
            this.second = second;
        }

        public T getFirst() {
            return this.first;
        }

        public V getSecond() {
            return this.second;
        }
    }
}

