/*
 * Decompiled with CFR 0.152.
 */
package test;

import cz.vutbr.web.css.CSSException;
import cz.vutbr.web.css.CSSFactory;
import cz.vutbr.web.css.Declaration;
import cz.vutbr.web.css.RuleBlock;
import cz.vutbr.web.css.RuleSet;
import cz.vutbr.web.css.StyleSheet;
import cz.vutbr.web.css.TermFactory;
import cz.vutbr.web.css.TermURI;
import java.io.IOException;
import java.util.Date;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import test.DeclarationsUtil;
import test.SelectorsUtil;

public class SimpleTest {
    private static Logger log = LoggerFactory.getLogger(SimpleTest.class);
    public static final TermFactory tf = CSSFactory.getTermFactory();
    public static final String TEST_STRING1 = "BODY { display: block;}";
    public static final String TEST_CHARSET_STRING1 = "@charset \"UTF-8\";";
    public static final String TEST_CHARSET_STRING2 = "@charset \"ISO-8859-1\";\n\nBODY { color: blue;}";
    public static final String TEST_HASH_COLOR1 = "BODY { color: #00AA85;}";
    public static final String TEST_HASH_COLOR2 = "DIV, P { color: #CCC;}";
    public static final String TEST_RGBFUNCTION1 = "BODY { color: rgb(192,64,32);}";
    public static final String TEST_RGBFUNCTION2 = "BODY { color: rgb(50%,128,30%);} ";
    public static final String TEST_UNIT = "BODY { margin: 5em; }";
    public static final String TEST_STRING2 = "BODY {\n\tbackground-color: #EEE;\n\tcolor: red;\n}\n\nH1.prvni+P {\n\tcolor: #00A;\n}\n\nH1 {\n\tfont-size: 20px;\n\tcolor: #000;\n}\n\nH1.prvni {\n\tcolor: #00A;\n}\n\n.AA {\nfont-weight: bold;\n}\n\n.BB {\n\tcolor: #0F0;}\n\n";
    public static String TEST_URI1 = "BODY { background-image: url(image.jpg); } ";

    @BeforeClass
    public static void init() {
        log.info("\n\n\n == SimpleTest test at {} == \n\n\n", new Date());
    }

    @Test
    public void testCharsets() throws IOException, CSSException {
        StyleSheet ss = CSSFactory.parse(TEST_CHARSET_STRING1);
        Assert.assertEquals((String)"No rules are defined", (long)0L, (long)ss.size());
        ss = CSSFactory.parse(TEST_CHARSET_STRING2);
        Assert.assertEquals((String)"One rule is set", (long)1L, (long)ss.size());
        RuleSet rule = (RuleSet)ss.get(0);
        Assert.assertEquals((String)"Rule contains one selector BODY ", SelectorsUtil.createSelectors("BODY"), rule.getSelectors());
        Assert.assertEquals((String)"Rule contains one declaration { color: blue;}", DeclarationsUtil.appendDeclaration(null, "color", tf.createColor(0, 0, 255)), rule.asList());
    }

    @Test
    public void testString1() throws IOException, CSSException {
        StyleSheet ss = CSSFactory.parse(TEST_STRING1);
        Assert.assertEquals((String)"One rule is set", (long)1L, (long)ss.size());
        RuleSet rule = (RuleSet)ss.get(0);
        Assert.assertEquals((String)"Rule contains one selector BODY ", SelectorsUtil.createSelectors("BODY"), rule.getSelectors());
        Assert.assertEquals((String)"Rule contains one declaration {display:block;}", DeclarationsUtil.appendDeclaration(null, "display", tf.createIdent("block")), rule.asList());
    }

    @Test
    public void testRGBFunction1() throws IOException, CSSException {
        StyleSheet ss = CSSFactory.parse(TEST_RGBFUNCTION1);
        Assert.assertEquals((String)"One rule is set", (long)1L, (long)ss.size());
        RuleSet rule = (RuleSet)ss.get(0);
        Assert.assertEquals((String)"Rule contains one selector BODY ", SelectorsUtil.createSelectors("BODY"), rule.getSelectors());
        Assert.assertEquals((String)"Rule contains one declaration {color: #00aa85;}", DeclarationsUtil.appendDeclaration(null, "color", tf.createColor(192, 64, 32)), rule.asList());
    }

    @Test
    public void testRGBFunction2() throws IOException, CSSException {
        StyleSheet ss = CSSFactory.parse(TEST_RGBFUNCTION2);
        Assert.assertEquals((String)"One rule is set", (long)1L, (long)ss.size());
        RuleSet rule = (RuleSet)ss.get(0);
        Assert.assertEquals((String)"Rule contains one selector BODY ", SelectorsUtil.createSelectors("BODY"), rule.getSelectors());
        Assert.assertEquals((String)"Rule contains one declaration {color: rgb(50%,128,30%);}", DeclarationsUtil.appendDeclaration(null, "color", tf.createColor(127, 128, 76)), rule.asList());
    }

    @Test
    public void testHashColor1() throws IOException, CSSException {
        StyleSheet ss = CSSFactory.parse(TEST_HASH_COLOR1);
        Assert.assertEquals((String)"One rule is set", (long)1L, (long)ss.size());
        RuleSet rule = (RuleSet)ss.get(0);
        Assert.assertEquals((String)"Rule contains one selector BODY ", SelectorsUtil.createSelectors("BODY"), rule.getSelectors());
        Assert.assertEquals((String)"Rule contains one declaration {color: #00aa85;}", DeclarationsUtil.appendDeclaration(null, "color", tf.createColor(0, 170, 133)), rule.asList());
    }

    @Test
    public void testHashColor2() throws IOException, CSSException {
        StyleSheet ss = CSSFactory.parse(TEST_HASH_COLOR2);
        Assert.assertEquals((String)"One rule is set", (long)1L, (long)ss.size());
        RuleSet rule = (RuleSet)ss.get(0);
        Assert.assertEquals((String)"Rule contains two selectors DIV, P", SelectorsUtil.createSelectors("DIV", "P"), rule.getSelectors());
        Assert.assertEquals((String)"Rule contains one declaration {color: #CCC;}", DeclarationsUtil.appendDeclaration(null, "color", tf.createColor(204, 204, 204)), rule.asList());
    }

    @Test
    public void testUnit() throws IOException, CSSException {
        StyleSheet ss = CSSFactory.parse(TEST_UNIT);
        Assert.assertEquals((String)"There is one rule", (long)1L, (long)ss.size());
    }

    @Test
    public void testString2() throws IOException, CSSException {
        StyleSheet ss = CSSFactory.parse(TEST_STRING2);
        Assert.assertEquals((String)"Six rules are set", (long)6L, (long)ss.size());
    }

    @Test
    public void testURI1() throws IOException, CSSException {
        StyleSheet ss = CSSFactory.parse(TEST_URI1);
        Assert.assertEquals((String)"There is one rule", (long)1L, (long)ss.size());
        Declaration dec = (Declaration)((RuleBlock)ss.get(0)).get(0);
        Assert.assertEquals((String)"There is one declaration", (long)1L, (long)((RuleBlock)ss.get(0)).size());
        Object term = dec.get(0);
        Assert.assertTrue((String)"Term value is URI", (boolean)(term instanceof TermURI));
        TermURI uri = (TermURI)term;
        Assert.assertEquals((String)"URI has proper value", (Object)"image.jpg", uri.getValue());
    }
}

