/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;

public class PDEPerspective
implements IPerspectiveFactory {
    private IPageLayout factory;

    public void createInitialLayout(IPageLayout factory) {
        this.factory = factory;
        this.addViews();
        this.addActionSets();
        this.addNewWizardShortcuts();
        this.addPerspectiveShortcuts();
        this.addViewShortcuts();
    }

    private void addPerspectiveShortcuts() {
        this.factory.addPerspectiveShortcut("org.eclipse.ui.resourcePerspective");
        this.factory.addPerspectiveShortcut("org.eclipse.jdt.ui.JavaPerspective");
        this.factory.addPerspectiveShortcut("org.eclipse.debug.ui.DebugPerspective");
    }

    private void addViews() {
        IFolderLayout topLeft = this.factory.createFolder("topLeft", 1, 0.25f, this.factory.getEditorArea());
        topLeft.addPlaceholder("org.eclipse.ui.views.ResourceNavigator");
        topLeft.addView("org.eclipse.jdt.ui.PackageExplorer");
        topLeft.addPlaceholder("org.eclipse.jdt.ui.TypeHierarchy");
        topLeft.addView("org.eclipse.pde.ui.PluginsView");
        IFolderLayout bottom = this.factory.createFolder("bottomRight", 4, 0.75f, this.factory.getEditorArea());
        bottom.addView("org.eclipse.pde.runtime.LogView");
        bottom.addView("org.eclipse.ui.views.TaskList");
        bottom.addView("org.eclipse.ui.views.ProblemView");
        this.factory.addView("org.eclipse.ui.views.ContentOutline", 2, 0.75f, this.factory.getEditorArea());
    }

    private void addActionSets() {
        this.factory.addActionSet("org.eclipse.debug.ui.launchActionSet");
        this.factory.addActionSet("org.eclipse.debug.ui.debugActionSet");
        this.factory.addActionSet("org.eclipse.jdt.ui.JavaActionSet");
        this.factory.addActionSet("org.eclipse.jdt.ui.JavaElementCreationActionSet");
        this.factory.addActionSet("org.eclipse.debug.ui.breakpointActionSet");
    }

    private void addNewWizardShortcuts() {
        this.factory.addNewWizardShortcut("org.eclipse.pde.ui.NewProductConfigurationWizard");
        this.factory.addNewWizardShortcut("org.eclipse.pde.ui.NewProfileWizard");
        this.factory.addNewWizardShortcut("org.eclipse.jdt.ui.wizards.NewPackageCreationWizard");
        this.factory.addNewWizardShortcut("org.eclipse.jdt.ui.wizards.NewClassCreationWizard");
        this.factory.addNewWizardShortcut("org.eclipse.jdt.ui.wizards.NewInterfaceCreationWizard");
        this.factory.addNewWizardShortcut("org.eclipse.jdt.ui.wizards.NewSourceFolderCreationWizard");
        this.factory.addNewWizardShortcut("org.eclipse.ui.wizards.new.folder");
        this.factory.addNewWizardShortcut("org.eclipse.ui.wizards.new.file");
    }

    private void addViewShortcuts() {
        this.factory.addShowViewShortcut("org.eclipse.jdt.ui.PackageExplorer");
        this.factory.addShowViewShortcut("org.eclipse.pde.runtime.LogView");
        this.factory.addShowViewShortcut("org.eclipse.pde.ui.PluginsView");
        this.factory.addShowViewShortcut("org.eclipse.ui.views.ResourceNavigator");
        this.factory.addShowViewShortcut("org.eclipse.ui.views.ProblemView");
        this.factory.addShowViewShortcut("org.eclipse.ui.views.TaskList");
        this.factory.addShowViewShortcut("org.eclipse.ui.views.ContentOutline");
    }
}

