/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.build;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.BuildScriptGenerator;
import org.eclipse.pde.internal.core.ClasspathHelper;
import org.eclipse.pde.internal.core.PDEState;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.build.BaseBuildAction;

public class BuildPluginAction
extends BaseBuildAction {
    protected void makeScripts(IProgressMonitor monitor) throws InvocationTargetException, CoreException {
        BuildScriptGenerator generator = new BuildScriptGenerator();
        AbstractScriptGenerator.setEmbeddedSource((boolean)AbstractScriptGenerator.getDefaultEmbeddedSource());
        AbstractScriptGenerator.setForceUpdateJar((boolean)AbstractScriptGenerator.getForceUpdateJarFormat());
        AbstractScriptGenerator.setConfigInfo((String)AbstractScriptGenerator.getDefaultConfigInfos());
        IProject project = this.fManifestFile.getProject();
        generator.setWorkingDirectory(project.getLocation().toOSString());
        String url = ClasspathHelper.getDevEntriesProperties((String)(String.valueOf(project.getLocation().addTrailingSeparator().toString()) + "dev.properties"), (boolean)false);
        generator.setDevEntries(url);
        generator.setPDEState(TargetPlatformHelper.getState());
        generator.setNextId(TargetPlatformHelper.getPDEState().getNextId());
        generator.setStateExtraData(TargetPlatformHelper.getBundleClasspaths((PDEState)TargetPlatformHelper.getPDEState()), TargetPlatformHelper.getPatchMap((PDEState)TargetPlatformHelper.getPDEState()));
        generator.setBuildingOSGi(true);
        IPluginModelBase model = PluginRegistry.findModel((IProject)project);
        if (model != null && model.getPluginBase().getId() != null) {
            generator.setBundles(new BundleDescription[]{model.getBundleDescription()});
            generator.generate();
        } else {
            MessageDialog.openError(null, (String)PDEUIMessages.BuildPluginAction_ErrorDialog_Title, (String)PDEUIMessages.BuildPluginAction_ErrorDialog_Message);
        }
    }
}

