/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.correction;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.pde.internal.ui.correction.AddBuildEntryResolution;
import org.eclipse.pde.internal.ui.correction.AddExportPackageMarkerResolution;
import org.eclipse.pde.internal.ui.correction.AddSingletonToSymbolicName;
import org.eclipse.pde.internal.ui.correction.AddSourceBuildEntryResolution;
import org.eclipse.pde.internal.ui.correction.AppendSeperatorBuildEntryResolution;
import org.eclipse.pde.internal.ui.correction.ChooseClassXMLResolution;
import org.eclipse.pde.internal.ui.correction.ChooseManifestClassResolution;
import org.eclipse.pde.internal.ui.correction.CreateClassXMLResolution;
import org.eclipse.pde.internal.ui.correction.CreateJREBundleHeaderResolution;
import org.eclipse.pde.internal.ui.correction.CreateManifestClassResolution;
import org.eclipse.pde.internal.ui.correction.ExternalizeResolution;
import org.eclipse.pde.internal.ui.correction.ExternalizeStringsResolution;
import org.eclipse.pde.internal.ui.correction.OptionalImportPackageResolution;
import org.eclipse.pde.internal.ui.correction.OptionalRequireBundleResolution;
import org.eclipse.pde.internal.ui.correction.RemoveBuildEntryResolution;
import org.eclipse.pde.internal.ui.correction.RemoveExportPackageResolution;
import org.eclipse.pde.internal.ui.correction.RemoveImportExportServicesResolution;
import org.eclipse.pde.internal.ui.correction.RemoveImportPackageResolution;
import org.eclipse.pde.internal.ui.correction.RemoveInternalDirectiveEntryResolution;
import org.eclipse.pde.internal.ui.correction.RemoveNodeXMLResolution;
import org.eclipse.pde.internal.ui.correction.RemoveRequireBundleResolution;
import org.eclipse.pde.internal.ui.correction.RemoveSeperatorBuildEntryResolution;
import org.eclipse.pde.internal.ui.correction.RemoveStaticProjectReferences;
import org.eclipse.pde.internal.ui.correction.RemoveUnknownExecEnvironments;
import org.eclipse.pde.internal.ui.correction.RenameAutostartResolution;
import org.eclipse.pde.internal.ui.correction.UnsupportedSingletonDirectiveResolution;
import org.eclipse.pde.internal.ui.correction.UpdateClasspathResolution;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator2;

public class ResolutionGenerator
implements IMarkerResolutionGenerator2 {
    private static IMarkerResolution[] NO_RESOLUTIONS = new IMarkerResolution[0];

    public IMarkerResolution[] getResolutions(IMarker marker) {
        int problemID = marker.getAttribute("id", -1);
        switch (problemID) {
            case 4097: {
                return new IMarkerResolution[]{new RenameAutostartResolution(2)};
            }
            case 4098: {
                return new IMarkerResolution[]{new CreateJREBundleHeaderResolution(1)};
            }
            case 4099: {
                return new IMarkerResolution[]{new AddSingletonToSymbolicName(2, true)};
            }
            case 4100: {
                return new IMarkerResolution[]{new AddSingletonToSymbolicName(2, false)};
            }
            case 4113: {
                return new IMarkerResolution[]{new UnsupportedSingletonDirectiveResolution(2)};
            }
            case 4101: {
                return new IMarkerResolution[]{new RemoveStaticProjectReferences(3)};
            }
            case 4102: {
                return this.getUnresolvedExportProposals(marker);
            }
            case 4103: {
                return this.getUnresolvedImportPackageProposals(marker);
            }
            case 4104: {
                return this.getUnresolvedBundle(marker);
            }
            case 4112: {
                return new IMarkerResolution[]{new CreateManifestClassResolution(1, "Bundle-Activator"), new ChooseManifestClassResolution(2, "Bundle-Activator")};
            }
            case 4105: {
                return new IMarkerResolution[]{new CreateManifestClassResolution(1, "Plugin-Class"), new ChooseManifestClassResolution(2, "Plugin-Class")};
            }
            case 4114: {
                return this.getRemoveInternalDirectiveResolution(marker);
            }
            case 4115: {
                return new IMarkerResolution[]{new UpdateClasspathResolution(2)};
            }
            case 4116: {
                return new IMarkerResolution[]{new RemoveUnknownExecEnvironments(3)};
            }
            case 4117: {
                return new IMarkerResolution[]{new RemoveImportExportServicesResolution(3, "Import-Service")};
            }
            case 4118: {
                return new IMarkerResolution[]{new RemoveImportExportServicesResolution(3, "Export-Service")};
            }
            case 4119: {
                return new IMarkerResolution[]{new RemoveRequireBundleResolution(3, marker.getAttribute("bundleId", null))};
            }
            case 4120: {
                return new IMarkerResolution[]{new AddExportPackageMarkerResolution(1, marker.getAttribute("packages", null))};
            }
            case 8194: {
                return new IMarkerResolution[]{new RemoveSeperatorBuildEntryResolution(2, marker)};
            }
            case 8193: {
                return new IMarkerResolution[]{new AppendSeperatorBuildEntryResolution(2, marker)};
            }
            case 8195: {
                return new IMarkerResolution[]{new AddBuildEntryResolution(1, marker)};
            }
            case 8196: {
                return new IMarkerResolution[]{new AddSourceBuildEntryResolution(1, marker)};
            }
            case 8197: {
                return new IMarkerResolution[]{new RemoveBuildEntryResolution(3, marker)};
            }
            case 12289: {
                return new IMarkerResolution[]{new RemoveNodeXMLResolution(3, marker)};
            }
            case 12290: {
                return new IMarkerResolution[]{new ExternalizeResolution(2, marker), new ExternalizeStringsResolution(2)};
            }
            case 12291: {
                return new IMarkerResolution[]{new CreateClassXMLResolution(1, marker), new ChooseClassXMLResolution(2, marker)};
            }
        }
        return NO_RESOLUTIONS;
    }

    private IMarkerResolution[] getRemoveInternalDirectiveResolution(IMarker marker) {
        IResource res;
        String packageName = marker.getAttribute("packageName", null);
        if (packageName != null && (res = marker.getResource()) != null) {
            return new IMarkerResolution[]{new RemoveInternalDirectiveEntryResolution(3, packageName)};
        }
        return NO_RESOLUTIONS;
    }

    private IMarkerResolution[] getUnresolvedExportProposals(IMarker marker) {
        IResource res;
        String packageName = marker.getAttribute("packageName", null);
        if (packageName != null && (res = marker.getResource()) != null) {
            return new IMarkerResolution[]{new RemoveExportPackageResolution(3, packageName)};
        }
        return NO_RESOLUTIONS;
    }

    private IMarkerResolution[] getUnresolvedImportPackageProposals(IMarker marker) {
        String packageName = marker.getAttribute("packageName", null);
        if (packageName == null) {
            return NO_RESOLUTIONS;
        }
        boolean optionalPkg = marker.getAttribute("optional", false);
        if (optionalPkg) {
            return new IMarkerResolution[]{new RemoveImportPackageResolution(3, packageName)};
        }
        return new IMarkerResolution[]{new RemoveImportPackageResolution(3, packageName), new OptionalImportPackageResolution(2, packageName)};
    }

    private IMarkerResolution[] getUnresolvedBundle(IMarker marker) {
        String bundleId = marker.getAttribute("bundleId", null);
        if (bundleId == null) {
            return NO_RESOLUTIONS;
        }
        boolean optionalBundle = marker.getAttribute("optional", false);
        if (optionalBundle) {
            return new IMarkerResolution[]{new RemoveRequireBundleResolution(3, bundleId)};
        }
        return new IMarkerResolution[]{new RemoveRequireBundleResolution(3, bundleId), new OptionalRequireBundleResolution(2, bundleId)};
    }

    public boolean hasResolutions(IMarker marker) {
        return marker.getAttribute("id", -1) > 0;
    }
}

