/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;

public abstract class LaunchShortcutOverviewPage
extends PDEFormPage
implements IHyperlinkListener {
    public LaunchShortcutOverviewPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    protected final Section createStaticSection(FormToolkit toolkit, Composite parent, String text) {
        Section section = toolkit.createSection(parent, 256);
        section.clientVerticalSpacing = 6;
        section.setText(text);
        section.setLayout((Layout)FormLayoutFactory.createClearTableWrapLayout(false, 1));
        TableWrapData data = new TableWrapData(256);
        section.setLayoutData((Object)data);
        return section;
    }

    protected final FormText createClient(Composite section, String content, FormToolkit toolkit) {
        FormText text = toolkit.createFormText(section, true);
        try {
            text.setText(content, true, false);
        }
        catch (SWTException e) {
            text.setText(e.getMessage(), false, false);
        }
        text.addHyperlinkListener((IHyperlinkListener)this);
        return text;
    }

    public void linkActivated(HyperlinkEvent e) {
        String href = (String)e.getHref();
        if (href.startsWith("launchShortcut.")) {
            int index = (href = href.substring(15)).indexOf(46);
            if (index < 0) {
                return;
            }
            String mode = href.substring(0, index);
            String id = href.substring(index + 1);
            this.getEditor().doSave(null);
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IConfigurationElement[] elements = registry.getConfigurationElementsFor("org.eclipse.debug.ui.launchShortcuts");
            int i = 0;
            while (i < elements.length) {
                if (id.equals(elements[i].getAttribute("id"))) {
                    try {
                        ILaunchShortcut shortcut = (ILaunchShortcut)elements[i].createExecutableExtension("class");
                        this.preLaunch();
                        shortcut.launch((ISelection)new StructuredSelection(this.getLaunchObject()), mode);
                    }
                    catch (CoreException coreException) {}
                }
                ++i;
            }
        }
    }

    protected abstract Object getLaunchObject();

    protected void preLaunch() {
    }

    protected abstract short getIndent();

    public void linkEntered(HyperlinkEvent e) {
        IStatusLineManager mng = this.getEditor().getEditorSite().getActionBars().getStatusLineManager();
        mng.setMessage(e.getLabel());
    }

    public void linkExited(HyperlinkEvent e) {
        IStatusLineManager mng = this.getEditor().getEditorSite().getActionBars().getStatusLineManager();
        mng.setMessage(null);
    }

    protected final String getLauncherText(boolean osgi, String message) {
        IConfigurationElement[] elements = this.getLaunchers(osgi);
        StringBuffer buffer = new StringBuffer();
        String indent = Short.toString(this.getIndent());
        int i = 0;
        while (i < elements.length) {
            String mode = elements[i].getAttribute("mode");
            buffer.append("<li style=\"image\" value=\"");
            buffer.append(mode);
            buffer.append("\" bindent=\"" + indent + "\"><a href=\"launchShortcut.");
            buffer.append(mode);
            buffer.append('.');
            buffer.append(elements[i].getAttribute("id"));
            buffer.append("\">");
            buffer.append(elements[i].getAttribute("label"));
            buffer.append("</a></li>");
            ++i;
        }
        return NLS.bind((String)message, (Object)buffer.toString());
    }

    private IConfigurationElement[] getLaunchers(boolean osgi) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor("org.eclipse.pde.ui.launchShortcuts");
        ArrayList<IConfigurationElement> list = new ArrayList<IConfigurationElement>();
        int i = 0;
        while (i < elements.length) {
            String mode = elements[i].getAttribute("mode");
            if (mode != null && (mode.equals("run") || mode.equals("debug") || mode.equals("profile")) && elements[i].getAttribute("label") != null && elements[i].getAttribute("id") != null && osgi == "true".equals(elements[i].getAttribute("osgi"))) {
                list.add(elements[i]);
            }
            ++i;
        }
        elements = list.toArray(new IConfigurationElement[list.size()]);
        Arrays.sort(elements, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                int mode2;
                int mode1 = this.getModeValue(((IConfigurationElement)arg0).getAttribute("mode"));
                if (mode1 != (mode2 = this.getModeValue(((IConfigurationElement)arg1).getAttribute("mode")))) {
                    return mode1 - mode2;
                }
                String label1 = ((IConfigurationElement)arg0).getAttribute("label");
                String label2 = ((IConfigurationElement)arg1).getAttribute("label");
                return label1.compareTo(label2);
            }

            private int getModeValue(String value) {
                if (value.equals("run")) {
                    return 0;
                }
                if (value.equals("debug")) {
                    return 1;
                }
                return 2;
            }
        });
        return elements;
    }
}

